/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.batik.svggen.CachedImageHandler;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.ErrorConstants;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public abstract class DefaultCachedImageHandler
implements CachedImageHandler,
ErrorConstants,
SVGSyntax {
    static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    static final AffineTransform IDENTITY = new AffineTransform();
    private static Method createGraphics = null;
    private static boolean initDone = false;
    private static final Class[] paramc = new Class[]{BufferedImage.class};
    private static Object[] paramo = null;
    protected ImageCacher imageCacher;

    @Override
    public ImageCacher getImageCacher() {
        return this.imageCacher;
    }

    void setImageCacher(ImageCacher imageCacher) {
        if (imageCacher == null) {
            throw new IllegalArgumentException();
        }
        DOMTreeManager dOMTreeManager = null;
        if (this.imageCacher != null) {
            dOMTreeManager = this.imageCacher.getDOMTreeManager();
        }
        this.imageCacher = imageCacher;
        if (dOMTreeManager != null) {
            this.imageCacher.setDOMTreeManager(dOMTreeManager);
        }
    }

    @Override
    public void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        this.imageCacher.setDOMTreeManager(dOMTreeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Object object;
        if (!initDone) {
            try {
                object = Class.forName("org.apache.batik.ext.awt.image.GraphicsUtil");
                createGraphics = ((Class)object).getMethod("createGraphics", paramc);
                paramo = new Object[1];
            }
            catch (Throwable throwable) {
            }
            finally {
                initDone = true;
            }
        }
        if (createGraphics == null) {
            return bufferedImage.createGraphics();
        }
        DefaultCachedImageHandler.paramo[0] = bufferedImage;
        object = null;
        try {
            object = (Graphics2D)createGraphics.invoke(null, paramo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Override
    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "image");
        return element;
    }

    @Override
    public AffineTransform handleImage(Image image, Element element, int n2, int n3, int n4, int n5, SVGGeneratorContext sVGGeneratorContext) {
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        AffineTransform affineTransform = null;
        if (n6 == 0 || n7 == 0 || n4 == 0 || n5 == 0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(image, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, n2, n3, n6, n7, n4, n5, sVGGeneratorContext);
        }
        return affineTransform;
    }

    @Override
    public AffineTransform handleImage(RenderedImage renderedImage, Element element, int n2, int n3, int n4, int n5, SVGGeneratorContext sVGGeneratorContext) {
        int n6 = renderedImage.getWidth();
        int n7 = renderedImage.getHeight();
        AffineTransform affineTransform = null;
        if (n6 == 0 || n7 == 0 || n4 == 0 || n5 == 0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(renderedImage, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, n2, n3, n6, n7, n4, n5, sVGGeneratorContext);
        }
        return affineTransform;
    }

    @Override
    public AffineTransform handleImage(RenderableImage renderableImage, Element element, double d2, double d3, double d4, double d5, SVGGeneratorContext sVGGeneratorContext) {
        double d6 = renderableImage.getWidth();
        double d7 = renderableImage.getHeight();
        AffineTransform affineTransform = null;
        if (d6 == 0.0 || d7 == 0.0 || d4 == 0.0 || d5 == 0.0) {
            this.handleEmptyImage(element);
        } else {
            try {
                this.handleHREF(renderableImage, element, sVGGeneratorContext);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
                try {
                    sVGGeneratorContext.errorHandler.handleError(sVGGraphics2DIOException);
                }
                catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                    throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
                }
            }
            affineTransform = this.handleTransform(element, d2, d3, d6, d7, d4, d5, sVGGeneratorContext);
        }
        return affineTransform;
    }

    protected AffineTransform handleTransform(Element element, double d2, double d3, double d4, double d5, double d6, double d7, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "x", sVGGeneratorContext.doubleString(d2));
        element.setAttributeNS(null, "y", sVGGeneratorContext.doubleString(d3));
        element.setAttributeNS(null, "width", sVGGeneratorContext.doubleString(d6));
        element.setAttributeNS(null, "height", sVGGeneratorContext.doubleString(d7));
        return null;
    }

    protected void handleEmptyImage(Element element) {
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", "");
        element.setAttributeNS(null, "width", "0");
        element.setAttributeNS(null, "height", "0");
    }

    public void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) {
        if (image == null) {
            throw new SVGGraphics2DRuntimeException("image should not be null");
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        if (n2 == 0 || n3 == 0) {
            this.handleEmptyImage(element);
        } else if (image instanceof RenderedImage) {
            this.handleHREF((RenderedImage)((Object)image), element, sVGGeneratorContext);
        } else {
            BufferedImage bufferedImage = this.buildBufferedImage(new Dimension(n2, n3));
            Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            this.handleHREF(bufferedImage, element, sVGGeneratorContext);
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, this.getBufferedImageType());
    }

    protected void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) {
        BufferedImage bufferedImage = null;
        if (renderedImage instanceof BufferedImage && ((BufferedImage)renderedImage).getType() == this.getBufferedImageType()) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            Dimension dimension = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
            bufferedImage = this.buildBufferedImage(dimension);
            Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
            graphics2D.drawRenderedImage(renderedImage, IDENTITY);
            graphics2D.dispose();
        }
        this.cacheBufferedImage(element, bufferedImage, sVGGeneratorContext);
    }

    protected void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) {
        Dimension dimension = new Dimension((int)Math.ceil(renderableImage.getWidth()), (int)Math.ceil(renderableImage.getHeight()));
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = DefaultCachedImageHandler.createGraphics(bufferedImage);
        graphics2D.drawRenderableImage(renderableImage, IDENTITY);
        graphics2D.dispose();
        this.handleHREF(bufferedImage, element, sVGGeneratorContext);
    }

    protected void cacheBufferedImage(Element element, BufferedImage bufferedImage, SVGGeneratorContext sVGGeneratorContext) {
        ByteArrayOutputStream byteArrayOutputStream;
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            this.encodeImage(bufferedImage, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("unexpected exception", iOException);
        }
        String string = this.imageCacher.lookup(byteArrayOutputStream, bufferedImage.getWidth(), bufferedImage.getHeight(), sVGGeneratorContext);
        element.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", this.getRefPrefix() + string);
    }

    public abstract String getRefPrefix();

    public abstract void encodeImage(BufferedImage var1, OutputStream var2);

    public abstract int getBufferedImageType();
}

