/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.DefaultCachedImageHandler;
import org.apache.batik.svggen.ImageCacher;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.util.Base64EncoderStream;
import org.w3c.dom.Element;

public class CachedImageHandlerBase64Encoder
extends DefaultCachedImageHandler {
    public CachedImageHandlerBase64Encoder() {
        this.setImageCacher(new ImageCacher.Embedded());
    }

    @Override
    public Element createElement(SVGGeneratorContext sVGGeneratorContext) {
        Element element = sVGGeneratorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "use");
        return element;
    }

    @Override
    public String getRefPrefix() {
        return "";
    }

    @Override
    protected AffineTransform handleTransform(Element element, double d2, double d3, double d4, double d5, double d6, double d7, SVGGeneratorContext sVGGeneratorContext) {
        AffineTransform affineTransform = new AffineTransform();
        double d8 = d6 / d4;
        double d9 = d7 / d5;
        affineTransform.translate(d2, d3);
        if (d8 != 1.0 || d9 != 1.0) {
            affineTransform.scale(d8, d9);
        }
        if (!affineTransform.isIdentity()) {
            return affineTransform;
        }
        return null;
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) {
        Base64EncoderStream base64EncoderStream = new Base64EncoderStream(outputStream);
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        imageWriter.writeImage(bufferedImage, base64EncoderStream);
        base64EncoderStream.close();
    }

    @Override
    public int getBufferedImageType() {
        return 2;
    }
}

