/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.w3c.dom.Element;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    static final double SQRT2 = Math.sqrt(2.0);

    protected UnitProcessor() {
    }

    public static float svgToObjectBoundingBox(String string, String string2, short s2, Context context) {
        LengthParser lengthParser = new LengthParser();
        UnitResolver unitResolver = new UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.svgToObjectBoundingBox(unitResolver.value, unitResolver.unit, s2, context);
    }

    public static float svgToObjectBoundingBox(float f2, short s2, short s3, Context context) {
        switch (s2) {
            case 1: {
                return f2;
            }
            case 2: {
                return f2 / 100.0f;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return UnitProcessor.svgToUserSpace(f2, s2, s3, context);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float svgToUserSpace(String string, String string2, short s2, Context context) {
        LengthParser lengthParser = new LengthParser();
        UnitResolver unitResolver = new UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.svgToUserSpace(unitResolver.value, unitResolver.unit, s2, context);
    }

    public static float svgToUserSpace(float f2, short s2, short s3, Context context) {
        switch (s2) {
            case 1: 
            case 5: {
                return f2;
            }
            case 7: {
                return f2 / context.getPixelUnitToMillimeter();
            }
            case 6: {
                return f2 * 10.0f / context.getPixelUnitToMillimeter();
            }
            case 8: {
                return f2 * 25.4f / context.getPixelUnitToMillimeter();
            }
            case 9: {
                return f2 * 25.4f / (72.0f * context.getPixelUnitToMillimeter());
            }
            case 10: {
                return f2 * 25.4f / (6.0f * context.getPixelUnitToMillimeter());
            }
            case 3: {
                return UnitProcessor.emsToPixels(f2, s3, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f2, s3, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f2, s3, context);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float userSpaceToSVG(float f2, short s2, short s3, Context context) {
        switch (s2) {
            case 1: 
            case 5: {
                return f2;
            }
            case 7: {
                return f2 * context.getPixelUnitToMillimeter();
            }
            case 6: {
                return f2 * context.getPixelUnitToMillimeter() / 10.0f;
            }
            case 8: {
                return f2 * context.getPixelUnitToMillimeter() / 25.4f;
            }
            case 9: {
                return f2 * (72.0f * context.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 10: {
                return f2 * (6.0f * context.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 3: {
                return UnitProcessor.pixelsToEms(f2, s3, context);
            }
            case 4: {
                return UnitProcessor.pixelsToExs(f2, s3, context);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(f2, s3, context);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    protected static float percentagesToPixels(float f2, short s2, Context context) {
        if (s2 == 2) {
            float f3 = context.getViewportWidth();
            return f3 * f2 / 100.0f;
        }
        if (s2 == 1) {
            float f4 = context.getViewportHeight();
            return f4 * f2 / 100.0f;
        }
        double d2 = context.getViewportWidth();
        double d3 = context.getViewportHeight();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3) / SQRT2;
        return (float)(d4 * (double)f2 / 100.0);
    }

    protected static float pixelsToPercentages(float f2, short s2, Context context) {
        if (s2 == 2) {
            float f3 = context.getViewportWidth();
            return f2 * 100.0f / f3;
        }
        if (s2 == 1) {
            float f4 = context.getViewportHeight();
            return f2 * 100.0f / f4;
        }
        double d2 = context.getViewportWidth();
        double d3 = context.getViewportHeight();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3) / SQRT2;
        return (float)((double)f2 * 100.0 / d4);
    }

    protected static float pixelsToEms(float f2, short s2, Context context) {
        return f2 / context.getFontSize();
    }

    protected static float emsToPixels(float f2, short s2, Context context) {
        return f2 * context.getFontSize();
    }

    protected static float pixelsToExs(float f2, short s2, Context context) {
        float f3 = context.getXHeight();
        return f2 / f3 / context.getFontSize();
    }

    protected static float exsToPixels(float f2, short s2, Context context) {
        float f3 = context.getXHeight();
        return f2 * f3 * context.getFontSize();
    }

    public static interface Context {
        public Element getElement();

        public float getPixelUnitToMillimeter();

        public float getPixelToMM();

        public float getFontSize();

        public float getXHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    implements LengthHandler {
        public float value;
        public short unit = 1;

        @Override
        public void startLength() {
        }

        @Override
        public void lengthValue(float f2) {
            this.value = f2;
        }

        @Override
        public void em() {
            this.unit = (short)3;
        }

        @Override
        public void ex() {
            this.unit = (short)4;
        }

        @Override
        public void in() {
            this.unit = (short)8;
        }

        @Override
        public void cm() {
            this.unit = (short)6;
        }

        @Override
        public void mm() {
            this.unit = (short)7;
        }

        @Override
        public void pc() {
            this.unit = (short)10;
        }

        @Override
        public void pt() {
            this.unit = (short)9;
        }

        @Override
        public void px() {
            this.unit = (short)5;
        }

        @Override
        public void percentage() {
            this.unit = (short)2;
        }

        @Override
        public void endLength() {
        }
    }
}

