/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.util.Calendar;
import java.util.SimpleTimeZone;
import org.apache.batik.parser.AbstractParser;
import org.apache.batik.xml.XMLUtilities;

public abstract class TimingParser
extends AbstractParser {
    protected static final int TIME_OFFSET = 0;
    protected static final int TIME_SYNCBASE = 1;
    protected static final int TIME_EVENTBASE = 2;
    protected static final int TIME_REPEAT = 3;
    protected static final int TIME_ACCESSKEY = 4;
    protected static final int TIME_ACCESSKEY_SVG12 = 5;
    protected static final int TIME_MEDIA_MARKER = 6;
    protected static final int TIME_WALLCLOCK = 7;
    protected static final int TIME_INDEFINITE = 8;
    protected boolean useSVG11AccessKeys;
    protected boolean useSVG12AccessKeys;

    public TimingParser(boolean bl2, boolean bl3) {
        this.useSVG11AccessKeys = bl2;
        this.useSVG12AccessKeys = bl3;
    }

    protected Object[] parseTimingSpecifier() {
        this.skipSpaces();
        boolean bl2 = false;
        if (this.current == 92) {
            bl2 = true;
            this.current = this.reader.read();
        }
        Object[] objectArray = null;
        if (this.current == 43 || this.current == 45 && !bl2 || this.current >= 48 && this.current <= 57) {
            float f2 = this.parseOffset();
            objectArray = new Object[]{0, Float.valueOf(f2)};
        } else if (XMLUtilities.isXMLNameFirstCharacter((char)this.current)) {
            objectArray = this.parseIDValue(bl2);
        } else {
            this.reportUnexpectedCharacterError(this.current);
        }
        return objectArray;
    }

    protected String parseName() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        do {
            stringBuffer.append((char)this.current);
            this.current = this.reader.read();
            bl2 = false;
            if (this.current != 92) continue;
            bl2 = true;
            this.current = this.reader.read();
        } while (XMLUtilities.isXMLNameCharacter((char)this.current) && (bl2 || this.current != 45 && this.current != 46));
        return stringBuffer.toString();
    }

    protected Object[] parseIDValue(boolean bl2) {
        String string = this.parseName();
        if ((string.equals("accessKey") && this.useSVG11AccessKeys || string.equals("accesskey")) && !bl2) {
            if (this.current != 40) {
                this.reportUnexpectedCharacterError(this.current);
            }
            this.current = this.reader.read();
            if (this.current == -1) {
                this.reportError("end.of.stream", new Object[0]);
            }
            char c2 = (char)this.current;
            this.current = this.reader.read();
            if (this.current != 41) {
                this.reportUnexpectedCharacterError(this.current);
            }
            this.current = this.reader.read();
            this.skipSpaces();
            float f2 = 0.0f;
            if (this.current == 43 || this.current == 45) {
                f2 = this.parseOffset();
            }
            return new Object[]{4, Float.valueOf(f2), Character.valueOf(c2)};
        }
        if (string.equals("accessKey") && this.useSVG12AccessKeys && !bl2) {
            if (this.current != 40) {
                this.reportUnexpectedCharacterError(this.current);
            }
            this.current = this.reader.read();
            StringBuffer stringBuffer = new StringBuffer();
            while (this.current >= 65 && this.current <= 90 || this.current >= 97 && this.current <= 122 || this.current >= 48 && this.current <= 57 || this.current == 43) {
                stringBuffer.append((char)this.current);
                this.current = this.reader.read();
            }
            if (this.current != 41) {
                this.reportUnexpectedCharacterError(this.current);
            }
            this.current = this.reader.read();
            this.skipSpaces();
            float f3 = 0.0f;
            if (this.current == 43 || this.current == 45) {
                f3 = this.parseOffset();
            }
            return new Object[]{5, Float.valueOf(f3), stringBuffer.toString()};
        }
        if (string.equals("wallclock") && !bl2) {
            if (this.current != 40) {
                this.reportUnexpectedCharacterError(this.current);
            }
            this.current = this.reader.read();
            this.skipSpaces();
            Calendar calendar = this.parseWallclockValue();
            this.skipSpaces();
            if (this.current != 41) {
                this.reportError("character.unexpected", new Object[]{this.current});
            }
            this.current = this.reader.read();
            return new Object[]{7, calendar};
        }
        if (string.equals("indefinite") && !bl2) {
            return new Object[]{8};
        }
        if (this.current == 46) {
            String string2;
            this.current = this.reader.read();
            if (this.current == 92) {
                bl2 = true;
                this.current = this.reader.read();
            }
            if (!XMLUtilities.isXMLNameFirstCharacter((char)this.current)) {
                this.reportUnexpectedCharacterError(this.current);
            }
            if (((string2 = this.parseName()).equals("begin") || string2.equals("end")) && !bl2) {
                this.skipSpaces();
                float f4 = 0.0f;
                if (this.current == 43 || this.current == 45) {
                    f4 = this.parseOffset();
                }
                return new Object[]{1, Float.valueOf(f4), string, string2};
            }
            if (string2.equals("repeat") && !bl2) {
                Integer n2 = null;
                if (this.current == 40) {
                    this.current = this.reader.read();
                    n2 = this.parseDigits();
                    if (this.current != 41) {
                        this.reportUnexpectedCharacterError(this.current);
                    }
                    this.current = this.reader.read();
                }
                this.skipSpaces();
                float f5 = 0.0f;
                if (this.current == 43 || this.current == 45) {
                    f5 = this.parseOffset();
                }
                return new Object[]{3, Float.valueOf(f5), string, n2};
            }
            if (string2.equals("marker") && !bl2) {
                if (this.current != 40) {
                    this.reportUnexpectedCharacterError(this.current);
                }
                String string3 = this.parseName();
                if (this.current != 41) {
                    this.reportUnexpectedCharacterError(this.current);
                }
                this.current = this.reader.read();
                return new Object[]{6, string, string3};
            }
            this.skipSpaces();
            float f6 = 0.0f;
            if (this.current == 43 || this.current == 45) {
                f6 = this.parseOffset();
            }
            return new Object[]{2, Float.valueOf(f6), string, string2};
        }
        this.skipSpaces();
        float f7 = 0.0f;
        if (this.current == 43 || this.current == 45) {
            f7 = this.parseOffset();
        }
        return new Object[]{2, Float.valueOf(f7), null, string};
    }

    protected float parseClockValue() {
        float f2;
        int n2 = this.parseDigits();
        if (this.current == 58) {
            this.current = this.reader.read();
            int n3 = this.parseDigits();
            if (this.current == 58) {
                this.current = this.reader.read();
                int n4 = this.parseDigits();
                f2 = n2 * 3600 + n3 * 60 + n4;
            } else {
                f2 = n2 * 60 + n3;
            }
            if (this.current == 46) {
                this.current = this.reader.read();
                f2 += this.parseFraction();
            }
        } else if (this.current == 46) {
            this.current = this.reader.read();
            f2 = (this.parseFraction() + (float)n2) * this.parseUnit();
        } else {
            f2 = (float)n2 * this.parseUnit();
        }
        return f2;
    }

    protected float parseOffset() {
        boolean bl2 = false;
        if (this.current == 45) {
            bl2 = true;
            this.current = this.reader.read();
            this.skipSpaces();
        } else if (this.current == 43) {
            this.current = this.reader.read();
            this.skipSpaces();
        }
        if (bl2) {
            return -this.parseClockValue();
        }
        return this.parseClockValue();
    }

    protected int parseDigits() {
        int n2 = 0;
        if (this.current < 48 || this.current > 57) {
            this.reportUnexpectedCharacterError(this.current);
        }
        do {
            n2 = n2 * 10 + (this.current - 48);
            this.current = this.reader.read();
        } while (this.current >= 48 && this.current <= 57);
        return n2;
    }

    protected float parseFraction() {
        float f2 = 0.0f;
        if (this.current < 48 || this.current > 57) {
            this.reportUnexpectedCharacterError(this.current);
        }
        float f3 = 0.1f;
        do {
            f2 += f3 * (float)(this.current - 48);
            f3 *= 0.1f;
            this.current = this.reader.read();
        } while (this.current >= 48 && this.current <= 57);
        return f2;
    }

    protected float parseUnit() {
        if (this.current == 104) {
            this.current = this.reader.read();
            return 3600.0f;
        }
        if (this.current == 109) {
            this.current = this.reader.read();
            if (this.current == 105) {
                this.current = this.reader.read();
                if (this.current != 110) {
                    this.reportUnexpectedCharacterError(this.current);
                }
                this.current = this.reader.read();
                return 60.0f;
            }
            if (this.current == 115) {
                this.current = this.reader.read();
                return 0.001f;
            }
            this.reportUnexpectedCharacterError(this.current);
        } else if (this.current == 115) {
            this.current = this.reader.read();
        }
        return 1.0f;
    }

    protected Calendar parseWallclockValue() {
        Comparable<Calendar> comparable;
        String string;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block26: {
            int n10;
            block25: {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                f2 = 0.0f;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                string = null;
                n10 = this.parseDigits();
                if (this.current != 45) break block25;
                bl5 = true;
                n9 = n10;
                this.current = this.reader.read();
                n8 = this.parseDigits();
                if (this.current != 45) {
                    this.reportUnexpectedCharacterError(this.current);
                }
                this.current = this.reader.read();
                n7 = this.parseDigits();
                if (this.current != 84) break block26;
                this.current = this.reader.read();
                n10 = this.parseDigits();
                if (this.current != 58) {
                    this.reportUnexpectedCharacterError(this.current);
                }
            }
            if (this.current == 58) {
                bl4 = true;
                n6 = n10;
                this.current = this.reader.read();
                n5 = this.parseDigits();
                if (this.current == 58) {
                    this.current = this.reader.read();
                    n4 = this.parseDigits();
                    if (this.current == 46) {
                        this.current = this.reader.read();
                        f2 = this.parseFraction();
                    }
                }
                if (this.current == 90) {
                    bl3 = true;
                    string = "UTC";
                    this.current = this.reader.read();
                } else if (this.current == 43 || this.current == 45) {
                    comparable = new StringBuffer();
                    bl3 = true;
                    if (this.current == 45) {
                        bl2 = true;
                        ((StringBuffer)comparable).append('-');
                    } else {
                        ((StringBuffer)comparable).append('+');
                    }
                    this.current = this.reader.read();
                    n3 = this.parseDigits();
                    if (n3 < 10) {
                        ((StringBuffer)comparable).append('0');
                    }
                    ((StringBuffer)comparable).append(n3);
                    if (this.current != 58) {
                        this.reportUnexpectedCharacterError(this.current);
                    }
                    ((StringBuffer)comparable).append(':');
                    this.current = this.reader.read();
                    n2 = this.parseDigits();
                    if (n2 < 10) {
                        ((StringBuffer)comparable).append('0');
                    }
                    ((StringBuffer)comparable).append(n2);
                    string = ((StringBuffer)comparable).toString();
                }
            }
        }
        if (!bl5 && !bl4) {
            this.reportUnexpectedCharacterError(this.current);
        }
        if (bl3) {
            int n11 = (bl2 ? -1 : 1) * (n3 * 3600000 + n2 * 60000);
            comparable = Calendar.getInstance(new SimpleTimeZone(n11, string));
        } else {
            comparable = Calendar.getInstance();
        }
        if (bl5 && bl4) {
            ((Calendar)comparable).set(n9, n8, n7, n6, n5, n4);
        } else if (bl5) {
            ((Calendar)comparable).set(n9, n8, n7, 0, 0, 0);
        } else {
            ((Calendar)comparable).set(10, n6);
            ((Calendar)comparable).set(12, n5);
            ((Calendar)comparable).set(13, n4);
        }
        if (f2 == 0.0f) {
            ((Calendar)comparable).set(14, (int)(f2 * 1000.0f));
        } else {
            ((Calendar)comparable).set(14, 0);
        }
        return comparable;
    }
}

