/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.geom.AffineTransform;
import java.io.Reader;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;

public class AWTTransformProducer
implements TransformListHandler {
    protected AffineTransform affineTransform;

    public static AffineTransform createAffineTransform(Reader reader) {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(reader);
        return aWTTransformProducer.getAffineTransform();
    }

    public static AffineTransform createAffineTransform(String string) {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(string);
        return aWTTransformProducer.getAffineTransform();
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    @Override
    public void startTransformList() {
        this.affineTransform = new AffineTransform();
    }

    @Override
    public void matrix(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.affineTransform.concatenate(new AffineTransform(f2, f3, f4, f5, f6, f7));
    }

    @Override
    public void rotate(float f2) {
        this.affineTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(f2)));
    }

    @Override
    public void rotate(float f2, float f3, float f4) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f2), f3, f4);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void translate(float f2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, 0.0);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void translate(float f2, float f3) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void scale(float f2) {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f2, f2));
    }

    @Override
    public void scale(float f2, float f3) {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f2, f3));
    }

    @Override
    public void skewX(float f2) {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(f2)), 0.0));
    }

    @Override
    public void skewY(float f2) {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(f2))));
    }

    @Override
    public void endTransformList() {
    }
}

