/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.io.Reader;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.ShapeProducer;

public class AWTPathProducer
implements PathHandler,
ShapeProducer {
    protected ExtendedGeneralPath path;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    protected int windingRule;

    public static Shape createShape(Reader reader, int n2) {
        PathParser pathParser = new PathParser();
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(n2);
        pathParser.setPathHandler(aWTPathProducer);
        pathParser.parse(reader);
        return aWTPathProducer.getShape();
    }

    @Override
    public void setWindingRule(int n2) {
        this.windingRule = n2;
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public void startPath() {
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(this.windingRule);
    }

    @Override
    public void endPath() {
    }

    @Override
    public void movetoRel(float f2, float f3) {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY += f3;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void movetoAbs(float f2, float f3) {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY = f3;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void closePath() {
        this.path.closePath();
        Point2D point2D = this.path.getCurrentPoint();
        this.currentX = (float)point2D.getX();
        this.currentY = (float)point2D.getY();
    }

    @Override
    public void linetoRel(float f2, float f3) {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY += f3;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoAbs(float f2, float f3) {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY = f3;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoHorizontalRel(float f2) {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoHorizontalAbs(float f2) {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoVerticalRel(float f2) {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY += f2;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void linetoVerticalAbs(float f2) {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY = f2;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void curvetoCubicRel(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.xCenter = this.currentX + f4;
        this.yCenter = this.currentY + f5;
        this.path.curveTo(this.currentX + f2, this.currentY + f3, this.xCenter, this.yCenter, this.currentX += f6, this.currentY += f7);
    }

    @Override
    public void curvetoCubicAbs(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.xCenter = f4;
        this.yCenter = f5;
        this.currentX = f6;
        this.currentY = f7;
        this.path.curveTo(f2, f3, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoCubicSmoothRel(float f2, float f3, float f4, float f5) {
        this.xCenter = this.currentX + f2;
        this.yCenter = this.currentY + f3;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f4, this.currentY += f5);
    }

    @Override
    public void curvetoCubicSmoothAbs(float f2, float f3, float f4, float f5) {
        this.xCenter = f2;
        this.yCenter = f3;
        this.currentX = f4;
        this.currentY = f5;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticRel(float f2, float f3, float f4, float f5) {
        this.xCenter = this.currentX + f2;
        this.yCenter = this.currentY + f3;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f4, this.currentY += f5);
    }

    @Override
    public void curvetoQuadraticAbs(float f2, float f3, float f4, float f5) {
        this.xCenter = f2;
        this.yCenter = f3;
        this.currentX = f4;
        this.currentY = f5;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticSmoothRel(float f2, float f3) {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f2, this.currentY += f3);
    }

    @Override
    public void curvetoQuadraticSmoothAbs(float f2, float f3) {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.currentX = f2;
        this.currentY = f3;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void arcRel(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
        this.xCenter = this.currentX += f5;
        this.yCenter = this.currentY += f6;
        this.path.arcTo(f2, f3, f4, bl2, bl3, this.currentX, this.currentY);
    }

    @Override
    public void arcAbs(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
        this.xCenter = this.currentX = f5;
        this.yCenter = this.currentY = f6;
        this.path.arcTo(f2, f3, f4, bl2, bl3, this.currentX, this.currentY);
    }
}

