/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public final class ArabicTextHandler {
    private static final int arabicStart = 1536;
    private static final int arabicEnd = 1791;
    private static final AttributedCharacterIterator.Attribute ARABIC_FORM = GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM;
    private static final Integer ARABIC_NONE = GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE;
    private static final Integer ARABIC_ISOLATED = GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED;
    private static final Integer ARABIC_TERMINAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL;
    private static final Integer ARABIC_INITIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL;
    private static final Integer ARABIC_MEDIAL = GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL;
    static int singleCharFirst = 1569;
    static int singleCharLast = 1610;
    static int[][] singleCharRemappings = new int[][]{{65152, -1, -1, -1}, {65153, 65154, -1, -1}, {65155, 65156, -1, -1}, {65157, 65158, -1, -1}, {65159, 65160, -1, -1}, {65161, 65162, 65163, 65164}, {65165, 65166, -1, -1}, {65167, 65168, 65169, 65170}, {65171, 65172, -1, -1}, {65173, 65174, 65175, 65176}, {65177, 65178, 65179, 65180}, {65181, 65182, 65183, 65184}, {65185, 65186, 65187, 65188}, {65189, 65190, 65191, 65192}, {65193, 65194, -1, -1}, {65195, 65196, -1, -1}, {65197, 65198, -1, -1}, {65199, 65200, -1, -1}, {65201, 65202, 65203, 65204}, {65205, 65206, 65207, 65208}, {65209, 65210, 65211, 65212}, {65213, 65214, 65215, 65216}, {65217, 65218, 65219, 65220}, {65221, 65222, 65223, 65224}, {65225, 65226, 65227, 65228}, {65229, 65230, 65231, 65232}, null, null, null, null, null, null, {65233, 65234, 65235, 65236}, {65237, 65238, 65239, 65240}, {65241, 65242, 65243, 65244}, {65245, 65246, 65247, 65248}, {65249, 65250, 65251, 65252}, {65253, 65254, 65255, 65256}, {65257, 65258, 65259, 65260}, {65261, 65262, -1, -1}, {65263, 65264, -1, -1}, {65265, 65266, 65267, 65268}};
    static int doubleCharFirst = 1570;
    static int doubleCharLast = 1618;
    static int[][][] doubleCharRemappings = new int[][][]{new int[][]{{1604, 65269, 65270, -1, -1}}, new int[][]{{1604, 65271, 65272, -1, -1}}, (int[][])null, new int[][]{{1604, 65273, 65274, -1, -1}}, (int[][])null, new int[][]{{1604, 65275, 65276, -1, -1}}, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, (int[][])null, new int[][]{{32, 65136, -1, -1, -1}, {1600, -1, -1, -1, 65137}}, new int[][]{{32, 65138, -1, -1, -1}}, new int[][]{{32, 65140, -1, -1, -1}}, new int[][]{{32, 65142, -1, -1, -1}, {1600, -1, -1, -1, 65143}}, new int[][]{{32, 65144, -1, -1, -1}, {1600, -1, -1, -1, 65145}}, new int[][]{{32, 65146, -1, -1, -1}, {1600, -1, -1, -1, 65147}}, new int[][]{{32, 65148, -1, -1, -1}, {1600, -1, -1, -1, 65149}}, new int[][]{{32, 65150, -1, -1, -1}, {1600, -1, -1, -1, 65151}}};

    private ArabicTextHandler() {
    }

    public static AttributedString assignArabicForms(AttributedString attributedString) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!ArabicTextHandler.containsArabic(attributedString)) {
            return attributedString;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n6 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        int[] nArray = null;
        if (n6 >= 3) {
            n5 = attributedCharacterIterator.first();
            n4 = attributedCharacterIterator.next();
            n3 = 1;
            n2 = attributedCharacterIterator.next();
            while (n2 != 65535) {
                if (ArabicTextHandler.arabicCharTransparent((char)n4) && ArabicTextHandler.hasSubstitute((char)n5, (char)n2)) {
                    int n7;
                    if (nArray == null) {
                        nArray = new int[n6];
                        for (n7 = 0; n7 < n6; ++n7) {
                            nArray[n7] = n7 + attributedCharacterIterator.getBeginIndex();
                        }
                    }
                    n7 = nArray[n3];
                    nArray[n3] = nArray[n3 - 1];
                    nArray[n3 - 1] = n7;
                }
                n5 = n4;
                n4 = n2;
                n2 = attributedCharacterIterator.next();
                ++n3;
            }
        }
        if (nArray != null) {
            StringBuffer stringBuffer = new StringBuffer(n6);
            for (n3 = 0; n3 < n6; ++n3) {
                n4 = attributedCharacterIterator.setIndex((int)nArray[n3]);
                stringBuffer.append((char)n4);
            }
            AttributedString attributedString2 = new AttributedString(stringBuffer.toString());
            for (n2 = 0; n2 < n6; ++n2) {
                attributedCharacterIterator.setIndex(nArray[n2]);
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                attributedString2.addAttributes(map, n2, n2 + 1);
            }
            if (nArray[0] != attributedCharacterIterator.getBeginIndex()) {
                attributedCharacterIterator.setIndex(nArray[0]);
                Float f2 = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
                Float f3 = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
                if (f2 != null && !f2.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, Float.valueOf(Float.NaN), nArray[0], nArray[0] + 1);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, f2, 0, 1);
                }
                if (f3 != null && !f3.isNaN()) {
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, Float.valueOf(Float.NaN), nArray[0], nArray[0] + 1);
                    attributedString2.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, f3, 0, 1);
                }
            }
            attributedString = attributedString2;
        }
        attributedCharacterIterator = attributedString.getIterator();
        n5 = -1;
        n4 = attributedCharacterIterator.getBeginIndex();
        n3 = attributedCharacterIterator.first();
        while (n3 != 65535) {
            if (n3 >= 1536 && n3 <= 1791) {
                if (n5 == -1) {
                    n5 = n4;
                }
            } else if (n5 != -1) {
                attributedString.addAttribute(ARABIC_FORM, ARABIC_NONE, n5, n4);
                n5 = -1;
            }
            n3 = attributedCharacterIterator.next();
            ++n4;
        }
        if (n5 != -1) {
            attributedString.addAttribute(ARABIC_FORM, ARABIC_NONE, n5, n4);
        }
        attributedCharacterIterator = attributedString.getIterator();
        n3 = attributedCharacterIterator.getBeginIndex();
        Integer n8 = ARABIC_NONE;
        block5: while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
            int n9 = attributedCharacterIterator.getRunStart(ARABIC_FORM);
            n3 = attributedCharacterIterator.getRunLimit(ARABIC_FORM);
            char c2 = attributedCharacterIterator.setIndex(n9);
            n8 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
            if (n8 == null) continue;
            int n10 = n9;
            int n11 = n9 - 1;
            while (n10 < n3) {
                char c3 = c2;
                c2 = attributedCharacterIterator.setIndex(n10);
                while (ArabicTextHandler.arabicCharTransparent(c2) && n10 < n3) {
                    c2 = attributedCharacterIterator.setIndex(++n10);
                }
                if (n10 >= n3) continue block5;
                Integer n12 = n8;
                n8 = ARABIC_NONE;
                if (n11 >= n9) {
                    if (ArabicTextHandler.arabicCharShapesRight(c3) && ArabicTextHandler.arabicCharShapesLeft(c2)) {
                        n12 = n12 + 1;
                        attributedString.addAttribute(ARABIC_FORM, n12, n11, n11 + 1);
                        n8 = ARABIC_INITIAL;
                    } else if (ArabicTextHandler.arabicCharShaped(c2)) {
                        n8 = ARABIC_ISOLATED;
                    }
                } else if (ArabicTextHandler.arabicCharShaped(c2)) {
                    n8 = ARABIC_ISOLATED;
                }
                if (n8 != ARABIC_NONE) {
                    attributedString.addAttribute(ARABIC_FORM, n8, n10, n10 + 1);
                }
                n11 = n10++;
            }
        }
        return attributedString;
    }

    public static boolean arabicChar(char c2) {
        return c2 >= '\u0600' && c2 <= '\u06ff';
    }

    public static boolean containsArabic(AttributedString attributedString) {
        return ArabicTextHandler.containsArabic(attributedString.getIterator());
    }

    public static boolean containsArabic(AttributedCharacterIterator attributedCharacterIterator) {
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            if (ArabicTextHandler.arabicChar(c2)) {
                return true;
            }
            c2 = attributedCharacterIterator.next();
        }
        return false;
    }

    public static boolean arabicCharTransparent(char c2) {
        char c3 = c2;
        if (c3 < '\u064b' || c3 > '\u06ed') {
            return false;
        }
        return c3 <= '\u0655' || c3 == '\u0670' || c3 >= '\u06d6' && c3 <= '\u06e4' || c3 >= '\u06e7' && c3 <= '\u06e8' || c3 >= '\u06ea';
    }

    private static boolean arabicCharShapesRight(char c2) {
        char c3 = c2;
        return c3 >= '\u0622' && c3 <= '\u0625' || c3 == '\u0627' || c3 == '\u0629' || c3 >= '\u062f' && c3 <= '\u0632' || c3 == '\u0648' || c3 >= '\u0671' && c3 <= '\u0673' || c3 >= '\u0675' && c3 <= '\u0677' || c3 >= '\u0688' && c3 <= '\u0699' || c3 == '\u06c0' || c3 >= '\u06c2' && c3 <= '\u06cb' || c3 == '\u06cd' || c3 == '\u06cf' || c3 >= '\u06d2' && c3 <= '\u06d3' || ArabicTextHandler.arabicCharShapesDuel(c2);
    }

    private static boolean arabicCharShapesDuel(char c2) {
        char c3 = c2;
        return c3 == '\u0626' || c3 == '\u0628' || c3 >= '\u062a' && c3 <= '\u062e' || c3 >= '\u0633' && c3 <= '\u063a' || c3 >= '\u0641' && c3 <= '\u0647' || c3 >= '\u0649' && c3 <= '\u064a' || c3 >= '\u0678' && c3 <= '\u0687' || c3 >= '\u069a' && c3 <= '\u06bf' || c3 == '\u06c1' || c3 == '\u06cc' || c3 == '\u06ce' || c3 >= '\u06d0' && c3 <= '\u06d1' || c3 >= '\u06fa' && c3 <= '\u06fc';
    }

    private static boolean arabicCharShapesLeft(char c2) {
        return ArabicTextHandler.arabicCharShapesDuel(c2);
    }

    private static boolean arabicCharShaped(char c2) {
        return ArabicTextHandler.arabicCharShapesRight(c2);
    }

    public static boolean hasSubstitute(char c2, char c3) {
        if (c2 < doubleCharFirst || c2 > doubleCharLast) {
            return false;
        }
        int[][] nArray = doubleCharRemappings[c2 - doubleCharFirst];
        if (nArray == null) {
            return false;
        }
        for (int[] nArray2 : nArray) {
            if (nArray2[0] != c3) continue;
            return true;
        }
        return false;
    }

    public static int getSubstituteChar(char c2, char c3, int n2) {
        if (n2 == 0) {
            return -1;
        }
        if (c2 < doubleCharFirst || c2 > doubleCharLast) {
            return -1;
        }
        int[][] nArray = doubleCharRemappings[c2 - doubleCharFirst];
        if (nArray == null) {
            return -1;
        }
        for (int[] nArray2 : nArray) {
            if (nArray2[0] != c3) continue;
            return nArray2[n2];
        }
        return -1;
    }

    public static int getSubstituteChar(char c2, int n2) {
        if (n2 == 0) {
            return -1;
        }
        if (c2 < singleCharFirst || c2 > singleCharLast) {
            return -1;
        }
        int[] nArray = singleCharRemappings[c2 - singleCharFirst];
        if (nArray == null) {
            return -1;
        }
        return nArray[n2 - 1];
    }

    public static String createSubstituteString(AttributedCharacterIterator attributedCharacterIterator) {
        int n2 = attributedCharacterIterator.getBeginIndex();
        int n3 = attributedCharacterIterator.getEndIndex();
        int n4 = n3 - n2;
        StringBuffer stringBuffer = new StringBuffer(n4);
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2;
            char c3 = attributedCharacterIterator.setIndex(i2);
            if (!ArabicTextHandler.arabicChar(c3)) {
                stringBuffer.append(c3);
                continue;
            }
            Integer n5 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
            if (ArabicTextHandler.charStartsLigature(c3) && i2 + 1 < n3) {
                c2 = attributedCharacterIterator.setIndex(i2 + 1);
                Integer n6 = (Integer)attributedCharacterIterator.getAttribute(ARABIC_FORM);
                if (n5 != null && n6 != null) {
                    int n7;
                    if (n5.equals(ARABIC_TERMINAL) && n6.equals(ARABIC_INITIAL)) {
                        n7 = ArabicTextHandler.getSubstituteChar(c3, c2, ARABIC_ISOLATED);
                        if (n7 > -1) {
                            stringBuffer.append((char)n7);
                            ++i2;
                            continue;
                        }
                    } else if (n5.equals(ARABIC_TERMINAL)) {
                        n7 = ArabicTextHandler.getSubstituteChar(c3, c2, ARABIC_TERMINAL);
                        if (n7 > -1) {
                            stringBuffer.append((char)n7);
                            ++i2;
                            continue;
                        }
                    } else if (n5.equals(ARABIC_MEDIAL) && n6.equals(ARABIC_MEDIAL) && (n7 = ArabicTextHandler.getSubstituteChar(c3, c2, ARABIC_MEDIAL)) > -1) {
                        stringBuffer.append((char)n7);
                        ++i2;
                        continue;
                    }
                }
            }
            if (n5 != null && n5 > 0 && (c2 = ArabicTextHandler.getSubstituteChar(c3, n5)) > '\uffffffff') {
                c3 = c2;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static boolean charStartsLigature(char c2) {
        char c3 = c2;
        return c3 == '\u064b' || c3 == '\u064c' || c3 == '\u064d' || c3 == '\u064e' || c3 == '\u064f' || c3 == '\u0650' || c3 == '\u0651' || c3 == '\u0652' || c3 == '\u0622' || c3 == '\u0623' || c3 == '\u0625' || c3 == '\u0627';
    }

    public static int getNumChars(char c2) {
        if (ArabicTextHandler.isLigature(c2)) {
            return 2;
        }
        return 1;
    }

    public static boolean isLigature(char c2) {
        char c3 = c2;
        if (c3 < '\ufe70' || c3 > '\ufefc') {
            return false;
        }
        return c3 <= '\ufe72' || c3 == '\ufe74' || c3 >= '\ufe76' && c3 <= '\ufe7f' || c3 >= '\ufef5';
    }
}

