/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;
    private TextPaintInfo cacheTPI;

    public SVGGVTGlyphVector(GVTFont gVTFont, Glyph[] glyphArray, FontRenderContext fontRenderContext) {
        this.font = gVTFont;
        this.glyphs = glyphArray;
        this.frc = fontRenderContext;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphArray.length];
        this.glyphVisible = new boolean[glyphArray.length];
        for (int i2 = 0; i2 < glyphArray.length; ++i2) {
            this.glyphVisible[i2] = true;
        }
        this.endPos = glyphArray[glyphArray.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphArray[glyphArray.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    @Override
    public GVTFont getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public int getGlyphCode(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + n2 + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[n2].getGlyphCode();
    }

    @Override
    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n3 + ", is illegal. It must be > 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n2 + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n2 + n3 > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n2 + "+" + n3 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (nArray == null) {
            nArray = new int[n3];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            nArray[i2 - n2] = this.glyphs[i2].getGlyphCode();
        }
        return nArray;
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    @Override
    public Shape getGlyphLogicalBounds(int n2) {
        if (this.glyphLogicalBounds[n2] == null && this.glyphVisible[n2]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n2];
    }

    private void computeGlyphLogicalBounds() {
        Cloneable cloneable;
        Rectangle2D rectangle2D;
        Shape[] shapeArray;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            shapeArray = this.font.getLineMetrics("By", this.frc);
            f2 = shapeArray.getAscent();
            f3 = shapeArray.getDescent();
            if (f3 < 0.0f) {
                f3 = -f3;
            }
        }
        if (f2 == 0.0f) {
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
                if (!this.glyphVisible[i2]) continue;
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i2);
                Rectangle2D rectangle2D2 = gVTGlyphMetrics.getBounds2D();
                f2 = (float)(-rectangle2D2.getMinY());
                f3 = (float)(rectangle2D2.getHeight() - (double)f2);
                if (f2 > f4) {
                    f4 = f2;
                }
                if (!(f3 > f5)) continue;
                f5 = f3;
            }
            f2 = f4;
            f3 = f5;
        }
        shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d2 = -1.0;
        double d3 = -1.0;
        for (int i3 = 0; i3 < this.getNumGlyphs(); ++i3) {
            if (!this.glyphVisible[i3]) {
                shapeArray[i3] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i3);
            GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i3);
            rectangle2D = new Rectangle2D.Double(0.0, -f2, gVTGlyphMetrics.getHorizontalAdvance(), f2 + f3);
            if (rectangle2D.isEmpty()) {
                if (i3 > 0) {
                    blArray[i3] = blArray[i3 - 1];
                    continue;
                }
                blArray[i3] = true;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            Point2D point2D = this.getGlyphPosition(i3);
            cloneable = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            if (affineTransform != null) {
                ((AffineTransform)cloneable).concatenate(affineTransform);
            }
            shapeArray[i3] = ((AffineTransform)cloneable).createTransformedShape(rectangle2D);
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            Point2D.Double double_6 = new Point2D.Double();
            ((AffineTransform)cloneable).transform(double_, double_4);
            ((AffineTransform)cloneable).transform(double_2, double_5);
            ((AffineTransform)cloneable).transform(double_3, double_6);
            double d4 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
            double d5 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
            double d6 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
            double d7 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
            blArray[i3] = Math.abs(d4) < 0.001 && Math.abs(d7) < 0.001 ? false : !(Math.abs(d5) < 0.001) || !(Math.abs(d6) < 0.001);
            Rectangle2D rectangle2D3 = shapeArray[i3].getBounds2D();
            if (rectangle2D3.getWidth() > d2) {
                d2 = rectangle2D3.getWidth();
            }
            if (!(rectangle2D3.getHeight() > d3)) continue;
            d3 = rectangle2D3.getHeight();
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i4 = 0; i4 < this.getNumGlyphs(); ++i4) {
            if (shapeArray[i4] == null) continue;
            generalPath.append(shapeArray[i4], false);
        }
        Rectangle2D rectangle2D4 = generalPath.getBounds2D();
        if (rectangle2D4.getHeight() < d3 * 1.5) {
            for (int i5 = 0; i5 < this.getNumGlyphs(); ++i5) {
                double d8;
                if (blArray[i5] || shapeArray[i5] == null) continue;
                rectangle2D = shapeArray[i5].getBounds2D();
                double d9 = rectangle2D.getMinX();
                double d10 = rectangle2D.getWidth();
                if (i5 < this.getNumGlyphs() - 1 && shapeArray[i5 + 1] != null && ((RectangularShape)(cloneable = shapeArray[i5 + 1].getBounds2D())).getX() > d9 && (d8 = ((RectangularShape)cloneable).getX() - d9) < d10 * 1.15 && d8 > d10 * 0.85) {
                    double d11 = (d8 - d10) * 0.5;
                    d10 += d11;
                    ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX() - d11, ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth() + d11, ((RectangularShape)cloneable).getHeight());
                }
                shapeArray[i5] = new Rectangle2D.Double(d9, rectangle2D4.getMinY(), d10, rectangle2D4.getHeight());
            }
        } else if (rectangle2D4.getWidth() < d2 * 1.5) {
            for (int i6 = 0; i6 < this.getNumGlyphs(); ++i6) {
                double d12;
                if (blArray[i6] || shapeArray[i6] == null) continue;
                rectangle2D = shapeArray[i6].getBounds2D();
                double d13 = rectangle2D.getMinY();
                double d14 = rectangle2D.getHeight();
                if (i6 < this.getNumGlyphs() - 1 && shapeArray[i6 + 1] != null && ((RectangularShape)(cloneable = shapeArray[i6 + 1].getBounds2D())).getY() > d13 && (d12 = ((RectangularShape)cloneable).getY() - d13) < d14 * 1.15 && d12 > d14 * 0.85) {
                    double d15 = (d12 - d14) * 0.5;
                    d14 += d15;
                    ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY() - d15, ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight() + d15);
                }
                shapeArray[i6] = new Rectangle2D.Double(rectangle2D4.getMinX(), d13, rectangle2D4.getWidth(), d14);
            }
        }
        System.arraycopy(shapeArray, 0, this.glyphLogicalBounds, 0, this.getNumGlyphs());
    }

    @Override
    public GVTGlyphMetrics getGlyphMetrics(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("idx: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        if (n2 < this.glyphs.length - 1 && this.font != null) {
            float f2 = this.font.getHKern(this.glyphs[n2].getGlyphCode(), this.glyphs[n2 + 1].getGlyphCode());
            float f3 = this.font.getVKern(this.glyphs[n2].getGlyphCode(), this.glyphs[n2 + 1].getGlyphCode());
            return this.glyphs[n2].getGlyphMetrics(f2, f3);
        }
        return this.glyphs[n2].getGlyphMetrics();
    }

    @Override
    public Shape getGlyphOutline(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n2].getOutline();
    }

    @Override
    public Rectangle2D getGlyphCellBounds(int n2) {
        return this.getGlyphLogicalBounds(n2).getBounds2D();
    }

    @Override
    public Point2D getGlyphPosition(int n2) {
        if (n2 == this.glyphs.length) {
            return this.endPos;
        }
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[n2].getPosition();
    }

    @Override
    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n3 + ", is illegal. It must be > 0.");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n2 + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n2 + n3 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n2 + '+' + n3 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (fArray == null) {
            fArray = new float[n3 * 2];
        }
        if (n2 + n3 == this.glyphs.length + 1) {
            fArray[--n3 * 2] = (float)this.endPos.getX();
            fArray[n3 * 2 + 1] = (float)this.endPos.getY();
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            Point2D point2D = this.glyphs[i2].getPosition();
            fArray[(i2 - n2) * 2] = (float)point2D.getX();
            fArray[(i2 - n2) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    @Override
    public AffineTransform getGlyphTransform(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[n2].getTransform();
    }

    @Override
    public Shape getGlyphVisualBounds(int n2) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        return this.glyphs[n2].getOutline();
    }

    @Override
    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        Rectangle2D rectangle2D = null;
        if (textPaintInfo.visible) {
            for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
                Rectangle2D rectangle2D2;
                if (!this.glyphVisible[i2] || (rectangle2D2 = this.glyphs[i2].getBounds2D()) == null) continue;
                if (rectangle2D == null) {
                    rectangle2D = rectangle2D2;
                    continue;
                }
                rectangle2D.add(rectangle2D2);
            }
        }
        this.bounds2D = rectangle2D;
        if (this.bounds2D == null) {
            this.bounds2D = new Rectangle2D.Float();
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        return this.bounds2D;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
                Shape shape = this.getGlyphLogicalBounds(i2);
                if (shape == null) continue;
                generalPath.append(shape, false);
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    @Override
    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    @Override
    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
                Shape shape;
                if (!this.glyphVisible[i2] || (shape = this.glyphs[i2].getOutline()) == null) continue;
                this.outline.append(shape, false);
            }
        }
        return this.outline;
    }

    @Override
    public Shape getOutline(float f2, float f3) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    @Override
    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    @Override
    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.outline = null;
        this.bounds2D = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
            Glyph glyph = this.glyphs[i2];
            glyph.setTransform(null);
            this.glyphLogicalBounds[i2] = null;
            String string = glyph.getUnicode();
            if (string != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(string.charAt(0))) {
                char c2;
                int n2;
                for (n2 = i2 + 1; n2 < this.glyphs.length && (string = this.glyphs[n2].getUnicode()) != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(c2 = string.charAt(0)); ++n2) {
                }
                if (n2 != this.glyphs.length) {
                    Glyph glyph2 = this.glyphs[n2];
                    float f4 = f2 + glyph2.getHorizAdvX();
                    for (int i3 = i2; i3 < n2; ++i3) {
                        glyph = this.glyphs[i3];
                        glyph.setTransform(null);
                        this.glyphLogicalBounds[i2] = null;
                        glyph.setPosition(new Point2D.Float(f4 - glyph.getHorizAdvX(), f3));
                    }
                    i2 = n2;
                    glyph = glyph2;
                }
            }
            glyph.setPosition(new Point2D.Float(f2, f3));
            f2 += glyph.getHorizAdvX();
        }
        this.endPos = new Point2D.Float(f2, f3);
    }

    @Override
    public void setGlyphPosition(int n2, Point2D point2D) {
        if (n2 == this.glyphs.length) {
            this.endPos = (Point2D)point2D.clone();
            return;
        }
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        this.glyphs[n2].setPosition(point2D);
        this.glyphLogicalBounds[n2] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    @Override
    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        if (n2 < 0 || n2 > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n2 + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + '.');
        }
        this.glyphs[n2].setTransform(affineTransform);
        this.glyphLogicalBounds[n2] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    @Override
    public void setGlyphVisible(int n2, boolean bl2) {
        if (bl2 == this.glyphVisible[n2]) {
            return;
        }
        this.glyphVisible[n2] = bl2;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[n2] = null;
    }

    @Override
    public boolean isGlyphVisible(int n2) {
        return this.glyphVisible[n2];
    }

    @Override
    public int getCharacterCount(int n2, int n3) {
        int n4 = 0;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.glyphs.length - 1) {
            n3 = this.glyphs.length - 1;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            Glyph glyph = this.glyphs[i2];
            if (glyph.getGlyphCode() == -1) {
                ++n4;
                continue;
            }
            String string = glyph.getUnicode();
            n4 += string.length();
        }
        return n4;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void maybeReverse(boolean bl2) {
    }

    @Override
    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (!textPaintInfo.visible) {
            return;
        }
        for (int i2 = 0; i2 < this.glyphs.length; ++i2) {
            if (!this.glyphVisible[i2]) continue;
            this.glyphs[i2].draw(graphics2D);
        }
    }
}

