/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.util.Arrays;
import org.apache.batik.gvt.font.UnicodeRange;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] nArray, int[] nArray2, UnicodeRange[] unicodeRangeArray, UnicodeRange[] unicodeRangeArray2, float f2) {
        this.firstGlyphCodes = nArray;
        this.secondGlyphCodes = nArray2;
        this.firstUnicodeRanges = unicodeRangeArray;
        this.secondUnicodeRanges = unicodeRangeArray2;
        this.kerningAdjust = f2;
        if (nArray != null) {
            Arrays.sort(this.firstGlyphCodes);
        }
        if (nArray2 != null) {
            Arrays.sort(this.secondGlyphCodes);
        }
    }

    public boolean matchesFirstGlyph(int n2, String string) {
        int n3;
        if (this.firstGlyphCodes != null && (n3 = Arrays.binarySearch(this.firstGlyphCodes, n2)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n3 = string.charAt(0);
        for (UnicodeRange unicodeRange : this.firstUnicodeRanges) {
            if (!unicodeRange.contains(n3)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesFirstGlyph(int n2, char c2) {
        int n3;
        if (this.firstGlyphCodes != null && (n3 = Arrays.binarySearch(this.firstGlyphCodes, n2)) >= 0) {
            return true;
        }
        for (UnicodeRange unicodeRange : this.firstUnicodeRanges) {
            if (!unicodeRange.contains(c2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n2, String string) {
        int n3;
        if (this.secondGlyphCodes != null && (n3 = Arrays.binarySearch(this.secondGlyphCodes, n2)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n3 = string.charAt(0);
        for (UnicodeRange unicodeRange : this.secondUnicodeRanges) {
            if (!unicodeRange.contains(n3)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n2, char c2) {
        int n3;
        if (this.secondGlyphCodes != null && (n3 = Arrays.binarySearch(this.secondGlyphCodes, n2)) >= 0) {
            return true;
        }
        for (UnicodeRange unicodeRange : this.secondUnicodeRanges) {
            if (!unicodeRange.contains(c2)) continue;
            return true;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

