/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AWTGlyphGeometryCache;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.util.Platform;

public class AWTGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GlyphVector awtGlyphVector;
    private AWTGVTFont gvtFont;
    private CharacterIterator ci;
    private Point2D[] defaultGlyphPositions;
    private Point2D.Float[] glyphPositions;
    private AffineTransform[] glyphTransforms;
    private Shape[] glyphOutlines;
    private Shape[] glyphVisualBounds;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private GVTGlyphMetrics[] glyphMetrics;
    private GeneralPath outline;
    private Rectangle2D visualBounds;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private double scaleFactor;
    private float ascent;
    private float descent;
    private TextPaintInfo cacheTPI;
    private static final boolean outlinesPositioned;
    private static final boolean drawGlyphVectorWorks;
    private static final boolean glyphVectorTransformWorks;

    public AWTGVTGlyphVector(GlyphVector glyphVector, AWTGVTFont aWTGVTFont, double d2, CharacterIterator characterIterator) {
        this.awtGlyphVector = glyphVector;
        this.gvtFont = aWTGVTFont;
        this.scaleFactor = d2;
        this.ci = characterIterator;
        GVTLineMetrics gVTLineMetrics = this.gvtFont.getLineMetrics("By", this.awtGlyphVector.getFontRenderContext());
        this.ascent = gVTLineMetrics.getAscent();
        this.descent = gVTLineMetrics.getDescent();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        int n2 = glyphVector.getNumGlyphs();
        this.glyphPositions = new Point2D.Float[n2 + 1];
        this.glyphTransforms = new AffineTransform[n2];
        this.glyphOutlines = new Shape[n2];
        this.glyphVisualBounds = new Shape[n2];
        this.glyphLogicalBounds = new Shape[n2];
        this.glyphVisible = new boolean[n2];
        this.glyphMetrics = new GVTGlyphMetrics[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.glyphVisible[i2] = true;
        }
    }

    @Override
    public GVTFont getFont() {
        return this.gvtFont;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.awtGlyphVector.getFontRenderContext();
    }

    @Override
    public int getGlyphCode(int n2) {
        return this.awtGlyphVector.getGlyphCode(n2);
    }

    @Override
    public int[] getGlyphCodes(int n2, int n3, int[] nArray) {
        return this.awtGlyphVector.getGlyphCodes(n2, n3, nArray);
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int n2) {
        return this.awtGlyphVector.getGlyphJustificationInfo(n2);
    }

    @Override
    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        if (textPaintInfo == null) {
            return null;
        }
        if (!textPaintInfo.visible) {
            return null;
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        Shape shape = null;
        if (textPaintInfo.fillPaint != null) {
            shape = this.getOutline();
            this.bounds2D = shape.getBounds2D();
        }
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint = textPaintInfo.strokePaint;
        if (stroke != null && paint != null) {
            if (shape == null) {
                shape = this.getOutline();
            }
            Rectangle2D rectangle2D = stroke.createStrokedShape(shape).getBounds2D();
            if (this.bounds2D == null) {
                this.bounds2D = rectangle2D;
            } else {
                this.bounds2D.add(rectangle2D);
            }
        }
        if (this.bounds2D == null) {
            return null;
        }
        if (this.bounds2D.getWidth() == 0.0 || this.bounds2D.getHeight() == 0.0) {
            this.bounds2D = null;
        }
        return this.bounds2D;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            this.computeGlyphLogicalBounds();
        }
        return this.logicalBounds;
    }

    @Override
    public Shape getGlyphLogicalBounds(int n2) {
        if (this.glyphLogicalBounds[n2] == null && this.glyphVisible[n2]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n2];
    }

    private void computeGlyphLogicalBounds() {
        int n2;
        Rectangle2D rectangle2D;
        Object object;
        Shape[] shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d2 = -1.0;
        double d3 = -1.0;
        for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
            float f2;
            if (!this.glyphVisible[i2]) {
                shapeArray[i2] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i2);
            float f3 = 0.0f;
            float f4 = (float)((double)(-this.ascent) / this.scaleFactor);
            object = this.getGlyphMetrics(i2);
            float f5 = (float)((double)((GVTGlyphMetrics)object).getHorizontalAdvance() / this.scaleFactor);
            rectangle2D = new Rectangle2D.Double(f3, f4, f5, f2 = (float)((double)((GVTGlyphMetrics)object).getVerticalAdvance() / this.scaleFactor));
            if (rectangle2D.isEmpty()) {
                if (i2 > 0) {
                    blArray[i2] = blArray[i2 - 1];
                    continue;
                }
                blArray[i2] = true;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            Point2D point2D = this.getGlyphPosition(i2);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            if (affineTransform != null) {
                affineTransform2.concatenate(affineTransform);
            }
            affineTransform2.scale(this.scaleFactor, this.scaleFactor);
            shapeArray[i2] = affineTransform2.createTransformedShape(rectangle2D);
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            Point2D.Double double_6 = new Point2D.Double();
            affineTransform2.transform(double_, double_4);
            affineTransform2.transform(double_2, double_5);
            affineTransform2.transform(double_3, double_6);
            double d4 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
            double d5 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
            double d6 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
            double d7 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
            blArray[i2] = !(Math.abs(d4) < 0.001 && Math.abs(d7) < 0.001 || Math.abs(d5) < 0.001 && Math.abs(d6) < 0.001);
            Rectangle2D rectangle2D2 = shapeArray[i2].getBounds2D();
            if (rectangle2D2.getWidth() > d2) {
                d2 = rectangle2D2.getWidth();
            }
            if (!(rectangle2D2.getHeight() > d3)) continue;
            d3 = rectangle2D2.getHeight();
        }
        GeneralPath generalPath = new GeneralPath();
        for (n2 = 0; n2 < this.getNumGlyphs(); ++n2) {
            if (shapeArray[n2] == null) continue;
            generalPath.append(shapeArray[n2], false);
        }
        this.logicalBounds = generalPath.getBounds2D();
        if (this.logicalBounds.getHeight() < d3 * 1.5) {
            for (n2 = 0; n2 < this.getNumGlyphs(); ++n2) {
                double d8;
                if (blArray[n2] || shapeArray[n2] == null) continue;
                object = shapeArray[n2].getBounds2D();
                double d9 = ((RectangularShape)object).getMinX();
                double d10 = ((RectangularShape)object).getWidth();
                if (n2 < this.getNumGlyphs() - 1 && shapeArray[n2 + 1] != null && (rectangle2D = shapeArray[n2 + 1].getBounds2D()).getX() > d9 && (d8 = rectangle2D.getX() - d9) < d10 * 1.15 && d8 > d10 * 0.85) {
                    double d11 = (d8 - d10) * 0.5;
                    d10 += d11;
                    rectangle2D.setRect(rectangle2D.getX() - d11, rectangle2D.getY(), rectangle2D.getWidth() + d11, rectangle2D.getHeight());
                }
                shapeArray[n2] = new Rectangle2D.Double(d9, this.logicalBounds.getMinY(), d10, this.logicalBounds.getHeight());
            }
        } else if (this.logicalBounds.getWidth() < d2 * 1.5) {
            for (n2 = 0; n2 < this.getNumGlyphs(); ++n2) {
                double d12;
                if (blArray[n2] || shapeArray[n2] == null) continue;
                object = shapeArray[n2].getBounds2D();
                double d13 = ((RectangularShape)object).getMinY();
                double d14 = ((RectangularShape)object).getHeight();
                if (n2 < this.getNumGlyphs() - 1 && shapeArray[n2 + 1] != null && (rectangle2D = shapeArray[n2 + 1].getBounds2D()).getY() > d13 && (d12 = rectangle2D.getY() - d13) < d14 * 1.15 && d12 > d14 * 0.85) {
                    double d15 = (d12 - d14) * 0.5;
                    d14 += d15;
                    rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() - d15, rectangle2D.getWidth(), rectangle2D.getHeight() + d15);
                }
                shapeArray[n2] = new Rectangle2D.Double(this.logicalBounds.getMinX(), d13, this.logicalBounds.getWidth(), d14);
            }
        }
        System.arraycopy(shapeArray, 0, this.glyphLogicalBounds, 0, this.getNumGlyphs());
    }

    @Override
    public GVTGlyphMetrics getGlyphMetrics(int n2) {
        if (this.glyphMetrics[n2] != null) {
            return this.glyphMetrics[n2];
        }
        Point2D point2D = this.defaultGlyphPositions[n2];
        char c2 = this.ci.setIndex(this.ci.getBeginIndex() + n2);
        this.ci.setIndex(this.ci.getBeginIndex());
        AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c2, this.awtGlyphVector, n2, point2D);
        Rectangle2D rectangle2D = value.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() * this.scaleFactor, rectangle2D.getY() * this.scaleFactor, rectangle2D.getWidth() * this.scaleFactor, rectangle2D.getHeight() * this.scaleFactor);
        float f2 = (float)(this.defaultGlyphPositions[n2 + 1].getX() - this.defaultGlyphPositions[n2].getX());
        this.glyphMetrics[n2] = new GVTGlyphMetrics((float)((double)f2 * this.scaleFactor), this.ascent + this.descent, double_, 0);
        return this.glyphMetrics[n2];
    }

    @Override
    public Shape getGlyphOutline(int n2) {
        if (this.glyphOutlines[n2] == null) {
            Point2D point2D = this.defaultGlyphPositions[n2];
            char c2 = this.ci.setIndex(this.ci.getBeginIndex() + n2);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c2, this.awtGlyphVector, n2, point2D);
            Shape shape = value.getOutline();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n2).getX(), this.getGlyphPosition(n2).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n2);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphOutlines[n2] = affineTransform.createTransformedShape(shape);
        }
        return this.glyphOutlines[n2];
    }

    static boolean outlinesPositioned() {
        return outlinesPositioned;
    }

    @Override
    public Rectangle2D getGlyphCellBounds(int n2) {
        return this.getGlyphLogicalBounds(n2).getBounds2D();
    }

    @Override
    public Point2D getGlyphPosition(int n2) {
        return this.glyphPositions[n2];
    }

    @Override
    public float[] getGlyphPositions(int n2, int n3, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n3 * 2];
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            Point2D point2D = this.getGlyphPosition(i2);
            fArray[(i2 - n2) * 2] = (float)point2D.getX();
            fArray[(i2 - n2) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    @Override
    public AffineTransform getGlyphTransform(int n2) {
        return this.glyphTransforms[n2];
    }

    @Override
    public Shape getGlyphVisualBounds(int n2) {
        if (this.glyphVisualBounds[n2] == null) {
            Point2D point2D = this.defaultGlyphPositions[n2];
            char c2 = this.ci.setIndex(this.ci.getBeginIndex() + n2);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c2, this.awtGlyphVector, n2, point2D);
            Rectangle2D rectangle2D = value.getOutlineBounds2D();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n2).getX(), this.getGlyphPosition(n2).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n2);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphVisualBounds[n2] = affineTransform.createTransformedShape(rectangle2D);
        }
        return this.glyphVisualBounds[n2];
    }

    @Override
    public int getNumGlyphs() {
        return this.awtGlyphVector.getNumGlyphs();
    }

    @Override
    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        for (int i2 = 0; i2 < this.getNumGlyphs(); ++i2) {
            if (!this.glyphVisible[i2]) continue;
            Shape shape = this.getGlyphOutline(i2);
            this.outline.append(shape, false);
        }
        return this.outline;
    }

    @Override
    public Shape getOutline(float f2, float f3) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    @Override
    public Rectangle2D getGeometricBounds() {
        if (this.visualBounds == null) {
            Shape shape = this.getOutline();
            this.visualBounds = shape.getBounds2D();
        }
        return this.visualBounds;
    }

    @Override
    public void performDefaultLayout() {
        Point2D point2D;
        int n2;
        if (this.defaultGlyphPositions == null) {
            this.awtGlyphVector.performDefaultLayout();
            this.defaultGlyphPositions = new Point2D.Float[this.getNumGlyphs() + 1];
            for (int i2 = 0; i2 <= this.getNumGlyphs(); ++i2) {
                this.defaultGlyphPositions[i2] = this.awtGlyphVector.getGlyphPosition(i2);
            }
        }
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        float f2 = 0.0f;
        for (n2 = 0; n2 < this.getNumGlyphs(); ++n2) {
            this.glyphTransforms[n2] = null;
            this.glyphVisualBounds[n2] = null;
            this.glyphLogicalBounds[n2] = null;
            this.glyphOutlines[n2] = null;
            this.glyphMetrics[n2] = null;
            point2D = this.defaultGlyphPositions[n2];
            float f3 = (float)(point2D.getX() * this.scaleFactor - (double)f2);
            float f4 = (float)(point2D.getY() * this.scaleFactor);
            this.ci.setIndex(n2 + this.ci.getBeginIndex());
            if (this.glyphPositions[n2] == null) {
                this.glyphPositions[n2] = new Point2D.Float(f3, f4);
                continue;
            }
            this.glyphPositions[n2].x = f3;
            this.glyphPositions[n2].y = f4;
        }
        point2D = this.defaultGlyphPositions[n2];
        this.glyphPositions[n2] = new Point2D.Float((float)(point2D.getX() * this.scaleFactor - (double)f2), (float)(point2D.getY() * this.scaleFactor));
    }

    @Override
    public void setGlyphPosition(int n2, Point2D point2D) {
        this.glyphPositions[n2].x = (float)point2D.getX();
        this.glyphPositions[n2].y = (float)point2D.getY();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        if (n2 != this.getNumGlyphs()) {
            this.glyphVisualBounds[n2] = null;
            this.glyphLogicalBounds[n2] = null;
            this.glyphOutlines[n2] = null;
            this.glyphMetrics[n2] = null;
        }
    }

    @Override
    public void setGlyphTransform(int n2, AffineTransform affineTransform) {
        this.glyphTransforms[n2] = affineTransform;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n2] = null;
        this.glyphLogicalBounds[n2] = null;
        this.glyphOutlines[n2] = null;
        this.glyphMetrics[n2] = null;
    }

    @Override
    public void setGlyphVisible(int n2, boolean bl2) {
        if (bl2 == this.glyphVisible[n2]) {
            return;
        }
        this.glyphVisible[n2] = bl2;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n2] = null;
        this.glyphLogicalBounds[n2] = null;
        this.glyphOutlines[n2] = null;
        this.glyphMetrics[n2] = null;
    }

    @Override
    public boolean isGlyphVisible(int n2) {
        return this.glyphVisible[n2];
    }

    @Override
    public int getCharacterCount(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= this.getNumGlyphs()) {
            n3 = this.getNumGlyphs() - 1;
        }
        int n4 = 0;
        int n5 = n2 + this.ci.getBeginIndex();
        int n6 = n3 + this.ci.getBeginIndex();
        char c2 = this.ci.setIndex(n5);
        while (this.ci.getIndex() <= n6) {
            n4 += ArabicTextHandler.getNumChars(c2);
            c2 = this.ci.next();
        }
        return n4;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public void maybeReverse(boolean bl2) {
    }

    @Override
    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        int n2;
        int n3 = this.getNumGlyphs();
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO);
        if (textPaintInfo == null) {
            return;
        }
        if (!textPaintInfo.visible) {
            return;
        }
        Paint paint = textPaintInfo.fillPaint;
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint2 = textPaintInfo.strokePaint;
        if (paint == null && (paint2 == null || stroke == null)) {
            return;
        }
        boolean bl2 = drawGlyphVectorWorks;
        if (bl2 && stroke != null && paint2 != null) {
            bl2 = false;
        }
        if (bl2 && paint != null && !(paint instanceof Color)) {
            bl2 = false;
        }
        if (bl2) {
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            if (object2 == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object3 == RenderingHints.VALUE_STROKE_PURE) {
                bl2 = false;
            }
        }
        int n4 = 16;
        int n5 = 32;
        if (bl2 && (((n2 = ((AffineTransform)(object = graphics2D.getTransform())).getType()) & 0x20) != 0 || (n2 & 0x10) != 0)) {
            bl2 = false;
        }
        if (bl2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6;
                if (!this.glyphVisible[i2]) {
                    bl2 = false;
                    break;
                }
                AffineTransform affineTransform = this.glyphTransforms[i2];
                if (affineTransform == null || ((n6 = affineTransform.getType()) & 0xFFFFFFFE) == 0 || glyphVectorTransformWorks && (n6 & 0x20) == 0 && (n6 & 0x10) == 0) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            Point2D point2D;
            int n7;
            double d2 = this.scaleFactor;
            double[] dArray = new double[6];
            for (n7 = 0; n7 < n3; ++n7) {
                point2D = this.glyphPositions[n7];
                double d3 = ((Point2D)point2D).getX();
                double d4 = ((Point2D)point2D).getY();
                AffineTransform affineTransform = this.glyphTransforms[n7];
                if (affineTransform != null) {
                    affineTransform.getMatrix(dArray);
                    d3 += dArray[4];
                    d4 += dArray[5];
                    if (dArray[0] != 1.0 || dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[3] != 1.0) {
                        dArray[4] = 0.0;
                        dArray[5] = 0.0;
                        affineTransform = new AffineTransform(dArray);
                    } else {
                        affineTransform = null;
                    }
                }
                point2D = new Point2D.Double(d3 / d2, d4 / d2);
                this.awtGlyphVector.setGlyphPosition(n7, point2D);
                this.awtGlyphVector.setGlyphTransform(n7, affineTransform);
            }
            graphics2D.scale(d2, d2);
            graphics2D.setPaint(paint);
            graphics2D.drawGlyphVector(this.awtGlyphVector, 0.0f, 0.0f);
            graphics2D.scale(1.0 / d2, 1.0 / d2);
            for (n7 = 0; n7 < n3; ++n7) {
                point2D = this.defaultGlyphPositions[n7];
                this.awtGlyphVector.setGlyphPosition(n7, point2D);
                this.awtGlyphVector.setGlyphTransform(n7, null);
            }
        } else {
            object = this.getOutline();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill((Shape)object);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw((Shape)object);
            }
        }
    }

    static {
        String string = System.getProperty("java.specification.version");
        if ("1.6".compareTo(string) <= 0) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = false;
            glyphVectorTransformWorks = true;
        } else if ("1.4".compareTo(string) <= 0) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = true;
        } else if (Platform.isOSX) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = false;
            glyphVectorTransformWorks = false;
        } else {
            outlinesPositioned = false;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = false;
        }
    }
}

