/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.geom.Point2D;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTGlyphVector;

public class LineInfo {
    FlowRegions fr;
    double lineHeight = -1.0;
    double ascent = -1.0;
    double descent = -1.0;
    double hLeading = -1.0;
    double baseline;
    int numGlyphs;
    int words = 0;
    int size = 0;
    GlyphGroupInfo[] ggis = null;
    int newSize = 0;
    GlyphGroupInfo[] newGGIS = null;
    int numRanges;
    double[] ranges;
    double[] rangeAdv;
    BlockInfo bi = null;
    boolean paraStart;
    boolean paraEnd;
    protected static final int FULL_WORD = 0;
    protected static final int FULL_ADV = 1;
    static final float MAX_COMPRESS = 0.1f;
    static final float COMRESS_SCALE = 3.0f;

    public LineInfo(FlowRegions flowRegions, BlockInfo blockInfo, boolean bl2) {
        this.fr = flowRegions;
        this.bi = blockInfo;
        this.lineHeight = blockInfo.getLineHeight();
        this.ascent = blockInfo.getAscent();
        this.descent = blockInfo.getDescent();
        this.hLeading = (this.lineHeight - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(flowRegions.getCurrentY() + this.hLeading + this.ascent);
        this.paraStart = bl2;
        this.paraEnd = false;
        if (this.lineHeight > 0.0) {
            flowRegions.newLineHeight(this.lineHeight);
            this.updateRangeInfo();
        }
    }

    public void setParaEnd(boolean bl2) {
        this.paraEnd = bl2;
    }

    public boolean addWord(WordInfo wordInfo) {
        double d2 = wordInfo.getLineHeight();
        if (d2 <= this.lineHeight) {
            return this.insertWord(wordInfo);
        }
        this.fr.newLineHeight(d2);
        if (!this.updateRangeInfo()) {
            if (this.lineHeight > 0.0) {
                this.fr.newLineHeight(this.lineHeight);
            }
            return false;
        }
        if (!this.insertWord(wordInfo)) {
            if (this.lineHeight > 0.0) {
                this.setLineHeight(this.lineHeight);
            }
            return false;
        }
        this.lineHeight = d2;
        if ((double)wordInfo.getAscent() > this.ascent) {
            this.ascent = wordInfo.getAscent();
        }
        if ((double)wordInfo.getDescent() > this.descent) {
            this.descent = wordInfo.getDescent();
        }
        this.hLeading = (d2 - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return true;
    }

    public boolean insertWord(WordInfo wordInfo) {
        this.mergeGlyphGroups(wordInfo);
        if (!this.assignGlyphGroupRanges(this.newSize, this.newGGIS)) {
            return false;
        }
        this.swapGlyphGroupInfo();
        return true;
    }

    public boolean assignGlyphGroupRanges(int n2, GlyphGroupInfo[] glyphGroupInfoArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.numRanges; ++i2) {
            GlyphGroupInfo glyphGroupInfo;
            double d2 = this.ranges[2 * i2 + 1] - this.ranges[2 * i2];
            float f2 = 0.0f;
            float f3 = 0.0f;
            while (n3 < n2) {
                glyphGroupInfo = glyphGroupInfoArray[n3];
                glyphGroupInfo.setRange(i2);
                f2 = glyphGroupInfo.getAdvance();
                double d3 = d2 - (double)(f3 + f2);
                if (d3 < 0.0) break;
                ++n3;
                f3 += f2;
            }
            if (n3 == n2) {
                --n3;
                f3 -= f2;
            }
            glyphGroupInfo = glyphGroupInfoArray[n3];
            float f4 = glyphGroupInfo.getLastAdvance();
            while ((double)(f3 + f4) > d2) {
                f4 = 0.0f;
                if (--n3 < 0 || i2 != (glyphGroupInfo = glyphGroupInfoArray[n3]).getRange()) break;
                f3 -= glyphGroupInfo.getAdvance();
                f4 = glyphGroupInfo.getLastAdvance();
            }
            this.rangeAdv[i2] = f3 + f4;
            if (++n3 != n2) continue;
            return true;
        }
        return false;
    }

    public boolean setLineHeight(double d2) {
        this.fr.newLineHeight(d2);
        if (this.updateRangeInfo()) {
            this.lineHeight = d2;
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.fr.newLineHeight(this.lineHeight);
        }
        return false;
    }

    public double getCurrentY() {
        return this.fr.getCurrentY();
    }

    public boolean gotoY(double d2) {
        if (this.fr.gotoY(d2)) {
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.updateRangeInfo();
        }
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return false;
    }

    protected boolean updateRangeInfo() {
        int n2;
        this.fr.resetRange();
        int n3 = this.fr.getNumRangeOnLine();
        if (n3 == 0) {
            return false;
        }
        this.numRanges = n3;
        if (this.ranges == null) {
            this.rangeAdv = new double[this.numRanges];
            this.ranges = new double[2 * this.numRanges];
        } else if (this.numRanges > this.rangeAdv.length) {
            n2 = 2 * this.rangeAdv.length;
            if (n2 < this.numRanges) {
                n2 = this.numRanges;
            }
            this.rangeAdv = new double[n2];
            this.ranges = new double[2 * n2];
        }
        for (n2 = 0; n2 < this.numRanges; ++n2) {
            double d2;
            double[] dArray = this.fr.nextRange();
            double d3 = dArray[0];
            if (n2 == 0) {
                d2 = this.bi.getLeftMargin();
                if (this.paraStart) {
                    double d4 = this.bi.getIndent();
                    d2 = d2 < -d4 ? 0.0 : (d2 += d4);
                }
                d3 += d2;
            }
            d2 = dArray[1];
            if (n2 == this.numRanges - 1) {
                d2 -= (double)this.bi.getRightMargin();
            }
            this.ranges[2 * n2] = d3;
            this.ranges[2 * n2 + 1] = d2;
        }
        return true;
    }

    protected void swapGlyphGroupInfo() {
        GlyphGroupInfo[] glyphGroupInfoArray = this.ggis;
        this.ggis = this.newGGIS;
        this.newGGIS = glyphGroupInfoArray;
        this.size = this.newSize;
        this.newSize = 0;
    }

    protected void mergeGlyphGroups(WordInfo wordInfo) {
        int n2 = wordInfo.getNumGlyphGroups();
        this.newSize = 0;
        if (this.ggis == null) {
            this.newSize = n2;
            this.newGGIS = new GlyphGroupInfo[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.newGGIS[i2] = wordInfo.getGlyphGroup(i2);
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            GlyphGroupInfo glyphGroupInfo = wordInfo.getGlyphGroup(n4);
            int n5 = glyphGroupInfo.getStart();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[this.size - 1];
            int n6 = glyphGroupInfo2.getStart();
            this.newGGIS = LineInfo.assureSize(this.newGGIS, this.size + n2);
            if (n5 < n6) {
                glyphGroupInfo2 = this.ggis[n3];
                n6 = glyphGroupInfo2.getStart();
                while (n3 < this.size && n4 < n2) {
                    if (n5 < n6) {
                        this.newGGIS[this.newSize++] = glyphGroupInfo;
                        if (++n4 >= n2) continue;
                        glyphGroupInfo = wordInfo.getGlyphGroup(n4);
                        n5 = glyphGroupInfo.getStart();
                        continue;
                    }
                    this.newGGIS[this.newSize++] = glyphGroupInfo2;
                    if (++n3 >= this.size) continue;
                    glyphGroupInfo2 = this.ggis[n3];
                    n6 = glyphGroupInfo2.getStart();
                }
            }
            while (n3 < this.size) {
                this.newGGIS[this.newSize++] = this.ggis[n3++];
            }
            while (n4 < n2) {
                this.newGGIS[this.newSize++] = wordInfo.getGlyphGroup(n4++);
            }
        }
    }

    public void layout() {
        int n2;
        int n3;
        if (this.size == 0) {
            return;
        }
        this.assignGlyphGroupRanges(this.size, this.ggis);
        GVTGlyphVector gVTGlyphVector = this.ggis[0].getGlyphVector();
        boolean bl2 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = new int[this.numRanges];
        int[] nArray2 = new int[this.numRanges];
        GlyphGroupInfo[] glyphGroupInfoArray = new GlyphGroupInfo[this.numRanges];
        GlyphGroupInfo glyphGroupInfo = this.ggis[0];
        int n4 = n3 = glyphGroupInfo.getRange();
        nArray[n4] = nArray[n4] + 1;
        int n5 = n3;
        nArray2[n5] = nArray2[n5] + glyphGroupInfo.getGlyphCount();
        for (n2 = 1; n2 < this.size; ++n2) {
            glyphGroupInfo = this.ggis[n2];
            n3 = glyphGroupInfo.getRange();
            if (glyphGroupInfoArray[n3] == null || !glyphGroupInfoArray[n3].getHideLast()) {
                int n6 = n3;
                nArray[n6] = nArray[n6] + 1;
            }
            glyphGroupInfoArray[n3] = glyphGroupInfo;
            int n7 = n3;
            nArray2[n7] = nArray2[n7] + glyphGroupInfo.getGlyphCount();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[n2 - 1];
            int n8 = glyphGroupInfo2.getRange();
            if (n3 == n8) continue;
            int n9 = n8;
            nArray2[n9] = nArray2[n9] + (glyphGroupInfo2.getLastGlyphCount() - glyphGroupInfo2.getGlyphCount());
        }
        int n10 = n3;
        nArray2[n10] = nArray2[n10] + (glyphGroupInfo.getLastGlyphCount() - glyphGroupInfo.getGlyphCount());
        n2 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        n3 = -1;
        glyphGroupInfo = null;
        for (int i2 = 0; i2 < this.size; ++i2) {
            int n11;
            block20: {
                GlyphGroupInfo glyphGroupInfo3;
                block19: {
                    glyphGroupInfo3 = glyphGroupInfo;
                    int n12 = n2;
                    glyphGroupInfo = this.ggis[i2];
                    n2 = glyphGroupInfo.getRange();
                    if (n2 == n12) break block19;
                    d4 = this.ranges[2 * n2];
                    d5 = this.ranges[2 * n2 + 1] - d4;
                    d6 = this.rangeAdv[n2];
                    n11 = this.bi.getTextAlignment();
                    if (this.paraEnd && n11 == 3) {
                        n11 = 0;
                    }
                    switch (n11) {
                        default: {
                            int n13;
                            double d7 = d5 - d6;
                            if (!bl2) {
                                n13 = nArray[n2] - 1;
                                if (n13 >= 1) {
                                    d2 = d7 / (double)n13;
                                    break;
                                }
                            } else {
                                n13 = nArray2[n2] - 1;
                                if (n13 >= 1) {
                                    d3 = d7 / (double)n13;
                                    break;
                                }
                            }
                            break block20;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            d4 += (d5 - d6) / 2.0;
                            break;
                        }
                        case 2: {
                            d4 += d5 - d6;
                        }
                    }
                    break block20;
                }
                if (glyphGroupInfo3 != null && glyphGroupInfo3.getHideLast()) {
                    gVTGlyphVector.setGlyphVisible(glyphGroupInfo3.getEnd(), false);
                }
            }
            n11 = glyphGroupInfo.getStart();
            int n14 = glyphGroupInfo.getEnd();
            boolean[] blArray = glyphGroupInfo.getHide();
            Point2D point2D = gVTGlyphVector.getGlyphPosition(n11);
            double d8 = point2D.getX();
            double d9 = 0.0;
            for (int i3 = n11; i3 <= n14; ++i3) {
                Point2D point2D2 = gVTGlyphVector.getGlyphPosition(i3 + 1);
                if (blArray[i3 - n11]) {
                    gVTGlyphVector.setGlyphVisible(i3, false);
                    d9 += point2D2.getX() - point2D.getX();
                } else {
                    gVTGlyphVector.setGlyphVisible(i3, true);
                }
                point2D.setLocation(point2D.getX() - d8 - d9 + d4, point2D.getY() + this.baseline);
                gVTGlyphVector.setGlyphPosition(i3, point2D);
                point2D = point2D2;
                d9 -= d3;
            }
            if (glyphGroupInfo.getHideLast()) {
                d4 += (double)glyphGroupInfo.getAdvance() - d9;
                continue;
            }
            d4 += (double)glyphGroupInfo.getAdvance() - d9 + d2;
        }
    }

    public static GlyphGroupInfo[] assureSize(GlyphGroupInfo[] glyphGroupInfoArray, int n2) {
        if (glyphGroupInfoArray == null) {
            if (n2 < 10) {
                n2 = 10;
            }
            return new GlyphGroupInfo[n2];
        }
        if (n2 <= glyphGroupInfoArray.length) {
            return glyphGroupInfoArray;
        }
        int n3 = glyphGroupInfoArray.length * 2;
        if (n3 < n2) {
            n3 = n2;
        }
        return new GlyphGroupInfo[n3];
    }
}

