/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.geom.Segment;
import org.apache.batik.ext.awt.geom.SegmentList;

public class FlowRegions {
    Shape flowShape;
    SegmentList sl;
    SegmentList.SplitResults sr;
    List validRanges;
    int currentRange;
    double currentY;
    double lineHeight;

    public FlowRegions(Shape shape) {
        this(shape, shape.getBounds2D().getY());
    }

    public FlowRegions(Shape shape, double d2) {
        this.flowShape = shape;
        this.sl = new SegmentList(shape);
        this.currentY = d2 - 1.0;
        this.gotoY(d2);
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public double getLineHeight() {
        return this.lineHeight;
    }

    public boolean gotoY(double d2) {
        if (d2 < this.currentY) {
            throw new IllegalArgumentException("New Y can not be lower than old Y\nOld Y: " + this.currentY + " New Y: " + d2);
        }
        if (d2 == this.currentY) {
            return false;
        }
        this.sr = this.sl.split(d2);
        this.sl = this.sr.getBelow();
        this.sr = null;
        this.currentY = d2;
        if (this.sl == null) {
            return true;
        }
        this.newLineHeight(this.lineHeight);
        return false;
    }

    public void newLineHeight(double d2) {
        this.lineHeight = d2;
        this.sr = this.sl.split(this.currentY + d2);
        if (this.sr.getAbove() != null) {
            this.sortRow(this.sr.getAbove());
        }
        this.currentRange = 0;
    }

    public int getNumRangeOnLine() {
        if (this.validRanges == null) {
            return 0;
        }
        return this.validRanges.size();
    }

    public void resetRange() {
        this.currentRange = 0;
    }

    public double[] nextRange() {
        if (this.currentRange >= this.validRanges.size()) {
            return null;
        }
        return (double[])this.validRanges.get(this.currentRange++);
    }

    public void endLine() {
        this.sl = this.sr.getBelow();
        this.sr = null;
        this.currentY += this.lineHeight;
    }

    public boolean newLine() {
        return this.newLine(this.lineHeight);
    }

    public boolean newLine(double d2) {
        if (this.sr != null) {
            this.sl = this.sr.getBelow();
        }
        this.sr = null;
        if (this.sl == null) {
            return false;
        }
        this.currentY += this.lineHeight;
        this.newLineHeight(d2);
        return true;
    }

    public boolean newLineAt(double d2, double d3) {
        if (this.sr != null) {
            this.sl = this.sr.getBelow();
        }
        this.sr = null;
        if (this.sl == null) {
            return false;
        }
        this.currentY = d2;
        this.newLineHeight(d3);
        return true;
    }

    public boolean done() {
        return this.sl == null;
    }

    public void sortRow(SegmentList segmentList) {
        Transition[] transitionArray = new Transition[segmentList.size() * 2];
        Iterator iterator = segmentList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            transitionArray[n2++] = new Transition(segment.minX(), true);
            transitionArray[n2++] = new Transition(segment.maxX(), false);
        }
        Arrays.sort(transitionArray, TransitionComp.COMP);
        this.validRanges = new ArrayList();
        int n3 = 1;
        double d2 = 0.0;
        for (n2 = 1; n2 < transitionArray.length; ++n2) {
            Transition transition = transitionArray[n2];
            if (transition.up) {
                double d3;
                double d4;
                if (n3 == 0 && this.flowShape.contains(d4 = (d2 + transition.loc) / 2.0, d3 = this.currentY + this.lineHeight / 2.0)) {
                    this.validRanges.add(new double[]{d2, transition.loc});
                }
                ++n3;
                continue;
            }
            if (--n3 != 0) continue;
            d2 = transition.loc;
        }
    }

    static class TransitionComp
    implements Comparator {
        public static Comparator COMP = new TransitionComp();

        TransitionComp() {
        }

        public int compare(Object object, Object object2) {
            Transition transition = (Transition)object;
            Transition transition2 = (Transition)object2;
            if (transition.loc < transition2.loc) {
                return -1;
            }
            if (transition.loc > transition2.loc) {
                return 1;
            }
            if (transition.up) {
                if (transition2.up) {
                    return 0;
                }
                return -1;
            }
            if (transition2.up) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    static class Transition {
        public double loc;
        public boolean up;

        public Transition(double d2, boolean bl2) {
            this.loc = d2;
            this.up = bl2;
        }
    }
}

