/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseWheelEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseWheelListener;

public class AWTEventDispatcher
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
EventDispatcher {
    protected GraphicsNode root;
    protected AffineTransform baseTransform;
    protected EventListenerList glisteners;
    protected GraphicsNode lastHit;
    protected GraphicsNode currentKeyEventTarget;
    protected List eventQueue = new LinkedList();
    protected boolean eventDispatchEnabled = true;
    protected int eventQueueMaxSize = 10;
    static final int MAX_QUEUE_SIZE = 10;
    private int nodeIncrementEventID = 401;
    private int nodeIncrementEventCode = 9;
    private int nodeIncrementEventModifiers = 0;
    private int nodeDecrementEventID = 401;
    private int nodeDecrementEventCode = 9;
    private int nodeDecrementEventModifiers = 64;

    @Override
    public void setRootNode(GraphicsNode graphicsNode) {
        if (this.root != graphicsNode) {
            this.eventQueue.clear();
        }
        this.root = graphicsNode;
    }

    @Override
    public GraphicsNode getRootNode() {
        return this.root;
    }

    @Override
    public void setBaseTransform(AffineTransform affineTransform) {
        if (!(this.baseTransform == affineTransform || this.baseTransform != null && this.baseTransform.equals(affineTransform))) {
            this.eventQueue.clear();
        }
        this.baseTransform = affineTransform;
    }

    @Override
    public AffineTransform getBaseTransform() {
        return new AffineTransform(this.baseTransform);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.dispatchEvent(mouseWheelEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(GraphicsNodeMouseListener.class, graphicsNodeMouseListener);
    }

    @Override
    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(GraphicsNodeMouseListener.class, graphicsNodeMouseListener);
        }
    }

    @Override
    public void addGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener graphicsNodeMouseWheelListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(GraphicsNodeMouseWheelListener.class, graphicsNodeMouseWheelListener);
    }

    @Override
    public void removeGraphicsNodeMouseWheelListener(GraphicsNodeMouseWheelListener graphicsNodeMouseWheelListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(GraphicsNodeMouseWheelListener.class, graphicsNodeMouseWheelListener);
        }
    }

    @Override
    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners == null) {
            this.glisteners = new EventListenerList();
        }
        this.glisteners.add(GraphicsNodeKeyListener.class, graphicsNodeKeyListener);
    }

    @Override
    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.glisteners != null) {
            this.glisteners.remove(GraphicsNodeKeyListener.class, graphicsNodeKeyListener);
        }
    }

    @Override
    public EventListener[] getListeners(Class clazz) {
        Object object = Array.newInstance(clazz, this.glisteners.getListenerCount(clazz));
        Object[] objectArray = this.glisteners.getListenerList();
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length - 1; i2 += 2) {
            if (!objectArray[i2].equals(clazz)) continue;
            Array.set(object, n2, objectArray[i2 + 1]);
            ++n2;
        }
        return (EventListener[])object;
    }

    public void setEventDispatchEnabled(boolean bl2) {
        this.eventDispatchEnabled = bl2;
        if (this.eventDispatchEnabled) {
            while (this.eventQueue.size() > 0) {
                EventObject eventObject = (EventObject)this.eventQueue.remove(0);
                this.dispatchEvent(eventObject);
            }
        }
    }

    public void setEventQueueMaxSize(int n2) {
        this.eventQueueMaxSize = n2;
        if (n2 == 0) {
            this.eventQueue.clear();
        }
        while (this.eventQueue.size() > this.eventQueueMaxSize) {
            this.eventQueue.remove(0);
        }
    }

    @Override
    public void dispatchEvent(EventObject eventObject) {
        if (this.root == null) {
            return;
        }
        if (!this.eventDispatchEnabled) {
            if (this.eventQueueMaxSize > 0) {
                this.eventQueue.add(eventObject);
                while (this.eventQueue.size() > this.eventQueueMaxSize) {
                    this.eventQueue.remove(0);
                }
            }
            return;
        }
        if (eventObject instanceof MouseWheelEvent) {
            this.dispatchMouseWheelEvent((MouseWheelEvent)eventObject);
        } else if (eventObject instanceof MouseEvent) {
            this.dispatchMouseEvent((MouseEvent)eventObject);
        } else if (eventObject instanceof KeyEvent) {
            InputEvent inputEvent = (InputEvent)eventObject;
            if (this.isNodeIncrementEvent(inputEvent)) {
                this.incrementKeyTarget();
            } else if (this.isNodeDecrementEvent(inputEvent)) {
                this.decrementKeyTarget();
            } else {
                this.dispatchKeyEvent((KeyEvent)eventObject);
            }
        }
    }

    protected int getCurrentLockState() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = 0;
        try {
            if (toolkit.getLockingKeyState(262)) {
                ++n2;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n2 <<= 1;
        try {
            if (toolkit.getLockingKeyState(145)) {
                ++n2;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n2 <<= 1;
        try {
            if (toolkit.getLockingKeyState(144)) {
                ++n2;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        n2 <<= 1;
        try {
            if (toolkit.getLockingKeyState(20)) {
                ++n2;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return n2;
    }

    protected void dispatchKeyEvent(KeyEvent keyEvent) {
        this.currentKeyEventTarget = this.lastHit;
        GraphicsNode graphicsNode = this.currentKeyEventTarget == null ? this.root : this.currentKeyEventTarget;
        this.processKeyEvent(new GraphicsNodeKeyEvent(graphicsNode, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), this.getCurrentLockState(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        GraphicsNodeMouseEvent graphicsNodeMouseEvent;
        Point point;
        GraphicsNode graphicsNode;
        Point2D.Float float_ = new Point2D.Float(mouseEvent.getX(), mouseEvent.getY());
        Point2D point2D = float_;
        if (this.baseTransform != null) {
            point2D = this.baseTransform.transform(float_, null);
        }
        if ((graphicsNode = this.root.nodeHitAt(point2D)) != null) {
            try {
                graphicsNode.getGlobalTransform().createInverse().transform(point2D, point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        if (!mouseEvent.getComponent().isShowing()) {
            point = new Point(0, 0);
        } else {
            point = mouseEvent.getComponent().getLocationOnScreen();
            point.x += mouseEvent.getX();
            point.y += mouseEvent.getY();
        }
        int n2 = this.getCurrentLockState();
        if (this.lastHit != graphicsNode) {
            if (this.lastHit != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.lastHit, 505, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n2, mouseEvent.getButton(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), graphicsNode);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
            if (graphicsNode != null) {
                graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, 504, mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n2, mouseEvent.getButton(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), this.lastHit);
                this.processMouseEvent(graphicsNodeMouseEvent);
            }
        }
        if (graphicsNode != null) {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(graphicsNode, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n2, mouseEvent.getButton(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        } else {
            graphicsNodeMouseEvent = new GraphicsNodeMouseEvent(this.root, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), n2, mouseEvent.getButton(), (float)point2D.getX(), (float)point2D.getY(), (int)Math.floor(((Point2D)float_).getX()), (int)Math.floor(((Point2D)float_).getY()), point.x, point.y, mouseEvent.getClickCount(), null);
            this.processMouseEvent(graphicsNodeMouseEvent);
        }
        this.lastHit = graphicsNode;
    }

    protected void dispatchMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (this.lastHit != null) {
            this.processMouseWheelEvent(new GraphicsNodeMouseWheelEvent(this.lastHit, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), this.getCurrentLockState(), mouseWheelEvent.getWheelRotation()));
        }
    }

    protected void processMouseEvent(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        if (this.glisteners != null) {
            GraphicsNodeMouseListener[] graphicsNodeMouseListenerArray = (GraphicsNodeMouseListener[])this.getListeners(GraphicsNodeMouseListener.class);
            switch (graphicsNodeMouseEvent.getID()) {
                case 503: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseMoved(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 506: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseDragged(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 504: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseEntered(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 505: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseExited(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 500: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseClicked(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 501: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mousePressed(graphicsNodeMouseEvent);
                    }
                    break;
                }
                case 502: {
                    for (GraphicsNodeMouseListener graphicsNodeMouseListener : graphicsNodeMouseListenerArray) {
                        graphicsNodeMouseListener.mouseReleased(graphicsNodeMouseEvent);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Mouse Event type: " + graphicsNodeMouseEvent.getID());
                }
            }
        }
    }

    protected void processMouseWheelEvent(GraphicsNodeMouseWheelEvent graphicsNodeMouseWheelEvent) {
        if (this.glisteners != null) {
            GraphicsNodeMouseWheelListener[] graphicsNodeMouseWheelListenerArray;
            for (GraphicsNodeMouseWheelListener graphicsNodeMouseWheelListener : graphicsNodeMouseWheelListenerArray = (GraphicsNodeMouseWheelListener[])this.getListeners(GraphicsNodeMouseWheelListener.class)) {
                graphicsNodeMouseWheelListener.mouseWheelMoved(graphicsNodeMouseWheelEvent);
            }
        }
    }

    public void processKeyEvent(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        if (this.glisteners != null) {
            GraphicsNodeKeyListener[] graphicsNodeKeyListenerArray = (GraphicsNodeKeyListener[])this.getListeners(GraphicsNodeKeyListener.class);
            switch (graphicsNodeKeyEvent.getID()) {
                case 401: {
                    for (GraphicsNodeKeyListener graphicsNodeKeyListener : graphicsNodeKeyListenerArray) {
                        graphicsNodeKeyListener.keyPressed(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 402: {
                    for (GraphicsNodeKeyListener graphicsNodeKeyListener : graphicsNodeKeyListenerArray) {
                        graphicsNodeKeyListener.keyReleased(graphicsNodeKeyEvent);
                    }
                    break;
                }
                case 400: {
                    for (GraphicsNodeKeyListener graphicsNodeKeyListener : graphicsNodeKeyListenerArray) {
                        graphicsNodeKeyListener.keyTyped(graphicsNodeKeyEvent);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Key Event type: " + graphicsNodeKeyEvent.getID());
                }
            }
        }
        graphicsNodeKeyEvent.consume();
    }

    private void incrementKeyTarget() {
        throw new UnsupportedOperationException("Increment not implemented.");
    }

    private void decrementKeyTarget() {
        throw new UnsupportedOperationException("Decrement not implemented.");
    }

    @Override
    public void setNodeIncrementEvent(InputEvent inputEvent) {
        this.nodeIncrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeIncrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeIncrementEventModifiers = inputEvent.getModifiersEx();
    }

    @Override
    public void setNodeDecrementEvent(InputEvent inputEvent) {
        this.nodeDecrementEventID = inputEvent.getID();
        if (inputEvent instanceof KeyEvent) {
            this.nodeDecrementEventCode = ((KeyEvent)inputEvent).getKeyCode();
        }
        this.nodeDecrementEventModifiers = inputEvent.getModifiersEx();
    }

    protected boolean isNodeIncrementEvent(InputEvent inputEvent) {
        if (inputEvent.getID() != this.nodeIncrementEventID) {
            return false;
        }
        if (inputEvent instanceof KeyEvent && ((KeyEvent)inputEvent).getKeyCode() != this.nodeIncrementEventCode) {
            return false;
        }
        return (inputEvent.getModifiersEx() & this.nodeIncrementEventModifiers) != 0;
    }

    protected boolean isNodeDecrementEvent(InputEvent inputEvent) {
        if (inputEvent.getID() != this.nodeDecrementEventID) {
            return false;
        }
        if (inputEvent instanceof KeyEvent && ((KeyEvent)inputEvent).getKeyCode() != this.nodeDecrementEventCode) {
            return false;
        }
        return (inputEvent.getModifiersEx() & this.nodeDecrementEventModifiers) != 0;
    }

    protected static boolean isMetaDown(int n2) {
        return (n2 & 0x100) != 0;
    }
}

