/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaintContext;

public class PatternPaint
implements Paint {
    private GraphicsNode node;
    private Rectangle2D patternRegion;
    private AffineTransform patternTransform;
    private Filter tile;
    private boolean overflow;
    private PatternPaintContext lastContext;

    public PatternPaint(GraphicsNode graphicsNode, Rectangle2D rectangle2D, boolean bl2, AffineTransform affineTransform) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.patternRegion = rectangle2D;
        this.overflow = bl2;
        this.patternTransform = affineTransform;
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        compositeGraphicsNode.getChildren().add(graphicsNode);
        Filter filter = compositeGraphicsNode.getGraphicsNodeRable(true);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (bl2) {
            Rectangle2D rectangle2D3 = compositeGraphicsNode.getBounds();
            rectangle2D2.add(rectangle2D3);
        }
        this.tile = new PadRable8Bit(filter, rectangle2D2, PadMode.ZERO_PAD);
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public Rectangle2D getPatternRect() {
        return (Rectangle2D)this.patternRegion.clone();
    }

    public AffineTransform getPatternTransform() {
        return this.patternTransform;
    }

    public boolean getOverflow() {
        return this.overflow;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.patternTransform != null) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.patternTransform);
        }
        if (this.lastContext != null && this.lastContext.getColorModel().equals(colorModel)) {
            double[] dArray = new double[6];
            double[] dArray2 = new double[6];
            affineTransform.getMatrix(dArray);
            this.lastContext.getUsr2Dev().getMatrix(dArray2);
            if (dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3]) {
                if (dArray[4] == dArray2[4] && dArray[5] == dArray2[5]) {
                    return this.lastContext;
                }
                return new PatternPaintContextWrapper(this.lastContext, (int)(dArray2[4] - dArray[4] + 0.5), (int)(dArray2[5] - dArray[5] + 0.5));
            }
        }
        this.lastContext = new PatternPaintContext(colorModel, affineTransform, renderingHints, this.tile, this.patternRegion, this.overflow);
        return this.lastContext;
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    static class PatternPaintContextWrapper
    implements PaintContext {
        PatternPaintContext ppc;
        int xShift;
        int yShift;

        PatternPaintContextWrapper(PatternPaintContext patternPaintContext, int n2, int n3) {
            this.ppc = patternPaintContext;
            this.xShift = n2;
            this.yShift = n3;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return this.ppc.getColorModel();
        }

        @Override
        public Raster getRaster(int n2, int n3, int n4, int n5) {
            return this.ppc.getRaster(n2 + this.xShift, n3 + this.yShift, n4, n5);
        }
    }
}

