/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] shapePainterArray = new ShapePainter[this.count + this.count / 2 + 1];
            System.arraycopy(this.painters, 0, shapePainterArray, 0, this.count);
            this.painters = shapePainterArray;
        }
        this.painters[this.count++] = shapePainter;
    }

    public ShapePainter getShapePainter(int n2) {
        return this.painters[n2];
    }

    public int getShapePainterCount() {
        return this.count;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.painters != null) {
            for (int i2 = 0; i2 < this.count; ++i2) {
                this.painters[i2].paint(graphics2D);
            }
        }
    }

    @Override
    public Shape getPaintedArea() {
        if (this.painters == null) {
            return null;
        }
        Area area = new Area();
        for (int i2 = 0; i2 < this.count; ++i2) {
            Shape shape = this.painters[i2].getPaintedArea();
            if (shape == null) continue;
            area.add(new Area(shape));
        }
        return area;
    }

    @Override
    public Rectangle2D getPaintedBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < this.count; ++i2) {
            Rectangle2D rectangle2D2 = this.painters[i2].getPaintedBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public boolean inPaintedArea(Point2D point2D) {
        if (this.painters == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.painters[i2].inPaintedArea(point2D)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Shape getSensitiveArea() {
        if (this.painters == null) {
            return null;
        }
        Area area = new Area();
        for (int i2 = 0; i2 < this.count; ++i2) {
            Shape shape = this.painters[i2].getSensitiveArea();
            if (shape == null) continue;
            area.add(new Area(shape));
        }
        return area;
    }

    @Override
    public Rectangle2D getSensitiveBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D rectangle2D = null;
        for (int i2 = 0; i2 < this.count; ++i2) {
            Rectangle2D rectangle2D2 = this.painters[i2].getSensitiveBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public boolean inSensitiveArea(Point2D point2D) {
        if (this.painters == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (!this.painters[i2].inSensitiveArea(point2D)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        if (this.painters != null) {
            for (int i2 = 0; i2 < this.count; ++i2) {
                this.painters[i2].setShape(shape);
            }
        }
        this.shape = shape;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }
}

