/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;

public class CompositeGraphicsNode
extends AbstractGraphicsNode
implements List {
    public static final Rectangle2D VIEWPORT = new Rectangle();
    public static final Rectangle2D NULL_RECT = new Rectangle();
    protected GraphicsNode[] children;
    protected volatile int count;
    protected volatile int modCount;
    protected Rectangle2D backgroundEnableRgn = null;
    private volatile Rectangle2D geometryBounds;
    private volatile Rectangle2D primitiveBounds;
    private volatile Rectangle2D sensitiveBounds;
    private Shape outline;

    public List getChildren() {
        return this;
    }

    public void setBackgroundEnable(Rectangle2D rectangle2D) {
        this.backgroundEnableRgn = rectangle2D;
    }

    public Rectangle2D getBackgroundEnable() {
        return this.backgroundEnableRgn;
    }

    @Override
    public void setVisible(boolean bl2) {
        this.isVisible = bl2;
    }

    @Override
    public void primitivePaint(Graphics2D graphics2D) {
        if (this.count == 0) {
            return;
        }
        Thread thread = Thread.currentThread();
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (HaltingThread.hasBeenHalted(thread)) {
                return;
            }
            GraphicsNode graphicsNode = this.children[i2];
            if (graphicsNode == null) continue;
            graphicsNode.paint(graphics2D);
        }
    }

    @Override
    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.geometryBounds = null;
        this.primitiveBounds = null;
        this.sensitiveBounds = null;
        this.outline = null;
    }

    @Override
    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds != null) {
            if (this.primitiveBounds == NULL_RECT) {
                return null;
            }
            return this.primitiveBounds;
        }
        Thread thread = Thread.currentThread();
        int n2 = 0;
        Rectangle2D rectangle2D = null;
        while (rectangle2D == null && n2 < this.count) {
            rectangle2D = this.children[n2++].getTransformedBounds(IDENTITY);
            if ((n2 & 0xF) != 0 || !HaltingThread.hasBeenHalted(thread)) continue;
        }
        if (HaltingThread.hasBeenHalted(thread)) {
            this.invalidateGeometryCache();
            return null;
        }
        if (rectangle2D == null) {
            this.primitiveBounds = NULL_RECT;
            return null;
        }
        this.primitiveBounds = rectangle2D;
        while (n2 < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n2++].getTransformedBounds(IDENTITY)) != null) {
                if (this.primitiveBounds == null) {
                    return null;
                }
                this.primitiveBounds.add(rectangle2D2);
            }
            if ((n2 & 0xF) != 0 || !HaltingThread.hasBeenHalted(thread)) continue;
            break;
        }
        if (HaltingThread.hasBeenHalted(thread)) {
            this.invalidateGeometryCache();
        }
        return this.primitiveBounds;
    }

    public static Rectangle2D getTransformedBBox(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        if (affineTransform == null || rectangle2D == null) {
            return rectangle2D;
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getY();
        double d5 = rectangle2D.getHeight();
        double d6 = affineTransform.getScaleX();
        double d7 = affineTransform.getScaleY();
        if (d6 < 0.0) {
            d2 = -(d2 + d3);
            d6 = -d6;
        }
        if (d7 < 0.0) {
            d4 = -(d4 + d5);
            d7 = -d7;
        }
        return new Rectangle2D.Float((float)(d2 * d6 + affineTransform.getTranslateX()), (float)(d4 * d7 + affineTransform.getTranslateY()), (float)(d3 * d6), (float)(d5 * d7));
    }

    @Override
    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getPrimitiveBounds(), affineTransform2);
        }
        int n2 = 0;
        Rectangle2D rectangle2D = null;
        while (rectangle2D == null && n2 < this.count) {
            rectangle2D = this.children[n2++].getTransformedBounds(affineTransform2);
        }
        while (n2 < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n2++].getTransformedBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            int n2 = 0;
            while (this.geometryBounds == null && n2 < this.count) {
                this.geometryBounds = this.children[n2++].getTransformedGeometryBounds(IDENTITY);
            }
            while (n2 < this.count) {
                Rectangle2D rectangle2D;
                if ((rectangle2D = this.children[n2++].getTransformedGeometryBounds(IDENTITY)) == null) continue;
                if (this.geometryBounds == null) {
                    return this.getGeometryBounds();
                }
                this.geometryBounds.add(rectangle2D);
            }
        }
        return this.geometryBounds;
    }

    @Override
    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getGeometryBounds(), affineTransform2);
        }
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (rectangle2D == null && n2 < this.count) {
            rectangle2D = this.children[n2++].getTransformedGeometryBounds(affineTransform2);
        }
        Rectangle2D rectangle2D2 = null;
        while (n2 < this.count) {
            if ((rectangle2D2 = this.children[n2++].getTransformedGeometryBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        int n2 = 0;
        while (this.sensitiveBounds == null && n2 < this.count) {
            this.sensitiveBounds = this.children[n2++].getTransformedSensitiveBounds(IDENTITY);
        }
        while (n2 < this.count) {
            Rectangle2D rectangle2D;
            if ((rectangle2D = this.children[n2++].getTransformedSensitiveBounds(IDENTITY)) == null) continue;
            if (this.sensitiveBounds == null) {
                return this.getSensitiveBounds();
            }
            this.sensitiveBounds.add(rectangle2D);
        }
        return this.sensitiveBounds;
    }

    @Override
    public Rectangle2D getTransformedSensitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        if (affineTransform2 == null || affineTransform2.getShearX() == 0.0 && affineTransform2.getShearY() == 0.0) {
            return CompositeGraphicsNode.getTransformedBBox(this.getSensitiveBounds(), affineTransform2);
        }
        Rectangle2D rectangle2D = null;
        int n2 = 0;
        while (rectangle2D == null && n2 < this.count) {
            rectangle2D = this.children[n2++].getTransformedSensitiveBounds(affineTransform2);
        }
        while (n2 < this.count) {
            Rectangle2D rectangle2D2;
            if ((rectangle2D2 = this.children[n2++].getTransformedSensitiveBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i2 = 0; i2 < this.count; ++i2) {
                AffineTransform affineTransform = this.children[i2].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                if (!this.children[i2].contains(point2D3)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public GraphicsNode nodeHitAt(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i2 = this.count - 1; i2 >= 0; --i2) {
                AffineTransform affineTransform = this.children[i2].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                GraphicsNode graphicsNode = this.children[i2].nodeHitAt(point2D3);
                if (graphicsNode == null) continue;
                return graphicsNode;
            }
        }
        return null;
    }

    @Override
    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        for (int i2 = 0; i2 < this.count; ++i2) {
            Shape shape = this.children[i2].getOutline();
            if (shape == null) continue;
            AffineTransform affineTransform = this.children[i2].getTransform();
            if (affineTransform != null) {
                ((GeneralPath)this.outline).append(affineTransform.createTransformedShape(shape), false);
                continue;
            }
            ((GeneralPath)this.outline).append(shape, false);
        }
        return this.outline;
    }

    @Override
    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        super.setRoot(rootGraphicsNode);
        for (int i2 = 0; i2 < this.count; ++i2) {
            GraphicsNode graphicsNode = this.children[i2];
            ((AbstractGraphicsNode)graphicsNode).setRoot(rootGraphicsNode);
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public Iterator iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new GraphicsNode[this.count];
        System.arraycopy(this.children, 0, objectArray, 0, this.count);
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.count) {
            objectArray = new GraphicsNode[this.count];
        }
        System.arraycopy(this.children, 0, objectArray, 0, this.count);
        if (objectArray.length > this.count) {
            objectArray[this.count] = null;
        }
        return objectArray;
    }

    public Object get(int n2) {
        this.checkRange(n2);
        return this.children[n2];
    }

    public Object set(int n2, Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        this.checkRange(n2);
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        GraphicsNode graphicsNode2 = this.children[n2];
        this.children[n2] = graphicsNode;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode2).setParent(null);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        ((AbstractGraphicsNode)graphicsNode2).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode2;
    }

    @Override
    public boolean add(Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        this.children[this.count++] = graphicsNode;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return true;
    }

    public void add(int n2, Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        if (n2 > this.count || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.count);
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.children, n2, this.children, n2 + 1, this.count - n2);
        this.children[n2] = graphicsNode;
        ++this.count;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n2, Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        if (graphicsNode.getParent() != this) {
            return false;
        }
        int n2 = 0;
        while (graphicsNode != this.children[n2]) {
            ++n2;
        }
        this.remove(n2);
        return true;
    }

    public Object remove(int n2) {
        this.checkRange(n2);
        GraphicsNode graphicsNode = this.children[n2];
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        ++this.modCount;
        int n3 = this.count - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.children, n2 + 1, this.children, n2, n3);
        }
        this.children[--this.count] = null;
        if (this.count == 0) {
            this.children = null;
        }
        ((AbstractGraphicsNode)graphicsNode).setParent(null);
        ((AbstractGraphicsNode)graphicsNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode;
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e2 : collection) {
            if (this.contains(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            int n2 = this.count;
            GraphicsNode[] graphicsNodeArray = this.children;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object != graphicsNodeArray[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            for (int i2 = this.count - 1; i2 >= 0; --i2) {
                if (object != this.children[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n2) {
        if (n2 < 0 || n2 > this.count) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new ListItr(n2);
    }

    public List subList(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    private void checkRange(int n2) {
        if (n2 >= this.count || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.count);
        }
    }

    public void ensureCapacity(int n2) {
        if (this.children == null) {
            this.children = new GraphicsNode[4];
        }
        ++this.modCount;
        int n3 = this.children.length;
        if (n2 > n3) {
            GraphicsNode[] graphicsNodeArray = this.children;
            int n4 = n3 + n3 / 2 + 1;
            if (n4 < n2) {
                n4 = n2;
            }
            this.children = new GraphicsNode[n4];
            System.arraycopy(graphicsNodeArray, 0, this.children, 0, this.count);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int n2) {
            this.cursor = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object object = CompositeGraphicsNode.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.set(this.lastRet, object);
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.add(this.cursor++, object);
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompositeGraphicsNode.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != CompositeGraphicsNode.this.count;
        }

        public Object next() {
            try {
                Object object = CompositeGraphicsNode.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CompositeGraphicsNode.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

