/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;

public class JDKRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry {
    public static final float PRIORITY = 1000000.0f;

    public JDKRegistryEntry() {
        super("JDK", 1000000.0f, new String[0], new String[]{"image/gif"});
    }

    @Override
    public boolean isCompatibleURL(ParsedURL parsedURL) {
        try {
            new URL(parsedURL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    @Override
    public Filter handleURL(ParsedURL parsedURL, boolean bl2) {
        Object[] objectArray;
        String string;
        URL uRL;
        try {
            uRL = new URL(parsedURL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        final DeferRable deferRable = new DeferRable();
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{"JDK", uRL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{"JDK"};
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                Filter filter = null;
                try {
                    RenderedImage renderedImage;
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.createImage(uRL);
                    if (image != null && (renderedImage = JDKRegistryEntry.this.loadImage(image, deferRable)) != null) {
                        filter = new RedRable(GraphicsUtil.wrap(renderedImage));
                    }
                }
                catch (ThreadDeath threadDeath) {
                    filter = ImageTagRegistry.getBrokenLinkImage(JDKRegistryEntry.this, string, objectArray);
                    deferRable.setSource(filter);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (filter == null) {
                    filter = ImageTagRegistry.getBrokenLinkImage(JDKRegistryEntry.this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }

    public RenderedImage loadImage(Image image, DeferRable deferRable) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        MyImgObs myImgObs = new MyImgObs();
        Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, myImgObs);
        myImgObs.waitTilWidthHeightDone();
        if (myImgObs.imageError) {
            return null;
        }
        int n2 = myImgObs.width;
        int n3 = myImgObs.height;
        deferRable.setBounds(new Rectangle2D.Double(0.0, 0.0, n2, n3));
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        myImgObs.waitTilImageDone();
        if (myImgObs.imageError) {
            return null;
        }
        deferRable.setProperties(new HashMap());
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static class MyImgObs
    implements ImageObserver {
        boolean widthDone = false;
        boolean heightDone = false;
        boolean imageDone = false;
        int width = -1;
        int height = -1;
        boolean imageError = false;
        int IMG_BITS = 224;

        public void clear() {
            this.width = -1;
            this.height = -1;
            this.widthDone = false;
            this.heightDone = false;
            this.imageDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            MyImgObs myImgObs = this;
            synchronized (myImgObs) {
                boolean bl2 = false;
                if ((n2 & 1) != 0) {
                    this.width = n5;
                }
                if ((n2 & 2) != 0) {
                    this.height = n6;
                }
                if ((n2 & 0x20) != 0) {
                    this.width = n5;
                    this.height = n6;
                }
                if ((n2 & this.IMG_BITS) != 0) {
                    if (!(this.widthDone && this.heightDone && this.imageDone)) {
                        this.widthDone = true;
                        this.heightDone = true;
                        this.imageDone = true;
                        bl2 = true;
                    }
                    if ((n2 & 0x40) != 0) {
                        this.imageError = true;
                    }
                }
                if (!this.widthDone && this.width != -1) {
                    bl2 = true;
                    this.widthDone = true;
                }
                if (!this.heightDone && this.height != -1) {
                    bl2 = true;
                    this.heightDone = true;
                }
                if (bl2) {
                    this.notifyAll();
                }
            }
            return true;
        }

        public synchronized void waitTilWidthHeightDone() {
            while (!this.widthDone || !this.heightDone) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void waitTilWidthDone() {
            while (!this.widthDone) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void waitTilHeightDone() {
            while (!this.heightDone) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void waitTilImageDone() {
            while (!this.imageDone) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

