/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public final class TurbulencePatternRed
extends AbstractRed {
    private StitchInfo stitchInfo = null;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private double baseFrequencyX;
    private double baseFrequencyY;
    private int numOctaves;
    private int seed;
    private Rectangle2D tile;
    private AffineTransform txf;
    private boolean isFractalNoise;
    private int[] channels;
    double[] tx = new double[]{1.0, 0.0};
    double[] ty = new double[]{0.0, 1.0};
    private static final int RAND_m = Integer.MAX_VALUE;
    private static final int RAND_a = 16807;
    private static final int RAND_q = 127773;
    private static final int RAND_r = 2836;
    private static final int BSize = 256;
    private static final int BM = 255;
    private static final double PerlinN = 4096.0;
    private final int[] latticeSelector = new int[257];
    private final double[] gradient = new double[2056];

    public double getBaseFrequencyX() {
        return this.baseFrequencyX;
    }

    public double getBaseFrequencyY() {
        return this.baseFrequencyY;
    }

    public int getNumOctaves() {
        return this.numOctaves;
    }

    public int getSeed() {
        return this.seed;
    }

    public Rectangle2D getTile() {
        return (Rectangle2D)this.tile.clone();
    }

    public boolean isFractalNoise() {
        return this.isFractalNoise;
    }

    public boolean[] getChannels() {
        boolean[] blArray = new boolean[4];
        for (int n2 : this.channels) {
            blArray[n2] = true;
        }
        return blArray;
    }

    public final int setupSeed(int n2) {
        if (n2 <= 0) {
            n2 = -(n2 % 0x7FFFFFFE) + 1;
        }
        if (n2 > 0x7FFFFFFE) {
            n2 = 0x7FFFFFFE;
        }
        return n2;
    }

    public final int random(int n2) {
        int n3 = 16807 * (n2 % 127773) - 2836 * (n2 / 127773);
        if (n3 <= 0) {
            n3 += Integer.MAX_VALUE;
        }
        return n3;
    }

    private void initLattice(int n2) {
        int n3;
        double d2;
        int n4;
        int n5;
        n2 = this.setupSeed(n2);
        for (n5 = 0; n5 < 4; ++n5) {
            for (n4 = 0; n4 < 256; ++n4) {
                n2 = this.random(n2);
                double d3 = n2 % 512 - 256;
                n2 = this.random(n2);
                double d4 = n2 % 512 - 256;
                d2 = 1.0 / Math.sqrt(d3 * d3 + d4 * d4);
                this.gradient[n4 * 8 + n5 * 2] = d3 * d2;
                this.gradient[n4 * 8 + n5 * 2 + 1] = d4 * d2;
            }
        }
        for (n4 = 0; n4 < 256; ++n4) {
            this.latticeSelector[n4] = n4;
        }
        while (--n4 > 0) {
            n5 = this.latticeSelector[n4];
            n2 = this.random(n2);
            n3 = n2 % 256;
            this.latticeSelector[n4] = this.latticeSelector[n3];
            this.latticeSelector[n3] = n5;
            int n6 = n4 << 3;
            int n7 = n3 << 3;
            for (n3 = 0; n3 < 8; ++n3) {
                d2 = this.gradient[n6 + n3];
                this.gradient[n6 + n3] = this.gradient[n7 + n3];
                this.gradient[n7 + n3] = d2;
            }
        }
        this.latticeSelector[256] = this.latticeSelector[0];
        for (n3 = 0; n3 < 8; ++n3) {
            this.gradient[2048 + n3] = this.gradient[n3];
        }
    }

    private static final double s_curve(double d2) {
        return d2 * d2 * (3.0 - 2.0 * d2);
    }

    private static final double lerp(double d2, double d3, double d4) {
        return d3 + d2 * (d4 - d3);
    }

    private final void noise2(double[] dArray, double d2, double d3) {
        int n2 = (int)(d2 += 4096.0) & 0xFF;
        int n3 = this.latticeSelector[n2];
        int n4 = this.latticeSelector[n2 + 1];
        double d4 = d2 - (double)((int)d2);
        double d5 = d4 - 1.0;
        double d6 = TurbulencePatternRed.s_curve(d4);
        n2 = (int)(d3 += 4096.0);
        int n5 = (n4 + n2 & 0xFF) << 3;
        n2 = (n3 + n2 & 0xFF) << 3;
        double d7 = d3 - (double)((int)d3);
        double d8 = d7 - 1.0;
        double d9 = TurbulencePatternRed.s_curve(d7);
        switch (this.channels.length) {
            case 4: {
                dArray[3] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 6] + d7 * this.gradient[n2 + 7], d5 * this.gradient[n5 + 6] + d7 * this.gradient[n5 + 7]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 8 + 6] + d8 * this.gradient[n2 + 8 + 7], d5 * this.gradient[n5 + 8 + 6] + d8 * this.gradient[n5 + 8 + 7]));
            }
            case 3: {
                dArray[2] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 4] + d7 * this.gradient[n2 + 5], d5 * this.gradient[n5 + 4] + d7 * this.gradient[n5 + 5]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 8 + 4] + d8 * this.gradient[n2 + 8 + 5], d5 * this.gradient[n5 + 8 + 4] + d8 * this.gradient[n5 + 8 + 5]));
            }
            case 2: {
                dArray[1] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 2] + d7 * this.gradient[n2 + 3], d5 * this.gradient[n5 + 2] + d7 * this.gradient[n5 + 3]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 8 + 2] + d8 * this.gradient[n2 + 8 + 3], d5 * this.gradient[n5 + 8 + 2] + d8 * this.gradient[n5 + 8 + 3]));
            }
            case 1: {
                dArray[0] = TurbulencePatternRed.lerp(d9, TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 0] + d7 * this.gradient[n2 + 1], d5 * this.gradient[n5 + 0] + d7 * this.gradient[n5 + 1]), TurbulencePatternRed.lerp(d6, d4 * this.gradient[n2 + 8 + 0] + d8 * this.gradient[n2 + 8 + 1], d5 * this.gradient[n5 + 8 + 0] + d8 * this.gradient[n5 + 8 + 1]));
            }
        }
    }

    private final void noise2Stitch(double[] dArray, double d2, double d3, StitchInfo stitchInfo) {
        double d4 = d2 + 4096.0;
        int n2 = (int)d4;
        int n3 = n2 + 1;
        if (n3 >= stitchInfo.wrapX) {
            if (n2 >= stitchInfo.wrapX) {
                n2 -= stitchInfo.width;
                n3 -= stitchInfo.width;
            } else {
                n3 -= stitchInfo.width;
            }
        }
        int n4 = this.latticeSelector[n2 & 0xFF];
        int n5 = this.latticeSelector[n3 & 0xFF];
        double d5 = d4 - (double)((int)d4);
        double d6 = d5 - 1.0;
        double d7 = TurbulencePatternRed.s_curve(d5);
        d4 = d3 + 4096.0;
        n2 = (int)d4;
        n3 = n2 + 1;
        if (n3 >= stitchInfo.wrapY) {
            if (n2 >= stitchInfo.wrapY) {
                n2 -= stitchInfo.height;
                n3 -= stitchInfo.height;
            } else {
                n3 -= stitchInfo.height;
            }
        }
        int n6 = (n4 + n2 & 0xFF) << 3;
        int n7 = (n5 + n2 & 0xFF) << 3;
        int n8 = (n4 + n3 & 0xFF) << 3;
        int n9 = (n5 + n3 & 0xFF) << 3;
        double d8 = d4 - (double)((int)d4);
        double d9 = d8 - 1.0;
        double d10 = TurbulencePatternRed.s_curve(d8);
        switch (this.channels.length) {
            case 4: {
                dArray[3] = TurbulencePatternRed.lerp(d10, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n6 + 6] + d8 * this.gradient[n6 + 7], d6 * this.gradient[n7 + 6] + d8 * this.gradient[n7 + 7]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n8 + 6] + d9 * this.gradient[n8 + 7], d6 * this.gradient[n9 + 6] + d9 * this.gradient[n9 + 7]));
            }
            case 3: {
                dArray[2] = TurbulencePatternRed.lerp(d10, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n6 + 4] + d8 * this.gradient[n6 + 5], d6 * this.gradient[n7 + 4] + d8 * this.gradient[n7 + 5]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n8 + 4] + d9 * this.gradient[n8 + 5], d6 * this.gradient[n9 + 4] + d9 * this.gradient[n9 + 5]));
            }
            case 2: {
                dArray[1] = TurbulencePatternRed.lerp(d10, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n6 + 2] + d8 * this.gradient[n6 + 3], d6 * this.gradient[n7 + 2] + d8 * this.gradient[n7 + 3]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n8 + 2] + d9 * this.gradient[n8 + 3], d6 * this.gradient[n9 + 2] + d9 * this.gradient[n9 + 3]));
            }
            case 1: {
                dArray[0] = TurbulencePatternRed.lerp(d10, TurbulencePatternRed.lerp(d7, d5 * this.gradient[n6 + 0] + d8 * this.gradient[n6 + 1], d6 * this.gradient[n7 + 0] + d8 * this.gradient[n7 + 1]), TurbulencePatternRed.lerp(d7, d5 * this.gradient[n8 + 0] + d9 * this.gradient[n8 + 1], d6 * this.gradient[n9 + 0] + d9 * this.gradient[n9 + 1]));
            }
        }
    }

    private final int turbulence_4(double d2, double d3, double[] dArray) {
        int n2;
        int n3;
        double d4 = 255.0;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        for (int i2 = this.numOctaves; i2 > 0; --i2) {
            double d5 = d2 + 4096.0;
            int n4 = (int)d5 & 0xFF;
            n3 = this.latticeSelector[n4];
            n2 = this.latticeSelector[n4 + 1];
            double d6 = d5 - (double)((int)d5);
            double d7 = d6 - 1.0;
            double d8 = TurbulencePatternRed.s_curve(d6);
            double d9 = d3 + 4096.0;
            n4 = (int)d9 & 0xFF;
            int n5 = n4 + 1 & 0xFF;
            n5 = (n2 + n4 & 0xFF) << 3;
            n4 = (n3 + n4 & 0xFF) << 3;
            double d10 = d9 - (double)((int)d9);
            double d11 = d10 - 1.0;
            double d12 = TurbulencePatternRed.s_curve(d10);
            double d13 = TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 0] + d10 * this.gradient[n4 + 1], d7 * this.gradient[n5 + 0] + d10 * this.gradient[n5 + 1]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 0] + d11 * this.gradient[n4 + 8 + 1], d7 * this.gradient[n5 + 8 + 0] + d11 * this.gradient[n5 + 8 + 1]));
            dArray[0] = d13 < 0.0 ? dArray[0] - d13 * d4 : dArray[0] + d13 * d4;
            d13 = TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 2] + d10 * this.gradient[n4 + 3], d7 * this.gradient[n5 + 2] + d10 * this.gradient[n5 + 3]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 2] + d11 * this.gradient[n4 + 8 + 3], d7 * this.gradient[n5 + 8 + 2] + d11 * this.gradient[n5 + 8 + 3]));
            dArray[1] = d13 < 0.0 ? dArray[1] - d13 * d4 : dArray[1] + d13 * d4;
            d13 = TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 4] + d10 * this.gradient[n4 + 5], d7 * this.gradient[n5 + 4] + d10 * this.gradient[n5 + 5]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 4] + d11 * this.gradient[n4 + 8 + 5], d7 * this.gradient[n5 + 8 + 4] + d11 * this.gradient[n5 + 8 + 5]));
            dArray[2] = d13 < 0.0 ? dArray[2] - d13 * d4 : dArray[2] + d13 * d4;
            d13 = TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 6] + d10 * this.gradient[n4 + 7], d7 * this.gradient[n5 + 6] + d10 * this.gradient[n5 + 7]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 6] + d11 * this.gradient[n4 + 8 + 7], d7 * this.gradient[n5 + 8 + 6] + d11 * this.gradient[n5 + 8 + 7]));
            dArray[3] = d13 < 0.0 ? dArray[3] - d13 * d4 : dArray[3] + d13 * d4;
            d4 *= 0.5;
            d2 *= 2.0;
            d3 *= 2.0;
        }
        n3 = (int)dArray[0];
        n2 = (n3 & 0xFFFFFF00) == 0 ? n3 << 16 : ((n3 & Integer.MIN_VALUE) != 0 ? 0 : 0xFF0000);
        n3 = (int)dArray[1];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3 << 8) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : 65280);
        n3 = (int)dArray[2];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : 255);
        n3 = (int)dArray[3];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3 << 24) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : -16777216);
        return n2;
    }

    private final void turbulence(int[] nArray, double d2, double d3, double[] dArray, double[] dArray2) {
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        double d4 = 255.0;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        switch (this.channels.length) {
            case 4: {
                for (int i2 = 0; i2 < this.numOctaves; ++i2) {
                    this.noise2(dArray2, d2, d3);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d4 : dArray[2] + dArray2[2] * d4;
                    dArray[3] = dArray2[3] < 0.0 ? dArray[3] - dArray2[3] * d4 : dArray[3] + dArray2[3] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) != 0) {
                    nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) == 0) break;
                nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 3: {
                for (int i3 = 0; i3 < this.numOctaves; ++i3) {
                    this.noise2(dArray2, d2, d3);
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d4 : dArray[2] + dArray2[2] * d4;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                }
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 2: {
                for (int i4 = 0; i4 < this.numOctaves; ++i4) {
                    this.noise2(dArray2, d2, d3);
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                }
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 1: {
                for (int i5 = 0; i5 < this.numOctaves; ++i5) {
                    this.noise2(dArray2, d2, d3);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                }
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final void turbulenceStitch(int[] nArray, double d2, double d3, double[] dArray, double[] dArray2, StitchInfo stitchInfo) {
        double d4 = 1.0;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        dArray[3] = 0.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        switch (this.channels.length) {
            case 4: {
                for (int i2 = 0; i2 < this.numOctaves; ++i2) {
                    this.noise2Stitch(dArray2, d2, d3, stitchInfo);
                    dArray[3] = dArray2[3] < 0.0 ? dArray[3] - dArray2[3] * d4 : dArray[3] + dArray2[3] * d4;
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d4 : dArray[2] + dArray2[2] * d4;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[3] = (int)(dArray[3] * 255.0);
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[2] = (int)(dArray[2] * 255.0);
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 3: {
                for (int i3 = 0; i3 < this.numOctaves; ++i3) {
                    this.noise2Stitch(dArray2, d2, d3, stitchInfo);
                    dArray[2] = dArray2[2] < 0.0 ? dArray[2] - dArray2[2] * d4 : dArray[2] + dArray2[2] * d4;
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[2] = (int)(dArray[2] * 255.0);
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 2: {
                for (int i4 = 0; i4 < this.numOctaves; ++i4) {
                    this.noise2Stitch(dArray2, d2, d3, stitchInfo);
                    dArray[1] = dArray2[1] < 0.0 ? dArray[1] - dArray2[1] * d4 : dArray[1] + dArray2[1] * d4;
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[1] = (int)(dArray[1] * 255.0);
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                break;
            }
            case 1: {
                for (int i5 = 0; i5 < this.numOctaves; ++i5) {
                    this.noise2Stitch(dArray2, d2, d3, stitchInfo);
                    dArray[0] = dArray2[0] < 0.0 ? dArray[0] - dArray2[0] * d4 : dArray[0] + dArray2[0] * d4;
                    d4 *= 0.5;
                    d2 *= 2.0;
                    d3 *= 2.0;
                    stitchInfo.doubleFrequency();
                }
                nArray[0] = (int)(dArray[0] * 255.0);
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final int turbulenceFractal_4(double d2, double d3, double[] dArray) {
        int n2;
        int n3;
        double d4 = 127.5;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        for (int i2 = this.numOctaves; i2 > 0; --i2) {
            double d5 = d2 + 4096.0;
            int n4 = (int)d5 & 0xFF;
            n3 = this.latticeSelector[n4];
            n2 = this.latticeSelector[n4 + 1];
            double d6 = d5 - (double)((int)d5);
            double d7 = d6 - 1.0;
            double d8 = TurbulencePatternRed.s_curve(d6);
            double d9 = d3 + 4096.0;
            n4 = (int)d9 & 0xFF;
            int n5 = n4 + 1 & 0xFF;
            n5 = (n2 + n4 & 0xFF) << 3;
            n4 = (n3 + n4 & 0xFF) << 3;
            double d10 = d9 - (double)((int)d9);
            double d11 = d10 - 1.0;
            double d12 = TurbulencePatternRed.s_curve(d10);
            dArray[0] = dArray[0] + TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 0] + d10 * this.gradient[n4 + 1], d7 * this.gradient[n5 + 0] + d10 * this.gradient[n5 + 1]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 0] + d11 * this.gradient[n4 + 8 + 1], d7 * this.gradient[n5 + 8 + 0] + d11 * this.gradient[n5 + 8 + 1])) * d4;
            dArray[1] = dArray[1] + TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 2] + d10 * this.gradient[n4 + 3], d7 * this.gradient[n5 + 2] + d10 * this.gradient[n5 + 3]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 2] + d11 * this.gradient[n4 + 8 + 3], d7 * this.gradient[n5 + 8 + 2] + d11 * this.gradient[n5 + 8 + 3])) * d4;
            dArray[2] = dArray[2] + TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 4] + d10 * this.gradient[n4 + 5], d7 * this.gradient[n5 + 4] + d10 * this.gradient[n5 + 5]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 4] + d11 * this.gradient[n4 + 8 + 5], d7 * this.gradient[n5 + 8 + 4] + d11 * this.gradient[n5 + 8 + 5])) * d4;
            dArray[3] = dArray[3] + TurbulencePatternRed.lerp(d12, TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 6] + d10 * this.gradient[n4 + 7], d7 * this.gradient[n5 + 6] + d10 * this.gradient[n5 + 7]), TurbulencePatternRed.lerp(d8, d6 * this.gradient[n4 + 8 + 6] + d11 * this.gradient[n4 + 8 + 7], d7 * this.gradient[n5 + 8 + 6] + d11 * this.gradient[n5 + 8 + 7])) * d4;
            d4 *= 0.5;
            d2 *= 2.0;
            d3 *= 2.0;
        }
        n3 = (int)dArray[0];
        n2 = (n3 & 0xFFFFFF00) == 0 ? n3 << 16 : ((n3 & Integer.MIN_VALUE) != 0 ? 0 : 0xFF0000);
        n3 = (int)dArray[1];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3 << 8) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : 65280);
        n3 = (int)dArray[2];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : 255);
        n3 = (int)dArray[3];
        n2 = (n3 & 0xFFFFFF00) == 0 ? (n2 |= n3 << 24) : (n2 |= (n3 & Integer.MIN_VALUE) != 0 ? 0 : -16777216);
        return n2;
    }

    private final void turbulenceFractal(int[] nArray, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = 127.5;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        for (int i2 = this.numOctaves; i2 > 0; --i2) {
            this.noise2(dArray2, d2, d3);
            switch (this.channels.length) {
                case 4: {
                    dArray[3] = dArray[3] + dArray2[3] * d4;
                }
                case 3: {
                    dArray[2] = dArray[2] + dArray2[2] * d4;
                }
                case 2: {
                    dArray[1] = dArray[1] + dArray2[1] * d4;
                }
                case 1: {
                    dArray[0] = dArray[0] + dArray2[0] * d4;
                }
            }
            d4 *= 0.5;
            d2 *= 2.0;
            d3 *= 2.0;
        }
        switch (this.channels.length) {
            case 4: {
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 3: {
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 2: {
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 1: {
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    private final void turbulenceFractalStitch(int[] nArray, double d2, double d3, double[] dArray, double[] dArray2, StitchInfo stitchInfo) {
        double d4 = 127.5;
        dArray[3] = 127.5;
        dArray[2] = 127.5;
        dArray[1] = 127.5;
        dArray[0] = 127.5;
        d2 *= this.baseFrequencyX;
        d3 *= this.baseFrequencyY;
        for (int i2 = this.numOctaves; i2 > 0; --i2) {
            this.noise2Stitch(dArray2, d2, d3, stitchInfo);
            switch (this.channels.length) {
                case 4: {
                    dArray[3] = dArray[3] + dArray2[3] * d4;
                }
                case 3: {
                    dArray[2] = dArray[2] + dArray2[2] * d4;
                }
                case 2: {
                    dArray[1] = dArray[1] + dArray2[1] * d4;
                }
                case 1: {
                    dArray[0] = dArray[0] + dArray2[0] * d4;
                }
            }
            d4 *= 0.5;
            d2 *= 2.0;
            d3 *= 2.0;
            stitchInfo.doubleFrequency();
        }
        switch (this.channels.length) {
            case 4: {
                nArray[3] = (int)dArray[3];
                if ((nArray[3] & 0xFFFFFF00) != 0) {
                    nArray[3] = (nArray[3] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 3: {
                nArray[2] = (int)dArray[2];
                if ((nArray[2] & 0xFFFFFF00) != 0) {
                    nArray[2] = (nArray[2] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 2: {
                nArray[1] = (int)dArray[1];
                if ((nArray[1] & 0xFFFFFF00) != 0) {
                    nArray[1] = (nArray[1] & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
            }
            case 1: {
                nArray[0] = (int)dArray[0];
                if ((nArray[0] & 0xFFFFFF00) == 0) break;
                nArray[0] = (nArray[0] & Integer.MIN_VALUE) != 0 ? 0 : 255;
            }
        }
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException("Cannot generate a noise pattern into a null raster");
        }
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n6 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n5 - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int n7 = singlePixelPackedSampleModel.getScanlineStride() - n2;
        int n8 = n6;
        int[] nArray2 = new int[4];
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        double d2 = this.tx[0];
        double d3 = this.tx[1];
        double d4 = this.ty[0] - (double)n2 * d2;
        double d5 = this.ty[1] - (double)n2 * d3;
        double[] dArray3 = new double[]{n4, n5};
        this.txf.transform(dArray3, 0, dArray3, 0, 1);
        double d6 = dArray3[0];
        double d7 = dArray3[1];
        if (this.isFractalNoise) {
            if (this.stitchInfo == null) {
                if (this.channels.length == 4) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n9 = n8 + n2;
                        while (n8 < n9) {
                            nArray[n8] = this.turbulenceFractal_4(d6, d7, dArray);
                            d6 += d2;
                            d7 += d3;
                            ++n8;
                        }
                        d6 += d4;
                        d7 += d5;
                        n8 += n7;
                    }
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n10 = n8 + n2;
                        while (n8 < n10) {
                            this.turbulenceFractal(nArray2, d6, d7, dArray, dArray2);
                            nArray[n8] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                            d6 += d2;
                            d7 += d3;
                            ++n8;
                        }
                        d6 += d4;
                        d7 += d5;
                        n8 += n7;
                    }
                }
            } else {
                StitchInfo stitchInfo = new StitchInfo();
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n11 = n8 + n2;
                    while (n8 < n11) {
                        stitchInfo.assign(this.stitchInfo);
                        this.turbulenceFractalStitch(nArray2, d6, d7, dArray, dArray2, stitchInfo);
                        nArray[n8] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                        d6 += d2;
                        d7 += d3;
                        ++n8;
                    }
                    d6 += d4;
                    d7 += d5;
                    n8 += n7;
                }
            }
        } else if (this.stitchInfo == null) {
            if (this.channels.length == 4) {
                for (int i5 = 0; i5 < n3; ++i5) {
                    int n12 = n8 + n2;
                    while (n8 < n12) {
                        nArray[n8] = this.turbulence_4(d6, d7, dArray);
                        d6 += d2;
                        d7 += d3;
                        ++n8;
                    }
                    d6 += d4;
                    d7 += d5;
                    n8 += n7;
                }
            } else {
                for (int i6 = 0; i6 < n3; ++i6) {
                    int n13 = n8 + n2;
                    while (n8 < n13) {
                        this.turbulence(nArray2, d6, d7, dArray, dArray2);
                        nArray[n8] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                        d6 += d2;
                        d7 += d3;
                        ++n8;
                    }
                    d6 += d4;
                    d7 += d5;
                    n8 += n7;
                }
            }
        } else {
            StitchInfo stitchInfo = new StitchInfo();
            for (int i7 = 0; i7 < n3; ++i7) {
                int n14 = n8 + n2;
                while (n8 < n14) {
                    stitchInfo.assign(this.stitchInfo);
                    this.turbulenceStitch(nArray2, d6, d7, dArray, dArray2, stitchInfo);
                    nArray[n8] = nArray2[3] << 24 | nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2];
                    d6 += d2;
                    d7 += d3;
                    ++n8;
                }
                d6 += d4;
                d7 += d5;
                n8 += n7;
            }
        }
        return writableRaster;
    }

    public TurbulencePatternRed(double d2, double d3, int n2, int n3, boolean bl2, Rectangle2D rectangle2D, AffineTransform affineTransform, Rectangle rectangle, ColorSpace colorSpace, boolean bl3) {
        this.baseFrequencyX = d2;
        this.baseFrequencyY = d3;
        this.seed = n3;
        this.isFractalNoise = bl2;
        this.tile = rectangle2D;
        this.txf = affineTransform;
        if (this.txf == null) {
            this.txf = IDENTITY;
        }
        int n4 = colorSpace.getNumComponents();
        if (bl3) {
            ++n4;
        }
        this.channels = new int[n4];
        for (int i2 = 0; i2 < this.channels.length; ++i2) {
            this.channels[i2] = i2;
        }
        affineTransform.deltaTransform(this.tx, 0, this.tx, 0, 1);
        affineTransform.deltaTransform(this.ty, 0, this.ty, 0, 1);
        double[] dArray = new double[]{0.5, 0.0};
        double[] dArray2 = new double[]{0.0, 0.5};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        affineTransform.deltaTransform(dArray2, 0, dArray2, 0, 1);
        double d4 = Math.max(Math.abs(dArray[0]), Math.abs(dArray2[0]));
        int n5 = -((int)Math.round((Math.log(d4) + Math.log(d2)) / Math.log(2.0)));
        double d5 = Math.max(Math.abs(dArray[1]), Math.abs(dArray2[1]));
        int n6 = -((int)Math.round((Math.log(d5) + Math.log(d3)) / Math.log(2.0)));
        this.numOctaves = n2 > n5 ? n5 : n2;
        int n7 = this.numOctaves = this.numOctaves > n6 ? n6 : this.numOctaves;
        if (this.numOctaves < 1 && n2 > 1) {
            this.numOctaves = 1;
        }
        if (this.numOctaves > 8) {
            this.numOctaves = 8;
        }
        if (rectangle2D != null) {
            double d6;
            double d7 = Math.floor(rectangle2D.getWidth() * d2) / rectangle2D.getWidth();
            this.baseFrequencyX = d2 / d7 < (d6 = Math.ceil(rectangle2D.getWidth() * d2) / rectangle2D.getWidth()) / d2 ? d7 : d6;
            d7 = Math.floor(rectangle2D.getHeight() * d3) / rectangle2D.getHeight();
            d6 = Math.ceil(rectangle2D.getHeight() * d3) / rectangle2D.getHeight();
            this.baseFrequencyY = d3 / d7 < d6 / d3 ? d7 : d6;
            this.stitchInfo = new StitchInfo();
            this.stitchInfo.width = (int)(rectangle2D.getWidth() * this.baseFrequencyX);
            this.stitchInfo.height = (int)(rectangle2D.getHeight() * this.baseFrequencyY);
            this.stitchInfo.wrapX = (int)(rectangle2D.getX() * this.baseFrequencyX + 4096.0 + (double)this.stitchInfo.width);
            this.stitchInfo.wrapY = (int)(rectangle2D.getY() * this.baseFrequencyY + 4096.0 + (double)this.stitchInfo.height);
            if (this.stitchInfo.width == 0) {
                this.stitchInfo.width = 1;
            }
            if (this.stitchInfo.height == 0) {
                this.stitchInfo.height = 1;
            }
        }
        this.initLattice(n3);
        DirectColorModel directColorModel = bl3 ? new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3) : new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
        int n8 = AbstractTiledRed.getDefaultTileSize();
        this.init((CachableRed)null, rectangle, (ColorModel)directColorModel, ((ColorModel)directColorModel).createCompatibleSampleModel(n8, n8), 0, 0, null);
    }

    static final class StitchInfo {
        int width;
        int height;
        int wrapX;
        int wrapY;

        StitchInfo() {
        }

        StitchInfo(StitchInfo stitchInfo) {
            this.width = stitchInfo.width;
            this.height = stitchInfo.height;
            this.wrapX = stitchInfo.wrapX;
            this.wrapY = stitchInfo.wrapY;
        }

        final void assign(StitchInfo stitchInfo) {
            this.width = stitchInfo.width;
            this.height = stitchInfo.height;
            this.wrapX = stitchInfo.wrapX;
            this.wrapY = stitchInfo.wrapY;
        }

        final void doubleFrequency() {
            this.width *= 2;
            this.height *= 2;
            this.wrapX *= 2;
            this.wrapY *= 2;
            this.wrapX = (int)((double)this.wrapX - 4096.0);
            this.wrapY = (int)((double)this.wrapY - 4096.0);
        }
    }
}

