/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class MultiplyAlphaRed
extends AbstractRed {
    public MultiplyAlphaRed(CachableRed cachableRed, CachableRed cachableRed2) {
        super(MultiplyAlphaRed.makeList(cachableRed, cachableRed2), MultiplyAlphaRed.makeBounds(cachableRed, cachableRed2), MultiplyAlphaRed.fixColorModel(cachableRed), MultiplyAlphaRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public boolean is_INT_PACK_BYTE_COMP(SampleModel sampleModel, SampleModel sampleModel2) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (!(sampleModel2 instanceof ComponentSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        if (sampleModel2.getDataType() != 0) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        if (nArray[3] != -16777216) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel2;
        if (componentSampleModel.getNumBands() != 1) {
            return false;
        }
        return componentSampleModel.getPixelStride() == 1;
    }

    public WritableRaster INT_PACK_BYTE_COMP_Impl(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        cachableRed.copyData(writableRaster);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        Raster raster = cachableRed2.getData(rectangle);
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n2 = componentSampleModel.getScanlineStride();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n3 = dataBufferByte.getOffset() + componentSampleModel.getOffset(rectangle.x - raster.getSampleModelTranslateX(), rectangle.y - raster.getSampleModelTranslateY());
        byte[] byArray = dataBufferByte.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n4 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(rectangle.x - writableRaster.getSampleModelTranslateX(), rectangle.y - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.isAlphaPremultiplied()) {
            for (int i2 = 0; i2 < rectangle.height; ++i2) {
                int n6;
                int n7 = n3 + i2 * n2;
                int n8 = n6 + rectangle.width;
                for (n6 = n5 + i2 * n4; n6 < n8; ++n6) {
                    int n9 = byArray[n7++] & 0xFF;
                    int n10 = nArray[n6];
                    nArray[n6] = ((n10 >>> 24) * n9 & 0xFF00) << 16 | ((n10 >>> 16 & 0xFF) * n9 & 0xFF00) << 8 | (n10 >>> 8 & 0xFF) * n9 & 0xFF00 | ((n10 & 0xFF) * n9 & 0xFF00) >> 8;
                }
            }
        } else {
            for (int i3 = 0; i3 < rectangle.height; ++i3) {
                int n11;
                int n12 = n3 + i3 * n2;
                int n13 = n11 + rectangle.width;
                for (n11 = n5 + i3 * n4; n11 < n13; ++n11) {
                    int n14 = byArray[n12++] & 0xFF;
                    int n15 = nArray[n11] >>> 24;
                    nArray[n11] = (n15 * n14 & 0xFF00) << 16 | nArray[n11] & 0xFFFFFF;
                }
            }
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        CachableRed cachableRed2 = (CachableRed)this.getSources().get(1);
        if (this.is_INT_PACK_BYTE_COMP(cachableRed.getSampleModel(), cachableRed2.getSampleModel())) {
            return this.INT_PACK_BYTE_COMP_Impl(writableRaster);
        }
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            cachableRed.copyData(writableRaster);
            Rectangle rectangle = writableRaster.getBounds();
            if (!rectangle.intersects(cachableRed2.getBounds())) {
                return writableRaster;
            }
            rectangle = rectangle.intersection(cachableRed2.getBounds());
            int[] nArray = null;
            int[] nArray2 = null;
            Raster raster = cachableRed2.getData(rectangle);
            int n2 = rectangle.width;
            int n3 = writableRaster.getSampleModel().getNumBands();
            if (colorModel.isAlphaPremultiplied()) {
                for (int i2 = rectangle.y; i2 < rectangle.y + rectangle.height; ++i2) {
                    nArray = writableRaster.getPixels(rectangle.x, i2, n2, 1, nArray);
                    nArray2 = raster.getSamples(rectangle.x, i2, n2, 1, 0, nArray2);
                    int n4 = 0;
                    switch (n3) {
                        case 2: {
                            int n5;
                            for (int n6 : nArray2) {
                                n5 = n6 & 0xFF;
                                nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                ++n4;
                            }
                            break;
                        }
                        case 4: {
                            int n5;
                            for (int n6 : nArray2) {
                                n5 = n6 & 0xFF;
                                nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                nArray[++n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                ++n4;
                            }
                            break;
                        }
                        default: {
                            int n5;
                            for (int n6 : nArray2) {
                                n5 = n6 & 0xFF;
                                for (int i3 = 0; i3 < n3; ++i3) {
                                    nArray[n4] = (nArray[n4] & 0xFF) * n5 >> 8;
                                    ++n4;
                                }
                            }
                        }
                    }
                    writableRaster.setPixels(rectangle.x, i2, n2, 1, nArray);
                }
            } else {
                int n7 = cachableRed.getSampleModel().getNumBands() - 1;
                for (int i4 = rectangle.y; i4 < rectangle.y + rectangle.height; ++i4) {
                    nArray = writableRaster.getSamples(rectangle.x, i4, n2, 1, n7, nArray);
                    nArray2 = raster.getSamples(rectangle.x, i4, n2, 1, 0, nArray2);
                    for (int i5 = 0; i5 < nArray.length; ++i5) {
                        nArray[i5] = (nArray[i5] & 0xFF) * (nArray2[i5] & 0xFF) >> 8;
                    }
                    writableRaster.setSamples(rectangle.x, i4, n2, 1, n7, nArray);
                }
            }
            return writableRaster;
        }
        int[] nArray = new int[writableRaster.getNumBands() - 1];
        for (int i6 = 0; i6 < nArray.length; ++i6) {
            nArray[i6] = i6;
        }
        WritableRaster writableRaster2 = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), nArray);
        cachableRed.copyData(writableRaster2);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle = rectangle.intersection(cachableRed2.getBounds());
        nArray = new int[]{writableRaster.getNumBands() - 1};
        writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray);
        cachableRed2.copyData(writableRaster2);
        return writableRaster;
    }

    public static List makeList(CachableRed cachableRed, CachableRed cachableRed2) {
        ArrayList<CachableRed> arrayList = new ArrayList<CachableRed>(2);
        arrayList.add(cachableRed);
        arrayList.add(cachableRed2);
        return arrayList;
    }

    public static Rectangle makeBounds(CachableRed cachableRed, CachableRed cachableRed2) {
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = cachableRed2.getBounds();
        return rectangle.intersection(rectangle2);
    }

    public static SampleModel fixSampleModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (colorModel.hasAlpha()) {
            return sampleModel;
        }
        int n2 = sampleModel.getWidth();
        int n3 = sampleModel.getHeight();
        int n4 = sampleModel.getNumBands() + 1;
        int[] nArray = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = i2;
        }
        return new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray);
    }

    public static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            return colorModel;
        }
        int n2 = cachableRed.getSampleModel().getNumBands() + 1;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 8;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
    }
}

