/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import org.apache.batik.util.DoublyLinkedList;

public class LRUCache {
    private DoublyLinkedList free = null;
    private DoublyLinkedList used = null;
    private int maxSize = 0;

    public LRUCache(int n2) {
        if (n2 <= 0) {
            n2 = 1;
        }
        this.maxSize = n2;
        this.free = new DoublyLinkedList();
        this.used = new DoublyLinkedList();
        while (n2 > 0) {
            this.free.add(new LRUNode());
            --n2;
        }
    }

    public int getUsed() {
        return this.used.getSize();
    }

    public synchronized void setSize(int n2) {
        if (this.maxSize < n2) {
            for (int i2 = this.maxSize; i2 < n2; ++i2) {
                this.free.add(new LRUNode());
            }
        } else if (this.maxSize > n2) {
            for (int i3 = this.used.getSize(); i3 > n2; --i3) {
                LRUNode lRUNode = (LRUNode)this.used.getTail();
                this.used.remove(lRUNode);
                lRUNode.setObj(null);
            }
        }
        this.maxSize = n2;
    }

    public synchronized void flush() {
        while (this.used.getSize() > 0) {
            LRUNode lRUNode = (LRUNode)this.used.pop();
            lRUNode.setObj(null);
            this.free.add(lRUNode);
        }
    }

    public synchronized void remove(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.remove(lRUNode);
        lRUNode.setObj(null);
        this.free.add(lRUNode);
    }

    public synchronized void touch(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode == null) {
            return;
        }
        this.used.touch(lRUNode);
    }

    public synchronized void add(LRUObj lRUObj) {
        LRUNode lRUNode = lRUObj.lruGet();
        if (lRUNode != null) {
            this.used.touch(lRUNode);
            return;
        }
        if (this.free.getSize() > 0) {
            lRUNode = (LRUNode)this.free.pop();
            lRUNode.setObj(lRUObj);
            this.used.add(lRUNode);
        } else {
            lRUNode = (LRUNode)this.used.getTail();
            lRUNode.setObj(lRUObj);
            this.used.touch(lRUNode);
        }
    }

    protected synchronized void print() {
        System.out.println("In Use: " + this.used.getSize() + " Free: " + this.free.getSize());
        LRUNode lRUNode = (LRUNode)this.used.getHead();
        if (lRUNode == null) {
            return;
        }
        do {
            System.out.println(lRUNode.getObj());
        } while ((lRUNode = (LRUNode)lRUNode.getNext()) != this.used.getHead());
    }

    public static class LRUNode
    extends DoublyLinkedList.Node {
        private LRUObj obj = null;

        public LRUObj getObj() {
            return this.obj;
        }

        protected void setObj(LRUObj lRUObj) {
            if (this.obj != null) {
                this.obj.lruRemove();
            }
            this.obj = lRUObj;
            if (this.obj != null) {
                this.obj.lruSet(this);
            }
        }
    }

    public static interface LRUObj {
        public void lruSet(LRUNode var1);

        public LRUNode lruGet();

        public void lruRemove();
    }
}

