/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class GaussianBlurRed8Bit
extends AbstractRed {
    int xinset;
    int yinset;
    double stdDevX;
    double stdDevY;
    RenderingHints hints;
    ConvolveOp[] convOp = new ConvolveOp[2];
    int dX;
    int dY;
    static final float SQRT2PI = (float)Math.sqrt(Math.PI * 2);
    static final float DSQRT2PI = SQRT2PI * 3.0f / 4.0f;
    static final float precision = 0.499f;

    public GaussianBlurRed8Bit(CachableRed cachableRed, double d2, RenderingHints renderingHints) {
        this(cachableRed, d2, d2, renderingHints);
    }

    public GaussianBlurRed8Bit(CachableRed cachableRed, double d2, double d3, RenderingHints renderingHints) {
        boolean bl2;
        this.stdDevX = d2;
        this.stdDevY = d3;
        this.hints = renderingHints;
        this.xinset = GaussianBlurRed8Bit.surroundPixels(d2, renderingHints);
        this.yinset = GaussianBlurRed8Bit.surroundPixels(d3, renderingHints);
        Rectangle rectangle = cachableRed.getBounds();
        rectangle.x += this.xinset;
        rectangle.y += this.yinset;
        rectangle.width -= 2 * this.xinset;
        rectangle.height -= 2 * this.yinset;
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            rectangle.width = 0;
            rectangle.height = 0;
        }
        ColorModel colorModel = GaussianBlurRed8Bit.fixColorModel(cachableRed);
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n2 = sampleModel.getWidth();
        int n3 = sampleModel.getHeight();
        if (n2 > rectangle.width) {
            n2 = rectangle.width;
        }
        if (n3 > rectangle.height) {
            n3 = rectangle.height;
        }
        sampleModel = colorModel.createCompatibleSampleModel(n2, n3);
        this.init(cachableRed, rectangle, colorModel, sampleModel, cachableRed.getTileGridXOffset() + this.xinset, cachableRed.getTileGridYOffset() + this.yinset, null);
        boolean bl3 = bl2 = this.hints != null && RenderingHints.VALUE_RENDER_QUALITY.equals(this.hints.get(RenderingHints.KEY_RENDERING));
        if (this.xinset != 0 && (d2 < 2.0 || bl2)) {
            this.convOp[0] = new ConvolveOp(this.makeQualityKernelX(this.xinset * 2 + 1));
        } else {
            this.dX = (int)Math.floor((double)DSQRT2PI * d2 + 0.5);
        }
        if (this.yinset != 0 && (d3 < 2.0 || bl2)) {
            this.convOp[1] = new ConvolveOp(this.makeQualityKernelY(this.yinset * 2 + 1));
        } else {
            this.dY = (int)Math.floor((double)DSQRT2PI * d3 + 0.5);
        }
    }

    public static int surroundPixels(double d2) {
        return GaussianBlurRed8Bit.surroundPixels(d2, null);
    }

    public static int surroundPixels(double d2, RenderingHints renderingHints) {
        boolean bl2;
        boolean bl3 = bl2 = renderingHints != null && RenderingHints.VALUE_RENDER_QUALITY.equals(renderingHints.get(RenderingHints.KEY_RENDERING));
        if (d2 < 2.0 || bl2) {
            float f2 = (float)(0.5 / (d2 * (double)SQRT2PI));
            int n2 = 0;
            while (f2 < 0.499f) {
                f2 += (float)(Math.pow(Math.E, (double)(-n2 * n2) / (2.0 * d2 * d2)) / (d2 * (double)SQRT2PI));
                ++n2;
            }
            return n2;
        }
        int n3 = (int)Math.floor((double)DSQRT2PI * d2 + 0.5);
        if (n3 % 2 == 0) {
            return n3 - 1 + n3 / 2;
        }
        return n3 - 2 + n3 / 2;
    }

    private float[] computeQualityKernelData(int n2, double d2) {
        int n3;
        float[] fArray = new float[n2];
        int n4 = n2 / 2;
        float f2 = 0.0f;
        for (n3 = 0; n3 < n2; ++n3) {
            fArray[n3] = (float)(Math.pow(Math.E, (double)(-(n3 - n4) * (n3 - n4)) / (2.0 * d2 * d2)) / ((double)SQRT2PI * d2));
            f2 += fArray[n3];
        }
        n3 = 0;
        while (n3 < n2) {
            int n5 = n3++;
            fArray[n5] = fArray[n5] / f2;
        }
        return fArray;
    }

    private Kernel makeQualityKernelX(int n2) {
        return new Kernel(n2, 1, this.computeQualityKernelData(n2, this.stdDevX));
    }

    private Kernel makeQualityKernelY(int n2) {
        return new Kernel(1, n2, this.computeQualityKernelData(n2, this.stdDevY));
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        int n2;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = writableRaster.getBounds();
        rectangle.x -= this.xinset;
        rectangle.y -= this.yinset;
        rectangle.width += 2 * this.xinset;
        rectangle.height += 2 * this.yinset;
        ColorModel colorModel = cachableRed.getColorModel();
        WritableRaster writableRaster2 = null;
        WritableRaster writableRaster3 = null;
        writableRaster2 = colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height);
        WritableRaster writableRaster4 = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
        cachableRed.copyData(writableRaster4);
        if (colorModel.hasAlpha() && !colorModel.isAlphaPremultiplied()) {
            GraphicsUtil.coerceData(writableRaster2, colorModel, true);
        }
        if (this.xinset == 0) {
            n2 = 0;
        } else if (this.convOp[0] != null) {
            writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            writableRaster3 = this.convOp[0].filter(writableRaster2, writableRaster3);
            n2 = this.convOp[0].getKernel().getXOrigin();
            WritableRaster writableRaster5 = writableRaster2;
            writableRaster2 = writableRaster3;
            writableRaster3 = writableRaster5;
        } else if ((this.dX & 1) == 0) {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2 - 1);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 1, 0, this.dX + 1, this.dX / 2);
            n2 = this.dX - 1 + this.dX / 2;
        } else {
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, 0, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX / 2, 0, this.dX, this.dX / 2);
            writableRaster2 = this.boxFilterH(writableRaster2, writableRaster2, this.dX - 2, 0, this.dX, this.dX / 2);
            n2 = this.dX - 2 + this.dX / 2;
        }
        if (this.yinset == 0) {
            writableRaster3 = writableRaster2;
        } else if (this.convOp[1] != null) {
            if (writableRaster3 == null) {
                writableRaster3 = this.getColorModel().createCompatibleWritableRaster(rectangle.width, rectangle.height);
            }
            writableRaster3 = this.convOp[1].filter(writableRaster2, writableRaster3);
        } else {
            if ((this.dY & 1) == 0) {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, this.dY / 2, this.dY, this.dY / 2 - 1);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, this.dY - 1, this.dY + 1, this.dY / 2);
            } else {
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, 0, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, this.dY / 2, this.dY, this.dY / 2);
                writableRaster2 = this.boxFilterV(writableRaster2, writableRaster2, n2, this.dY - 2, this.dY, this.dY / 2);
            }
            writableRaster3 = writableRaster2;
        }
        writableRaster3 = writableRaster3.createWritableTranslatedChild(rectangle.x, rectangle.y);
        GraphicsUtil.copyData(writableRaster3, writableRaster);
        return writableRaster;
    }

    private WritableRaster boxFilterH(Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5) {
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n6 < 2 * n2 + n4) {
            return writableRaster;
        }
        if (n7 < 2 * n3) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        int n9 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n10 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n11 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n4];
        int n12 = 0x1000000 / n4;
        for (int i2 = n3; i2 < n7 - n3; ++i2) {
            int n13;
            int n14 = n10 + i2 * n8;
            int n15 = n11 + i2 * n9;
            int n16 = n14 + (n6 - n2);
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n2) + n4;
            while (n14 < n22) {
                n13 = nArray3[n17] = nArray[n14];
                n18 += n13 >>> 24;
                n19 += n13 >> 16 & 0xFF;
                n20 += n13 >> 8 & 0xFF;
                n21 += n13 & 0xFF;
                ++n17;
                ++n14;
            }
            int n23 = nArray2[n15 += n2 + n5] = n18 * n12 & 0xFF000000 | (n19 * n12 & 0xFF000000) >>> 8 | (n20 * n12 & 0xFF000000) >>> 16 | (n21 * n12 & 0xFF000000) >>> 24;
            ++n15;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray3[n17];
                if (n13 == nArray[n14]) {
                    nArray2[n15] = n23;
                } else {
                    n18 -= n13 >>> 24;
                    n19 -= n13 >> 16 & 0xFF;
                    n20 -= n13 >> 8 & 0xFF;
                    n21 -= n13 & 0xFF;
                    n13 = nArray3[n17] = nArray[n14];
                    n23 = nArray2[n15] = (n18 += n13 >>> 24) * n12 & 0xFF000000 | ((n19 += n13 >> 16 & 0xFF) * n12 & 0xFF000000) >>> 8 | ((n20 += n13 >> 8 & 0xFF) * n12 & 0xFF000000) >>> 16 | ((n21 += n13 & 0xFF) * n12 & 0xFF000000) >>> 24;
                }
                n17 = (n17 + 1) % n4;
                ++n14;
                ++n15;
            }
        }
        return writableRaster;
    }

    private WritableRaster boxFilterV(Raster raster, WritableRaster writableRaster, int n2, int n3, int n4, int n5) {
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n6 < 2 * n2) {
            return writableRaster;
        }
        if (n7 < 2 * n3 + n4) {
            return writableRaster;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        int n9 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n10 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY());
        int n11 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = new int[n4];
        int n12 = 0x1000000 / n4;
        for (int i2 = n2; i2 < n6 - n2; ++i2) {
            int n13;
            int n14 = n10 + i2;
            int n15 = n11 + i2;
            int n16 = n14 + (n7 - n3) * n8;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = (n14 += n3 * n8) + n4 * n8;
            while (n14 < n22) {
                n13 = nArray3[n17] = nArray[n14];
                n18 += n13 >>> 24;
                n19 += n13 >> 16 & 0xFF;
                n20 += n13 >> 8 & 0xFF;
                n21 += n13 & 0xFF;
                ++n17;
                n14 += n8;
            }
            int n23 = nArray2[n15 += (n3 + n5) * n9] = n18 * n12 & 0xFF000000 | (n19 * n12 & 0xFF000000) >>> 8 | (n20 * n12 & 0xFF000000) >>> 16 | (n21 * n12 & 0xFF000000) >>> 24;
            n15 += n9;
            n17 = 0;
            while (n14 < n16) {
                n13 = nArray3[n17];
                if (n13 == nArray[n14]) {
                    nArray2[n15] = n23;
                } else {
                    n18 -= n13 >>> 24;
                    n19 -= n13 >> 16 & 0xFF;
                    n20 -= n13 >> 8 & 0xFF;
                    n21 -= n13 & 0xFF;
                    n13 = nArray3[n17] = nArray[n14];
                    n23 = nArray2[n15] = (n18 += n13 >>> 24) * n12 & 0xFF000000 | ((n19 += n13 >> 16 & 0xFF) * n12 & 0xFF000000) >>> 8 | ((n20 += n13 >> 8 & 0xFF) * n12 & 0xFF000000) >>> 16 | ((n21 += n13 & 0xFF) * n12 & 0xFF000000) >>> 24;
                }
                n17 = (n17 + 1) % n4;
                n14 += n8;
                n15 += n9;
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        int n2 = cachableRed.getSampleModel().getNumBands();
        int[] nArray = new int[4];
        switch (n2) {
            case 1: {
                nArray[0] = 255;
                break;
            }
            case 2: {
                nArray[0] = 255;
                nArray[3] = 65280;
                break;
            }
            case 3: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                break;
            }
            case 4: {
                nArray[0] = 0xFF0000;
                nArray[1] = 65280;
                nArray[2] = 255;
                nArray[3] = -16777216;
                break;
            }
            default: {
                throw new IllegalArgumentException("GaussianBlurRed8Bit only supports one to four band images");
            }
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        return new DirectColorModel(colorSpace, 8 * n2, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
    }
}

