/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class FormatRed
extends AbstractRed {
    public static CachableRed construct(CachableRed cachableRed, ColorModel colorModel) {
        ColorModel colorModel2 = cachableRed.getColorModel();
        if (colorModel.hasAlpha() != colorModel2.hasAlpha() || colorModel.isAlphaPremultiplied() != colorModel2.isAlphaPremultiplied()) {
            return new FormatRed(cachableRed, colorModel);
        }
        if (colorModel.getNumComponents() != colorModel2.getNumComponents()) {
            throw new IllegalArgumentException("Incompatible ColorModel given");
        }
        if (colorModel2 instanceof ComponentColorModel && colorModel instanceof ComponentColorModel) {
            return cachableRed;
        }
        if (colorModel2 instanceof DirectColorModel && colorModel instanceof DirectColorModel) {
            return cachableRed;
        }
        return new FormatRed(cachableRed, colorModel);
    }

    public FormatRed(CachableRed cachableRed, SampleModel sampleModel) {
        super(cachableRed, cachableRed.getBounds(), FormatRed.makeColorModel(cachableRed, sampleModel), sampleModel, cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public FormatRed(CachableRed cachableRed, ColorModel colorModel) {
        super(cachableRed, cachableRed.getBounds(), colorModel, FormatRed.makeSampleModel(cachableRed, colorModel), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public CachableRed getSource() {
        return (CachableRed)this.getSources().get(0);
    }

    @Override
    public Object getProperty(String string) {
        return this.getSource().getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getSource().getPropertyNames();
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        ColorModel colorModel = this.getColorModel();
        CachableRed cachableRed = this.getSource();
        ColorModel colorModel2 = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        sampleModel = sampleModel.createCompatibleSampleModel(writableRaster.getWidth(), writableRaster.getHeight());
        WritableRaster writableRaster2 = Raster.createWritableRaster(sampleModel, new Point(writableRaster.getMinX(), writableRaster.getMinY()));
        this.getSource().copyData(writableRaster2);
        BufferedImage bufferedImage = new BufferedImage(colorModel2, writableRaster2.createWritableTranslatedChild(0, 0), colorModel2.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bufferedImage, bufferedImage2);
        return writableRaster;
    }

    public static SampleModel makeSampleModel(CachableRed cachableRed, ColorModel colorModel) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        return colorModel.createCompatibleSampleModel(sampleModel.getWidth(), sampleModel.getHeight());
    }

    public static ColorModel makeColorModel(CachableRed cachableRed, SampleModel sampleModel) {
        int n2;
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n3 = sampleModel.getNumBands();
        int n4 = sampleModel.getDataType();
        switch (n4) {
            case 0: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 16;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 3: {
                n2 = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DataBuffer type: " + n4);
            }
        }
        boolean bl2 = colorModel.hasAlpha();
        if (bl2) {
            if (n3 == colorModel.getNumComponents() - 1) {
                bl2 = false;
            } else if (n3 != colorModel.getNumComponents()) {
                throw new IllegalArgumentException("Incompatible number of bands in and out");
            }
        } else if (n3 == colorModel.getNumComponents() + 1) {
            bl2 = true;
        } else if (n3 != colorModel.getNumComponents()) {
            throw new IllegalArgumentException("Incompatible number of bands in and out");
        }
        boolean bl3 = colorModel.isAlphaPremultiplied();
        if (!bl2) {
            bl3 = false;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            int[] nArray = new int[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = n2;
            }
            return new ComponentColorModel(colorSpace, nArray, bl2, bl3, bl2 ? 3 : 1, n4);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            if (n3 == 4) {
                return new DirectColorModel(colorSpace, n2, nArray[0], nArray[1], nArray[2], nArray[3], bl3, n4);
            }
            if (n3 == 3) {
                return new DirectColorModel(colorSpace, n2, nArray[0], nArray[1], nArray[2], 0, bl3, n4);
            }
            throw new IllegalArgumentException("Incompatible number of bands out for ColorModel");
        }
        throw new IllegalArgumentException("Unsupported SampleModel Type");
    }
}

