/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class AffineRed
extends AbstractRed {
    RenderingHints hints;
    AffineTransform src2me;
    AffineTransform me2src;

    public AffineTransform getTransform() {
        return (AffineTransform)this.src2me.clone();
    }

    public CachableRed getSource() {
        return (CachableRed)this.getSources().get(0);
    }

    public AffineRed(CachableRed cachableRed, AffineTransform affineTransform, RenderingHints renderingHints) {
        this.src2me = affineTransform;
        this.hints = renderingHints;
        try {
            this.me2src = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.me2src = null;
        }
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
        ColorModel colorModel = AffineRed.fixColorModel(cachableRed);
        SampleModel sampleModel = this.fixSampleModel(cachableRed, colorModel, rectangle2);
        Point2D point2D = new Point2D.Float(cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset());
        point2D = affineTransform.transform(point2D, null);
        this.init(cachableRed, rectangle2, colorModel, sampleModel, (int)point2D.getX(), (int)point2D.getY(), null);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        PadRed.ZeroRecter zeroRecter = PadRed.ZeroRecter.getZeroRecter(writableRaster);
        zeroRecter.zeroRect(new Rectangle(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight()));
        this.genRect(writableRaster);
        return writableRaster;
    }

    @Override
    public Raster getTile(int n2, int n3) {
        if (this.me2src == null) {
            return null;
        }
        int n4 = this.tileGridXOff + n2 * this.tileWidth;
        int n5 = this.tileGridYOff + n3 * this.tileHeight;
        Point point = new Point(n4, n5);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        if (this.me2src == null) {
            return;
        }
        Rectangle rectangle = this.me2src.createTransformedShape(writableRaster.getBounds()).getBounds();
        rectangle.setBounds(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        if (!rectangle.intersects(cachableRed.getBounds())) {
            return;
        }
        Raster raster = cachableRed.getData(rectangle.intersection(cachableRed.getBounds()));
        if (raster == null) {
            return;
        }
        AffineTransform affineTransform = (AffineTransform)this.src2me.clone();
        affineTransform.concatenate(AffineTransform.getTranslateInstance(raster.getMinX(), raster.getMinY()));
        Point2D point2D = new Point2D.Float(writableRaster.getMinX(), writableRaster.getMinY());
        point2D = this.me2src.transform(point2D, null);
        Point2D point2D2 = new Point2D.Double(point2D.getX() - (double)raster.getMinX(), point2D.getY() - (double)raster.getMinY());
        point2D2 = affineTransform.transform(point2D2, null);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-point2D2.getX(), -point2D2.getY()));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.hints);
        ColorModel colorModel = cachableRed.getColorModel();
        ColorModel colorModel2 = this.getColorModel();
        WritableRaster writableRaster2 = (WritableRaster)raster;
        colorModel = GraphicsUtil.coerceData(writableRaster2, colorModel, true);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster2.createWritableTranslatedChild(0, 0), colorModel.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel2, writableRaster.createWritableTranslatedChild(0, 0), colorModel2.isAlphaPremultiplied(), null);
        affineTransformOp.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel.hasAlpha()) {
            if (!colorModel.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceColorModel(colorModel, true);
            }
            return colorModel;
        }
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n2 = cachableRed.getSampleModel().getNumBands() + 1;
        if (n2 == 4) {
            int[] nArray = new int[4];
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                nArray[i2] = 0xFF0000 >> 8 * i2;
            }
            nArray[3] = 255 << 8 * (n2 - 1);
            return new DirectColorModel(colorSpace, 8 * n2, nArray[0], nArray[1], nArray[2], nArray[3], true, 3);
        }
        int[] nArray = new int[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            nArray[i3] = 8;
        }
        return new ComponentColorModel(colorSpace, nArray, true, true, 3, 3);
    }

    protected SampleModel fixSampleModel(CachableRed cachableRed, ColorModel colorModel, Rectangle rectangle) {
        int n2;
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n3 = AbstractTiledRed.getDefaultTileSize();
        int n4 = sampleModel.getWidth();
        if (n4 < n3) {
            n4 = n3;
        }
        if (n4 > rectangle.width) {
            n4 = rectangle.width;
        }
        if ((n2 = sampleModel.getHeight()) < n3) {
            n2 = n3;
        }
        if (n2 > rectangle.height) {
            n2 = rectangle.height;
        }
        if (n4 <= 0 || n2 <= 0) {
            n4 = 1;
            n2 = 1;
        }
        return colorModel.createCompatibleSampleModel(n4, n2);
    }
}

