/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class SVGComposite
implements Composite {
    public static final SVGComposite OVER = new SVGComposite(CompositeRule.OVER);
    public static final SVGComposite IN = new SVGComposite(CompositeRule.IN);
    public static final SVGComposite OUT = new SVGComposite(CompositeRule.OUT);
    public static final SVGComposite ATOP = new SVGComposite(CompositeRule.ATOP);
    public static final SVGComposite XOR = new SVGComposite(CompositeRule.XOR);
    public static final SVGComposite MULTIPLY = new SVGComposite(CompositeRule.MULTIPLY);
    public static final SVGComposite SCREEN = new SVGComposite(CompositeRule.SCREEN);
    public static final SVGComposite DARKEN = new SVGComposite(CompositeRule.DARKEN);
    public static final SVGComposite LIGHTEN = new SVGComposite(CompositeRule.LIGHTEN);
    CompositeRule rule;

    public CompositeRule getRule() {
        return this.rule;
    }

    public SVGComposite(CompositeRule compositeRule) {
        this.rule = compositeRule;
    }

    public boolean equals(Object object) {
        if (object instanceof SVGComposite) {
            SVGComposite sVGComposite = (SVGComposite)object;
            return sVGComposite.getRule() == this.getRule();
        }
        if (object instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)object;
            switch (this.getRule().getRule()) {
                case 1: {
                    return alphaComposite == AlphaComposite.SrcOver;
                }
                case 2: {
                    return alphaComposite == AlphaComposite.SrcIn;
                }
                case 3: {
                    return alphaComposite == AlphaComposite.SrcOut;
                }
            }
            return false;
        }
        return false;
    }

    public boolean is_INT_PACK(ColorModel colorModel) {
        if (!(colorModel instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)colorModel;
        int[] nArray = packedColorModel.getMasks();
        if (nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray[3] == -16777216;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        boolean bl2 = this.is_INT_PACK(colorModel) && this.is_INT_PACK(colorModel2);
        switch (this.rule.getRule()) {
            case 1: {
                if (!colorModel2.hasAlpha()) {
                    if (bl2) {
                        return new OverCompositeContext_INT_PACK_NA(colorModel, colorModel2);
                    }
                    return new OverCompositeContext_NA(colorModel, colorModel2);
                }
                if (!bl2) {
                    return new OverCompositeContext(colorModel, colorModel2);
                }
                if (colorModel.isAlphaPremultiplied()) {
                    return new OverCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new OverCompositeContext_INT_PACK_UNPRE(colorModel, colorModel2);
            }
            case 2: {
                if (bl2) {
                    return new InCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new InCompositeContext(colorModel, colorModel2);
            }
            case 3: {
                if (bl2) {
                    return new OutCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new OutCompositeContext(colorModel, colorModel2);
            }
            case 4: {
                if (bl2) {
                    return new AtopCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new AtopCompositeContext(colorModel, colorModel2);
            }
            case 5: {
                if (bl2) {
                    return new XorCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new XorCompositeContext(colorModel, colorModel2);
            }
            case 6: {
                float[] fArray = this.rule.getCoefficients();
                if (bl2) {
                    return new ArithCompositeContext_INT_PACK_LUT(colorModel, colorModel2, fArray[0], fArray[1], fArray[2], fArray[3]);
                }
                return new ArithCompositeContext(colorModel, colorModel2, fArray[0], fArray[1], fArray[2], fArray[3]);
            }
            case 7: {
                if (bl2) {
                    return new MultiplyCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new MultiplyCompositeContext(colorModel, colorModel2);
            }
            case 8: {
                if (bl2) {
                    return new ScreenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new ScreenCompositeContext(colorModel, colorModel2);
            }
            case 9: {
                if (bl2) {
                    return new DarkenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new DarkenCompositeContext(colorModel, colorModel2);
            }
            case 10: {
                if (bl2) {
                    return new LightenCompositeContext_INT_PACK(colorModel, colorModel2);
                }
                return new LightenCompositeContext(colorModel, colorModel2);
            }
        }
        throw new UnsupportedOperationException("Unknown composite rule requested.");
    }

    public static class LightenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        LightenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13;
                    int n14;
                    int n15 = nArray[n5++];
                    int n16 = nArray2[n7++];
                    int n17 = n15 >>> 24;
                    int n18 = n16 >>> 24;
                    int n19 = (255 - n18) * 65793;
                    int n20 = (255 - n17) * 65793;
                    int n21 = n17 + n18 - (n17 * n18 * 65793 + 0x800000 >>> 24);
                    n17 = n15 >> 16 & 0xFF;
                    n18 = n16 >> 16 & 0xFF;
                    int n22 = (n19 * n17 + 0x800000 >>> 24) + n18;
                    int n23 = (n20 * n18 + 0x800000 >>> 24) + n17;
                    if (n22 < n23) {
                        n22 = n23;
                    }
                    if ((n14 = (n19 * (n17 = n15 >> 8 & 0xFF) + 0x800000 >>> 24) + (n18 = n16 >> 8 & 0xFF)) < (n23 = (n20 * n18 + 0x800000 >>> 24) + n17)) {
                        n14 = n23;
                    }
                    if ((n13 = (n19 * (n17 = n15 & 0xFF) + 0x800000 >>> 24) + (n18 = n16 & 0xFF)) < (n23 = (n20 * n18 + 0x800000 >>> 24) + n17)) {
                        n13 = n23;
                    }
                    nArray3[n9++] = (n21 &= 0xFF) << 24 | (n22 &= 0xFF) << 16 | (n14 &= 0xFF) << 8 | (n13 &= 0xFF);
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class LightenCompositeContext
    extends AlphaPreCompositeContext {
        LightenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = 255 - nArray2[i3 + 3];
                    int n10 = (n9 * nArray[i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    int n11 = 255 - nArray[i3 + 3];
                    int n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n10 : n12;
                    n10 = (n9 * nArray[++i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n10 : n12;
                    n10 = (n9 * nArray[++i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n10 : n12;
                    nArray2[++i3] = nArray[i3] + nArray2[i3] - (nArray2[i3] * nArray[i3] * 65793 + 0x800000 >>> 24);
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class DarkenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        DarkenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13;
                    int n14;
                    int n15 = nArray[n5++];
                    int n16 = nArray2[n7++];
                    int n17 = n15 >>> 24;
                    int n18 = n16 >>> 24;
                    int n19 = (255 - n18) * 65793;
                    int n20 = (255 - n17) * 65793;
                    int n21 = n17 + n18 - (n17 * n18 * 65793 + 0x800000 >>> 24);
                    n17 = n15 >> 16 & 0xFF;
                    n18 = n16 >> 16 & 0xFF;
                    int n22 = (n19 * n17 + 0x800000 >>> 24) + n18;
                    int n23 = (n20 * n18 + 0x800000 >>> 24) + n17;
                    if (n22 > n23) {
                        n22 = n23;
                    }
                    if ((n14 = (n19 * (n17 = n15 >> 8 & 0xFF) + 0x800000 >>> 24) + (n18 = n16 >> 8 & 0xFF)) > (n23 = (n20 * n18 + 0x800000 >>> 24) + n17)) {
                        n14 = n23;
                    }
                    if ((n13 = (n19 * (n17 = n15 & 0xFF) + 0x800000 >>> 24) + (n18 = n16 & 0xFF)) > (n23 = (n20 * n18 + 0x800000 >>> 24) + n17)) {
                        n13 = n23;
                    }
                    nArray3[n9++] = (n21 &= 0xFF) << 24 | (n22 &= 0xFF) << 16 | (n14 &= 0xFF) << 8 | (n13 &= 0xFF);
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class DarkenCompositeContext
    extends AlphaPreCompositeContext {
        DarkenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = 255 - nArray2[i3 + 3];
                    int n10 = (n9 * nArray[i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    int n11 = 255 - nArray[i3 + 3];
                    int n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n12 : n10;
                    n10 = (n9 * nArray[++i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n12 : n10;
                    n10 = (n9 * nArray[++i3] * 65793 + 0x800000 >>> 24) + nArray2[i3];
                    n12 = (n11 * nArray2[i3] * 65793 + 0x800000 >>> 24) + nArray[i3];
                    nArray2[i3] = n10 > n12 ? n12 : n10;
                    nArray2[++i3] = nArray[i3] + nArray2[i3] - (nArray2[i3] * nArray[i3] * 65793 + 0x800000 >>> 24);
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class ScreenCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        ScreenCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = n13 >>> 24;
                    int n16 = n14 >>> 24;
                    int n17 = n13 >> 16 & 0xFF;
                    int n18 = n14 >> 16 & 0xFF;
                    int n19 = n13 >> 8 & 0xFF;
                    int n20 = n14 >> 8 & 0xFF;
                    int n21 = n13 & 0xFF;
                    int n22 = n14 & 0xFF;
                    nArray3[n9++] = n17 + n18 - (n17 * n18 * 65793 + 0x800000 >>> 24) << 16 | n19 + n20 - (n19 * n20 * 65793 + 0x800000 >>> 24) << 8 | n21 + n22 - (n21 * n22 * 65793 + 0x800000 >>> 24) | n15 + n16 - (n15 * n16 * 65793 + 0x800000 >>> 24) << 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class ScreenCompositeContext
    extends AlphaPreCompositeContext {
        ScreenCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = nArray[i3];
                    int n10 = nArray2[i3];
                    nArray2[i3] = n9 + n10 - (n10 * n9 * 65793 + 0x800000 >>> 24);
                    n9 = nArray[++i3];
                    n10 = nArray2[i3];
                    nArray2[i3] = n9 + n10 - (n10 * n9 * 65793 + 0x800000 >>> 24);
                    n9 = nArray[++i3];
                    n10 = nArray2[i3];
                    nArray2[i3] = n9 + n10 - (n10 * n9 * 65793 + 0x800000 >>> 24);
                    n9 = nArray[++i3];
                    n10 = nArray2[i3];
                    nArray2[i3] = n9 + n10 - (n10 * n9 * 65793 + 0x800000 >>> 24);
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class MultiplyCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        MultiplyCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = n13 >>> 24;
                    int n16 = n14 >>> 24;
                    int n17 = n13 >> 16 & 0xFF;
                    int n18 = n14 >> 16 & 0xFF;
                    int n19 = n13 >> 8 & 0xFF;
                    int n20 = n14 >> 8 & 0xFF;
                    int n21 = n13 & 0xFF;
                    int n22 = n14 & 0xFF;
                    int n23 = 255 - n16;
                    int n24 = 255 - n15;
                    nArray3[n9++] = ((n17 * n23 + n18 * n24 + n17 * n18) * 65793 + 0x800000 & 0xFF000000) >>> 8 | ((n19 * n23 + n20 * n24 + n19 * n20) * 65793 + 0x800000 & 0xFF000000) >>> 16 | (n21 * n23 + n22 * n24 + n21 * n22) * 65793 + 0x800000 >>> 24 | n15 + n16 - (n15 * n16 * 65793 + 0x800000 >>> 24) << 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class MultiplyCompositeContext
    extends AlphaPreCompositeContext {
        MultiplyCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = 255 - nArray2[i3 + 3];
                    int n10 = 255 - nArray[i3 + 3];
                    nArray2[i3] = (nArray[i3] * n9 + nArray2[i3] * n10 + nArray[i3] * nArray2[i3]) * 65793 + 0x800000 >>> 24;
                    nArray2[++i3] = (nArray[i3] * n9 + nArray2[i3] * n10 + nArray[i3] * nArray2[i3]) * 65793 + 0x800000 >>> 24;
                    nArray2[++i3] = (nArray[i3] * n9 + nArray2[i3] * n10 + nArray[i3] * nArray2[i3]) * 65793 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] + nArray2[i3] - (nArray2[i3] * nArray[i3] * 65793 + 0x800000 >>> 24);
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class ArithCompositeContext_INT_PACK_LUT
    extends AlphaPreCompositeContext_INT_PACK {
        byte[] lut;

        ArithCompositeContext_INT_PACK_LUT(ColorModel colorModel, ColorModel colorModel2, float f2, float f3, float f4, float f5) {
            super(colorModel, colorModel2);
            f2 /= 255.0f;
            f5 = f5 * 255.0f + 0.5f;
            int n2 = 65536;
            this.lut = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = (int)((float)((i2 >> 8) * (i2 & 0xFF)) * f2 + (float)(i2 >> 8) * f3 + (float)(i2 & 0xFF) * f4 + f5);
                if ((n3 & 0xFFFFFF00) != 0) {
                    n3 = (n3 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                this.lut[i2] = (byte)n3;
            }
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            byte[] byArray = this.lut;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n10 = n9 + n2;
                while (n9 < n10) {
                    int n11 = nArray[n5++];
                    int n12 = nArray2[n7++];
                    int n13 = 0xFF & byArray[n11 >> 16 & 0xFF00 | n12 >>> 24];
                    int n14 = 0xFF & byArray[n11 >> 8 & 0xFF00 | n12 >> 16 & 0xFF];
                    int n15 = 0xFF & byArray[n11 & 0xFF00 | n12 >> 8 & 0xFF];
                    int n16 = 0xFF & byArray[n11 << 8 & 0xFF00 | n12 & 0xFF];
                    if (n14 > n13) {
                        n13 = n14;
                    }
                    if (n15 > n13) {
                        n13 = n15;
                    }
                    if (n16 > n13) {
                        n13 = n16;
                    }
                    nArray3[n9++] = n13 << 24 | n14 << 16 | n15 << 8 | n16;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class ArithCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        float k1;
        float k2;
        float k3;
        float k4;

        ArithCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2, float f2, float f3, float f4, float f5) {
            super(colorModel, colorModel2);
            this.k1 = f2 / 255.0f;
            this.k2 = f3;
            this.k3 = f4;
            this.k4 = f5 * 255.0f + 0.5f;
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n10 = n9 + n2;
                while (n9 < n10) {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    if (((n16 = (int)((float)(((n15 = nArray[n5++]) >>> 24) * ((n14 = nArray2[n7++]) >>> 24)) * this.k1 + (float)(n15 >>> 24) * this.k2 + (float)(n14 >>> 24) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n16 = (n16 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (((n13 = (int)((float)((n15 >> 16 & 0xFF) * (n14 >> 16 & 0xFF)) * this.k1 + (float)(n15 >> 16 & 0xFF) * this.k2 + (float)(n14 >> 16 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n13 = (n13 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n13) {
                        n16 = n13;
                    }
                    if (((n12 = (int)((float)((n15 >> 8 & 0xFF) * (n14 >> 8 & 0xFF)) * this.k1 + (float)(n15 >> 8 & 0xFF) * this.k2 + (float)(n14 >> 8 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n12 = (n12 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n12) {
                        n16 = n12;
                    }
                    if (((n11 = (int)((float)((n15 & 0xFF) * (n14 & 0xFF)) * this.k1 + (float)(n15 & 0xFF) * this.k2 + (float)(n14 & 0xFF) * this.k3 + this.k4)) & 0xFFFFFF00) != 0) {
                        n11 = (n11 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    if (n16 < n11) {
                        n16 = n11;
                    }
                    nArray3[n9++] = n16 << 24 | n13 << 16 | n12 << 8 | n11;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class ArithCompositeContext
    extends AlphaPreCompositeContext {
        float k1;
        float k2;
        float k3;
        float k4;

        ArithCompositeContext(ColorModel colorModel, ColorModel colorModel2, float f2, float f3, float f4, float f5) {
            super(colorModel, colorModel2);
            this.k1 = f2;
            this.k2 = f3;
            this.k3 = f4;
            this.k4 = f5;
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getNumBands();
            int n5 = writableRaster.getMinY();
            int n6 = n5 + writableRaster.getHeight();
            float f2 = this.k1 / 255.0f;
            float f3 = this.k4 * 255.0f + 0.5f;
            for (int i2 = n5; i2 < n6; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    int n7;
                    int n8 = 0;
                    int n9 = 1;
                    while (n9 < n4) {
                        n7 = (int)(f2 * (float)nArray[i3] * (float)nArray2[i3] + this.k2 * (float)nArray[i3] + this.k3 * (float)nArray2[i3] + f3);
                        if ((n7 & 0xFFFFFF00) != 0) {
                            n7 = (n7 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                        }
                        if (n7 > n8) {
                            n8 = n7;
                        }
                        nArray2[i3] = n7;
                        ++n9;
                        ++i3;
                    }
                    n7 = (int)(f2 * (float)nArray[i3] * (float)nArray2[i3] + this.k2 * (float)nArray[i3] + this.k3 * (float)nArray2[i3] + f3);
                    if ((n7 & 0xFFFFFF00) != 0) {
                        n7 = (n7 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                    }
                    nArray2[i3] = n7 > n8 ? n7 : n8;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class XorCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        XorCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = (255 - (n14 >>> 24)) * 65793;
                    int n16 = (255 - (n13 >>> 24)) * 65793;
                    nArray3[n9++] = (n13 >>> 24) * n15 + (n14 >>> 24) * n16 + 0x800000 & 0xFF000000 | ((n13 >> 16 & 0xFF) * n15 + (n14 >> 16 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 8 | ((n13 >> 8 & 0xFF) * n15 + (n14 >> 8 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 16 | (n13 & 0xFF) * n15 + (n14 & 0xFF) * n16 + 0x800000 >>> 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class XorCompositeContext
    extends AlphaPreCompositeContext {
        XorCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = (255 - nArray2[i3 + 3]) * 65793;
                    int n10 = (255 - nArray[i3 + 3]) * 65793;
                    nArray2[i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class AtopCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        AtopCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = (n14 >>> 24) * 65793;
                    int n16 = (255 - (n13 >>> 24)) * 65793;
                    nArray3[n9++] = n14 & 0xFF000000 | ((n13 >> 16 & 0xFF) * n15 + (n14 >> 16 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 8 | ((n13 >> 8 & 0xFF) * n15 + (n14 >> 8 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 16 | (n13 & 0xFF) * n15 + (n14 & 0xFF) * n16 + 0x800000 >>> 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class AtopCompositeContext
    extends AlphaPreCompositeContext {
        AtopCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; i3 += 2) {
                    int n9 = nArray2[i3 + 3] * 65793;
                    int n10 = (255 - nArray[i3 + 3]) * 65793;
                    nArray2[i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + nArray2[i3] * n10 + 0x800000 >>> 24;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class OutCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        OutCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = (255 - (nArray2[n7++] >>> 24)) * 65793;
                    int n14 = nArray[n5++];
                    nArray3[n9++] = (n14 >>> 24) * n13 + 0x800000 & 0xFF000000 | ((n14 >> 16 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 8 | ((n14 >> 8 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 16 | (n14 & 0xFF) * n13 + 0x800000 >>> 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class OutCompositeContext
    extends AlphaPreCompositeContext {
        OutCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = (255 - nArray2[i3 + 3]) * 65793;
                    nArray2[i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class InCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        InCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = (nArray2[n7++] >>> 24) * 65793;
                    int n14 = nArray[n5++];
                    nArray3[n9++] = (n14 >>> 24) * n13 + 0x800000 & 0xFF000000 | ((n14 >> 16 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 8 | ((n14 >> 8 & 0xFF) * n13 + 0x800000 & 0xFF000000) >>> 16 | (n14 & 0xFF) * n13 + 0x800000 >>> 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class InCompositeContext
    extends AlphaPreCompositeContext {
        InCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = nArray2[i3 + 3] * 65793;
                    nArray2[i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                    nArray2[++i3] = nArray[i3] * n9 + 0x800000 >>> 24;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class OverCompositeContext_INT_PACK_UNPRE
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK_UNPRE(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
            if (colorModel.isAlphaPremultiplied()) {
                throw new IllegalArgumentException("OverCompositeContext_INT_PACK_UNPRE is only forsources with unpremultiplied alpha");
            }
        }

        @Override
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            ColorModel colorModel = this.dstCM;
            if (!this.dstCM.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceData((WritableRaster)raster2, this.dstCM, true);
            }
            this.precompose(raster, raster2, writableRaster);
            if (!this.dstCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData(writableRaster, colorModel, false);
                if (raster2 != writableRaster) {
                    GraphicsUtil.coerceData((WritableRaster)raster2, colorModel, false);
                }
            }
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = (n13 >>> 24) * 65793;
                    int n16 = (255 - (n13 >>> 24)) * 65793;
                    nArray3[n9++] = (n13 & 0xFF000000) + (n14 >>> 24) * n16 + 0x800000 & 0xFF000000 | ((n13 >> 16 & 0xFF) * n15 + (n14 >> 16 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 8 | ((n13 >> 8 & 0xFF) * n15 + (n14 >> 8 & 0xFF) * n16 + 0x800000 & 0xFF000000) >>> 16 | (n13 & 0xFF) * n15 + (n14 & 0xFF) * n16 + 0x800000 >>> 24;
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK_NA
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK_NA(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = (255 - (n13 >>> 24)) * 65793;
                    nArray3[n9++] = (n13 & 0xFF0000) + (((n14 >> 16 & 0xFF) * n15 + 0x800000 & 0xFF000000) >>> 8) | (n13 & 0xFF00) + (((n14 >> 8 & 0xFF) * n15 + 0x800000 & 0xFF000000) >>> 16) | (n13 & 0xFF) + ((n14 & 0xFF) * n15 + 0x800000 >>> 24);
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class OverCompositeContext_INT_PACK
    extends AlphaPreCompositeContext_INT_PACK {
        OverCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose_INT_PACK(int n2, int n3, int[] nArray, int n4, int n5, int[] nArray2, int n6, int n7, int[] nArray3, int n8, int n9) {
            int n10 = 65793;
            int n11 = 0x800000;
            for (int i2 = 0; i2 < n3; ++i2) {
                int n12 = n9 + n2;
                while (n9 < n12) {
                    int n13 = nArray[n5++];
                    int n14 = nArray2[n7++];
                    int n15 = (255 - (n13 >>> 24)) * 65793;
                    nArray3[n9++] = (n13 & 0xFF000000) + ((n14 >>> 24) * n15 + 0x800000 & 0xFF000000) | (n13 & 0xFF0000) + (((n14 >> 16 & 0xFF) * n15 + 0x800000 & 0xFF000000) >>> 8) | (n13 & 0xFF00) + (((n14 >> 8 & 0xFF) * n15 + 0x800000 & 0xFF000000) >>> 16) | (n13 & 0xFF) + ((n14 & 0xFF) * n15 + 0x800000 >>> 24);
                }
                n5 += n4;
                n7 += n6;
                n9 += n8;
            }
        }
    }

    public static class OverCompositeContext_NA
    extends AlphaPreCompositeContext {
        OverCompositeContext_NA(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = 0;
                int n9 = 0;
                int n10 = n3 * 4;
                while (n8 < n10) {
                    int n11 = (255 - nArray[n8 + 3]) * 65793;
                    nArray2[n9] = nArray[n8] + (nArray2[n9] * n11 + 0x800000 >>> 24);
                    nArray2[++n9] = nArray[++n8] + (nArray2[n9] * n11 + 0x800000 >>> 24);
                    nArray2[++n9] = nArray[++n8] + (nArray2[n9] * n11 + 0x800000 >>> 24);
                    n8 += 2;
                    ++n9;
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static class OverCompositeContext
    extends AlphaPreCompositeContext {
        OverCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        @Override
        public void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int[] nArray = null;
            int[] nArray2 = null;
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = n4 + writableRaster.getHeight();
            int n6 = 65793;
            int n7 = 0x800000;
            for (int i2 = n4; i2 < n5; ++i2) {
                nArray = raster.getPixels(n2, i2, n3, 1, nArray);
                nArray2 = raster2.getPixels(n2, i2, n3, 1, nArray2);
                int n8 = n3 * 4;
                for (int i3 = 0; i3 < n8; ++i3) {
                    int n9 = (255 - nArray[i3 + 3]) * 65793;
                    nArray2[i3] = nArray[i3] + (nArray2[i3] * n9 + 0x800000 >>> 24);
                    nArray2[++i3] = nArray[i3] + (nArray2[i3] * n9 + 0x800000 >>> 24);
                    nArray2[++i3] = nArray[i3] + (nArray2[i3] * n9 + 0x800000 >>> 24);
                    nArray2[++i3] = nArray[i3] + (nArray2[i3] * n9 + 0x800000 >>> 24);
                }
                writableRaster.setPixels(n2, i2, n3, 1, nArray2);
            }
        }
    }

    public static abstract class AlphaPreCompositeContext_INT_PACK
    extends AlphaPreCompositeContext {
        AlphaPreCompositeContext_INT_PACK(ColorModel colorModel, ColorModel colorModel2) {
            super(colorModel, colorModel2);
        }

        protected abstract void precompose_INT_PACK(int var1, int var2, int[] var3, int var4, int var5, int[] var6, int var7, int var8, int[] var9, int var10, int var11);

        @Override
        protected void precompose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            int n2 = writableRaster.getMinX();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getMinY();
            int n5 = writableRaster.getHeight();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
            int n6 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n7 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n4 - raster.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)raster2.getSampleModel();
            int n8 = singlePixelPackedSampleModel2.getScanlineStride();
            DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
            int[] nArray2 = dataBufferInt2.getBankData()[0];
            int n9 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n2 - raster2.getSampleModelTranslateX(), n4 - raster2.getSampleModelTranslateY());
            SinglePixelPackedSampleModel singlePixelPackedSampleModel3 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int n10 = singlePixelPackedSampleModel3.getScanlineStride();
            DataBufferInt dataBufferInt3 = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray3 = dataBufferInt3.getBankData()[0];
            int n11 = dataBufferInt3.getOffset() + singlePixelPackedSampleModel3.getOffset(n2 - writableRaster.getSampleModelTranslateX(), n4 - writableRaster.getSampleModelTranslateY());
            int n12 = n6 - n3;
            int n13 = n8 - n3;
            int n14 = n10 - n3;
            this.precompose_INT_PACK(n3, n5, nArray, n12, n7, nArray2, n13, n9, nArray3, n14, n11);
        }
    }

    public static abstract class AlphaPreCompositeContext
    implements CompositeContext {
        ColorModel srcCM;
        ColorModel dstCM;

        AlphaPreCompositeContext(ColorModel colorModel, ColorModel colorModel2) {
            this.srcCM = colorModel;
            this.dstCM = colorModel2;
        }

        @Override
        public void dispose() {
            this.srcCM = null;
            this.dstCM = null;
        }

        protected abstract void precompose(Raster var1, Raster var2, WritableRaster var3);

        @Override
        public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
            ColorModel colorModel = this.srcCM;
            if (!this.srcCM.isAlphaPremultiplied()) {
                colorModel = GraphicsUtil.coerceData((WritableRaster)raster, this.srcCM, true);
            }
            ColorModel colorModel2 = this.dstCM;
            if (!this.dstCM.isAlphaPremultiplied()) {
                colorModel2 = GraphicsUtil.coerceData((WritableRaster)raster2, this.dstCM, true);
            }
            this.precompose(raster, raster2, writableRaster);
            if (!this.srcCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData((WritableRaster)raster, colorModel, false);
            }
            if (!this.dstCM.isAlphaPremultiplied()) {
                GraphicsUtil.coerceData(writableRaster, colorModel2, false);
                if (raster2 != writableRaster) {
                    GraphicsUtil.coerceData((WritableRaster)raster2, colorModel2, false);
                }
            }
        }
    }
}

