/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polyline2D;

public class Polygon2D
implements Shape,
Serializable,
Cloneable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polygon2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polygon2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IndexOutOfBoundsException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new float[4];
        this.ypoints = new float[4];
        this.xpoints[0] = (float)rectangle2D.getMinX();
        this.ypoints[0] = (float)rectangle2D.getMinY();
        this.xpoints[1] = (float)rectangle2D.getMaxX();
        this.ypoints[1] = (float)rectangle2D.getMinY();
        this.xpoints[2] = (float)rectangle2D.getMaxX();
        this.ypoints[2] = (float)rectangle2D.getMaxY();
        this.xpoints[3] = (float)rectangle2D.getMinX();
        this.ypoints[3] = (float)rectangle2D.getMaxY();
        this.calculatePath();
    }

    public Polygon2D(Polygon polygon) {
        if (polygon == null) {
            throw new IndexOutOfBoundsException("null Polygon");
        }
        this.npoints = polygon.npoints;
        this.xpoints = new float[polygon.npoints];
        this.ypoints = new float[polygon.npoints];
        for (int i2 = 0; i2 < polygon.npoints; ++i2) {
            this.xpoints[i2] = polygon.xpoints[i2];
            this.ypoints[i2] = polygon.ypoints[i2];
        }
        this.calculatePath();
    }

    public Polygon2D(float[] fArray, float[] fArray2, int n2) {
        if (n2 > fArray.length || n2 > fArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
        System.arraycopy(fArray, 0, this.xpoints, 0, n2);
        System.arraycopy(fArray2, 0, this.ypoints, 0, n2);
        this.calculatePath();
    }

    public Polygon2D(int[] nArray, int[] nArray2, int n2) {
        if (n2 > nArray.length || n2 > nArray2.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = n2;
        this.xpoints = new float[n2];
        this.ypoints = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xpoints[i2] = nArray[i2];
            this.ypoints[i2] = nArray2[i2];
        }
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polygon2D polygon2D = new Polygon2D();
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            polygon2D.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        return polygon2D;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i2 = 1; i2 < this.npoints; ++i2) {
            this.path.lineTo(this.xpoints[i2], this.ypoints[i2]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(float f2, float f3) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(f2, f3);
            this.bounds = new Rectangle2D.Float(f2, f3, 0.0f, 0.0f);
        } else {
            this.path.lineTo(f2, f3);
            float f4 = (float)this.bounds.getMaxX();
            float f5 = (float)this.bounds.getMaxY();
            float f6 = (float)this.bounds.getMinX();
            float f7 = (float)this.bounds.getMinY();
            if (f2 < f6) {
                f6 = f2;
            } else if (f2 > f4) {
                f4 = f2;
            }
            if (f3 < f7) {
                f7 = f3;
            } else if (f3 > f5) {
                f5 = f3;
            }
            this.bounds = new Rectangle2D.Float(f6, f7, f4 - f6, f5 - f7);
        }
    }

    public Polyline2D getPolyline2D() {
        Polyline2D polyline2D = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        polyline2D.addPoint(this.xpoints[0], this.ypoints[0]);
        return polyline2D;
    }

    public Polygon getPolygon() {
        int[] nArray = new int[this.npoints];
        int[] nArray2 = new int[this.npoints];
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            nArray[i2] = (int)this.xpoints[i2];
            nArray2[i2] = (int)this.ypoints[i2];
        }
        return new Polygon(nArray, nArray2, this.npoints);
    }

    public void addPoint(Point2D point2D) {
        this.addPoint((float)point2D.getX(), (float)point2D.getY());
    }

    public void addPoint(float f2, float f3) {
        if (this.npoints == this.xpoints.length) {
            float[] fArray = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, fArray, 0, this.npoints);
            this.xpoints = fArray;
            fArray = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, fArray, 0, this.npoints);
            this.ypoints = fArray;
        }
        this.xpoints[this.npoints] = f2;
        this.ypoints[this.npoints] = f3;
        ++this.npoints;
        this.updatePath(f2, f3);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n2, int n3) {
        return this.contains((double)n2, (double)n3);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    @Override
    public boolean contains(double d2, double d3) {
        if (this.npoints <= 2 || !this.bounds.contains(d2, d3)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(d2, d3);
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.bounds.intersects(d2, d3, d4, d5)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(d2, d3, d4, d5);
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d2, double d3, double d4, double d5) {
        if (this.npoints <= 0 || !this.bounds.intersects(d2, d3, d4, d5)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(d2, d3, d4, d5);
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        this.updateComputingPath();
        if (this.closedPath == null) {
            return null;
        }
        return this.closedPath.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }
}

