/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.image.GraphicsUtil;

abstract class MultipleGradientPaintContext
implements PaintContext {
    protected static final boolean DEBUG = false;
    protected ColorModel dataModel;
    protected ColorModel model;
    private static ColorModel lrgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel srgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel lrgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private static ColorModel srgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    protected static ColorModel cachedModel;
    protected static WeakReference cached;
    protected WritableRaster saved;
    protected MultipleGradientPaint.CycleMethodEnum cycleMethod;
    protected MultipleGradientPaint.ColorSpaceEnum colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup = true;
    protected boolean hasDiscontinuity = false;
    protected int fastGradientArraySize;
    protected int[] gradient;
    protected int[][] gradients;
    protected int gradientAverage;
    protected int gradientUnderflow;
    protected int gradientOverflow;
    protected int gradientsLength;
    protected float[] normalizedIntervals;
    protected float[] fractions;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    protected MultipleGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = fArray.length;
        if (fArray[0] != 0.0f) {
            bl2 = true;
            ++n2;
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            bl3 = true;
            ++n2;
        }
        for (int i2 = 0; i2 < fArray.length - 1; ++i2) {
            if (fArray[i2] != fArray[i2 + 1]) continue;
            --n2;
        }
        this.fractions = new float[n2];
        Color[] colorArray2 = new Color[n2 - 1];
        Color[] colorArray3 = new Color[n2 - 1];
        this.normalizedIntervals = new float[n2 - 1];
        this.gradientUnderflow = colorArray[0].getRGB();
        this.gradientOverflow = colorArray[colorArray.length - 1].getRGB();
        int n3 = 0;
        if (bl2) {
            this.fractions[0] = 0.0f;
            colorArray2[0] = colorArray[0];
            colorArray3[0] = colorArray[0];
            this.normalizedIntervals[0] = fArray[0];
            ++n3;
        }
        for (int i3 = 0; i3 < fArray.length - 1; ++i3) {
            if (fArray[i3] == fArray[i3 + 1]) {
                if (colorArray[i3].equals(colorArray[i3 + 1])) continue;
                this.hasDiscontinuity = true;
                continue;
            }
            this.fractions[n3] = fArray[i3];
            colorArray2[n3] = colorArray[i3];
            colorArray3[n3] = colorArray[i3 + 1];
            this.normalizedIntervals[n3] = fArray[i3 + 1] - fArray[i3];
            ++n3;
        }
        this.fractions[n3] = fArray[fArray.length - 1];
        if (bl3) {
            colorArray2[n3] = colorArray3[n3] = colorArray[colorArray.length - 1];
            this.normalizedIntervals[n3] = 1.0f - fArray[fArray.length - 1];
            this.fractions[++n3] = 1.0f;
        }
        AffineTransform affineTransform2 = affineTransform.createInverse();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.a00 = (float)dArray[0];
        this.a10 = (float)dArray[1];
        this.a01 = (float)dArray[2];
        this.a11 = (float)dArray[3];
        this.a02 = (float)dArray[4];
        this.a12 = (float)dArray[5];
        this.cycleMethod = cycleMethodEnum;
        this.colorSpace = colorSpaceEnum;
        if (colorModel.getColorSpace() == lrgbmodel_A.getColorSpace()) {
            this.dataModel = lrgbmodel_A;
        } else if (colorModel.getColorSpace() == srgbmodel_A.getColorSpace()) {
            this.dataModel = srgbmodel_A;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for interpolation");
        }
        this.calculateGradientFractions(colorArray2, colorArray3);
        this.model = GraphicsUtil.coerceColorModel(this.dataModel, colorModel.isAlphaPremultiplied());
    }

    protected final void calculateGradientFractions(Color[] colorArray, Color[] colorArray2) {
        int n2;
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            int[] nArray = SRGBtoLinearRGB;
            for (int i2 = 0; i2 < colorArray.length; ++i2) {
                colorArray[i2] = MultipleGradientPaintContext.interpolateColor(nArray, colorArray[i2]);
                colorArray2[i2] = MultipleGradientPaintContext.interpolateColor(nArray, colorArray2[i2]);
            }
        }
        this.transparencyTest = -16777216;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            this.transparencyTest &= this.gradientUnderflow;
            this.transparencyTest &= this.gradientOverflow;
        }
        this.gradients = new int[this.fractions.length - 1][];
        this.gradientsLength = this.gradients.length;
        int n3 = this.normalizedIntervals.length;
        float f2 = 1.0f;
        float[] fArray = this.normalizedIntervals;
        for (n2 = 0; n2 < n3; ++n2) {
            f2 = f2 > fArray[n2] ? fArray[n2] : f2;
        }
        n2 = 0;
        if (f2 == 0.0f) {
            n2 = Integer.MAX_VALUE;
            this.hasDiscontinuity = true;
        } else {
            for (float f3 : fArray) {
                n2 = (int)((float)n2 + f3 / f2 * 256.0f);
            }
        }
        if (n2 > 5000) {
            this.calculateMultipleArrayGradient(colorArray, colorArray2);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradients[0][0] != this.gradients[this.gradients.length - 1][255]) {
                this.hasDiscontinuity = true;
            }
        } else {
            this.calculateSingleArrayGradient(colorArray, colorArray2, f2);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradient[0] != this.gradient[this.fastGradientArraySize]) {
                this.hasDiscontinuity = true;
            }
        }
        if (this.transparencyTest >>> 24 == 255) {
            if (this.dataModel.getColorSpace() == lrgbmodel_NA.getColorSpace()) {
                this.dataModel = lrgbmodel_NA;
            } else if (this.dataModel.getColorSpace() == srgbmodel_NA.getColorSpace()) {
                this.dataModel = srgbmodel_NA;
            }
            this.model = this.dataModel;
        }
    }

    private static Color interpolateColor(int[] nArray, Color color) {
        int n2 = color.getRGB();
        int n3 = (nArray[n2 >> 24 & 0xFF] & 0xFF) << 24 | (nArray[n2 >> 16 & 0xFF] & 0xFF) << 16 | (nArray[n2 >> 8 & 0xFF] & 0xFF) << 8 | nArray[n2 & 0xFF] & 0xFF;
        return new Color(n3, true);
    }

    private void calculateSingleArrayGradient(Color[] colorArray, Color[] colorArray2, float f2) {
        int n2;
        this.isSimpleLookup = true;
        int n3 = 1;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 32768;
        int n7 = 32768;
        for (n2 = 0; n2 < this.gradients.length; ++n2) {
            int n8 = (int)(this.normalizedIntervals[n2] / f2 * 255.0f);
            n3 += n8;
            this.gradients[n2] = new int[n8];
            int n9 = colorArray[n2].getRGB();
            int n10 = colorArray2[n2].getRGB();
            this.interpolate(n9, n10, this.gradients[n2]);
            int n11 = this.gradients[n2][128];
            float f3 = this.normalizedIntervals[n2];
            n4 += (int)((float)(n11 >> 8 & 0xFF0000) * f3);
            n5 += (int)((float)(n11 & 0xFF0000) * f3);
            n6 += (int)((float)(n11 << 8 & 0xFF0000) * f3);
            n7 += (int)((float)(n11 << 16 & 0xFF0000) * f3);
            this.transparencyTest &= n9 & n10;
        }
        this.gradientAverage = (n4 & 0xFF0000) << 8 | n5 & 0xFF0000 | (n6 & 0xFF0000) >> 8 | (n7 & 0xFF0000) >> 16;
        this.gradient = new int[n3];
        n2 = 0;
        for (int[] nArray : this.gradients) {
            System.arraycopy(nArray, 0, this.gradient, n2, nArray.length);
            n2 += nArray.length;
        }
        this.gradient[this.gradient.length - 1] = colorArray2[colorArray2.length - 1].getRGB();
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (int i2 = 0; i2 < this.gradient.length; ++i2) {
                    this.gradient[i2] = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradient[i2]);
                }
                this.gradientAverage = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (int i3 = 0; i3 < this.gradient.length; ++i3) {
                this.gradient[i3] = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradient[i3]);
            }
            this.gradientAverage = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colorArray, Color[] colorArray2) {
        int n2;
        int n3;
        this.isSimpleLookup = false;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 32768;
        int n7 = 32768;
        for (n3 = 0; n3 < this.gradients.length; ++n3) {
            if (this.normalizedIntervals[n3] == 0.0f) continue;
            this.gradients[n3] = new int[256];
            int n8 = colorArray[n3].getRGB();
            int n9 = colorArray2[n3].getRGB();
            this.interpolate(n8, n9, this.gradients[n3]);
            n2 = this.gradients[n3][128];
            float f2 = this.normalizedIntervals[n3];
            n4 += (int)((float)(n2 >> 8 & 0xFF0000) * f2);
            n5 += (int)((float)(n2 & 0xFF0000) * f2);
            n6 += (int)((float)(n2 << 8 & 0xFF0000) * f2);
            n7 += (int)((float)(n2 << 16 & 0xFF0000) * f2);
            this.transparencyTest &= n8;
            this.transparencyTest &= n9;
        }
        this.gradientAverage = (n4 & 0xFF0000) << 8 | n5 & 0xFF0000 | (n6 & 0xFF0000) >> 8 | (n7 & 0xFF0000) >> 16;
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (n3 = 0; n3 < this.gradients.length; ++n3) {
                    for (n2 = 0; n2 < this.gradients[n3].length; ++n2) {
                        this.gradients[n3][n2] = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradients[n3][n2]);
                    }
                }
                this.gradientAverage = MultipleGradientPaintContext.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (n3 = 0; n3 < this.gradients.length; ++n3) {
                for (n2 = 0; n2 < this.gradients[n3].length; ++n2) {
                    this.gradients[n3][n2] = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradients[n3][n2]);
                }
            }
            this.gradientAverage = MultipleGradientPaintContext.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
    }

    private void interpolate(int n2, int n3, int[] nArray) {
        int n4 = nArray.length;
        float f2 = 1.0f / (float)n4;
        int n5 = n2 >> 24 & 0xFF;
        int n6 = n2 >> 16 & 0xFF;
        int n7 = n2 >> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        int n9 = (n3 >> 24 & 0xFF) - n5;
        int n10 = (n3 >> 16 & 0xFF) - n6;
        int n11 = (n3 >> 8 & 0xFF) - n7;
        int n12 = (n3 & 0xFF) - n8;
        float f3 = 2.0f * (float)n9 * f2;
        float f4 = 2.0f * (float)n10 * f2;
        float f5 = 2.0f * (float)n11 * f2;
        float f6 = 2.0f * (float)n12 * f2;
        nArray[0] = n2;
        nArray[--n4] = n3;
        for (int i2 = 1; i2 < n4; ++i2) {
            float f7 = i2;
            nArray[i2] = (n5 + ((int)(f7 * f3) + 1 >> 1) & 0xFF) << 24 | (n6 + ((int)(f7 * f4) + 1 >> 1) & 0xFF) << 16 | (n7 + ((int)(f7 * f5) + 1 >> 1) & 0xFF) << 8 | n8 + ((int)(f7 * f6) + 1 >> 1) & 0xFF;
        }
    }

    private static int convertEntireColorLinearRGBtoSRGB(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int[] nArray = LinearRGBtoSRGB;
        n4 = nArray[n4];
        n5 = nArray[n5];
        n6 = nArray[n6];
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    private static int convertEntireColorSRGBtoLinearRGB(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int[] nArray = SRGBtoLinearRGB;
        n4 = nArray[n4];
        n5 = nArray[n5];
        n6 = nArray[n6];
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    protected final int indexIntoGradientsArrays(float f2) {
        int n2;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            if (f2 >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f2 <= 0.0f) {
                return this.gradientUnderflow;
            }
        } else {
            if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
                if ((f2 -= (float)((int)f2)) < 0.0f) {
                    f2 += 1.0f;
                }
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.isSimpleLookup) {
                    int n6 = (int)(f2 *= (float)this.gradient.length);
                    if (n6 + 1 < this.gradient.length) {
                        return this.gradient[n6];
                    }
                    n3 = (int)((f2 - (float)n6) * 65536.0f);
                    n4 = this.gradient[n6];
                    n5 = this.gradient[0];
                } else {
                    for (int i2 = 0; i2 < this.gradientsLength; ++i2) {
                        if (!(f2 < this.fractions[i2 + 1])) continue;
                        float f3 = f2 - this.fractions[i2];
                        int n7 = (int)(f3 = f3 / this.normalizedIntervals[i2] * 256.0f);
                        if (n7 + 1 < this.gradients[i2].length || i2 + 1 < this.gradientsLength) {
                            return this.gradients[i2][n7];
                        }
                        n3 = (int)((f3 - (float)n7) * 65536.0f);
                        n4 = this.gradients[i2][n7];
                        n5 = this.gradients[0][0];
                        break;
                    }
                }
                return ((n4 >> 8 & 0xFF0000) + ((n5 >>> 24) - (n4 >>> 24)) * n3 & 0xFF0000) << 8 | (n4 & 0xFF0000) + ((n5 >> 16 & 0xFF) - (n4 >> 16 & 0xFF)) * n3 & 0xFF0000 | ((n4 << 8 & 0xFF0000) + ((n5 >> 8 & 0xFF) - (n4 >> 8 & 0xFF)) * n3 & 0xFF0000) >> 8 | ((n4 << 16 & 0xFF0000) + ((n5 & 0xFF) - (n4 & 0xFF)) * n3 & 0xFF0000) >> 16;
            }
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            n2 = (int)f2;
            f2 -= (float)n2;
            if ((n2 & 1) == 1) {
                f2 = 1.0f - f2;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(f2 * (float)this.fastGradientArraySize)];
        }
        for (n2 = 0; n2 < this.gradientsLength; ++n2) {
            if (!(f2 < this.fractions[n2 + 1])) continue;
            float f4 = f2 - this.fractions[n2];
            int n8 = (int)(f4 / this.normalizedIntervals[n2] * 255.0f);
            return this.gradients[n2][n8];
        }
        return this.gradientOverflow;
    }

    protected final int indexGradientAntiAlias(float f2, float f3) {
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            int n2;
            int n3;
            float f4;
            float f5 = f2 - f3 / 2.0f;
            float f6 = f2 + f3 / 2.0f;
            if (f5 >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f6 <= 0.0f) {
                return this.gradientUnderflow;
            }
            float f7 = 0.0f;
            float f8 = 0.0f;
            if (f6 >= 1.0f) {
                f7 = (f6 - 1.0f) / f3;
                if (f5 <= 0.0f) {
                    f8 = -f5 / f3;
                    f4 = 1.0f;
                    n3 = this.gradientAverage;
                } else {
                    f4 = 1.0f - f5;
                    n3 = this.getAntiAlias(f5, true, 1.0f, false, 1.0f - f5, 1.0f);
                }
            } else if (f5 <= 0.0f) {
                f8 = -f5 / f3;
                f4 = f6;
                n3 = this.getAntiAlias(0.0f, true, f6, false, f6, 1.0f);
            } else {
                return this.getAntiAlias(f5, true, f6, false, f3, 1.0f);
            }
            int n4 = (int)(65536.0f * f4 / f3);
            int n5 = (n3 >>> 20 & 0xFF0) * n4 >> 16;
            int n6 = (n3 >> 12 & 0xFF0) * n4 >> 16;
            int n7 = (n3 >> 4 & 0xFF0) * n4 >> 16;
            int n8 = (n3 << 4 & 0xFF0) * n4 >> 16;
            if (f8 != 0.0f) {
                n2 = this.gradientUnderflow;
                n4 = (int)(65536.0f * f8);
                n5 += (n2 >>> 20 & 0xFF0) * n4 >> 16;
                n6 += (n2 >> 12 & 0xFF0) * n4 >> 16;
                n7 += (n2 >> 4 & 0xFF0) * n4 >> 16;
                n8 += (n2 << 4 & 0xFF0) * n4 >> 16;
            }
            if (f7 != 0.0f) {
                n2 = this.gradientOverflow;
                n4 = (int)(65536.0f * f7);
                n5 += (n2 >>> 20 & 0xFF0) * n4 >> 16;
                n6 += (n2 >> 12 & 0xFF0) * n4 >> 16;
                n7 += (n2 >> 4 & 0xFF0) * n4 >> 16;
                n8 += (n2 << 4 & 0xFF0) * n4 >> 16;
            }
            return (n5 & 0xFF0) << 20 | (n6 & 0xFF0) << 12 | (n7 & 0xFF0) << 4 | (n8 & 0xFF0) >> 4;
        }
        int n9 = (int)f3;
        float f9 = 1.0f;
        if (n9 != 0 && (double)(f9 = (f3 -= (float)n9) / ((float)n9 + f3)) < 0.1) {
            return this.gradientAverage;
        }
        if ((double)f3 > 0.99) {
            return this.gradientAverage;
        }
        float f10 = f2 - f3 / 2.0f;
        float f11 = f2 + f3 / 2.0f;
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            f10 -= (float)((int)f10);
            f11 -= (float)((int)f11);
            if (f10 < 0.0f) {
                f10 += 1.0f;
            }
            if (f11 < 0.0f) {
                f11 += 1.0f;
            }
        } else {
            if (f11 < 0.0f) {
                f10 = -f10;
                bl2 = !bl2;
                f11 = -f11;
                bl3 = !bl3;
            } else if (f10 < 0.0f) {
                f10 = -f10;
                bl2 = !bl2;
            }
            int n10 = (int)f10;
            f10 -= (float)n10;
            int n11 = (int)f11;
            f11 -= (float)n11;
            if ((n10 & 1) == 1) {
                f10 = 1.0f - f10;
                boolean bl4 = bl2 = !bl2;
            }
            if ((n11 & 1) == 1) {
                f11 = 1.0f - f11;
                boolean bl5 = bl3 = !bl3;
            }
            if (f10 > f11 && !bl2 && bl3) {
                float f12 = f10;
                f10 = f11;
                f11 = f12;
                bl2 = true;
                bl3 = false;
            }
        }
        return this.getAntiAlias(f10, bl2, f11, bl3, f3, f9);
    }

    private final int getAntiAlias(float f2, boolean bl2, float f3, boolean bl3, float f4, float f5) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.isSimpleLookup) {
            int n10;
            int n11;
            n5 = (int)(f2 *= (float)this.fastGradientArraySize);
            n4 = (int)(f3 *= (float)this.fastGradientArraySize);
            if (bl2 && !bl3 && n5 <= n4) {
                if (n5 == n4) {
                    return this.gradient[n5];
                }
                for (n3 = n5 + 1; n3 < n4; ++n3) {
                    n2 = this.gradient[n3];
                    n6 += n2 >>> 20 & 0xFF0;
                    n7 += n2 >>> 12 & 0xFF0;
                    n8 += n2 >>> 4 & 0xFF0;
                    n9 += n2 << 4 & 0xFF0;
                }
            } else {
                if (bl2) {
                    n11 = n5 + 1;
                    n10 = this.fastGradientArraySize;
                } else {
                    n11 = 0;
                    n10 = n5;
                }
                for (n3 = n11; n3 < n10; ++n3) {
                    n2 = this.gradient[n3];
                    n6 += n2 >>> 20 & 0xFF0;
                    n7 += n2 >>> 12 & 0xFF0;
                    n8 += n2 >>> 4 & 0xFF0;
                    n9 += n2 << 4 & 0xFF0;
                }
                if (bl3) {
                    n11 = n4 + 1;
                    n10 = this.fastGradientArraySize;
                } else {
                    n11 = 0;
                    n10 = n4;
                }
                for (n3 = n11; n3 < n10; ++n3) {
                    n2 = this.gradient[n3];
                    n6 += n2 >>> 20 & 0xFF0;
                    n7 += n2 >>> 12 & 0xFF0;
                    n8 += n2 >>> 4 & 0xFF0;
                    n9 += n2 << 4 & 0xFF0;
                }
            }
            n10 = (int)(65536.0f / (f4 * (float)this.fastGradientArraySize));
            n6 = n6 * n10 >> 16;
            n7 = n7 * n10 >> 16;
            n8 = n8 * n10 >> 16;
            n9 = n9 * n10 >> 16;
            n11 = bl2 ? (int)((1.0f - (f2 - (float)n5)) * (float)n10) : (int)((f2 - (float)n5) * (float)n10);
            n2 = this.gradient[n5];
            n6 += (n2 >>> 20 & 0xFF0) * n11 >> 16;
            n7 += (n2 >>> 12 & 0xFF0) * n11 >> 16;
            n8 += (n2 >>> 4 & 0xFF0) * n11 >> 16;
            n9 += (n2 << 4 & 0xFF0) * n11 >> 16;
            n11 = bl3 ? (int)((1.0f - (f3 - (float)n4)) * (float)n10) : (int)((f3 - (float)n4) * (float)n10);
            n2 = this.gradient[n4];
            n6 += (n2 >>> 20 & 0xFF0) * n11 >> 16;
            n7 += (n2 >>> 12 & 0xFF0) * n11 >> 16;
            n8 += (n2 >>> 4 & 0xFF0) * n11 >> 16;
            n9 += (n2 << 4 & 0xFF0) * n11 >> 16;
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
            n9 = n9 + 8 >> 4;
        } else {
            int n12;
            n5 = 0;
            n4 = 0;
            n3 = -1;
            n2 = -1;
            float f6 = 0.0f;
            float f7 = 0.0f;
            for (n12 = 0; n12 < this.gradientsLength; ++n12) {
                if (f2 < this.fractions[n12 + 1] && n3 == -1) {
                    n3 = n12;
                    f6 = f2 - this.fractions[n12];
                    f6 = f6 / this.normalizedIntervals[n12] * 255.0f;
                    n5 = (int)f6;
                    if (n2 != -1) break;
                }
                if (!(f3 < this.fractions[n12 + 1]) || n2 != -1) continue;
                n2 = n12;
                f7 = f3 - this.fractions[n12];
                f7 = f7 / this.normalizedIntervals[n12] * 255.0f;
                n4 = (int)f7;
                if (n3 != -1) break;
            }
            if (n3 == -1) {
                n3 = this.gradients.length - 1;
                n5 = 255;
                f6 = 255;
            }
            if (n2 == -1) {
                n2 = this.gradients.length - 1;
                n4 = 255;
                f7 = 255;
            }
            if (n3 == n2 && n5 <= n4 && bl2 && !bl3) {
                return this.gradients[n3][n5 + n4 + 1 >> 1];
            }
            int n13 = (int)(65536.0f / f4);
            if (n3 < n2 && bl2 && !bl3) {
                int n14 = (int)((float)n13 * this.normalizedIntervals[n3] * (255.0f - f6) / 255.0f);
                n12 = this.gradients[n3][n5 + 256 >> 1];
                n6 += (n12 >>> 20 & 0xFF0) * n14 >> 16;
                n7 += (n12 >>> 12 & 0xFF0) * n14 >> 16;
                n8 += (n12 >>> 4 & 0xFF0) * n14 >> 16;
                n9 += (n12 << 4 & 0xFF0) * n14 >> 16;
                for (int i2 = n3 + 1; i2 < n2; ++i2) {
                    n14 = (int)((float)n13 * this.normalizedIntervals[i2]);
                    n12 = this.gradients[i2][128];
                    n6 += (n12 >>> 20 & 0xFF0) * n14 >> 16;
                    n7 += (n12 >>> 12 & 0xFF0) * n14 >> 16;
                    n8 += (n12 >>> 4 & 0xFF0) * n14 >> 16;
                    n9 += (n12 << 4 & 0xFF0) * n14 >> 16;
                }
                n14 = (int)((float)n13 * this.normalizedIntervals[n2] * f7 / 255.0f);
                n12 = this.gradients[n2][n4 + 1 >> 1];
                n6 += (n12 >>> 20 & 0xFF0) * n14 >> 16;
                n7 += (n12 >>> 12 & 0xFF0) * n14 >> 16;
                n8 += (n12 >>> 4 & 0xFF0) * n14 >> 16;
                n9 += (n12 << 4 & 0xFF0) * n14 >> 16;
            } else {
                int n15;
                int n16;
                int n17;
                int n18;
                if (bl2) {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n3] * (255.0f - f6) / 255.0f);
                    n12 = this.gradients[n3][n5 + 256 >> 1];
                } else {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n3] * f6 / 255.0f);
                    n12 = this.gradients[n3][n5 + 1 >> 1];
                }
                n6 += (n12 >>> 20 & 0xFF0) * n18 >> 16;
                n7 += (n12 >>> 12 & 0xFF0) * n18 >> 16;
                n8 += (n12 >>> 4 & 0xFF0) * n18 >> 16;
                n9 += (n12 << 4 & 0xFF0) * n18 >> 16;
                if (bl3) {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n2] * (255.0f - f7) / 255.0f);
                    n12 = this.gradients[n2][n4 + 256 >> 1];
                } else {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n2] * f7 / 255.0f);
                    n12 = this.gradients[n2][n4 + 1 >> 1];
                }
                n6 += (n12 >>> 20 & 0xFF0) * n18 >> 16;
                n7 += (n12 >>> 12 & 0xFF0) * n18 >> 16;
                n8 += (n12 >>> 4 & 0xFF0) * n18 >> 16;
                n9 += (n12 << 4 & 0xFF0) * n18 >> 16;
                if (bl2) {
                    n17 = n3 + 1;
                    n16 = this.gradientsLength;
                } else {
                    n17 = 0;
                    n16 = n3;
                }
                for (n15 = n17; n15 < n16; ++n15) {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n15]);
                    n12 = this.gradients[n15][128];
                    n6 += (n12 >>> 20 & 0xFF0) * n18 >> 16;
                    n7 += (n12 >>> 12 & 0xFF0) * n18 >> 16;
                    n8 += (n12 >>> 4 & 0xFF0) * n18 >> 16;
                    n9 += (n12 << 4 & 0xFF0) * n18 >> 16;
                }
                if (bl3) {
                    n17 = n2 + 1;
                    n16 = this.gradientsLength;
                } else {
                    n17 = 0;
                    n16 = n2;
                }
                for (n15 = n17; n15 < n16; ++n15) {
                    n18 = (int)((float)n13 * this.normalizedIntervals[n15]);
                    n12 = this.gradients[n15][128];
                    n6 += (n12 >>> 20 & 0xFF0) * n18 >> 16;
                    n7 += (n12 >>> 12 & 0xFF0) * n18 >> 16;
                    n8 += (n12 >>> 4 & 0xFF0) * n18 >> 16;
                    n9 += (n12 << 4 & 0xFF0) * n18 >> 16;
                }
            }
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
            n9 = n9 + 8 >> 4;
        }
        if (f5 != 1.0f) {
            n5 = (int)(65536.0f * (1.0f - f5));
            n4 = (this.gradientAverage >>> 24 & 0xFF) * n5;
            n3 = (this.gradientAverage >> 16 & 0xFF) * n5;
            n2 = (this.gradientAverage >> 8 & 0xFF) * n5;
            int n19 = (this.gradientAverage & 0xFF) * n5;
            int n20 = (int)(f5 * 65536.0f);
            n6 = n6 * n20 + n4 >> 16;
            n7 = n7 * n20 + n3 >> 16;
            n8 = n8 * n20 + n2 >> 16;
            n9 = n9 * n20 + n19 >> 16;
        }
        return n6 << 24 | n7 << 16 | n8 << 8 | n9;
    }

    private static int convertSRGBtoLinearRGB(int n2) {
        float f2 = (float)n2 / 255.0f;
        float f3 = f2 <= 0.04045f ? f2 / 12.92f : (float)Math.pow(((double)f2 + 0.055) / 1.055, 2.4);
        int n3 = Math.round(f3 * 255.0f);
        return n3;
    }

    private static int convertLinearRGBtoSRGB(int n2) {
        float f2 = (float)n2 / 255.0f;
        float f3 = f2 <= 0.0031308f ? f2 * 12.92f : 1.055f * (float)Math.pow(f2, 0.4166666666666667) - 0.055f;
        int n3 = Math.round(f3 * 255.0f);
        return n3;
    }

    @Override
    public final Raster getRaster(int n2, int n3, int n4, int n5) {
        if (n4 == 0 || n5 == 0) {
            return null;
        }
        WritableRaster writableRaster = this.saved;
        if (writableRaster == null || writableRaster.getWidth() < n4 || writableRaster.getHeight() < n5) {
            this.saved = writableRaster = MultipleGradientPaintContext.getCachedRaster(this.dataModel, n4, n5);
            writableRaster = writableRaster.createWritableChild(writableRaster.getMinX(), writableRaster.getMinY(), n4, n5, 0, 0, null);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n6 = dataBufferInt.getOffset();
        int n7 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n8 = n7 - n4;
        this.fillRaster(nArray, n6, n8, n2, n3, n4, n5);
        GraphicsUtil.coerceData(writableRaster, this.dataModel, this.model.isAlphaPremultiplied());
        return writableRaster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final synchronized WritableRaster getCachedRaster(ColorModel colorModel, int n2, int n3) {
        WritableRaster writableRaster;
        if (colorModel == cachedModel && cached != null && (writableRaster = (WritableRaster)cached.get()) != null && writableRaster.getWidth() >= n2 && writableRaster.getHeight() >= n3) {
            cached = null;
            return writableRaster;
        }
        if (n2 < 32) {
            n2 = 32;
        }
        if (n3 < 32) {
            n3 = 32;
        }
        return colorModel.createCompatibleWritableRaster(n2, n3);
    }

    protected static final synchronized void putCachedRaster(ColorModel colorModel, WritableRaster writableRaster) {
        WritableRaster writableRaster2;
        if (cached != null && (writableRaster2 = (WritableRaster)cached.get()) != null) {
            int n2 = writableRaster2.getWidth();
            int n3 = writableRaster2.getHeight();
            int n4 = writableRaster.getWidth();
            int n5 = writableRaster.getHeight();
            if (n2 >= n4 && n3 >= n5) {
                return;
            }
            if (n2 * n3 >= n4 * n5) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference<WritableRaster>(writableRaster);
    }

    @Override
    public final void dispose() {
        if (this.saved != null) {
            MultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    @Override
    public final ColorModel getColorModel() {
        return this.model;
    }

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            MultipleGradientPaintContext.SRGBtoLinearRGB[i2] = MultipleGradientPaintContext.convertSRGBtoLinearRGB(i2);
            MultipleGradientPaintContext.LinearRGBtoSRGB[i2] = MultipleGradientPaintContext.convertLinearRGBtoSRGB(i2);
        }
    }
}

