/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.constants.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLSupport
implements XMLConstants {
    private XMLSupport() {
    }

    public static String getXMLLang(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) == null) continue;
            return attr.getNodeValue();
        }
        return "en";
    }

    public static String getXMLSpace(Element element) {
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.getNodeType() != 1 || (attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) == null) continue;
            return attr.getNodeValue();
        }
        return "default";
    }

    public static String defaultXMLSpace(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl2 = false;
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': 
                case '\r': {
                    bl2 = false;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (bl2) continue block4;
                    stringBuffer.append(' ');
                    bl2 = true;
                    continue block4;
                }
                default: {
                    stringBuffer.append(c2);
                    bl2 = false;
                }
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String preserveXMLSpace(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': {
                    stringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

