/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.CleanerThread;
import org.w3c.dom.Element;

public class DocumentDescriptor {
    protected static final int INITIAL_CAPACITY = 101;
    protected Entry[] table = new Entry[101];
    protected int count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfElements() {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationLine(Element element) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            int n2 = element.hashCode() & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = this.table[n3];
            while (entry != null) {
                Object t2;
                if (entry.hash == n2 && (t2 = entry.get()) == element) {
                    return entry.locationLine;
                }
                entry = entry.next;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationColumn(Element element) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            int n2 = element.hashCode() & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = this.table[n3];
            while (entry != null) {
                Object t2;
                if (entry.hash == n2 && (t2 = entry.get()) == element) {
                    return entry.locationColumn;
                }
                entry = entry.next;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(Element element, int n2, int n3) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            Object object;
            int n4 = element.hashCode() & Integer.MAX_VALUE;
            int n5 = n4 % this.table.length;
            Entry entry = this.table[n5];
            while (entry != null) {
                if (entry.hash == n4 && (object = entry.get()) == element) {
                    entry.locationLine = n2;
                }
                entry = entry.next;
            }
            int n6 = this.table.length;
            if (this.count++ >= n6 - (n6 >> 2)) {
                this.rehash();
                n5 = n4 % this.table.length;
            }
            object = new Entry(n4, element, n2, n3, this.table[n5]);
            this.table[n5] = object;
        }
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
            Entry entry = entryArray[i2];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(Entry entry) {
        DocumentDescriptor documentDescriptor = this;
        synchronized (documentDescriptor) {
            int n2 = entry.hash;
            int n3 = n2 % this.table.length;
            Entry entry2 = this.table[n3];
            Entry entry3 = null;
            while (entry2 != entry) {
                entry3 = entry2;
                entry2 = entry2.next;
            }
            if (entry2 == null) {
                return;
            }
            if (entry3 == null) {
                this.table[n3] = entry2.next;
            } else {
                entry3.next = entry2.next;
            }
            --this.count;
        }
    }

    protected class Entry
    extends CleanerThread.WeakReferenceCleared {
        public int hash;
        public int locationLine;
        public int locationColumn;
        public Entry next;

        public Entry(int n2, Element element, int n3, int n4, Entry entry) {
            super(element);
            this.hash = n2;
            this.locationLine = n3;
            this.locationColumn = n4;
            this.next = entry;
        }

        @Override
        public void cleared() {
            DocumentDescriptor.this.removeEntry(this);
        }
    }
}

