/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGMatrix;
import org.apache.batik.dom.svg.AbstractSVGTransform;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMMatrix;
import org.apache.batik.dom.svg.SVGOMTransform;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;

public abstract class AbstractSVGTransformList
extends AbstractSVGList
implements SVGTransformList {
    public static final String SVG_TRANSFORMATION_LIST_SEPARATOR = "";

    @Override
    protected String getItemSeparator() {
        return SVG_TRANSFORMATION_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    @Override
    public SVGTransform initialize(SVGTransform sVGTransform) {
        return (SVGTransform)((Object)this.initializeImpl(sVGTransform));
    }

    @Override
    public SVGTransform getItem(int n2) {
        return (SVGTransform)((Object)this.getItemImpl(n2));
    }

    @Override
    public SVGTransform insertItemBefore(SVGTransform sVGTransform, int n2) {
        return (SVGTransform)((Object)this.insertItemBeforeImpl(sVGTransform, n2));
    }

    @Override
    public SVGTransform replaceItem(SVGTransform sVGTransform, int n2) {
        return (SVGTransform)((Object)this.replaceItemImpl(sVGTransform, n2));
    }

    @Override
    public SVGTransform removeItem(int n2) {
        return (SVGTransform)((Object)this.removeItemImpl(n2));
    }

    @Override
    public SVGTransform appendItem(SVGTransform sVGTransform) {
        return (SVGTransform)((Object)this.appendItemImpl(sVGTransform));
    }

    @Override
    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setMatrix(sVGMatrix);
        return sVGOMTransform;
    }

    @Override
    public SVGTransform consolidate() {
        this.revalidate();
        int n2 = this.itemList.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return this.getItem(0);
        }
        SVGTransformItem sVGTransformItem = (SVGTransformItem)this.getItemImpl(0);
        AffineTransform affineTransform = (AffineTransform)sVGTransformItem.affineTransform.clone();
        for (int i2 = 1; i2 < n2; ++i2) {
            sVGTransformItem = (SVGTransformItem)this.getItemImpl(i2);
            affineTransform.concatenate(sVGTransformItem.affineTransform);
        }
        SVGOMMatrix sVGOMMatrix = new SVGOMMatrix(affineTransform);
        return this.initialize(this.createSVGTransformFromMatrix(sVGOMMatrix));
    }

    public AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        for (int i2 = 0; i2 < this.getNumberOfItems(); ++i2) {
            SVGTransformItem sVGTransformItem = (SVGTransformItem)this.getItem(i2);
            affineTransform.concatenate(sVGTransformItem.affineTransform);
        }
        return affineTransform;
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        return new SVGTransformItem((SVGTransform)object);
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) {
        TransformListParser transformListParser = new TransformListParser();
        TransformListBuilder transformListBuilder = new TransformListBuilder(listHandler);
        transformListParser.setTransformListHandler(transformListBuilder);
        transformListParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) {
        if (!(object instanceof SVGTransform)) {
            this.createSVGException((short)0, "expected.transform", null);
        }
    }

    protected static class TransformListBuilder
    implements TransformListHandler {
        protected ListHandler listHandler;

        public TransformListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startTransformList() {
            this.listHandler.startList();
        }

        @Override
        public void matrix(float f2, float f3, float f4, float f5, float f6, float f7) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.matrix(f2, f3, f4, f5, f6, f7);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void rotate(float f2) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.rotate(f2);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void rotate(float f2, float f3, float f4) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setRotate(f2, f3, f4);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void translate(float f2) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.translate(f2);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void translate(float f2, float f3) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setTranslate(f2, f3);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void scale(float f2) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.scale(f2);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void scale(float f2, float f3) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setScale(f2, f3);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void skewX(float f2) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setSkewX(f2);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void skewY(float f2) {
            SVGTransformItem sVGTransformItem = new SVGTransformItem();
            sVGTransformItem.setSkewY(f2);
            this.listHandler.item(sVGTransformItem);
        }

        @Override
        public void endTransformList() {
            this.listHandler.endList();
        }
    }

    public static class SVGTransformItem
    extends AbstractSVGTransform
    implements SVGItem {
        protected boolean xOnly;
        protected boolean angleOnly;
        protected AbstractSVGList parent;
        protected String itemStringValue;

        public SVGTransformItem() {
        }

        public SVGTransformItem(SVGTransform sVGTransform) {
            this.assign(sVGTransform);
        }

        protected void resetAttribute() {
            if (this.parent != null) {
                this.itemStringValue = null;
                this.parent.itemChanged();
            }
        }

        @Override
        public void setParent(AbstractSVGList abstractSVGList) {
            this.parent = abstractSVGList;
        }

        @Override
        public AbstractSVGList getParent() {
            return this.parent;
        }

        @Override
        public String getValueAsString() {
            if (this.itemStringValue == null) {
                this.itemStringValue = this.getStringValue();
            }
            return this.itemStringValue;
        }

        public void assign(SVGTransform sVGTransform) {
            this.type = sVGTransform.getType();
            SVGMatrix sVGMatrix = sVGTransform.getMatrix();
            switch (this.type) {
                case 2: {
                    this.setTranslate(sVGMatrix.getE(), sVGMatrix.getF());
                    break;
                }
                case 3: {
                    this.setScale(sVGMatrix.getA(), sVGMatrix.getD());
                    break;
                }
                case 4: {
                    if (sVGMatrix.getE() == 0.0f) {
                        this.rotate(sVGTransform.getAngle());
                        break;
                    }
                    this.angleOnly = false;
                    if (sVGMatrix.getA() == 1.0f) {
                        this.setRotate(sVGTransform.getAngle(), sVGMatrix.getE(), sVGMatrix.getF());
                        break;
                    }
                    if (!(sVGTransform instanceof AbstractSVGTransform)) break;
                    AbstractSVGTransform abstractSVGTransform = (AbstractSVGTransform)sVGTransform;
                    this.setRotate(abstractSVGTransform.getAngle(), abstractSVGTransform.getX(), abstractSVGTransform.getY());
                    break;
                }
                case 5: {
                    this.setSkewX(sVGTransform.getAngle());
                    break;
                }
                case 6: {
                    this.setSkewY(sVGTransform.getAngle());
                    break;
                }
                case 1: {
                    this.setMatrix(sVGMatrix);
                }
            }
        }

        protected void translate(float f2) {
            this.xOnly = true;
            this.setTranslate(f2, 0.0f);
        }

        protected void rotate(float f2) {
            this.angleOnly = true;
            this.setRotate(f2, 0.0f, 0.0f);
        }

        protected void scale(float f2) {
            this.xOnly = true;
            this.setScale(f2, f2);
        }

        protected void matrix(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.setMatrix(new SVGOMMatrix(new AffineTransform(f2, f3, f4, f5, f6, f7)));
        }

        @Override
        public void setMatrix(SVGMatrix sVGMatrix) {
            super.setMatrix(sVGMatrix);
            this.resetAttribute();
        }

        @Override
        public void setTranslate(float f2, float f3) {
            super.setTranslate(f2, f3);
            this.resetAttribute();
        }

        @Override
        public void setScale(float f2, float f3) {
            super.setScale(f2, f3);
            this.resetAttribute();
        }

        @Override
        public void setRotate(float f2, float f3, float f4) {
            super.setRotate(f2, f3, f4);
            this.resetAttribute();
        }

        @Override
        public void setSkewX(float f2) {
            super.setSkewX(f2);
            this.resetAttribute();
        }

        @Override
        public void setSkewY(float f2) {
            super.setSkewY(f2);
            this.resetAttribute();
        }

        @Override
        protected SVGMatrix createMatrix() {
            return new AbstractSVGMatrix(){

                @Override
                protected AffineTransform getAffineTransform() {
                    return SVGTransformItem.this.affineTransform;
                }

                @Override
                public void setA(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setA(f2);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setB(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setB(f2);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setC(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setC(f2);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setD(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setD(f2);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setE(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setE(f2);
                    SVGTransformItem.this.resetAttribute();
                }

                @Override
                public void setF(float f2) {
                    SVGTransformItem.this.type = 1;
                    super.setF(f2);
                    SVGTransformItem.this.resetAttribute();
                }
            };
        }

        protected String getStringValue() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.type) {
                case 2: {
                    stringBuffer.append("translate(");
                    stringBuffer.append((float)this.affineTransform.getTranslateX());
                    if (!this.xOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append((float)this.affineTransform.getTranslateY());
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 4: {
                    stringBuffer.append("rotate(");
                    stringBuffer.append(this.angle);
                    if (!this.angleOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append(this.x);
                        stringBuffer.append(' ');
                        stringBuffer.append(this.y);
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 3: {
                    stringBuffer.append("scale(");
                    stringBuffer.append((float)this.affineTransform.getScaleX());
                    if (!this.xOnly) {
                        stringBuffer.append(' ');
                        stringBuffer.append((float)this.affineTransform.getScaleY());
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 5: {
                    stringBuffer.append("skewX(");
                    stringBuffer.append(this.angle);
                    stringBuffer.append(')');
                    break;
                }
                case 6: {
                    stringBuffer.append("skewY(");
                    stringBuffer.append(this.angle);
                    stringBuffer.append(')');
                    break;
                }
                case 1: {
                    stringBuffer.append("matrix(");
                    double[] dArray = new double[6];
                    this.affineTransform.getMatrix(dArray);
                    for (int i2 = 0; i2 < 6; ++i2) {
                        if (i2 != 0) {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append((float)dArray[i2]);
                    }
                    stringBuffer.append(')');
                }
            }
            return stringBuffer.toString();
        }
    }
}

