/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGPathSegConstants;
import org.apache.batik.dom.svg.SVGPathSegItem;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class AbstractSVGPathSegList
extends AbstractSVGList
implements SVGPathSegConstants,
SVGPathSegList {
    public static final String SVG_PATHSEG_LIST_SEPARATOR = " ";

    protected AbstractSVGPathSegList() {
    }

    @Override
    protected String getItemSeparator() {
        return SVG_PATHSEG_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    @Override
    public SVGPathSeg initialize(SVGPathSeg sVGPathSeg) {
        return (SVGPathSeg)((Object)this.initializeImpl(sVGPathSeg));
    }

    @Override
    public SVGPathSeg getItem(int n2) {
        return (SVGPathSeg)((Object)this.getItemImpl(n2));
    }

    @Override
    public SVGPathSeg insertItemBefore(SVGPathSeg sVGPathSeg, int n2) {
        return (SVGPathSeg)((Object)this.insertItemBeforeImpl(sVGPathSeg, n2));
    }

    @Override
    public SVGPathSeg replaceItem(SVGPathSeg sVGPathSeg, int n2) {
        return (SVGPathSeg)((Object)this.replaceItemImpl(sVGPathSeg, n2));
    }

    @Override
    public SVGPathSeg removeItem(int n2) {
        return (SVGPathSeg)((Object)this.removeItemImpl(n2));
    }

    @Override
    public SVGPathSeg appendItem(SVGPathSeg sVGPathSeg) {
        return (SVGPathSeg)((Object)this.appendItemImpl(sVGPathSeg));
    }

    @Override
    protected SVGItem createSVGItem(Object object) {
        SVGPathSeg sVGPathSeg = (SVGPathSeg)object;
        return this.createPathSegItem(sVGPathSeg);
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) {
        PathParser pathParser = new PathParser();
        PathSegListBuilder pathSegListBuilder = new PathSegListBuilder(listHandler);
        pathParser.setPathHandler(pathSegListBuilder);
        pathParser.parse(string);
    }

    @Override
    protected void checkItemType(Object object) {
        if (!(object instanceof SVGPathSeg)) {
            this.createSVGException((short)0, "expected SVGPathSeg", null);
        }
    }

    protected SVGPathSegItem createPathSegItem(SVGPathSeg sVGPathSeg) {
        SVGPathSegItem sVGPathSegItem = null;
        short s2 = sVGPathSeg.getPathSegType();
        switch (s2) {
            case 10: 
            case 11: {
                sVGPathSegItem = new SVGPathSegArcItem(sVGPathSeg);
                break;
            }
            case 1: {
                sVGPathSegItem = new SVGPathSegItem(sVGPathSeg);
                break;
            }
            case 6: 
            case 7: {
                sVGPathSegItem = new SVGPathSegCurvetoCubicItem(sVGPathSeg);
                break;
            }
            case 16: 
            case 17: {
                sVGPathSegItem = new SVGPathSegCurvetoCubicSmoothItem(sVGPathSeg);
                break;
            }
            case 8: 
            case 9: {
                sVGPathSegItem = new SVGPathSegCurvetoQuadraticItem(sVGPathSeg);
                break;
            }
            case 18: 
            case 19: {
                sVGPathSegItem = new SVGPathSegCurvetoQuadraticSmoothItem(sVGPathSeg);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                sVGPathSegItem = new SVGPathSegMovetoLinetoItem(sVGPathSeg);
                break;
            }
            case 12: 
            case 13: {
                sVGPathSegItem = new SVGPathSegLinetoHorizontalItem(sVGPathSeg);
                break;
            }
            case 14: 
            case 15: {
                sVGPathSegItem = new SVGPathSegLinetoVerticalItem(sVGPathSeg);
                break;
            }
        }
        return sVGPathSegItem;
    }

    protected static class PathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;

        public PathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startPath() {
            this.listHandler.startList();
        }

        @Override
        public void endPath() {
            this.listHandler.endList();
        }

        @Override
        public void movetoRel(float f2, float f3) {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(3, "m", f2, f3));
        }

        @Override
        public void movetoAbs(float f2, float f3) {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(2, "M", f2, f3));
        }

        @Override
        public void closePath() {
            this.listHandler.item(new SVGPathSegItem(1, "z"));
        }

        @Override
        public void linetoRel(float f2, float f3) {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(5, "l", f2, f3));
        }

        @Override
        public void linetoAbs(float f2, float f3) {
            this.listHandler.item(new SVGPathSegMovetoLinetoItem(4, "L", f2, f3));
        }

        @Override
        public void linetoHorizontalRel(float f2) {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(13, "h", f2));
        }

        @Override
        public void linetoHorizontalAbs(float f2) {
            this.listHandler.item(new SVGPathSegLinetoHorizontalItem(12, "H", f2));
        }

        @Override
        public void linetoVerticalRel(float f2) {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(15, "v", f2));
        }

        @Override
        public void linetoVerticalAbs(float f2) {
            this.listHandler.item(new SVGPathSegLinetoVerticalItem(14, "V", f2));
        }

        @Override
        public void curvetoCubicRel(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(7, "c", f2, f3, f4, f5, f6, f7));
        }

        @Override
        public void curvetoCubicAbs(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.listHandler.item(new SVGPathSegCurvetoCubicItem(6, "C", f2, f3, f4, f5, f6, f7));
        }

        @Override
        public void curvetoCubicSmoothRel(float f2, float f3, float f4, float f5) {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(17, "s", f2, f3, f4, f5));
        }

        @Override
        public void curvetoCubicSmoothAbs(float f2, float f3, float f4, float f5) {
            this.listHandler.item(new SVGPathSegCurvetoCubicSmoothItem(16, "S", f2, f3, f4, f5));
        }

        @Override
        public void curvetoQuadraticRel(float f2, float f3, float f4, float f5) {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(9, "q", f2, f3, f4, f5));
        }

        @Override
        public void curvetoQuadraticAbs(float f2, float f3, float f4, float f5) {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticItem(8, "Q", f2, f3, f4, f5));
        }

        @Override
        public void curvetoQuadraticSmoothRel(float f2, float f3) {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(19, "t", f2, f3));
        }

        @Override
        public void curvetoQuadraticSmoothAbs(float f2, float f3) {
            this.listHandler.item(new SVGPathSegCurvetoQuadraticSmoothItem(18, "T", f2, f3));
        }

        @Override
        public void arcRel(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            this.listHandler.item(new SVGPathSegArcItem(11, "a", f2, f3, f4, bl2, bl3, f5, f6));
        }

        @Override
        public void arcAbs(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            this.listHandler.item(new SVGPathSegArcItem(10, "A", f2, f3, f4, bl2, bl3, f5, f6));
        }
    }

    public static class SVGPathSegCurvetoQuadraticSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticSmoothAbs,
    SVGPathSegCurvetoQuadraticSmoothRel {
        public SVGPathSegCurvetoQuadraticSmoothItem(short s2, String string, float f2, float f3) {
            super(s2, string);
            this.setX(f2);
            this.setY(f3);
        }

        public SVGPathSegCurvetoQuadraticSmoothItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 18: {
                    this.letter = "T";
                    this.setX(((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoQuadraticSmoothAbs)sVGPathSeg).getY());
                    break;
                }
                case 19: {
                    this.letter = "t";
                    this.setX(((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoQuadraticSmoothRel)sVGPathSeg).getY());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegCurvetoCubicSmoothItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicSmoothAbs,
    SVGPathSegCurvetoCubicSmoothRel {
        public SVGPathSegCurvetoCubicSmoothItem(short s2, String string, float f2, float f3, float f4, float f5) {
            super(s2, string);
            this.setX(f4);
            this.setY(f5);
            this.setX2(f2);
            this.setY2(f3);
        }

        public SVGPathSegCurvetoCubicSmoothItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 16: {
                    this.letter = "S";
                    this.setX(((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY());
                    this.setX2(((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getX2());
                    this.setY2(((SVGPathSegCurvetoCubicSmoothAbs)sVGPathSeg).getY2());
                    break;
                }
                case 17: {
                    this.letter = "s";
                    this.setX(((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY());
                    this.setX2(((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getX2());
                    this.setY2(((SVGPathSegCurvetoCubicSmoothRel)sVGPathSeg).getY2());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        public void setX2(float f2) {
            super.setX2(f2);
            this.resetAttribute();
        }

        @Override
        public void setY2(float f2) {
            super.setY2(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX2()) + ' ' + Float.toString(this.getY2()) + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegLinetoVerticalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoVerticalAbs,
    SVGPathSegLinetoVerticalRel {
        public SVGPathSegLinetoVerticalItem(short s2, String string, float f2) {
            super(s2, string);
            this.setY(f2);
        }

        public SVGPathSegLinetoVerticalItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 14: {
                    this.letter = "V";
                    this.setY(((SVGPathSegLinetoVerticalAbs)sVGPathSeg).getY());
                    break;
                }
                case 15: {
                    this.letter = "v";
                    this.setY(((SVGPathSegLinetoVerticalRel)sVGPathSeg).getY());
                    break;
                }
            }
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegLinetoHorizontalItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoHorizontalAbs,
    SVGPathSegLinetoHorizontalRel {
        public SVGPathSegLinetoHorizontalItem(short s2, String string, float f2) {
            super(s2, string);
            this.setX(f2);
        }

        public SVGPathSegLinetoHorizontalItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 12: {
                    this.letter = "H";
                    this.setX(((SVGPathSegLinetoHorizontalAbs)sVGPathSeg).getX());
                    break;
                }
                case 13: {
                    this.letter = "h";
                    this.setX(((SVGPathSegLinetoHorizontalRel)sVGPathSeg).getX());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX());
        }
    }

    public static class SVGPathSegArcItem
    extends SVGPathSegItem
    implements SVGPathSegArcAbs,
    SVGPathSegArcRel {
        public SVGPathSegArcItem(short s2, String string, float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            super(s2, string);
            this.setX(f5);
            this.setY(f6);
            this.setR1(f2);
            this.setR2(f3);
            this.setAngle(f4);
            this.setLargeArcFlag(bl2);
            this.setSweepFlag(bl3);
        }

        public SVGPathSegArcItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 10: {
                    this.letter = "A";
                    this.setX(((SVGPathSegArcAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegArcAbs)sVGPathSeg).getY());
                    this.setR1(((SVGPathSegArcAbs)sVGPathSeg).getR1());
                    this.setR2(((SVGPathSegArcAbs)sVGPathSeg).getR2());
                    this.setAngle(((SVGPathSegArcAbs)sVGPathSeg).getAngle());
                    this.setLargeArcFlag(((SVGPathSegArcAbs)sVGPathSeg).getLargeArcFlag());
                    this.setSweepFlag(((SVGPathSegArcAbs)sVGPathSeg).getSweepFlag());
                    break;
                }
                case 11: {
                    this.letter = "a";
                    this.setX(((SVGPathSegArcRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegArcRel)sVGPathSeg).getY());
                    this.setR1(((SVGPathSegArcRel)sVGPathSeg).getR1());
                    this.setR2(((SVGPathSegArcRel)sVGPathSeg).getR2());
                    this.setAngle(((SVGPathSegArcRel)sVGPathSeg).getAngle());
                    this.setLargeArcFlag(((SVGPathSegArcRel)sVGPathSeg).getLargeArcFlag());
                    this.setSweepFlag(((SVGPathSegArcRel)sVGPathSeg).getSweepFlag());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        public void setR1(float f2) {
            super.setR1(f2);
            this.resetAttribute();
        }

        @Override
        public void setR2(float f2) {
            super.setR2(f2);
            this.resetAttribute();
        }

        @Override
        public void setAngle(float f2) {
            super.setAngle(f2);
            this.resetAttribute();
        }

        @Override
        public boolean getSweepFlag() {
            return this.isSweepFlag();
        }

        @Override
        public void setSweepFlag(boolean bl2) {
            super.setSweepFlag(bl2);
            this.resetAttribute();
        }

        @Override
        public boolean getLargeArcFlag() {
            return this.isLargeArcFlag();
        }

        @Override
        public void setLargeArcFlag(boolean bl2) {
            super.setLargeArcFlag(bl2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getR1()) + ' ' + Float.toString(this.getR2()) + ' ' + Float.toString(this.getAngle()) + ' ' + (this.isLargeArcFlag() ? "1" : "0") + ' ' + (this.isSweepFlag() ? "1" : "0") + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegCurvetoQuadraticItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoQuadraticAbs,
    SVGPathSegCurvetoQuadraticRel {
        public SVGPathSegCurvetoQuadraticItem(short s2, String string, float f2, float f3, float f4, float f5) {
            super(s2, string);
            this.setX(f4);
            this.setY(f5);
            this.setX1(f2);
            this.setY1(f3);
        }

        public SVGPathSegCurvetoQuadraticItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 8: {
                    this.letter = "Q";
                    this.setX(((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY());
                    this.setX1(((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getX1());
                    this.setY1(((SVGPathSegCurvetoQuadraticAbs)sVGPathSeg).getY1());
                    break;
                }
                case 9: {
                    this.letter = "q";
                    this.setX(((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY());
                    this.setX1(((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getX1());
                    this.setY1(((SVGPathSegCurvetoQuadraticRel)sVGPathSeg).getY1());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        public void setX1(float f2) {
            super.setX1(f2);
            this.resetAttribute();
        }

        @Override
        public void setY1(float f2) {
            super.setY1(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX1()) + ' ' + Float.toString(this.getY1()) + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegCurvetoCubicItem
    extends SVGPathSegItem
    implements SVGPathSegCurvetoCubicAbs,
    SVGPathSegCurvetoCubicRel {
        public SVGPathSegCurvetoCubicItem(short s2, String string, float f2, float f3, float f4, float f5, float f6, float f7) {
            super(s2, string);
            this.setX(f6);
            this.setY(f7);
            this.setX1(f2);
            this.setY1(f3);
            this.setX2(f4);
            this.setY2(f5);
        }

        public SVGPathSegCurvetoCubicItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 6: {
                    this.letter = "C";
                    this.setX(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY());
                    this.setX1(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX1());
                    this.setY1(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY1());
                    this.setX2(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getX2());
                    this.setY2(((SVGPathSegCurvetoCubicAbs)sVGPathSeg).getY2());
                    break;
                }
                case 7: {
                    this.letter = "c";
                    this.setX(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY());
                    this.setX1(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX1());
                    this.setY1(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY1());
                    this.setX2(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getX2());
                    this.setY2(((SVGPathSegCurvetoCubicRel)sVGPathSeg).getY2());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        public void setX1(float f2) {
            super.setX1(f2);
            this.resetAttribute();
        }

        @Override
        public void setY1(float f2) {
            super.setY1(f2);
            this.resetAttribute();
        }

        @Override
        public void setX2(float f2) {
            super.setX2(f2);
            this.resetAttribute();
        }

        @Override
        public void setY2(float f2) {
            super.setY2(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX1()) + ' ' + Float.toString(this.getY1()) + ' ' + Float.toString(this.getX2()) + ' ' + Float.toString(this.getY2()) + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }

    public static class SVGPathSegMovetoLinetoItem
    extends SVGPathSegItem
    implements SVGPathSegLinetoAbs,
    SVGPathSegLinetoRel,
    SVGPathSegMovetoAbs,
    SVGPathSegMovetoRel {
        public SVGPathSegMovetoLinetoItem(short s2, String string, float f2, float f3) {
            super(s2, string);
            this.setX(f2);
            this.setY(f3);
        }

        public SVGPathSegMovetoLinetoItem(SVGPathSeg sVGPathSeg) {
            this.type = sVGPathSeg.getPathSegType();
            switch (this.type) {
                case 5: {
                    this.letter = "l";
                    this.setX(((SVGPathSegLinetoRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegLinetoRel)sVGPathSeg).getY());
                    break;
                }
                case 4: {
                    this.letter = "L";
                    this.setX(((SVGPathSegLinetoAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegLinetoAbs)sVGPathSeg).getY());
                    break;
                }
                case 3: {
                    this.letter = "m";
                    this.setX(((SVGPathSegMovetoRel)sVGPathSeg).getX());
                    this.setY(((SVGPathSegMovetoRel)sVGPathSeg).getY());
                    break;
                }
                case 2: {
                    this.letter = "M";
                    this.setX(((SVGPathSegMovetoAbs)sVGPathSeg).getX());
                    this.setY(((SVGPathSegMovetoAbs)sVGPathSeg).getY());
                    break;
                }
            }
        }

        @Override
        public void setX(float f2) {
            super.setX(f2);
            this.resetAttribute();
        }

        @Override
        public void setY(float f2) {
            super.setY(f2);
            this.resetAttribute();
        }

        @Override
        protected String getStringValue() {
            return this.letter + ' ' + Float.toString(this.getX()) + ' ' + Float.toString(this.getY());
        }
    }
}

