/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGPathSegItem;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.PathParser;

public abstract class AbstractSVGNormPathSegList
extends AbstractSVGPathSegList {
    protected AbstractSVGNormPathSegList() {
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) {
        PathParser pathParser = new PathParser();
        NormalizedPathSegListBuilder normalizedPathSegListBuilder = new NormalizedPathSegListBuilder(listHandler);
        pathParser.setPathHandler(normalizedPathSegListBuilder);
        pathParser.parse(string);
    }

    protected static class SVGPathSegGenericItem
    extends SVGPathSegItem {
        public SVGPathSegGenericItem(short s2, String string, float f2, float f3, float f4, float f5, float f6, float f7) {
            super(s2, string);
            this.setX1(f4);
            this.setY1(f5);
            this.setX2(f4);
            this.setY2(f5);
            this.setX(f6);
            this.setY(f7);
        }

        public void setValue(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.setX1(f4);
            this.setY1(f5);
            this.setX2(f4);
            this.setY2(f5);
            this.setX(f6);
            this.setY(f7);
        }

        public void setValue(float f2, float f3) {
            this.setX(f2);
            this.setY(f3);
        }

        public void setPathSegType(short s2) {
            this.type = s2;
        }
    }

    protected static class NormalizedPathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;
        protected SVGPathSegGenericItem lastAbs;

        public NormalizedPathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startPath() {
            this.listHandler.startList();
            this.lastAbs = new SVGPathSegGenericItem(2, "M", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void endPath() {
            this.listHandler.endList();
        }

        @Override
        public void movetoRel(float f2, float f3) {
            this.movetoAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3);
        }

        @Override
        public void movetoAbs(float f2, float f3) {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(2, "M", f2, f3));
            this.lastAbs.setX(f2);
            this.lastAbs.setY(f3);
            this.lastAbs.setPathSegType((short)2);
        }

        @Override
        public void closePath() {
            this.listHandler.item(new SVGPathSegItem(1, "z"));
        }

        @Override
        public void linetoRel(float f2, float f3) {
            this.linetoAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3);
        }

        @Override
        public void linetoAbs(float f2, float f3) {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(4, "L", f2, f3));
            this.lastAbs.setX(f2);
            this.lastAbs.setY(f3);
            this.lastAbs.setPathSegType((short)4);
        }

        @Override
        public void linetoHorizontalRel(float f2) {
            this.linetoAbs(this.lastAbs.getX() + f2, this.lastAbs.getY());
        }

        @Override
        public void linetoHorizontalAbs(float f2) {
            this.linetoAbs(f2, this.lastAbs.getY());
        }

        @Override
        public void linetoVerticalRel(float f2) {
            this.linetoAbs(this.lastAbs.getX(), this.lastAbs.getY() + f2);
        }

        @Override
        public void linetoVerticalAbs(float f2) {
            this.linetoAbs(this.lastAbs.getX(), f2);
        }

        @Override
        public void curvetoCubicRel(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.curvetoCubicAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3, this.lastAbs.getX() + f4, this.lastAbs.getY() + f5, this.lastAbs.getX() + f6, this.lastAbs.getY() + f7);
        }

        @Override
        public void curvetoCubicAbs(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem(6, "C", f2, f3, f4, f5, f6, f7));
            this.lastAbs.setValue(f2, f3, f4, f5, f6, f7);
            this.lastAbs.setPathSegType((short)6);
        }

        @Override
        public void curvetoCubicSmoothRel(float f2, float f3, float f4, float f5) {
            this.curvetoCubicSmoothAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3, this.lastAbs.getX() + f4, this.lastAbs.getY() + f5);
        }

        @Override
        public void curvetoCubicSmoothAbs(float f2, float f3, float f4, float f5) {
            if (this.lastAbs.getPathSegType() == 6) {
                this.curvetoCubicAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX2()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY2()), f2, f3, f4, f5);
            } else {
                this.curvetoCubicAbs(this.lastAbs.getX(), this.lastAbs.getY(), f2, f3, f4, f5);
            }
        }

        @Override
        public void curvetoQuadraticRel(float f2, float f3, float f4, float f5) {
            this.curvetoQuadraticAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3, this.lastAbs.getX() + f4, this.lastAbs.getY() + f5);
        }

        @Override
        public void curvetoQuadraticAbs(float f2, float f3, float f4, float f5) {
            this.curvetoCubicAbs(this.lastAbs.getX() + 2.0f * (f2 - this.lastAbs.getX()) / 3.0f, this.lastAbs.getY() + 2.0f * (f3 - this.lastAbs.getY()) / 3.0f, f4 + 2.0f * (f2 - f4) / 3.0f, f5 + 2.0f * (f3 - f5) / 3.0f, f4, f5);
            this.lastAbs.setX1(f2);
            this.lastAbs.setY1(f3);
            this.lastAbs.setPathSegType((short)8);
        }

        @Override
        public void curvetoQuadraticSmoothRel(float f2, float f3) {
            this.curvetoQuadraticSmoothAbs(this.lastAbs.getX() + f2, this.lastAbs.getY() + f3);
        }

        @Override
        public void curvetoQuadraticSmoothAbs(float f2, float f3) {
            if (this.lastAbs.getPathSegType() == 8) {
                this.curvetoQuadraticAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX1()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY1()), f2, f3);
            } else {
                this.curvetoQuadraticAbs(this.lastAbs.getX(), this.lastAbs.getY(), f2, f3);
            }
        }

        @Override
        public void arcRel(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            this.arcAbs(f2, f3, f4, bl2, bl3, this.lastAbs.getX() + f5, this.lastAbs.getY() + f6);
        }

        @Override
        public void arcAbs(float f2, float f3, float f4, boolean bl2, boolean bl3, float f5, float f6) {
            if (f2 == 0.0f || f3 == 0.0f) {
                this.linetoAbs(f5, f6);
                return;
            }
            double d2 = this.lastAbs.getX();
            double d3 = this.lastAbs.getY();
            if (d2 == (double)f5 && d3 == (double)f6) {
                return;
            }
            Arc2D arc2D = ExtendedGeneralPath.computeArc(d2, d3, f2, f3, f4, bl2, bl3, f5, f6);
            if (arc2D == null) {
                return;
            }
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f4), arc2D.getCenterX(), arc2D.getCenterY());
            Shape shape = affineTransform.createTransformedShape(arc2D);
            PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            int n2 = -1;
            while (!pathIterator.isDone()) {
                n2 = pathIterator.currentSegment(fArray);
                switch (n2) {
                    case 3: {
                        this.curvetoCubicAbs(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                }
                pathIterator.next();
            }
            this.lastAbs.setPathSegType((short)10);
        }
    }
}

