/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.ListBuilder;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2);

    protected abstract void checkItemType(Object var1);

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object object) {
        this.checkItemType(object);
        if (this.itemList == null) {
            this.itemList = new ArrayList(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem getItemImpl(int n2) {
        this.revalidate();
        if (n2 < 0 || this.itemList == null || n2 >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n2});
        }
        return (SVGItem)this.itemList.get(n2);
    }

    protected SVGItem insertItemBeforeImpl(Object object, int n2) {
        this.checkItemType(object);
        this.revalidate();
        if (n2 < 0) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n2});
        }
        if (n2 > this.itemList.size()) {
            n2 = this.itemList.size();
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(n2, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem replaceItemImpl(Object object, int n2) {
        this.checkItemType(object);
        this.revalidate();
        if (n2 < 0 || n2 >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n2});
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.set(n2, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem removeItemImpl(int n2) {
        this.revalidate();
        if (n2 < 0 || n2 >= this.itemList.size()) {
            throw this.createDOMException((short)1, "index.out.of.bounds", new Object[]{n2});
        }
        SVGItem sVGItem = (SVGItem)this.itemList.remove(n2);
        sVGItem.setParent(null);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem appendItemImpl(Object object) {
        this.checkItemType(object);
        this.revalidate();
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(sVGItem);
        }
        return sVGItem;
    }

    protected SVGItem removeIfNeeded(Object object) {
        SVGItem sVGItem;
        if (object instanceof SVGItem) {
            sVGItem = (SVGItem)object;
            if (sVGItem.getParent() != null) {
                sVGItem.getParent().removeItem(sVGItem);
            }
        } else {
            sVGItem = this.createSVGItem(object);
        }
        return sVGItem;
    }

    protected void revalidate() {
        if (this.valid) {
            return;
        }
        try {
            ListBuilder listBuilder = new ListBuilder(this);
            this.doParse(this.getValueAsString(), listBuilder);
            List list = listBuilder.getList();
            if (list != null) {
                this.clear(this.itemList);
            }
            this.itemList = list;
        }
        catch (ParseException parseException) {
            this.itemList = null;
        }
        this.valid = true;
    }

    protected void setValueAsString(List list) {
        String string = null;
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            SVGItem sVGItem = (SVGItem)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(list.size() * 8);
            stringBuffer.append(sVGItem.getValueAsString());
            while (iterator.hasNext()) {
                sVGItem = (SVGItem)iterator.next();
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(sVGItem.getValueAsString());
            }
            string = stringBuffer.toString();
        }
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem sVGItem) {
        String string = this.getValueAsString() + this.getItemSeparator() + sVGItem.getValueAsString();
        this.setAttributeValue(string);
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem sVGItem) {
        if (this.itemList.contains(sVGItem)) {
            this.itemList.remove(sVGItem);
            sVGItem.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List list) {
        if (list == null) {
            return;
        }
        for (Object e2 : list) {
            SVGItem sVGItem = (SVGItem)e2;
            sVGItem.setParent(null);
        }
        list.clear();
    }
}

