/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    protected HashMap<String, EventListenerList> capturingListeners;
    protected HashMap<String, EventListenerList> bubblingListeners;
    protected AbstractNode node;

    public EventSupport(AbstractNode abstractNode) {
        this.node = abstractNode;
    }

    public void addEventListener(String string, EventListener eventListener, boolean bl2) {
        this.addEventListenerNS(null, string, eventListener, bl2, null);
    }

    public void addEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2, Object object) {
        HashMap<String, EventListenerList> hashMap;
        if (bl2) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashMap();
            }
            hashMap = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashMap();
            }
            hashMap = this.bubblingListeners;
        }
        EventListenerList eventListenerList = hashMap.get(string2);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            hashMap.put(string2, eventListenerList);
        }
        eventListenerList.addListener(string, object, eventListener);
    }

    public void removeEventListener(String string, EventListener eventListener, boolean bl2) {
        this.removeEventListenerNS(null, string, eventListener, bl2);
    }

    public void removeEventListenerNS(String string, String string2, EventListener eventListener, boolean bl2) {
        HashMap<String, EventListenerList> hashMap = bl2 ? this.capturingListeners : this.bubblingListeners;
        if (hashMap == null) {
            return;
        }
        EventListenerList eventListenerList = hashMap.get(string2);
        if (eventListenerList != null) {
            eventListenerList.removeListener(string, eventListener);
            if (eventListenerList.size() == 0) {
                hashMap.remove(string2);
            }
        }
    }

    public void moveEventListeners(EventSupport eventSupport) {
        eventSupport.capturingListeners = this.capturingListeners;
        eventSupport.bubblingListeners = this.bubblingListeners;
        this.capturingListeners = null;
        this.bubblingListeners = null;
    }

    public boolean dispatchEvent(NodeEventTarget nodeEventTarget, Event event) {
        if (event == null) {
            return false;
        }
        if (!(event instanceof AbstractEvent)) {
            throw this.createEventException((short)9, "unsupported.event", new Object[0]);
        }
        AbstractEvent abstractEvent = (AbstractEvent)event;
        String string = abstractEvent.getType();
        if (string == null || string.length() == 0) {
            throw this.createEventException((short)0, "unspecified.event", new Object[0]);
        }
        abstractEvent.setTarget(nodeEventTarget);
        abstractEvent.stopPropagation(false);
        abstractEvent.stopImmediatePropagation(false);
        abstractEvent.preventDefault(false);
        NodeEventTarget[] nodeEventTargetArray = this.getAncestors(nodeEventTarget);
        abstractEvent.setEventPhase((short)1);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        for (NodeEventTarget nodeEventTarget2 : nodeEventTargetArray) {
            abstractEvent.setCurrentTarget(nodeEventTarget2);
            this.fireEventListeners(nodeEventTarget2, abstractEvent, true, hashSet, hashSet2);
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        abstractEvent.setEventPhase((short)2);
        abstractEvent.setCurrentTarget(nodeEventTarget);
        this.fireEventListeners(nodeEventTarget, abstractEvent, false, hashSet, hashSet2);
        hashSet.addAll(hashSet2);
        hashSet2.clear();
        if (abstractEvent.getBubbles()) {
            abstractEvent.setEventPhase((short)3);
            for (int i2 = nodeEventTargetArray.length - 1; i2 >= 0; --i2) {
                NodeEventTarget nodeEventTarget3 = nodeEventTargetArray[i2];
                abstractEvent.setCurrentTarget(nodeEventTarget3);
                this.fireEventListeners(nodeEventTarget3, abstractEvent, false, hashSet, hashSet2);
                hashSet.addAll(hashSet2);
                hashSet2.clear();
            }
        }
        if (!abstractEvent.getDefaultPrevented()) {
            this.runDefaultActions(abstractEvent);
        }
        return abstractEvent.getDefaultPrevented();
    }

    protected void runDefaultActions(AbstractEvent abstractEvent) {
        List list = abstractEvent.getDefaultActions();
        if (list != null) {
            for (Object e2 : list) {
                Runnable runnable = (Runnable)e2;
                runnable.run();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, EventListenerList.Entry[] entryArray, HashSet hashSet, HashSet hashSet2) {
        if (entryArray == null) {
            return;
        }
        String string = abstractEvent.getNamespaceURI();
        for (EventListenerList.Entry entry : entryArray) {
            try {
                String string2 = entry.getNamespaceURI();
                if (string2 != null && string != null && !string2.equals(string)) continue;
                Object object = entry.getGroup();
                if (hashSet != null && hashSet.contains(object)) continue;
                entry.getListener().handleEvent(abstractEvent);
                if (abstractEvent.getStopImmediatePropagation()) {
                    if (hashSet != null) {
                        hashSet.add(object);
                    }
                    abstractEvent.stopImmediatePropagation(false);
                    continue;
                }
                if (!abstractEvent.getStopPropagation()) continue;
                if (hashSet2 != null) {
                    hashSet2.add(object);
                }
                abstractEvent.stopPropagation(false);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void fireEventListeners(NodeEventTarget nodeEventTarget, AbstractEvent abstractEvent, boolean bl2, HashSet hashSet, HashSet hashSet2) {
        String string = abstractEvent.getType();
        EventSupport eventSupport = nodeEventTarget.getEventSupport();
        if (eventSupport == null) {
            return;
        }
        EventListenerList eventListenerList = eventSupport.getEventListeners(string, bl2);
        if (eventListenerList == null) {
            return;
        }
        EventListenerList.Entry[] entryArray = eventListenerList.getEventListeners();
        this.fireEventListeners(nodeEventTarget, abstractEvent, entryArray, hashSet, hashSet2);
    }

    protected NodeEventTarget[] getAncestors(NodeEventTarget object) {
        object = object.getParentNodeEventTarget();
        int n2 = 0;
        NodeEventTarget[] nodeEventTargetArray = object;
        while (nodeEventTargetArray != null) {
            nodeEventTargetArray = nodeEventTargetArray.getParentNodeEventTarget();
            ++n2;
        }
        nodeEventTargetArray = new NodeEventTarget[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            nodeEventTargetArray[n3] = object;
            --n3;
            object = object.getParentNodeEventTarget();
        }
        return nodeEventTargetArray;
    }

    public boolean hasEventListenerNS(String string, String string2) {
        EventListenerList eventListenerList;
        if (this.capturingListeners != null && (eventListenerList = this.capturingListeners.get(string2)) != null && eventListenerList.hasEventListener(string)) {
            return true;
        }
        if (this.bubblingListeners != null && (eventListenerList = this.capturingListeners.get(string2)) != null) {
            return eventListenerList.hasEventListener(string);
        }
        return false;
    }

    public EventListenerList getEventListeners(String string, boolean bl2) {
        HashMap<String, EventListenerList> hashMap;
        HashMap<String, EventListenerList> hashMap2 = hashMap = bl2 ? this.capturingListeners : this.bubblingListeners;
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string);
    }

    protected EventException createEventException(short s2, String string, Object[] objectArray) {
        try {
            AbstractDocument abstractDocument = (AbstractDocument)this.node.getOwnerDocument();
            return new EventException(s2, abstractDocument.formatMessage(string, objectArray));
        }
        catch (Exception exception) {
            return new EventException(s2, string);
        }
    }

    protected void setTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setTarget(nodeEventTarget);
    }

    protected void stopPropagation(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.stopPropagation(bl2);
    }

    protected void stopImmediatePropagation(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.stopImmediatePropagation(bl2);
    }

    protected void preventDefault(AbstractEvent abstractEvent, boolean bl2) {
        abstractEvent.preventDefault(bl2);
    }

    protected void setCurrentTarget(AbstractEvent abstractEvent, NodeEventTarget nodeEventTarget) {
        abstractEvent.setCurrentTarget(nodeEventTarget);
    }

    protected void setEventPhase(AbstractEvent abstractEvent, short s2) {
        abstractEvent.setEventPhase(s2);
    }

    public static Event getUltimateOriginalEvent(Event event) {
        AbstractEvent abstractEvent;
        AbstractEvent abstractEvent2 = (AbstractEvent)event;
        while ((abstractEvent = (AbstractEvent)abstractEvent2.getOriginalEvent()) != null) {
            abstractEvent2 = abstractEvent;
        }
        return abstractEvent2;
    }
}

