/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import java.util.HashMap;
import org.apache.batik.dom.util.IntTable;
import org.w3c.dom.events.EventListener;

public class EventListenerList {
    protected int n;
    protected Entry head;
    protected IntTable counts = new IntTable();
    protected Entry[] listeners;
    protected HashMap listenersNS = new HashMap();

    public void addListener(String string, Object object, EventListener eventListener) {
        Entry entry = this.head;
        while (entry != null) {
            if ((string != null && string.equals(entry.namespaceURI) || string == null && entry.namespaceURI == null) && entry.listener == eventListener) {
                return;
            }
            entry = entry.next;
        }
        this.head = new Entry(eventListener, string, object, this.head);
        this.counts.inc(string);
        ++this.n;
        this.listeners = null;
        this.listenersNS.remove(string);
    }

    public void removeListener(String string, EventListener eventListener) {
        if (this.head == null) {
            return;
        }
        if (this.head != null && (string != null && string.equals(this.head.namespaceURI) || string == null && this.head.namespaceURI == null) && eventListener == this.head.listener) {
            this.head = this.head.next;
        } else {
            Entry entry = this.head;
            Entry entry2 = this.head.next;
            while (entry2 != null) {
                if ((string != null && string.equals(entry2.namespaceURI) || string == null && entry2.namespaceURI == null) && entry2.listener == eventListener) {
                    entry.next = entry2.next;
                    break;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            if (entry2 == null) {
                return;
            }
        }
        this.counts.dec(string);
        --this.n;
        this.listeners = null;
        this.listenersNS.remove(string);
    }

    public Entry[] getEventListeners() {
        if (this.listeners != null) {
            return this.listeners;
        }
        this.listeners = new Entry[this.n];
        int n2 = 0;
        Entry entry = this.head;
        while (entry != null) {
            this.listeners[n2++] = entry;
            entry = entry.next;
        }
        return this.listeners;
    }

    public Entry[] getEventListeners(String string) {
        if (string == null) {
            return this.getEventListeners();
        }
        Entry[] entryArray = (Entry[])this.listenersNS.get(string);
        if (entryArray != null) {
            return entryArray;
        }
        int n2 = this.counts.get(string);
        if (n2 == 0) {
            return null;
        }
        entryArray = new Entry[n2];
        this.listenersNS.put(string, entryArray);
        int n3 = 0;
        Entry entry = this.head;
        while (n3 < n2) {
            if (string.equals(entry.namespaceURI)) {
                entryArray[n3++] = entry;
            }
            entry = entry.next;
        }
        return entryArray;
    }

    public boolean hasEventListener(String string) {
        if (string == null) {
            return this.n != 0;
        }
        return this.counts.get(string) != 0;
    }

    public int size() {
        return this.n;
    }

    public static class Entry {
        protected EventListener listener;
        protected String namespaceURI;
        protected Object group;
        protected boolean mark;
        protected Entry next;

        public Entry(EventListener eventListener, String string, Object object, Entry entry) {
            this.listener = eventListener;
            this.namespaceURI = string;
            this.group = object;
            this.next = entry;
        }

        public EventListener getListener() {
            return this.listener;
        }

        public Object getGroup() {
            return this.group;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }
    }
}

