/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class GenericDocument
extends AbstractDocument {
    protected static final String ATTR_ID = "id";
    protected boolean readonly;

    protected GenericDocument() {
    }

    public GenericDocument(DocumentType documentType, DOMImplementation dOMImplementation) {
        super(documentType, dOMImplementation);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean bl2) {
        this.readonly = bl2;
    }

    @Override
    public boolean isId(Attr attr) {
        if (attr.getNamespaceURI() != null) {
            return false;
        }
        return ATTR_ID.equals(attr.getNodeName());
    }

    @Override
    public Element createElement(String string) {
        return new GenericElement(string.intern(), this);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    @Override
    public Text createTextNode(String string) {
        return new GenericText(string, this);
    }

    @Override
    public Comment createComment(String string) {
        return new GenericComment(string, this);
    }

    @Override
    public CDATASection createCDATASection(String string) {
        return new GenericCDATASection(string, this);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        return new GenericProcessingInstruction(string, string2, this);
    }

    @Override
    public Attr createAttribute(String string) {
        return new GenericAttr(string.intern(), this);
    }

    @Override
    public EntityReference createEntityReference(String string) {
        return new GenericEntityReference(string, this);
    }

    @Override
    public Element createElementNS(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null) {
            return new GenericElement(string2.intern(), this);
        }
        return new GenericElementNS(string.intern(), string2.intern(), this);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null) {
            return new GenericAttr(string2.intern(), this);
        }
        return new GenericAttrNS(string.intern(), string2.intern(), this);
    }

    @Override
    protected Node newNode() {
        return new GenericDocument();
    }
}

