/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import org.apache.batik.dom.AbstractCharacterData;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractText
extends AbstractCharacterData
implements Text {
    @Override
    public Text splitText(int n2) {
        if (this.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)this.getNodeType(), this.getNodeName()});
        }
        String string = this.getNodeValue();
        if (n2 < 0 || n2 >= string.length()) {
            throw this.createDOMException((short)1, "offset", new Object[]{n2});
        }
        Node node = this.getParentNode();
        if (node == null) {
            throw this.createDOMException((short)1, "need.parent", new Object[0]);
        }
        String string2 = string.substring(n2);
        Text text = this.createTextNode(string2);
        Node node2 = this.getNextSibling();
        if (node2 != null) {
            node.insertBefore(text, node2);
        } else {
            node.appendChild(text);
        }
        this.setNodeValue(string.substring(0, n2));
        return text;
    }

    protected Node getPreviousLogicallyAdjacentTextNode(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        for (node2 = node.getPreviousSibling(); node2 == null && node3 != null && node3.getNodeType() == 5; node2 = node2.getPreviousSibling()) {
            node2 = node3;
            node3 = node2.getParentNode();
        }
        while (node2 != null && node2.getNodeType() == 5) {
            node2 = node2.getLastChild();
        }
        if (node2 == null) {
            return null;
        }
        short s2 = node2.getNodeType();
        if (s2 == 3 || s2 == 4) {
            return node2;
        }
        return null;
    }

    protected Node getNextLogicallyAdjacentTextNode(Node node) {
        Node node2;
        Node node3 = node.getParentNode();
        for (node2 = node.getNextSibling(); node2 == null && node3 != null && node3.getNodeType() == 5; node2 = node2.getNextSibling()) {
            node2 = node3;
            node3 = node2.getParentNode();
        }
        while (node2 != null && node2.getNodeType() == 5) {
            node2 = node2.getFirstChild();
        }
        if (node2 == null) {
            return null;
        }
        short s2 = node2.getNodeType();
        if (s2 == 3 || s2 == 4) {
            return node2;
        }
        return null;
    }

    @Override
    public String getWholeText() {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = this;
        while (node != null) {
            stringBuffer.insert(0, node.getNodeValue());
            node = this.getPreviousLogicallyAdjacentTextNode(node);
        }
        node = this.getNextLogicallyAdjacentTextNode(this);
        while (node != null) {
            stringBuffer.append(node.getNodeValue());
            node = this.getNextLogicallyAdjacentTextNode(node);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isElementContentWhitespace() {
        int n2 = this.nodeValue.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (XMLUtilities.isXMLSpace(this.nodeValue.charAt(i2))) continue;
            return false;
        }
        Node node = this.getParentNode();
        if (node.getNodeType() == 1) {
            String string = XMLSupport.getXMLSpace((Element)node);
            return !string.equals("preserve");
        }
        return true;
    }

    @Override
    public Text replaceWholeText(String string) {
        Node node;
        Node node2 = this.getPreviousLogicallyAdjacentTextNode(this);
        while (node2 != null) {
            node = (AbstractNode)node2;
            if (node.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)node2.getNodeType(), node2.getNodeName()});
            }
            node2 = this.getPreviousLogicallyAdjacentTextNode(node2);
        }
        node2 = this.getNextLogicallyAdjacentTextNode(this);
        while (node2 != null) {
            node = (AbstractNode)node2;
            if (node.isReadonly()) {
                throw this.createDOMException((short)7, "readonly.node", new Object[]{(int)node2.getNodeType(), node2.getNodeName()});
            }
            node2 = this.getNextLogicallyAdjacentTextNode(node2);
        }
        node2 = this.getParentNode();
        node = this.getPreviousLogicallyAdjacentTextNode(this);
        while (node != null) {
            node2.removeChild(node);
            node = this.getPreviousLogicallyAdjacentTextNode(node);
        }
        node = this.getNextLogicallyAdjacentTextNode(this);
        while (node != null) {
            node2.removeChild(node);
            node = this.getNextLogicallyAdjacentTextNode(node);
        }
        if (this.isReadonly()) {
            node = this.createTextNode(string);
            node2.replaceChild(node, this);
            return node;
        }
        this.setNodeValue(string);
        return this;
    }

    @Override
    public String getTextContent() {
        if (this.isElementContentWhitespace()) {
            return "";
        }
        return this.getNodeValue();
    }

    protected abstract Text createTextNode(String var1);
}

