/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.Serializable;
import org.apache.batik.dom.AbstractAttr;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractParentChildNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.w3c.dom.ElementTraversal;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class AbstractElement
extends AbstractParentChildNode
implements ElementTraversal,
Element {
    protected NamedNodeMap attributes;
    protected TypeInfo typeInfo;

    protected AbstractElement() {
    }

    protected AbstractElement(String string, AbstractDocument abstractDocument) {
        this.ownerDocument = abstractDocument;
        if (abstractDocument.getStrictErrorChecking() && !DOMUtilities.isValidName(string)) {
            throw this.createDOMException((short)5, "xml.name", new Object[]{string});
        }
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes == null ? (this.attributes = this.createAttributes()) : this.attributes;
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.attributes != null && this.attributes.getNamedItem(string) != null;
    }

    @Override
    public String getAttribute(String string) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public void setAttribute(String string, String string2) {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if ((attr = this.getAttributeNode(string)) == null) {
            attr = this.getOwnerDocument().createAttribute(string);
            attr.setValue(string2);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setValue(string2);
        }
    }

    @Override
    public void removeAttribute(String string) {
        if (!this.hasAttribute(string)) {
            return;
        }
        this.attributes.removeNamedItem(string);
    }

    @Override
    public Attr getAttributeNode(String string) {
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    @Override
    public Attr setAttributeNode(Attr attr) {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    @Override
    public Attr removeAttributeNode(Attr attr) {
        String string;
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{attr.getName()});
        }
        return (Attr)this.attributes.removeNamedItemNS(string, (string = attr.getNamespaceURI()) == null ? attr.getNodeName() : attr.getLocalName());
    }

    @Override
    public void normalize() {
        super.normalize();
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                namedNodeMap.item(i2).normalize();
            }
        }
    }

    @Override
    public boolean hasAttributeNS(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return this.attributes != null && this.attributes.getNamedItemNS(string, string2) != null;
    }

    @Override
    public String getAttributeNS(String string, String string2) {
        Attr attr;
        if (this.attributes == null) {
            return "";
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return (attr = (Attr)this.attributes.getNamedItemNS(string, string2)) == null ? "" : attr.getValue();
    }

    @Override
    public void setAttributeNS(String string, String string2, String string3) {
        Attr attr;
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if ((attr = this.getAttributeNodeNS(string, string2)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(string, string2);
            attr.setValue(string3);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setValue(string3);
        }
    }

    @Override
    public void removeAttributeNS(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!this.hasAttributeNS(string, string2)) {
            return;
        }
        this.attributes.removeNamedItemNS(string, string2);
    }

    @Override
    public Attr getAttributeNodeNS(String string, String string2) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    @Override
    public Attr setAttributeNodeNS(Attr attr) {
        if (attr == null) {
            return null;
        }
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.typeInfo == null) {
            this.typeInfo = new ElementTypeInfo();
        }
        return this.typeInfo;
    }

    @Override
    public void setIdAttribute(String string, boolean bl2) {
        AbstractAttr abstractAttr = (AbstractAttr)this.getAttributeNode(string);
        if (abstractAttr == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string});
        }
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{string});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    @Override
    public void setIdAttributeNS(String string, String string2, boolean bl2) {
        AbstractAttr abstractAttr;
        if (string != null && string.length() == 0) {
            string = null;
        }
        if ((abstractAttr = (AbstractAttr)this.getAttributeNodeNS(string, string2)) == null) {
            throw this.createDOMException((short)8, "attribute.missing", new Object[]{string, string2});
        }
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{abstractAttr.getNodeName()});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    @Override
    public void setIdAttributeNode(Attr attr, boolean bl2) {
        AbstractAttr abstractAttr = (AbstractAttr)attr;
        if (abstractAttr.isReadonly()) {
            throw this.createDOMException((short)7, "readonly.node", new Object[]{abstractAttr.getNodeName()});
        }
        this.updateIdEntry(abstractAttr, bl2);
        abstractAttr.isIdAttr = bl2;
    }

    private void updateIdEntry(AbstractAttr abstractAttr, boolean bl2) {
        if (abstractAttr.isIdAttr) {
            if (!bl2) {
                this.ownerDocument.removeIdEntry(this, abstractAttr.getValue());
            }
        } else if (bl2) {
            this.ownerDocument.addIdEntry(this, abstractAttr.getValue());
        }
    }

    protected Attr getIdAttribute() {
        NamedNodeMap namedNodeMap = this.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
            if (!abstractAttr.isId()) continue;
            return abstractAttr;
        }
        return null;
    }

    protected String getId() {
        String string;
        Attr attr = this.getIdAttribute();
        if (attr != null && (string = attr.getNodeValue()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    protected void nodeAdded(Node node) {
        this.invalidateElementsByTagName(node);
    }

    @Override
    protected void nodeToBeRemoved(Node node) {
        this.invalidateElementsByTagName(node);
    }

    private void invalidateElementsByTagName(Node node) {
        Node node2;
        if (node.getNodeType() != 1) {
            return;
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        String string = node.getNamespaceURI();
        String string2 = node.getNodeName();
        String string3 = string == null ? node.getNodeName() : node.getLocalName();
        block3: for (node2 = this; node2 != null; node2 = node2.getParentNode()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 9: {
                    AbstractParentNode.ElementsByTagNameNS elementsByTagNameNS;
                    AbstractParentNode.ElementsByTagName elementsByTagName = abstractDocument.getElementsByTagName(node2, string2);
                    if (elementsByTagName != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagName = abstractDocument.getElementsByTagName(node2, "*")) != null) {
                        elementsByTagName.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string, string3)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", string3)) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, string, "*")) != null) {
                        elementsByTagNameNS.invalidate();
                    }
                    if ((elementsByTagNameNS = abstractDocument.getElementsByTagNameNS(node2, "*", "*")) == null) continue block3;
                    elementsByTagNameNS.invalidate();
                }
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            this.invalidateElementsByTagName(node2);
        }
    }

    protected NamedNodeMap createAttributes() {
        return new NamedNodeHashMap();
    }

    @Override
    protected Node export(Node node, AbstractDocument abstractDocument) {
        super.export(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    @Override
    protected Node deepExport(Node node, AbstractDocument abstractDocument) {
        super.deepExport(node, abstractDocument);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2);
                if (!abstractAttr.getSpecified()) continue;
                Attr attr = (Attr)abstractAttr.deepExport(abstractAttr.cloneNode(false), abstractDocument);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(attr);
                    continue;
                }
                abstractElement.setAttributeNode(attr);
            }
        }
        return node;
    }

    @Override
    protected Node copyInto(Node node) {
        super.copyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    @Override
    protected Node deepCopyInto(Node node) {
        super.deepCopyInto(node);
        AbstractElement abstractElement = (AbstractElement)node;
        if (this.attributes != null) {
            NamedNodeMap namedNodeMap = this.attributes;
            for (int i2 = namedNodeMap.getLength() - 1; i2 >= 0; --i2) {
                AbstractAttr abstractAttr = (AbstractAttr)namedNodeMap.item(i2).cloneNode(true);
                if (abstractAttr instanceof AbstractAttrNS) {
                    abstractElement.setAttributeNodeNS(abstractAttr);
                    continue;
                }
                abstractElement.setAttributeNode(abstractAttr);
            }
        }
        return node;
    }

    @Override
    protected void checkChildType(Node node, boolean bl2) {
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{(int)this.getNodeType(), this.getNodeName(), (int)node.getNodeType(), node.getNodeName()});
            }
        }
    }

    public void fireDOMAttrModifiedEvent(String string, Attr attr, String string2, String string3, short s2) {
        switch (s2) {
            case 2: {
                if (attr.isId()) {
                    this.ownerDocument.addIdEntry(this, string3);
                }
                this.attrAdded(attr, string3);
                break;
            }
            case 1: {
                if (attr.isId()) {
                    this.ownerDocument.updateIdEntry(this, string2, string3);
                }
                this.attrModified(attr, string2, string3);
                break;
            }
            default: {
                if (attr.isId()) {
                    this.ownerDocument.removeIdEntry(this, string2);
                }
                this.attrRemoved(attr, string2);
            }
        }
        AbstractDocument abstractDocument = this.getCurrentDocument();
        if (abstractDocument.getEventsEnabled() && !string2.equals(string3)) {
            DOMMutationEvent dOMMutationEvent = (DOMMutationEvent)abstractDocument.createEvent("MutationEvents");
            dOMMutationEvent.initMutationEventNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", true, false, attr, string2, string3, string, s2);
            this.dispatchEvent(dOMMutationEvent);
        }
    }

    protected void attrAdded(Attr attr, String string) {
    }

    protected void attrModified(Attr attr, String string, String string2) {
    }

    protected void attrRemoved(Attr attr, String string) {
    }

    @Override
    public Element getFirstElementChild() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getLastElementChild() {
        for (Node node = this.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getPreviousElementSibling() {
        Node node;
        for (node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return (Element)node;
    }

    @Override
    public int getChildElementCount() {
        this.getChildNodes();
        return this.childNodes.elementChildren;
    }

    public static class ElementTypeInfo
    implements TypeInfo {
        @Override
        public String getTypeNamespace() {
            return null;
        }

        @Override
        public String getTypeName() {
            return null;
        }

        @Override
        public boolean isDerivedFrom(String string, String string2, int n2) {
            return false;
        }
    }

    protected static class Entry
    implements Serializable {
        public int hash;
        public String namespaceURI;
        public String name;
        public Node value;
        public Entry next;

        public Entry(int n2, String string, String string2, Node node, Entry entry) {
            this.hash = n2;
            this.namespaceURI = string;
            this.name = string2;
            this.value = node;
            this.next = entry;
        }

        public boolean match(String string, String string2) {
            if (this.namespaceURI != null ? !this.namespaceURI.equals(string) : string != null) {
                return false;
            }
            return this.name.equals(string2);
        }
    }

    public class NamedNodeHashMap
    implements Serializable,
    NamedNodeMap {
        protected static final int INITIAL_CAPACITY = 3;
        protected Entry[] table = new Entry[3];
        protected int count;

        @Override
        public Node getNamedItem(String string) {
            if (string == null) {
                return null;
            }
            return this.get(null, string);
        }

        @Override
        public Node setNamedItem(Node node) {
            if (node == null) {
                return null;
            }
            this.checkNode(node);
            return this.setNamedItem(null, node.getNodeName(), node);
        }

        @Override
        public Node removeNamedItem(String string) {
            return this.removeNamedItemNS(null, string);
        }

        @Override
        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.count) {
                return null;
            }
            int n3 = 0;
            for (Entry entry : this.table) {
                Entry entry2 = entry;
                if (entry2 == null) continue;
                do {
                    if (n3++ != n2) continue;
                    return entry2.value;
                } while ((entry2 = entry2.next) != null);
            }
            return null;
        }

        @Override
        public int getLength() {
            return this.count;
        }

        @Override
        public Node getNamedItemNS(String string, String string2) {
            if (string != null && string.length() == 0) {
                string = null;
            }
            return this.get(string, string2);
        }

        @Override
        public Node setNamedItemNS(Node node) {
            String string;
            if (node == null) {
                return null;
            }
            return this.setNamedItem(string, (string = node.getNamespaceURI()) == null ? node.getNodeName() : node.getLocalName(), node);
        }

        @Override
        public Node removeNamedItemNS(String string, String string2) {
            AbstractAttr abstractAttr;
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (string2 == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{""});
            }
            if (string != null && string.length() == 0) {
                string = null;
            }
            if ((abstractAttr = (AbstractAttr)this.remove(string, string2)) == null) {
                throw AbstractElement.this.createDOMException((short)8, "attribute.missing", new Object[]{string2});
            }
            abstractAttr.setOwnerElement(null);
            AbstractElement.this.fireDOMAttrModifiedEvent(abstractAttr.getNodeName(), abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            return abstractAttr;
        }

        public Node setNamedItem(String string, String string2, Node node) {
            if (string != null && string.length() == 0) {
                string = null;
            }
            ((AbstractAttr)node).setOwnerElement(AbstractElement.this);
            AbstractAttr abstractAttr = (AbstractAttr)this.put(string, string2, node);
            if (abstractAttr != null) {
                abstractAttr.setOwnerElement(null);
                AbstractElement.this.fireDOMAttrModifiedEvent(string2, abstractAttr, abstractAttr.getNodeValue(), "", (short)3);
            }
            AbstractElement.this.fireDOMAttrModifiedEvent(string2, (Attr)node, "", node.getNodeValue(), (short)2);
            return abstractAttr;
        }

        protected void checkNode(Node node) {
            if (AbstractElement.this.isReadonly()) {
                throw AbstractElement.this.createDOMException((short)7, "readonly.node.map", new Object[0]);
            }
            if (AbstractElement.this.getOwnerDocument() != node.getOwnerDocument()) {
                throw AbstractElement.this.createDOMException((short)4, "node.from.wrong.document", new Object[]{(int)node.getNodeType(), node.getNodeName()});
            }
            if (node.getNodeType() == 2 && ((Attr)node).getOwnerElement() != null) {
                throw AbstractElement.this.createDOMException((short)4, "inuse.attribute", new Object[]{node.getNodeName()});
            }
        }

        protected Node get(String string, String string2) {
            int n2 = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = this.table[n3];
            while (entry != null) {
                if (entry.hash == n2 && entry.match(string, string2)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return null;
        }

        protected Node put(String string, String string2, Node node) {
            Entry entry;
            int n2 = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry2 = this.table[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.match(string, string2)) {
                    Node node2 = entry2.value;
                    entry2.value = node;
                    return node2;
                }
                entry2 = entry2.next;
            }
            int n4 = this.table.length;
            if (this.count++ >= n4 - (n4 >> 2)) {
                this.rehash();
                n3 = n2 % this.table.length;
            }
            this.table[n3] = entry = new Entry(n2, string, string2, node, this.table[n3]);
            return null;
        }

        protected Node remove(String string, String string2) {
            int n2 = this.hashCode(string, string2) & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            Entry entry = null;
            Entry entry2 = this.table[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.match(string, string2)) {
                    Node node = entry2.value;
                    if (entry == null) {
                        this.table[n3] = entry2.next;
                    } else {
                        entry.next = entry2.next;
                    }
                    --this.count;
                    return node;
                }
                entry = entry2;
                entry2 = entry2.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            for (int i2 = entryArray.length - 1; i2 >= 0; --i2) {
                Entry entry = entryArray[i2];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n2 = entry2.hash % this.table.length;
                    entry2.next = this.table[n2];
                    this.table[n2] = entry2;
                }
            }
        }

        protected int hashCode(String string, String string2) {
            int n2 = string == null ? 0 : string.hashCode();
            return n2 ^ string2.hashCode();
        }
    }
}

