/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.LengthManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;

public class BaselineShiftManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 40;
    }

    @Override
    public String getPropertyName() {
        return "baseline-shift";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.BASELINE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return SVGValueConstants.INHERIT_VALUE;
            }
            case 35: {
                Object object = values.get(lexicalUnit.getStringValue().toLowerCase().intern());
                if (object == null) {
                    throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
                }
                return (Value)object;
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value createStringValue(short s2, String string, CSSEngine cSSEngine) {
        if (s2 != 21) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        Object object = values.get(string.toLowerCase().intern());
        if (object == null) {
            throw this.createInvalidIdentifierDOMException(string);
        }
        return (Value)object;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == 2) {
            styleMap.putLineHeightRelative(n2, true);
            int n3 = cSSEngine.getLineHeightIndex();
            CSSStylableElement cSSStylableElement2 = (CSSStylableElement)cSSStylableElement.getParentNode();
            if (cSSStylableElement2 == null) {
                cSSStylableElement2 = cSSStylableElement;
            }
            Value value2 = cSSEngine.getComputedStyle(cSSStylableElement2, string, n3);
            float f2 = value2.getFloatValue();
            float f3 = value.getFloatValue();
            return new FloatValue(1, f2 * f3 / 100.0f);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n2, styleMap, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }

    static {
        values.put("baseline", SVGValueConstants.BASELINE_VALUE);
        values.put("sub", SVGValueConstants.SUB_VALUE);
        values.put("super", SVGValueConstants.SUPER_VALUE);
    }
}

