/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.css.sac.LexicalUnit;

public abstract class LengthManager
extends AbstractValueManager {
    static final double SQRT2 = Math.sqrt(2.0);
    protected static final int HORIZONTAL_ORIENTATION = 0;
    protected static final int VERTICAL_ORIENTATION = 1;
    protected static final int BOTH_ORIENTATION = 2;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 15: {
                return new FloatValue(3, lexicalUnit.getFloatValue());
            }
            case 16: {
                return new FloatValue(4, lexicalUnit.getFloatValue());
            }
            case 17: {
                return new FloatValue(5, lexicalUnit.getFloatValue());
            }
            case 19: {
                return new FloatValue(6, lexicalUnit.getFloatValue());
            }
            case 20: {
                return new FloatValue(7, lexicalUnit.getFloatValue());
            }
            case 18: {
                return new FloatValue(8, lexicalUnit.getFloatValue());
            }
            case 21: {
                return new FloatValue(9, lexicalUnit.getFloatValue());
            }
            case 22: {
                return new FloatValue(10, lexicalUnit.getFloatValue());
            }
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s2, float f2) {
        switch (s2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new FloatValue(s2, f2);
            }
        }
        throw this.createInvalidFloatTypeDOMException(s2);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n2, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        switch (value.getPrimitiveType()) {
            case 1: 
            case 5: {
                return value;
            }
            case 7: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f2 = value.getFloatValue();
                return new FloatValue(1, f2 / cSSContext.getPixelUnitToMillimeter());
            }
            case 6: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f3 = value.getFloatValue();
                return new FloatValue(1, f3 * 10.0f / cSSContext.getPixelUnitToMillimeter());
            }
            case 8: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f4 = value.getFloatValue();
                return new FloatValue(1, f4 * 25.4f / cSSContext.getPixelUnitToMillimeter());
            }
            case 9: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f5 = value.getFloatValue();
                return new FloatValue(1, f5 * 25.4f / (72.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 10: {
                CSSContext cSSContext = cSSEngine.getCSSContext();
                float f6 = value.getFloatValue();
                return new FloatValue(1, f6 * 25.4f / (6.0f * cSSContext.getPixelUnitToMillimeter()));
            }
            case 3: {
                styleMap.putFontSizeRelative(n2, true);
                float f7 = value.getFloatValue();
                int n3 = cSSEngine.getFontSizeIndex();
                float f8 = cSSEngine.getComputedStyle(cSSStylableElement, string, n3).getFloatValue();
                return new FloatValue(1, f7 * f8);
            }
            case 4: {
                styleMap.putFontSizeRelative(n2, true);
                float f9 = value.getFloatValue();
                int n4 = cSSEngine.getFontSizeIndex();
                float f10 = cSSEngine.getComputedStyle(cSSStylableElement, string, n4).getFloatValue();
                return new FloatValue(1, f9 * f10 * 0.5f);
            }
            case 2: {
                float f11;
                CSSContext cSSContext = cSSEngine.getCSSContext();
                switch (this.getOrientation()) {
                    case 0: {
                        styleMap.putBlockWidthRelative(n2, true);
                        f11 = value.getFloatValue() * cSSContext.getBlockWidth(cSSStylableElement) / 100.0f;
                        break;
                    }
                    case 1: {
                        styleMap.putBlockHeightRelative(n2, true);
                        f11 = value.getFloatValue() * cSSContext.getBlockHeight(cSSStylableElement) / 100.0f;
                        break;
                    }
                    default: {
                        styleMap.putBlockWidthRelative(n2, true);
                        styleMap.putBlockHeightRelative(n2, true);
                        double d2 = cSSContext.getBlockWidth(cSSStylableElement);
                        double d3 = cSSContext.getBlockHeight(cSSStylableElement);
                        f11 = (float)((double)value.getFloatValue() * (Math.sqrt(d2 * d2 + d3 * d3) / SQRT2) / 100.0);
                    }
                }
                return new FloatValue(1, f11);
            }
        }
        return value;
    }

    protected abstract int getOrientation();
}

