/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSOMValue
implements CSSPrimitiveValue,
CSSValueList,
Counter,
RGBColor,
Rect {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected LeftComponent leftComponent;
    protected RightComponent rightComponent;
    protected BottomComponent bottomComponent;
    protected TopComponent topComponent;
    protected RedComponent redComponent;
    protected GreenComponent greenComponent;
    protected BlueComponent blueComponent;
    protected CSSValue[] items;

    public CSSOMValue(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    @Override
    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    @Override
    public void setCssText(String string) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.textChanged(string);
    }

    @Override
    public short getCssValueType() {
        return this.valueProvider.getValue().getCssValueType();
    }

    @Override
    public short getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    @Override
    public void setFloatValue(short s2, float f2) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.floatValueChanged(s2, f2);
    }

    @Override
    public float getFloatValue(short s2) {
        return CSSOMValue.convertFloatValue(s2, this.valueProvider.getValue());
    }

    public static float convertFloatValue(short s2, Value value) {
        switch (s2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                if (value.getPrimitiveType() != s2) break;
                return value.getFloatValue();
            }
            case 6: {
                return CSSOMValue.toCentimeters(value);
            }
            case 7: {
                return CSSOMValue.toMillimeters(value);
            }
            case 8: {
                return CSSOMValue.toInches(value);
            }
            case 9: {
                return CSSOMValue.toPoints(value);
            }
            case 10: {
                return CSSOMValue.toPicas(value);
            }
            case 11: {
                return CSSOMValue.toDegrees(value);
            }
            case 12: {
                return CSSOMValue.toRadians(value);
            }
            case 13: {
                return CSSOMValue.toGradians(value);
            }
            case 14: {
                return CSSOMValue.toMilliseconds(value);
            }
            case 15: {
                return CSSOMValue.toSeconds(value);
            }
            case 16: {
                return CSSOMValue.toHertz(value);
            }
            case 17: {
                return CSSOMValue.tokHertz(value);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toCentimeters(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue();
            }
            case 7: {
                return value.getFloatValue() / 10.0f;
            }
            case 8: {
                return value.getFloatValue() * 2.54f;
            }
            case 9: {
                return value.getFloatValue() * 2.54f / 72.0f;
            }
            case 10: {
                return value.getFloatValue() * 2.54f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toInches(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() / 2.54f;
            }
            case 7: {
                return value.getFloatValue() / 25.4f;
            }
            case 8: {
                return value.getFloatValue();
            }
            case 9: {
                return value.getFloatValue() / 72.0f;
            }
            case 10: {
                return value.getFloatValue() / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMillimeters(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 10.0f;
            }
            case 7: {
                return value.getFloatValue();
            }
            case 8: {
                return value.getFloatValue() * 25.4f;
            }
            case 9: {
                return value.getFloatValue() * 25.4f / 72.0f;
            }
            case 10: {
                return value.getFloatValue() * 25.4f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPoints(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 72.0f / 2.54f;
            }
            case 7: {
                return value.getFloatValue() * 72.0f / 25.4f;
            }
            case 8: {
                return value.getFloatValue() * 72.0f;
            }
            case 9: {
                return value.getFloatValue();
            }
            case 10: {
                return value.getFloatValue() * 12.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPicas(Value value) {
        switch (value.getPrimitiveType()) {
            case 6: {
                return value.getFloatValue() * 6.0f / 2.54f;
            }
            case 7: {
                return value.getFloatValue() * 6.0f / 25.4f;
            }
            case 8: {
                return value.getFloatValue() * 6.0f;
            }
            case 9: {
                return value.getFloatValue() / 12.0f;
            }
            case 10: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toDegrees(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return value.getFloatValue();
            }
            case 12: {
                return (float)Math.toDegrees(value.getFloatValue());
            }
            case 13: {
                return value.getFloatValue() * 9.0f / 5.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toRadians(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return value.getFloatValue() * 5.0f / 9.0f;
            }
            case 12: {
                return value.getFloatValue();
            }
            case 13: {
                return (float)((double)(value.getFloatValue() * 100.0f) / Math.PI);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toGradians(Value value) {
        switch (value.getPrimitiveType()) {
            case 11: {
                return (float)((double)value.getFloatValue() * Math.PI / 180.0);
            }
            case 12: {
                return (float)((double)value.getFloatValue() * Math.PI / 100.0);
            }
            case 13: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMilliseconds(Value value) {
        switch (value.getPrimitiveType()) {
            case 14: {
                return value.getFloatValue();
            }
            case 15: {
                return value.getFloatValue() * 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toSeconds(Value value) {
        switch (value.getPrimitiveType()) {
            case 14: {
                return value.getFloatValue() / 1000.0f;
            }
            case 15: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toHertz(Value value) {
        switch (value.getPrimitiveType()) {
            case 16: {
                return value.getFloatValue();
            }
            case 17: {
                return value.getFloatValue() / 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float tokHertz(Value value) {
        switch (value.getPrimitiveType()) {
            case 16: {
                return value.getFloatValue() * 1000.0f;
            }
            case 17: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    @Override
    public void setStringValue(short s2, String string) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.stringValueChanged(s2, string);
    }

    @Override
    public String getStringValue() {
        return this.valueProvider.getValue().getStringValue();
    }

    @Override
    public Counter getCounterValue() {
        return this;
    }

    @Override
    public Rect getRectValue() {
        return this;
    }

    @Override
    public RGBColor getRGBColorValue() {
        return this;
    }

    @Override
    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    @Override
    public CSSValue item(int n2) {
        Object object;
        int n3 = this.valueProvider.getValue().getLength();
        if (n2 < 0 || n2 >= n3) {
            return null;
        }
        if (this.items == null) {
            this.items = new CSSValue[this.valueProvider.getValue().getLength()];
        } else if (this.items.length < n3) {
            object = new CSSValue[n3];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        object = this.items[n2];
        if (object == null) {
            object = new ListComponent(n2);
            this.items[n2] = object;
        }
        return object;
    }

    @Override
    public String getIdentifier() {
        return this.valueProvider.getValue().getIdentifier();
    }

    @Override
    public String getListStyle() {
        return this.valueProvider.getValue().getListStyle();
    }

    @Override
    public String getSeparator() {
        return this.valueProvider.getValue().getSeparator();
    }

    @Override
    public CSSPrimitiveValue getTop() {
        this.valueProvider.getValue().getTop();
        if (this.topComponent == null) {
            this.topComponent = new TopComponent();
        }
        return this.topComponent;
    }

    @Override
    public CSSPrimitiveValue getRight() {
        this.valueProvider.getValue().getRight();
        if (this.rightComponent == null) {
            this.rightComponent = new RightComponent();
        }
        return this.rightComponent;
    }

    @Override
    public CSSPrimitiveValue getBottom() {
        this.valueProvider.getValue().getBottom();
        if (this.bottomComponent == null) {
            this.bottomComponent = new BottomComponent();
        }
        return this.bottomComponent;
    }

    @Override
    public CSSPrimitiveValue getLeft() {
        this.valueProvider.getValue().getLeft();
        if (this.leftComponent == null) {
            this.leftComponent = new LeftComponent();
        }
        return this.leftComponent;
    }

    @Override
    public CSSPrimitiveValue getRed() {
        this.valueProvider.getValue().getRed();
        if (this.redComponent == null) {
            this.redComponent = new RedComponent();
        }
        return this.redComponent;
    }

    @Override
    public CSSPrimitiveValue getGreen() {
        this.valueProvider.getValue().getGreen();
        if (this.greenComponent == null) {
            this.greenComponent = new GreenComponent();
        }
        return this.greenComponent;
    }

    @Override
    public CSSPrimitiveValue getBlue() {
        this.valueProvider.getValue().getBlue();
        if (this.blueComponent == null) {
            this.blueComponent = new BlueComponent();
        }
        return this.blueComponent;
    }

    protected class ListComponent
    extends AbstractComponent {
        protected int index;

        public ListComponent(int n2) {
            this.index = n2;
        }

        @Override
        protected Value getValue() {
            if (this.index >= CSSOMValue.this.valueProvider.getValue().getLength()) {
                throw new DOMException(7, "");
            }
            return CSSOMValue.this.valueProvider.getValue().item(this.index);
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listTextChanged(this.index, string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listFloatValueChanged(this.index, s2, f2);
        }

        @Override
        public void setStringValue(short s2, String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listStringValueChanged(this.index, s2, string);
        }
    }

    protected class BlueComponent
    extends FloatComponent {
        protected BlueComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBlue();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueFloatValueChanged(s2, f2);
        }
    }

    protected class GreenComponent
    extends FloatComponent {
        protected GreenComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getGreen();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenFloatValueChanged(s2, f2);
        }
    }

    protected class RedComponent
    extends FloatComponent {
        protected RedComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRed();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redFloatValueChanged(s2, f2);
        }
    }

    protected class BottomComponent
    extends FloatComponent {
        protected BottomComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBottom();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomFloatValueChanged(s2, f2);
        }
    }

    protected class RightComponent
    extends FloatComponent {
        protected RightComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRight();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightFloatValueChanged(s2, f2);
        }
    }

    protected class TopComponent
    extends FloatComponent {
        protected TopComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getTop();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topFloatValueChanged(s2, f2);
        }
    }

    protected class LeftComponent
    extends FloatComponent {
        protected LeftComponent() {
        }

        @Override
        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getLeft();
        }

        @Override
        public void setCssText(String string) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftTextChanged(string);
        }

        @Override
        public void setFloatValue(short s2, float f2) {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftFloatValueChanged(s2, f2);
        }
    }

    protected abstract class FloatComponent
    extends AbstractComponent {
        protected FloatComponent() {
        }

        @Override
        public void setStringValue(short s2, String string) {
            throw new DOMException(15, "");
        }
    }

    protected abstract class AbstractComponent
    implements CSSPrimitiveValue {
        protected AbstractComponent() {
        }

        protected abstract Value getValue();

        @Override
        public String getCssText() {
            return this.getValue().getCssText();
        }

        @Override
        public short getCssValueType() {
            return this.getValue().getCssValueType();
        }

        @Override
        public short getPrimitiveType() {
            return this.getValue().getPrimitiveType();
        }

        @Override
        public float getFloatValue(short s2) {
            return CSSOMValue.convertFloatValue(s2, this.getValue());
        }

        @Override
        public String getStringValue() {
            return CSSOMValue.this.valueProvider.getValue().getStringValue();
        }

        @Override
        public Counter getCounterValue() {
            throw new DOMException(15, "");
        }

        @Override
        public Rect getRectValue() {
            throw new DOMException(15, "");
        }

        @Override
        public RGBColor getRGBColorValue() {
            throw new DOMException(15, "");
        }

        public int getLength() {
            throw new DOMException(15, "");
        }

        public CSSValue item(int n2) {
            throw new DOMException(15, "");
        }
    }

    public static abstract class AbstractModificationHandler
    implements ModificationHandler {
        protected abstract Value getValue();

        @Override
        public void floatValueChanged(short s2, float f2) {
            this.textChanged(FloatValue.getCssText(s2, f2));
        }

        @Override
        public void stringValueChanged(short s2, String string) {
            this.textChanged(StringValue.getCssText(s2, string));
        }

        @Override
        public void leftTextChanged(String string) {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + string + ')';
            this.textChanged(string);
        }

        @Override
        public void leftFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
            this.textChanged(string);
        }

        @Override
        public void topTextChanged(String string) {
            Value value = this.getValue();
            string = "rect(" + string + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void topFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rect(" + FloatValue.getCssText(s2, f2) + ", " + value.getRight().getCssText() + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void rightTextChanged(String string) {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + string + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void rightFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getBottom().getCssText() + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void bottomTextChanged(String string) {
            Value value = this.getValue();
            string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + string + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void bottomFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rect(" + value.getTop().getCssText() + ", " + value.getRight().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getLeft().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void redTextChanged(String string) {
            Value value = this.getValue();
            string = "rgb(" + string + ", " + value.getGreen().getCssText() + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void redFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rgb(" + FloatValue.getCssText(s2, f2) + ", " + value.getGreen().getCssText() + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void greenTextChanged(String string) {
            Value value = this.getValue();
            string = "rgb(" + value.getRed().getCssText() + ", " + string + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void greenFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rgb(" + value.getRed().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ", " + value.getBlue().getCssText() + ')';
            this.textChanged(string);
        }

        @Override
        public void blueTextChanged(String string) {
            Value value = this.getValue();
            string = "rgb(" + value.getRed().getCssText() + ", " + value.getGreen().getCssText() + ", " + string + ')';
            this.textChanged(string);
        }

        @Override
        public void blueFloatValueChanged(short s2, float f2) {
            Value value = this.getValue();
            String string = "rgb(" + value.getRed().getCssText() + ", " + value.getGreen().getCssText() + ", " + FloatValue.getCssText(s2, f2) + ')';
            this.textChanged(string);
        }

        @Override
        public void listTextChanged(int n2, String string) {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(string);
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            string = stringBuffer.toString();
            this.textChanged(string);
        }

        @Override
        public void listFloatValueChanged(int n2, short s2, float f2) {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(FloatValue.getCssText(s2, f2));
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            this.textChanged(stringBuffer.toString());
        }

        @Override
        public void listStringValueChanged(int n2, short s2, String string) {
            int n3;
            ListValue listValue = (ListValue)this.getValue();
            int n4 = listValue.getLength();
            StringBuffer stringBuffer = new StringBuffer(n4 * 8);
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(listValue.item(n3).getCssText());
                stringBuffer.append(listValue.getSeparatorChar());
            }
            stringBuffer.append(StringValue.getCssText(s2, string));
            for (n3 = n2 + 1; n3 < n4; ++n3) {
                stringBuffer.append(listValue.getSeparatorChar());
                stringBuffer.append(listValue.item(n3).getCssText());
            }
            this.textChanged(stringBuffer.toString());
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1);

        public void floatValueChanged(short var1, float var2);

        public void stringValueChanged(short var1, String var2);

        public void leftTextChanged(String var1);

        public void leftFloatValueChanged(short var1, float var2);

        public void topTextChanged(String var1);

        public void topFloatValueChanged(short var1, float var2);

        public void rightTextChanged(String var1);

        public void rightFloatValueChanged(short var1, float var2);

        public void bottomTextChanged(String var1);

        public void bottomFloatValueChanged(short var1, float var2);

        public void redTextChanged(String var1);

        public void redFloatValueChanged(short var1, float var2);

        public void greenTextChanged(String var1);

        public void greenFloatValueChanged(short var1, float var2);

        public void blueTextChanged(String var1);

        public void blueFloatValueChanged(short var1, float var2);

        public void listTextChanged(int var1, String var2);

        public void listFloatValueChanged(int var1, short var2, float var3);

        public void listStringValueChanged(int var1, short var2, String var3);
    }

    public static interface ValueProvider {
        public Value getValue();
    }
}

