/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.bridge.svg12.AbstractContentSelector;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathPatternContentSelector
extends AbstractContentSelector {
    protected NSPrefixResolver prefixResolver = new NSPrefixResolver();
    protected XPath xpath;
    protected XPathContext context;
    protected SelectedNodes selectedContent;
    protected String expression;

    public XPathPatternContentSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string) {
        super(contentManager, xBLOMContentElement, element);
        this.expression = string;
        this.parse();
    }

    protected void parse() {
        this.context = new XPathContext();
        try {
            this.xpath = new XPath(this.expression, null, this.prefixResolver, 1);
        }
        catch (TransformerException transformerException) {
            AbstractDocument abstractDocument = (AbstractDocument)this.contentElement.getOwnerDocument();
            throw abstractDocument.createXPathException((short)51, "xpath.invalid.expression", new Object[]{this.expression, transformerException.getMessage()});
        }
    }

    @Override
    public NodeList getSelectedContent() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
        }
        return this.selectedContent;
    }

    @Override
    boolean update() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
            return true;
        }
        this.parse();
        return this.selectedContent.update();
    }

    protected class NSPrefixResolver
    implements PrefixResolver {
        protected NSPrefixResolver() {
        }

        @Override
        public String getBaseIdentifier() {
            return null;
        }

        @Override
        public String getNamespaceForPrefix(String string) {
            return XPathPatternContentSelector.this.contentElement.lookupNamespaceURI(string);
        }

        @Override
        public String getNamespaceForPrefix(String string, Node node) {
            return XPathPatternContentSelector.this.contentElement.lookupNamespaceURI(string);
        }

        @Override
        public boolean handlesNullPrefixes() {
            return false;
        }
    }

    protected class SelectedNodes
    implements NodeList {
        protected ArrayList nodes = new ArrayList(10);

        public SelectedNodes() {
            this.update();
        }

        protected boolean update() {
            ArrayList arrayList = (ArrayList)this.nodes.clone();
            this.nodes.clear();
            for (Node node = XPathPatternContentSelector.this.boundElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.update(node);
            }
            int n2 = this.nodes.size();
            if (arrayList.size() != n2) {
                return true;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (arrayList.get(i2) == this.nodes.get(i2)) continue;
                return true;
            }
            return false;
        }

        protected boolean descendantSelected(Node node) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!XPathPatternContentSelector.this.isSelected(node) && !this.descendantSelected(node)) continue;
                return true;
            }
            return false;
        }

        protected void update(Node node) {
            if (!XPathPatternContentSelector.this.isSelected(node)) {
                try {
                    double d2 = XPathPatternContentSelector.this.xpath.execute(XPathPatternContentSelector.this.context, node, (PrefixResolver)XPathPatternContentSelector.this.prefixResolver).num();
                    if (d2 != Double.NEGATIVE_INFINITY) {
                        if (!this.descendantSelected(node)) {
                            this.nodes.add(node);
                        }
                    } else {
                        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                            this.update(node);
                        }
                    }
                }
                catch (TransformerException transformerException) {
                    AbstractDocument abstractDocument = (AbstractDocument)XPathPatternContentSelector.this.contentElement.getOwnerDocument();
                    throw abstractDocument.createXPathException((short)51, "xpath.error", new Object[]{XPathPatternContentSelector.this.expression, transformerException.getMessage()});
                }
            }
        }

        @Override
        public Node item(int n2) {
            if (n2 < 0 || n2 >= this.nodes.size()) {
                return null;
            }
            return (Node)this.nodes.get(n2);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }
    }
}

