/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.apache.batik.anim.dom.SVGOMAnimatedRect;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.FragmentIdentifierHandler;
import org.apache.batik.parser.FragmentIdentifierParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGPreserveAspectRatio;
import org.w3c.dom.svg.SVGRect;

public abstract class ViewBox
implements ErrorConstants,
SVGConstants {
    protected ViewBox() {
    }

    public static AffineTransform getViewTransform(String string, Element element, float f2, float f3, BridgeContext bridgeContext) {
        Object object;
        boolean bl2;
        short s2;
        float[] fArray;
        Node node;
        if (string == null || string.length() == 0) {
            return ViewBox.getPreserveAspectRatioTransform(element, f2, f3, bridgeContext);
        }
        ViewHandler viewHandler = new ViewHandler();
        FragmentIdentifierParser fragmentIdentifierParser = new FragmentIdentifierParser();
        fragmentIdentifierParser.setFragmentIdentifierHandler(viewHandler);
        fragmentIdentifierParser.parse(string);
        Node node2 = element;
        if (viewHandler.hasId) {
            node = element.getOwnerDocument();
            node2 = node.getElementById(viewHandler.id);
        }
        if (node2 == null) {
            throw new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string});
        }
        node = ViewBox.getClosestAncestorSVGElement(element);
        if (!node2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !node2.getLocalName().equals("view")) {
            node2 = node;
        }
        if (viewHandler.hasViewBox) {
            fArray = viewHandler.viewBox;
        } else {
            Node node3 = DOMUtilities.isAttributeSpecifiedNS(node2, null, "viewBox") ? node2 : node;
            String string2 = node3.getAttributeNS(null, "viewBox");
            fArray = ViewBox.parseViewBoxAttribute((Element)node3, string2, bridgeContext);
        }
        if (viewHandler.hasPreserveAspectRatio) {
            s2 = viewHandler.align;
            bl2 = viewHandler.meet;
        } else {
            object = DOMUtilities.isAttributeSpecifiedNS(node2, null, "preserveAspectRatio") ? node2 : node;
            String string3 = object.getAttributeNS(null, "preserveAspectRatio");
            PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
            ViewHandler viewHandler2 = new ViewHandler();
            preserveAspectRatioParser.setPreserveAspectRatioHandler(viewHandler2);
            try {
                preserveAspectRatioParser.parse(string3);
            }
            catch (ParseException parseException) {
                throw new BridgeException(bridgeContext, (Element)object, parseException, "attribute.malformed", new Object[]{"preserveAspectRatio", string3, parseException});
            }
            s2 = viewHandler2.align;
            bl2 = viewHandler2.meet;
        }
        object = ViewBox.getPreserveAspectRatioTransform(fArray, s2, bl2, f2, f3);
        if (viewHandler.hasTransform) {
            ((AffineTransform)object).concatenate(viewHandler.getAffineTransform());
        }
        return object;
    }

    private static Element getClosestAncestorSVGElement(Element element) {
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            Element element2 = node;
            if (!element2.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !element2.getLocalName().equals("svg")) continue;
            return element2;
        }
        return null;
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float f2, float f3) {
        return ViewBox.getPreserveAspectRatioTransform(element, f2, f3, null);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float f2, float f3, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "viewBox");
        String string2 = element.getAttributeNS(null, "preserveAspectRatio");
        return ViewBox.getPreserveAspectRatioTransform(element, string, string2, f2, f3, bridgeContext);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, String string, String string2, float f2, float f3, BridgeContext bridgeContext) {
        if (string.length() == 0) {
            return new AffineTransform();
        }
        float[] fArray = ViewBox.parseViewBoxAttribute(element, string, bridgeContext);
        PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
        ViewHandler viewHandler = new ViewHandler();
        preserveAspectRatioParser.setPreserveAspectRatioHandler(viewHandler);
        try {
            preserveAspectRatioParser.parse(string2);
        }
        catch (ParseException parseException) {
            throw new BridgeException(bridgeContext, element, parseException, "attribute.malformed", new Object[]{"preserveAspectRatio", string2, parseException});
        }
        return ViewBox.getPreserveAspectRatioTransform(fArray, viewHandler.align, viewHandler.meet, f2, f3);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float[] fArray, float f2, float f3, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "preserveAspectRatio");
        PreserveAspectRatioParser preserveAspectRatioParser = new PreserveAspectRatioParser();
        ViewHandler viewHandler = new ViewHandler();
        preserveAspectRatioParser.setPreserveAspectRatioHandler(viewHandler);
        try {
            preserveAspectRatioParser.parse(string);
        }
        catch (ParseException parseException) {
            throw new BridgeException(bridgeContext, element, parseException, "attribute.malformed", new Object[]{"preserveAspectRatio", string, parseException});
        }
        return ViewBox.getPreserveAspectRatioTransform(fArray, viewHandler.align, viewHandler.meet, f2, f3);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, float[] fArray, float f2, float f3, SVGAnimatedPreserveAspectRatio sVGAnimatedPreserveAspectRatio, BridgeContext bridgeContext) {
        try {
            SVGPreserveAspectRatio sVGPreserveAspectRatio = sVGAnimatedPreserveAspectRatio.getAnimVal();
            short s2 = sVGPreserveAspectRatio.getAlign();
            boolean bl2 = sVGPreserveAspectRatio.getMeetOrSlice() == 1;
            return ViewBox.getPreserveAspectRatioTransform(fArray, s2, bl2, f2, f3);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element element, SVGAnimatedRect sVGAnimatedRect, SVGAnimatedPreserveAspectRatio sVGAnimatedPreserveAspectRatio, float f2, float f3, BridgeContext bridgeContext) {
        if (!((SVGOMAnimatedRect)sVGAnimatedRect).isSpecified()) {
            return new AffineTransform();
        }
        SVGRect sVGRect = sVGAnimatedRect.getAnimVal();
        float[] fArray = new float[]{sVGRect.getX(), sVGRect.getY(), sVGRect.getWidth(), sVGRect.getHeight()};
        return ViewBox.getPreserveAspectRatioTransform(element, fArray, f2, f3, sVGAnimatedPreserveAspectRatio, bridgeContext);
    }

    public static float[] parseViewBoxAttribute(Element element, String string, BridgeContext bridgeContext) {
        int n2;
        if (string.length() == 0) {
            return null;
        }
        float[] fArray = new float[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            for (n2 = 0; n2 < 4 && stringTokenizer.hasMoreTokens(); ++n2) {
                fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"viewBox", string, numberFormatException});
        }
        if (n2 != 4) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"viewBox", string});
        }
        if (fArray[2] < 0.0f || fArray[3] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"viewBox", string});
        }
        if (fArray[2] == 0.0f || fArray[3] == 0.0f) {
            return null;
        }
        return fArray;
    }

    public static AffineTransform getPreserveAspectRatioTransform(float[] fArray, short s2, boolean bl2, float f2, float f3) {
        if (fArray == null) {
            return new AffineTransform();
        }
        AffineTransform affineTransform = new AffineTransform();
        float f4 = fArray[2] / fArray[3];
        float f5 = f2 / f3;
        if (s2 == 1) {
            affineTransform.scale(f2 / fArray[2], f3 / fArray[3]);
            affineTransform.translate(-fArray[0], -fArray[1]);
        } else if (f4 < f5 && bl2 || f4 >= f5 && !bl2) {
            float f6 = f3 / fArray[3];
            affineTransform.scale(f6, f6);
            switch (s2) {
                case 2: 
                case 5: 
                case 8: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f2 * fArray[3] / f3) / 2.0f, -fArray[1]);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0] - (fArray[2] - f2 * fArray[3] / f3), -fArray[1]);
                    break;
                }
            }
        } else {
            float f7 = f2 / fArray[2];
            affineTransform.scale(f7, f7);
            switch (s2) {
                case 2: 
                case 3: 
                case 4: {
                    affineTransform.translate(-fArray[0], -fArray[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f3 * fArray[2] / f2) / 2.0f);
                    break;
                }
                default: {
                    affineTransform.translate(-fArray[0], -fArray[1] - (fArray[3] - f3 * fArray[2] / f2));
                }
            }
        }
        return affineTransform;
    }

    protected static class ViewHandler
    extends AWTTransformProducer
    implements FragmentIdentifierHandler {
        public boolean hasTransform;
        public boolean hasId;
        public boolean hasViewBox;
        public boolean hasViewTargetParams;
        public boolean hasZoomAndPanParams;
        public String id;
        public float[] viewBox;
        public String viewTargetParams;
        public boolean isMagnify;
        public boolean hasPreserveAspectRatio;
        public short align;
        public boolean meet = true;

        protected ViewHandler() {
        }

        @Override
        public void endTransformList() {
            super.endTransformList();
            this.hasTransform = true;
        }

        @Override
        public void startFragmentIdentifier() {
        }

        @Override
        public void idReference(String string) {
            this.id = string;
            this.hasId = true;
        }

        @Override
        public void viewBox(float f2, float f3, float f4, float f5) {
            this.hasViewBox = true;
            this.viewBox = new float[4];
            this.viewBox[0] = f2;
            this.viewBox[1] = f3;
            this.viewBox[2] = f4;
            this.viewBox[3] = f5;
        }

        @Override
        public void startViewTarget() {
        }

        @Override
        public void viewTarget(String string) {
            this.viewTargetParams = string;
            this.hasViewTargetParams = true;
        }

        @Override
        public void endViewTarget() {
        }

        @Override
        public void zoomAndPan(boolean bl2) {
            this.isMagnify = bl2;
            this.hasZoomAndPanParams = true;
        }

        @Override
        public void endFragmentIdentifier() {
        }

        @Override
        public void startPreserveAspectRatio() {
        }

        @Override
        public void none() {
            this.align = 1;
        }

        @Override
        public void xMaxYMax() {
            this.align = (short)10;
        }

        @Override
        public void xMaxYMid() {
            this.align = (short)7;
        }

        @Override
        public void xMaxYMin() {
            this.align = (short)4;
        }

        @Override
        public void xMidYMax() {
            this.align = (short)9;
        }

        @Override
        public void xMidYMid() {
            this.align = (short)6;
        }

        @Override
        public void xMidYMin() {
            this.align = (short)3;
        }

        @Override
        public void xMinYMax() {
            this.align = (short)8;
        }

        @Override
        public void xMinYMid() {
            this.align = (short)5;
        }

        @Override
        public void xMinYMin() {
            this.align = (short)2;
        }

        @Override
        public void meet() {
            this.meet = true;
        }

        @Override
        public void slice() {
            this.meet = false;
        }

        @Override
        public void endPreserveAspectRatio() {
            this.hasPreserveAspectRatio = true;
        }
    }
}

