/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.batik.bridge.BasicTextPainter;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.TextHit;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextPainter;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;
import org.apache.batik.gvt.text.BidiAttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;

public class StrokingTextPainter
extends BasicTextPainter {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    public static final AttributedCharacterIterator.Attribute GVT_FONTS = GVTAttributedCharacterIterator.TextAttribute.GVT_FONTS;
    public static final AttributedCharacterIterator.Attribute BIDI_LEVEL = GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL;
    public static final AttributedCharacterIterator.Attribute XPOS = GVTAttributedCharacterIterator.TextAttribute.X;
    public static final AttributedCharacterIterator.Attribute YPOS = GVTAttributedCharacterIterator.TextAttribute.Y;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    public static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    public static final Integer WRITING_MODE_RTL = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final Integer ADJUST_SPACING = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
    public static final Integer ADJUST_ALL = GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL;
    public static final GVTAttributedCharacterIterator.TextAttribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    static Set extendedAtts = new HashSet();
    protected static TextPainter singleton;

    public static TextPainter getInstance() {
        return singleton;
    }

    @Override
    public void paint(TextNode textNode, Graphics2D graphics2D) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        this.paintDecorations(list, graphics2D, 1);
        this.paintDecorations(list, graphics2D, 4);
        this.paintTextRuns(list, graphics2D);
        this.paintDecorations(list, graphics2D, 2);
    }

    protected void printAttrs(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        int n2 = attributedCharacterIterator.getBeginIndex();
        System.out.print("AttrRuns: ");
        while (attributedCharacterIterator.current() != '\uffff') {
            int n3 = attributedCharacterIterator.getRunLimit();
            System.out.print("" + (n3 - n2) + ", ");
            attributedCharacterIterator.setIndex(n3);
            n2 = n3;
        }
        System.out.println("");
    }

    public List getTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator) {
        List list = textNode.getTextRuns();
        if (list != null) {
            return list;
        }
        AttributedCharacterIterator[] attributedCharacterIteratorArray = this.getTextChunkACIs(attributedCharacterIterator);
        list = this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray);
        textNode.setTextRuns(list);
        return textNode.getTextRuns();
    }

    public List computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        int[][] nArrayArray = new int[attributedCharacterIteratorArray.length][];
        int n2 = attributedCharacterIterator.getBeginIndex();
        for (int i2 = 0; i2 < attributedCharacterIteratorArray.length; ++i2) {
            BidiAttributedCharacterIterator bidiAttributedCharacterIterator = new BidiAttributedCharacterIterator(attributedCharacterIteratorArray[i2], this.fontRenderContext, n2);
            attributedCharacterIteratorArray[i2] = bidiAttributedCharacterIterator;
            nArrayArray[i2] = bidiAttributedCharacterIterator.getCharMap();
            n2 += attributedCharacterIteratorArray[i2].getEndIndex() - attributedCharacterIteratorArray[i2].getBeginIndex();
        }
        return this.computeTextRuns(textNode, attributedCharacterIterator, attributedCharacterIteratorArray, nArrayArray);
    }

    protected List computeTextRuns(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, AttributedCharacterIterator[] attributedCharacterIteratorArray, int[][] nArray) {
        TextChunk textChunk;
        int n2 = attributedCharacterIterator.getBeginIndex();
        for (int i2 = 0; i2 < attributedCharacterIteratorArray.length; ++i2) {
            attributedCharacterIteratorArray[i2] = this.createModifiedACIForFontMatching(attributedCharacterIteratorArray[i2]);
            n2 += attributedCharacterIteratorArray[i2].getEndIndex() - attributedCharacterIteratorArray[i2].getBeginIndex();
        }
        ArrayList arrayList = new ArrayList();
        TextChunk textChunk2 = null;
        int n3 = 0;
        Point2D point2D = textNode.getLocation();
        do {
            attributedCharacterIteratorArray[n3].first();
            List list = new ArrayList();
            textChunk = this.getTextChunk(textNode, attributedCharacterIteratorArray[n3], nArray != null ? nArray[n3] : null, list, textChunk2);
            list = this.reorderTextRuns(textChunk, list);
            attributedCharacterIteratorArray[n3].first();
            if (textChunk != null) {
                point2D = this.adjustChunkOffsets(point2D, list, textChunk);
            }
            arrayList.addAll(list);
            textChunk2 = textChunk;
        } while (textChunk != null && ++n3 < attributedCharacterIteratorArray.length);
        return arrayList;
    }

    protected List reorderTextRuns(TextChunk textChunk, List list) {
        return list;
    }

    protected AttributedCharacterIterator[] getTextChunkACIs(AttributedCharacterIterator attributedCharacterIterator) {
        int n2;
        Object object;
        boolean bl2;
        ArrayList<AttributedCharacterSpanIterator> arrayList = new ArrayList<AttributedCharacterSpanIterator>();
        int n3 = attributedCharacterIterator.getBeginIndex();
        attributedCharacterIterator.first();
        Object object2 = attributedCharacterIterator.getAttribute(WRITING_MODE);
        boolean bl3 = bl2 = object2 == WRITING_MODE_TTB;
        while (attributedCharacterIterator.setIndex(n3) != '\uffff') {
            object = null;
            int n4 = n3;
            n2 = 0;
            while (attributedCharacterIterator.setIndex(n4) != '\uffff') {
                Float f2;
                Serializable serializable;
                TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
                if (n4 != n3) {
                    if (!bl2 ? (serializable = (Float)attributedCharacterIterator.getAttribute(XPOS)) != null && !serializable.isNaN() : (serializable = (Float)attributedCharacterIterator.getAttribute(YPOS)) != null && !serializable.isNaN()) break;
                    if (object == null && textPath != null || object != null && textPath == null) break;
                }
                object = textPath;
                if (attributedCharacterIterator.getAttribute(FLOW_PARAGRAPH) != null) {
                    n2 = attributedCharacterIterator.getRunLimit(FLOW_PARAGRAPH);
                    attributedCharacterIterator.setIndex(n2);
                    break;
                }
                n2 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
                if (n4 == n3 && (serializable = (TextNode.Anchor)attributedCharacterIterator.getAttribute(ANCHOR_TYPE)) != TextNode.Anchor.START && !(bl2 ? (f2 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f2.isNaN() : (f2 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f2.isNaN())) {
                    int n5 = n4 + 1;
                    while (n5 < n2) {
                        Float f3;
                        attributedCharacterIterator.setIndex(n5);
                        if (bl2 ? (f3 = (Float)attributedCharacterIterator.getAttribute(YPOS)) == null || f3.isNaN() : (f3 = (Float)attributedCharacterIterator.getAttribute(XPOS)) == null || f3.isNaN()) break;
                        arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n5 - 1, n5));
                        n3 = n5++;
                    }
                }
                n4 = n2;
            }
            n4 = attributedCharacterIterator.getIndex();
            arrayList.add(new AttributedCharacterSpanIterator(attributedCharacterIterator, n3, n4));
            n3 = n4;
        }
        object = new AttributedCharacterIterator[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            object[n2] = (AttributedCharacterIterator)iterator.next();
            ++n2;
        }
        return object;
    }

    protected AttributedCharacterIterator createModifiedACIForFontMatching(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        AttributedString attributedString = null;
        int n2 = 0;
        int n3 = attributedCharacterIterator.getBeginIndex();
        boolean bl2 = true;
        int n4 = attributedCharacterIterator.getRunStart(TEXT_COMPOUND_ID);
        while (bl2) {
            Object object;
            int n5;
            Object object22;
            int n6 = n4;
            n4 = attributedCharacterIterator.getRunLimit(TEXT_COMPOUND_ID);
            int n7 = n4 - n6;
            List list = (List)attributedCharacterIterator.getAttribute(GVT_FONTS);
            float f2 = 12.0f;
            Float f3 = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            if (f3 != null) {
                f2 = f3.floatValue();
            }
            if (list.size() == 0) {
                list.add(this.getFontFamilyResolver().getDefault().deriveFont(f2, attributedCharacterIterator));
            }
            boolean[] blArray = new boolean[n7];
            if (attributedString == null) {
                attributedString = new AttributedString(attributedCharacterIterator);
            }
            GVTFont gVTFont = null;
            int n8 = 0;
            int n9 = n6;
            for (Object object22 : list) {
                int n10 = n9;
                boolean bl3 = false;
                attributedCharacterIterator.setIndex(n10);
                GVTFont gVTFont2 = (GVTFont)object22;
                if (gVTFont == null) {
                    gVTFont = gVTFont2;
                }
                while (n10 < n4) {
                    n5 = gVTFont2.canDisplayUpTo(attributedCharacterIterator, n10, n4);
                    object = attributedCharacterIterator.getAttribute(ALT_GLYPH_HANDLER);
                    if (object != null) {
                        n5 = -1;
                    }
                    if (n5 == -1) {
                        n5 = n4;
                    }
                    if (n5 <= n10) {
                        if (!bl3) {
                            n9 = n10;
                            bl3 = true;
                        }
                        ++n10;
                        continue;
                    }
                    int n11 = -1;
                    for (int i2 = n10; i2 < n5; ++i2) {
                        if (blArray[i2 - n6]) {
                            if (n11 != -1) {
                                attributedString.addAttribute(GVT_FONT, gVTFont2, n11 - n3, i2 - n3);
                                n11 = -1;
                            }
                        } else if (n11 == -1) {
                            n11 = i2;
                        }
                        blArray[i2 - n6] = true;
                        ++n8;
                    }
                    if (n11 != -1) {
                        attributedString.addAttribute(GVT_FONT, gVTFont2, n11 - n3, n5 - n3);
                    }
                    n10 = n5 + 1;
                }
                if (n8 != n7) continue;
                break;
            }
            int n12 = -1;
            object22 = null;
            GVTFont gVTFont3 = gVTFont;
            for (int i3 = 0; i3 < n7; ++i3) {
                if (blArray[i3]) {
                    if (n12 == -1) continue;
                    attributedString.addAttribute(GVT_FONT, gVTFont3, n12 + n2, i3 + n2);
                    n12 = -1;
                    gVTFont3 = null;
                    object22 = null;
                    continue;
                }
                n5 = attributedCharacterIterator.setIndex(n6 + i3);
                object = this.getFontFamilyResolver().getFamilyThatCanDisplay((char)n5);
                if (n12 == -1) {
                    n12 = i3;
                    object22 = object;
                    if (object22 == null) {
                        gVTFont3 = gVTFont;
                        continue;
                    }
                    gVTFont3 = object.deriveFont(f2, attributedCharacterIterator);
                    continue;
                }
                if (object22 == object) continue;
                attributedString.addAttribute(GVT_FONT, gVTFont3, n12 + n2, i3 + n2);
                n12 = i3;
                object22 = object;
                gVTFont3 = object22 == null ? gVTFont : object.deriveFont(f2, attributedCharacterIterator);
            }
            if (n12 != -1) {
                attributedString.addAttribute(GVT_FONT, gVTFont3, n12 + n2, n7 + n2);
            }
            n2 += n7;
            if (attributedCharacterIterator.setIndex(n4) == '\uffff') {
                bl2 = false;
            }
            n6 = n4;
        }
        if (attributedString != null) {
            return attributedString.getIterator();
        }
        return attributedCharacterIterator;
    }

    protected FontFamilyResolver getFontFamilyResolver() {
        return DefaultFontFamilyResolver.SINGLETON;
    }

    protected Set getTextRunBoundaryAttributes() {
        return extendedAtts;
    }

    protected TextChunk getTextChunk(TextNode textNode, AttributedCharacterIterator attributedCharacterIterator, int[] nArray, List list, TextChunk textChunk) {
        int n2 = 0;
        if (textChunk != null) {
            n2 = textChunk.end;
        }
        int n3 = n2;
        int n4 = attributedCharacterIterator.getIndex();
        if (attributedCharacterIterator.current() == '\uffff') {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
        boolean bl2 = true;
        TextSpanLayout textSpanLayout = null;
        Set set = this.getTextRunBoundaryAttributes();
        while (true) {
            int n5 = attributedCharacterIterator.getRunStart(set);
            int n6 = attributedCharacterIterator.getRunLimit(set);
            AttributedCharacterSpanIterator attributedCharacterSpanIterator = new AttributedCharacterSpanIterator(attributedCharacterIterator, n5, n6);
            int[] nArray2 = new int[n6 - n5];
            if (nArray != null) {
                System.arraycopy(nArray, n5 - n4, nArray2, 0, nArray2.length);
            } else {
                int n7 = nArray2.length;
                for (int i2 = 0; i2 < n7; ++i2) {
                    nArray2[i2] = i2;
                }
            }
            FontRenderContext fontRenderContext = this.fontRenderContext;
            RenderingHints renderingHints = textNode.getRenderingHints();
            if (renderingHints != null && renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                fontRenderContext = this.aaOffFontRenderContext;
            }
            textSpanLayout = this.getTextLayoutFactory().createTextLayout(attributedCharacterSpanIterator, nArray2, float_, fontRenderContext);
            list.add(new TextRun(textSpanLayout, attributedCharacterSpanIterator, bl2));
            Point2D point2D = textSpanLayout.getAdvance2D();
            float_2.x += (float)point2D.getX();
            float_2.y += (float)point2D.getY();
            ++n3;
            if (attributedCharacterIterator.setIndex(n6) == '\uffff') break;
            bl2 = false;
        }
        return new TextChunk(n2, n3, float_2);
    }

    protected Point2D adjustChunkOffsets(Point2D point2D, List list, TextChunk textChunk) {
        Point2D.Float float_;
        int n2 = textChunk.end - textChunk.begin;
        TextRun textRun = (TextRun)list.get(0);
        int n3 = textRun.getAnchorType();
        Float f2 = textRun.getLength();
        Integer n4 = textRun.getLengthAdjust();
        boolean bl2 = true;
        if (f2 == null || f2.isNaN()) {
            bl2 = false;
        }
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            textRun = (TextRun)list.get(i2);
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            n5 += attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n4 == GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING && n5 == 1) {
            bl2 = false;
        }
        float f3 = 1.0f;
        float f4 = 1.0f;
        textRun = (TextRun)list.get(n2 - 1);
        TextSpanLayout textSpanLayout = textRun.getLayout();
        GVTGlyphMetrics gVTGlyphMetrics = textSpanLayout.getGlyphMetrics(textSpanLayout.getGlyphCount() - 1);
        GVTLineMetrics gVTLineMetrics = textSpanLayout.getLineMetrics();
        Rectangle2D rectangle2D = gVTGlyphMetrics.getBounds2D();
        float f5 = (gVTGlyphMetrics.getVerticalAdvance() - (gVTLineMetrics.getAscent() + gVTLineMetrics.getDescent())) / 2.0f;
        float f6 = (float)(rectangle2D.getWidth() + rectangle2D.getX());
        float f7 = (float)((double)(f5 + gVTLineMetrics.getAscent()) + (rectangle2D.getHeight() + rectangle2D.getY()));
        if (!bl2) {
            float_ = new Point2D.Float((float)textChunk.advance.getX(), (float)(textChunk.advance.getY() + (double)f7 - (double)gVTGlyphMetrics.getVerticalAdvance()));
        } else {
            double d2;
            Point2D point2D2 = textChunk.advance;
            if (textSpanLayout.isVertical()) {
                if (n4 == ADJUST_SPACING) {
                    f4 = (float)((double)(f2.floatValue() - f7) / (point2D2.getY() - (double)gVTGlyphMetrics.getVerticalAdvance()));
                } else {
                    d2 = point2D2.getY() + (double)f7 - (double)gVTGlyphMetrics.getVerticalAdvance();
                    f4 = (float)((double)f2.floatValue() / d2);
                }
                float_ = new Point2D.Float(0.0f, f2.floatValue());
            } else {
                if (n4 == ADJUST_SPACING) {
                    f3 = (float)((double)(f2.floatValue() - f6) / (point2D2.getX() - (double)gVTGlyphMetrics.getHorizontalAdvance()));
                } else {
                    d2 = point2D2.getX() + (double)f6 - (double)gVTGlyphMetrics.getHorizontalAdvance();
                    f3 = (float)((double)f2.floatValue() / d2);
                }
                float_ = new Point2D.Float(f2.floatValue(), 0.0f);
            }
            Point2D.Float float_2 = new Point2D.Float(0.0f, 0.0f);
            for (int i3 = 0; i3 < n2; ++i3) {
                textRun = (TextRun)list.get(i3);
                textSpanLayout = textRun.getLayout();
                textSpanLayout.setScale(f3, f4, n4 == ADJUST_SPACING);
                Point2D point2D3 = textSpanLayout.getAdvance2D();
                float_2.x += (float)point2D3.getX();
                float_2.y += (float)point2D3.getY();
            }
            textChunk.advance = float_2;
        }
        float f8 = 0.0f;
        float f9 = 0.0f;
        switch (n3) {
            case 1: {
                f8 = (float)(-((Point2D)float_).getX() / 2.0);
                f9 = (float)(-((Point2D)float_).getY() / 2.0);
                break;
            }
            case 2: {
                f8 = (float)(-((Point2D)float_).getX());
                f9 = (float)(-((Point2D)float_).getY());
                break;
            }
        }
        textRun = (TextRun)list.get(0);
        textSpanLayout = textRun.getLayout();
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        boolean bl3 = textSpanLayout.isVertical();
        Float f10 = (Float)attributedCharacterIterator.getAttribute(XPOS);
        Float f11 = (Float)attributedCharacterIterator.getAttribute(YPOS);
        TextPath textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
        float f12 = (float)point2D.getX();
        float f13 = (float)point2D.getY();
        float f14 = 0.0f;
        float f15 = 0.0f;
        if (f10 != null && !f10.isNaN()) {
            f14 = f12 = f10.floatValue();
        }
        if (f11 != null && !f11.isNaN()) {
            f15 = f13 = f11.floatValue();
        }
        if (bl3) {
            f13 += f9;
            f15 += f9;
            f14 = 0.0f;
        } else {
            f12 += f8;
            f14 += f8;
            f15 = 0.0f;
        }
        for (int i4 = 0; i4 < n2; ++i4) {
            Point2D point2D4;
            textRun = (TextRun)list.get(i4);
            textSpanLayout = textRun.getLayout();
            attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            textPath = (TextPath)attributedCharacterIterator.getAttribute(TEXTPATH);
            if (bl3) {
                f10 = (Float)attributedCharacterIterator.getAttribute(XPOS);
                if (f10 != null && !f10.isNaN()) {
                    f12 = f10.floatValue();
                }
            } else {
                f11 = (Float)attributedCharacterIterator.getAttribute(YPOS);
                if (f11 != null && !f11.isNaN()) {
                    f13 = f11.floatValue();
                }
            }
            if (textPath == null) {
                textSpanLayout.setOffset(new Point2D.Float(f12, f13));
                point2D4 = textSpanLayout.getAdvance2D();
                f12 = (float)((double)f12 + point2D4.getX());
                f13 = (float)((double)f13 + point2D4.getY());
                continue;
            }
            textSpanLayout.setOffset(new Point2D.Float(f14, f15));
            point2D4 = textSpanLayout.getAdvance2D();
            f14 += (float)point2D4.getX();
            f15 += (float)point2D4.getY();
            point2D4 = textSpanLayout.getTextPathAdvance();
            f12 = (float)point2D4.getX();
            f13 = (float)point2D4.getY();
        }
        return new Point2D.Float(f12, f13);
    }

    protected void paintDecorations(List list, Graphics2D graphics2D, int n2) {
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        boolean bl2 = true;
        RectangularShape rectangularShape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Object e2 : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)e2;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            boolean bl3 = true;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                bl3 = textPaintInfo.visible;
                if (textPaintInfo.composite != null) {
                    graphics2D.setComposite(textPaintInfo.composite);
                }
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if (textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2 || bl3 != bl2) {
                if (bl2 && rectangularShape != null) {
                    if (paint != null) {
                        graphics2D.setPaint(paint);
                        graphics2D.fill(rectangularShape);
                    }
                    if (stroke != null && paint2 != null) {
                        graphics2D.setPaint(paint2);
                        graphics2D.setStroke(stroke);
                        graphics2D.draw(rectangularShape);
                    }
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d4 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d5 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
            bl2 = bl3;
        }
        if (bl2 && rectangularShape != null) {
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangularShape);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.setStroke(stroke);
                graphics2D.draw(rectangularShape);
            }
        }
    }

    protected void paintTextRuns(List list, Graphics2D graphics2D) {
        for (Object e2 : list) {
            TextRun textRun = (TextRun)e2;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null && textPaintInfo.composite != null) {
                graphics2D.setComposite(textPaintInfo.composite);
            }
            textRun.getLayout().draw(graphics2D);
        }
    }

    @Override
    public Shape getOutline(TextNode textNode) {
        Object object;
        Object object22;
        GeneralPath generalPath = null;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        for (Object object22 : list) {
            object = (TextRun)object22;
            TextSpanLayout textSpanLayout = ((TextRun)object).getLayout();
            GeneralPath generalPath2 = new GeneralPath(textSpanLayout.getOutline());
            if (generalPath == null) {
                generalPath = generalPath2;
                continue;
            }
            generalPath.setWindingRule(1);
            generalPath.append(generalPath2, false);
        }
        Shape shape = this.getDecorationOutline(list, 1);
        object22 = this.getDecorationOutline(list, 2);
        object = this.getDecorationOutline(list, 4);
        if (shape != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath(shape);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append(shape, false);
            }
        }
        if (object22 != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object22);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object22, false);
            }
        }
        if (object != null) {
            if (generalPath == null) {
                generalPath = new GeneralPath((Shape)object);
            } else {
                generalPath.setWindingRule(1);
                generalPath.append((Shape)object, false);
            }
        }
        return generalPath;
    }

    @Override
    public Rectangle2D getBounds2D(TextNode textNode) {
        Object object;
        Object object22;
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Rectangle2D rectangle2D = null;
        for (Object object22 : list) {
            object = (TextRun)object22;
            TextSpanLayout textSpanLayout = ((TextRun)object).getLayout();
            Rectangle2D rectangle2D2 = textSpanLayout.getBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        Shape shape = this.getDecorationStrokeOutline(list, 1);
        if (shape != null) {
            if (rectangle2D == null) {
                rectangle2D = shape.getBounds2D();
            } else {
                rectangle2D.add(shape.getBounds2D());
            }
        }
        if ((object22 = this.getDecorationStrokeOutline(list, 2)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object22.getBounds2D();
            } else {
                rectangle2D.add(object22.getBounds2D());
            }
        }
        if ((object = this.getDecorationStrokeOutline(list, 4)) != null) {
            if (rectangle2D == null) {
                rectangle2D = object.getBounds2D();
            } else {
                rectangle2D.add(object.getBounds2D());
            }
        }
        return rectangle2D;
    }

    protected Shape getDecorationOutline(List list, int n2) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Object e2 : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)e2;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                if (path2D == null) {
                    path2D = new GeneralPath(rectangularShape);
                } else {
                    path2D.append(rectangularShape, false);
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d4 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d5 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            if (path2D == null) {
                path2D = new GeneralPath(rectangularShape);
            } else {
                path2D.append(rectangularShape, false);
            }
        }
        return path2D;
    }

    protected Shape getDecorationStrokeOutline(List list, int n2) {
        Path2D path2D = null;
        Paint paint = null;
        Paint paint2 = null;
        Stroke stroke = null;
        RectangularShape rectangularShape = null;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Object e2 : list) {
            Rectangle2D rectangle2D;
            Shape shape;
            TextRun textRun = (TextRun)e2;
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            Paint paint3 = null;
            Stroke stroke2 = null;
            Paint paint4 = null;
            TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
            if (textPaintInfo != null) {
                switch (n2) {
                    case 1: {
                        paint3 = textPaintInfo.underlinePaint;
                        stroke2 = textPaintInfo.underlineStroke;
                        paint4 = textPaintInfo.underlineStrokePaint;
                        break;
                    }
                    case 4: {
                        paint3 = textPaintInfo.overlinePaint;
                        stroke2 = textPaintInfo.overlineStroke;
                        paint4 = textPaintInfo.overlineStrokePaint;
                        break;
                    }
                    case 2: {
                        paint3 = textPaintInfo.strikethroughPaint;
                        stroke2 = textPaintInfo.strikethroughStroke;
                        paint4 = textPaintInfo.strikethroughStrokePaint;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (textRun.isFirstRunInChunk()) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                rectangle2D = shape.getBounds2D();
                d2 = rectangle2D.getY();
                d3 = rectangle2D.getHeight();
            }
            if ((textRun.isFirstRunInChunk() || paint3 != paint || stroke2 != stroke || paint4 != paint2) && rectangularShape != null) {
                shape = null;
                if (stroke != null && paint2 != null) {
                    shape = stroke.createStrokedShape(rectangularShape);
                } else if (paint != null) {
                    shape = rectangularShape;
                }
                if (shape != null) {
                    if (path2D == null) {
                        path2D = new GeneralPath(shape);
                    } else {
                        path2D.append(shape, false);
                    }
                }
                rectangularShape = null;
            }
            if (!(paint3 == null && paint4 == null || textRun.getLayout().isVertical() || textRun.getLayout().isOnATextPath())) {
                shape = textRun.getLayout().getDecorationOutline(n2);
                if (rectangularShape == null) {
                    rectangle2D = shape.getBounds2D();
                    rectangularShape = new Rectangle2D.Double(rectangle2D.getX(), d2, rectangle2D.getWidth(), d3);
                } else {
                    rectangle2D = shape.getBounds2D();
                    double d4 = Math.min(rectangularShape.getX(), rectangle2D.getX());
                    double d5 = Math.max(rectangularShape.getMaxX(), rectangle2D.getMaxX());
                    ((Rectangle2D)rectangularShape).setRect(d4, d2, d5 - d4, d3);
                }
            }
            paint = paint3;
            stroke = stroke2;
            paint2 = paint4;
        }
        if (rectangularShape != null) {
            Object object = null;
            if (stroke != null && paint2 != null) {
                object = stroke.createStrokedShape(rectangularShape);
            } else if (paint != null) {
                object = rectangularShape;
            }
            if (object != null) {
                if (path2D == null) {
                    path2D = new GeneralPath((Shape)object);
                } else {
                    path2D.append((Shape)object, false);
                }
            }
        }
        return path2D;
    }

    @Override
    public Mark getMark(TextNode textNode, int n2, boolean bl2) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        if (n2 < attributedCharacterIterator.getBeginIndex() || n2 > attributedCharacterIterator.getEndIndex()) {
            return null;
        }
        TextHit textHit = new TextHit(n2, bl2);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    protected Mark hitTest(double d2, double d3, TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        if (list != null) {
            for (Object e2 : list) {
                TextRun textRun = (TextRun)e2;
                TextSpanLayout textSpanLayout = textRun.getLayout();
                TextHit textHit = textSpanLayout.hitTestChar((float)d2, (float)d3);
                Rectangle2D rectangle2D = textSpanLayout.getBounds2D();
                if (textHit == null || rectangle2D == null || !rectangle2D.contains(d2, d3)) continue;
                return new BasicTextPainter.BasicMark(textNode, textHit);
            }
        }
        return null;
    }

    @Override
    public Mark selectFirst(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getBeginIndex(), false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public Mark selectLast(TextNode textNode) {
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        TextHit textHit = new TextHit(attributedCharacterIterator.getEndIndex() - 1, false);
        return new BasicTextPainter.BasicMark(textNode, textHit);
    }

    @Override
    public int[] getSelected(Mark mark, Mark mark2) {
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new RuntimeException("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int[] nArray = new int[]{basicMark2.getHit().getCharIndex(), basicMark.getHit().getCharIndex()};
        List list = this.getTextRuns(textNode, attributedCharacterIterator);
        Iterator iterator = list.iterator();
        int n2 = -1;
        int n3 = -1;
        TextSpanLayout textSpanLayout = null;
        TextSpanLayout textSpanLayout2 = null;
        while (iterator.hasNext()) {
            TextRun textRun = (TextRun)iterator.next();
            TextSpanLayout textSpanLayout3 = textRun.getLayout();
            if (n2 == -1 && (n2 = textSpanLayout3.getGlyphIndex(nArray[0])) != -1) {
                textSpanLayout = textSpanLayout3;
            }
            if (n3 == -1 && (n3 = textSpanLayout3.getGlyphIndex(nArray[1])) != -1) {
                textSpanLayout2 = textSpanLayout3;
            }
            if (n2 == -1 || n3 == -1) continue;
            break;
        }
        if (textSpanLayout == null || textSpanLayout2 == null) {
            return null;
        }
        int n4 = textSpanLayout.getCharacterCount(n2, n2);
        int n5 = textSpanLayout2.getCharacterCount(n3, n3);
        if (n4 > 1) {
            if (nArray[0] > nArray[1] && textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] + (n4 - 1);
            } else if (nArray[1] > nArray[0] && !textSpanLayout.isLeftToRight()) {
                nArray[0] = nArray[0] - (n4 - 1);
            }
        }
        if (n5 > 1) {
            if (nArray[1] > nArray[0] && textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] + (n5 - 1);
            } else if (nArray[0] > nArray[1] && !textSpanLayout2.isLeftToRight()) {
                nArray[1] = nArray[1] - (n5 - 1);
            }
        }
        return nArray;
    }

    @Override
    public Shape getHighlightShape(Mark mark, Mark mark2) {
        Object object;
        int n2;
        BasicTextPainter.BasicMark basicMark;
        BasicTextPainter.BasicMark basicMark2;
        if (mark == null || mark2 == null) {
            return null;
        }
        try {
            basicMark2 = (BasicTextPainter.BasicMark)mark;
            basicMark = (BasicTextPainter.BasicMark)mark2;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This Mark was not instantiated by this TextPainter class!");
        }
        TextNode textNode = basicMark2.getTextNode();
        if (textNode == null) {
            return null;
        }
        if (textNode != basicMark.getTextNode()) {
            throw new RuntimeException("Markers are from different TextNodes!");
        }
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n3 = basicMark2.getHit().getCharIndex();
        if (n3 > (n2 = basicMark.getHit().getCharIndex())) {
            object = basicMark2;
            basicMark2 = basicMark;
            basicMark = object;
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        object = this.getTextRuns(textNode, attributedCharacterIterator);
        GeneralPath generalPath = new GeneralPath();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            TextRun textRun = (TextRun)e2;
            TextSpanLayout textSpanLayout = textRun.getLayout();
            Shape shape = textSpanLayout.getHighlightShape(n3, n2);
            if (shape == null || shape.getBounds().isEmpty()) continue;
            generalPath.append(shape, false);
        }
        return generalPath;
    }

    static {
        extendedAtts.add(FLOW_PARAGRAPH);
        extendedAtts.add(TEXT_COMPOUND_ID);
        extendedAtts.add(GVT_FONT);
        singleton = new StrokingTextPainter();
    }

    public static class TextRun {
        protected AttributedCharacterIterator aci;
        protected TextSpanLayout layout;
        protected int anchorType;
        protected boolean firstRunInChunk;
        protected Float length;
        protected Integer lengthAdjust;
        private int level;
        private int reversals;

        public TextRun(TextSpanLayout textSpanLayout, AttributedCharacterIterator attributedCharacterIterator, boolean bl2) {
            this.layout = textSpanLayout;
            this.aci = attributedCharacterIterator;
            this.aci.first();
            this.firstRunInChunk = bl2;
            this.anchorType = 0;
            TextNode.Anchor anchor = (TextNode.Anchor)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
            if (anchor != null) {
                this.anchorType = anchor.getType();
            }
            if (attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_RTL) {
                if (this.anchorType == 0) {
                    this.anchorType = 2;
                } else if (this.anchorType == 2) {
                    this.anchorType = 0;
                }
            }
            this.length = (Float)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH);
            this.lengthAdjust = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
            Integer n2 = (Integer)attributedCharacterIterator.getAttribute(BIDI_LEVEL);
            this.level = n2 != null ? n2 : -1;
        }

        public AttributedCharacterIterator getACI() {
            return this.aci;
        }

        public TextSpanLayout getLayout() {
            return this.layout;
        }

        public int getAnchorType() {
            return this.anchorType;
        }

        public Float getLength() {
            return this.length;
        }

        public Integer getLengthAdjust() {
            return this.lengthAdjust;
        }

        public boolean isFirstRunInChunk() {
            return this.firstRunInChunk;
        }

        public int getBidiLevel() {
            return this.level;
        }

        public void reverse() {
            ++this.reversals;
        }

        public void maybeReverseGlyphs(boolean bl2) {
            if ((this.reversals & 1) == 1) {
                this.layout.maybeReverse(bl2);
            }
        }
    }

    public static class TextChunk {
        public int begin;
        public int end;
        public Point2D advance;

        public TextChunk(int n2, int n3, Point2D point2D) {
            this.begin = n2;
            this.end = n3;
            this.advance = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        }
    }
}

