/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.batik.anim.dom.AbstractSVGAnimatedLength;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMAnimatedEnumeration;
import org.apache.batik.anim.dom.SVGOMAnimatedLengthList;
import org.apache.batik.anim.dom.SVGOMAnimatedNumberList;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGOMTextPositioningElement;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.AnimatableSVGBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.StrokingTextPainter;
import org.apache.batik.bridge.TextHit;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextSpanLayout;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGTextContent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.UnresolvedFontFamily;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGLengthList;
import org.w3c.dom.svg.SVGNumberList;
import org.w3c.dom.svg.SVGTextContentElement;
import org.w3c.dom.svg.SVGTextPositioningElement;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge
implements SVGTextContent {
    protected static final Integer ZERO = 0;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    public static final AttributedCharacterIterator.Attribute ALT_GLYPH_HANDLER = GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER;
    public static final AttributedCharacterIterator.Attribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final AttributedCharacterIterator.Attribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final AttributedCharacterIterator.Attribute GVT_FONT_FAMILIES = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES;
    public static final AttributedCharacterIterator.Attribute GVT_FONTS = GVTAttributedCharacterIterator.TextAttribute.GVT_FONTS;
    public static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    protected AttributedString laidoutText;
    protected WeakHashMap elemTPI = new WeakHashMap();
    protected boolean usingComplexSVGFont = false;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener;
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener;
    private boolean hasNewACI;
    private Element cssProceedElement;
    protected int endLimit;

    @Override
    public String getLocalName() {
        return "text";
    }

    @Override
    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    protected TextNode getTextNode() {
        return (TextNode)this.node;
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)super.createGraphicsNode(bridgeContext, element);
        if (textNode == null) {
            return null;
        }
        this.associateSVGContext(bridgeContext, element, textNode);
        Node node = this.getFirstChild(element);
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = this.getNextSibling(node);
        }
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        RenderingHints renderingHints = null;
        renderingHints = CSSUtilities.convertColorRendering(element, renderingHints);
        if ((renderingHints = CSSUtilities.convertTextRendering(element, renderingHints)) != null) {
            textNode.setRenderingHints(renderingHints);
        }
        textNode.setLocation(this.getLocation(bridgeContext, element));
        return textNode;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        try {
            SVGOMTextPositioningElement sVGOMTextPositioningElement = (SVGOMTextPositioningElement)element;
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList = (SVGOMAnimatedLengthList)sVGOMTextPositioningElement.getX();
            sVGOMAnimatedLengthList.check();
            SVGLengthList sVGLengthList = sVGOMAnimatedLengthList.getAnimVal();
            float f2 = 0.0f;
            if (sVGLengthList.getNumberOfItems() > 0) {
                f2 = sVGLengthList.getItem(0).getValue();
            }
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList2 = (SVGOMAnimatedLengthList)sVGOMTextPositioningElement.getY();
            sVGOMAnimatedLengthList2.check();
            SVGLengthList sVGLengthList2 = sVGOMAnimatedLengthList2.getAnimVal();
            float f3 = 0.0f;
            if (sVGLengthList2.getNumberOfItems() > 0) {
                f3 = sVGLengthList2.getItem(0).getValue();
            }
            return new Point2D.Float(f2, f3);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    protected boolean isTextElement(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("text") || string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref");
    }

    protected boolean isTextChild(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref");
    }

    @Override
    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        this.computeLaidoutText(bridgeContext, element, graphicsNode);
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        if (!bridgeContext.isDynamic()) {
            this.elemTPI.clear();
        }
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    protected Node getFirstChild(Node node) {
        return node.getFirstChild();
    }

    protected Node getNextSibling(Node node) {
        return node.getNextSibling();
    }

    protected Node getParentNode(Node node) {
        return node.getParentNode();
    }

    @Override
    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        if (bridgeContext.isDynamic()) {
            this.addTextEventListeners(bridgeContext, (NodeEventTarget)((Object)element));
        }
    }

    protected void addTextEventListeners(BridgeContext bridgeContext, NodeEventTarget nodeEventTarget) {
        if (this.childNodeRemovedEventListener == null) {
            this.childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
        }
        if (this.subtreeModifiedEventListener == null) {
            this.subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
        }
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true, null);
        bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false, null);
        bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
    }

    protected void removeTextEventListeners(BridgeContext bridgeContext, NodeEventTarget nodeEventTarget) {
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
    }

    @Override
    public void dispose() {
        this.removeTextEventListeners(this.ctx, (NodeEventTarget)((Object)this.e));
        super.dispose();
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getLocalName().equals("tspan")) {
                ((SVGOMElement)element).setSVGContext(new TspanBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("textPath")) {
                ((SVGOMElement)element).setSVGContext(new TextPathBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("tref")) {
                ((SVGOMElement)element).setSVGContext(new TRefBridge(bridgeContext, this, element));
            }
        }
        Node node = this.getFirstChild(element);
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.addContextToChild(bridgeContext, (Element)node);
            }
            node = this.getNextSibling(node);
        }
    }

    protected void removeContextFromChild(BridgeContext bridgeContext, Element element) {
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            if (element.getLocalName().equals("tspan")) {
                ((AbstractTextChildBridgeUpdateHandler)((SVGOMElement)element).getSVGContext()).dispose();
            } else if (element.getLocalName().equals("textPath")) {
                ((AbstractTextChildBridgeUpdateHandler)((SVGOMElement)element).getSVGContext()).dispose();
            } else if (element.getLocalName().equals("tref")) {
                ((AbstractTextChildBridgeUpdateHandler)((SVGOMElement)element).getSVGContext()).dispose();
            }
        }
        Node node = this.getFirstChild(element);
        while (node != null) {
            if (node.getNodeType() == 1) {
                this.removeContextFromChild(bridgeContext, (Element)node);
            }
            node = this.getNextSibling(node);
        }
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                this.laidoutText = null;
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (!this.isTextChild(element)) break;
                this.addContextToChild(this.ctx, element);
                this.laidoutText = null;
                break;
            }
        }
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.getTextNode());
        }
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(node)) break;
                this.laidoutText = null;
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (!this.isTextChild(element)) break;
                this.laidoutText = null;
                this.removeContextFromChild(this.ctx, element);
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent mutationEvent) {
        if (this.laidoutText == null) {
            this.computeLaidoutText(this.ctx, this.e, this.getTextNode());
        }
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            this.laidoutText = null;
        }
    }

    protected boolean isParentDisplayed(Node node) {
        Node node2 = this.getParentNode(node);
        return this.isTextElement((Element)node2);
    }

    protected void computeLaidoutText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        TextNode textNode = (TextNode)graphicsNode;
        this.elemTPI.clear();
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element);
        if (attributedString == null) {
            textNode.setAttributedCharacterIterator(null);
            return;
        }
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        if (bridgeContext.isDynamic()) {
            this.laidoutText = new AttributedString(attributedString.getIterator());
        }
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        this.setBaseTextPaintInfo(textPaintInfo, element, graphicsNode, bridgeContext);
        this.setDecorationTextPaintInfo(textPaintInfo, element);
        this.addPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
        if (this.usingComplexSVGFont) {
            textNode.setAttributedCharacterIterator(attributedString.getIterator());
        }
        if (bridgeContext.isDynamic()) {
            this.checkBBoxChange();
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate") || string.equals("textLength") || string.equals("lengthAdjust"))) {
            char c2 = string.charAt(0);
            if (c2 == 'x' || c2 == 'y') {
                this.getTextNode().setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLaidoutText(this.ctx, this.e, this.getTextNode());
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        int[] nArray;
        this.hasNewACI = false;
        block3: for (int n2 : nArray = cSSEngineEvent.getProperties()) {
            switch (n2) {
                case 1: 
                case 11: 
                case 12: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 53: 
                case 56: 
                case 58: 
                case 59: {
                    if (this.hasNewACI) continue block3;
                    this.hasNewACI = true;
                    this.computeLaidoutText(this.ctx, this.e, this.getTextNode());
                }
            }
        }
        this.cssProceedElement = cSSEngineEvent.getElement();
        super.handleCSSEngineEvent(cSSEngineEvent);
        this.cssProceedElement = null;
    }

    @Override
    protected void handleCSSPropertyChanged(int n2) {
        switch (n2) {
            case 15: 
            case 16: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: {
                this.rebuildACI();
                break;
            }
            case 57: {
                this.rebuildACI();
                super.handleCSSPropertyChanged(n2);
                break;
            }
            case 55: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertTextRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n2);
            }
        }
    }

    protected void rebuildACI() {
        TextPaintInfo textPaintInfo;
        TextPaintInfo textPaintInfo2;
        if (this.hasNewACI) {
            return;
        }
        TextNode textNode = this.getTextNode();
        if (textNode.getAttributedCharacterIterator() == null) {
            return;
        }
        if (this.cssProceedElement == this.e) {
            textPaintInfo2 = new TextPaintInfo();
            this.setBaseTextPaintInfo(textPaintInfo2, this.e, this.node, this.ctx);
            this.setDecorationTextPaintInfo(textPaintInfo2, this.e);
            textPaintInfo = (TextPaintInfo)this.elemTPI.get(this.e);
        } else {
            TextPaintInfo textPaintInfo3 = this.getParentTextPaintInfo(this.cssProceedElement);
            textPaintInfo2 = this.getTextPaintInfo(this.cssProceedElement, textNode, textPaintInfo3, this.ctx);
            textPaintInfo = (TextPaintInfo)this.elemTPI.get(this.cssProceedElement);
        }
        if (textPaintInfo == null) {
            return;
        }
        textNode.swapTextPaintInfo(textPaintInfo2, textPaintInfo);
        if (this.usingComplexSVGFont) {
            textNode.setAttributedCharacterIterator(textNode.getAttributedCharacterIterator());
        }
    }

    int getElementStartIndex(Element element) {
        TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element);
        if (textPaintInfo == null) {
            return -1;
        }
        return textPaintInfo.startChar;
    }

    int getElementEndIndex(Element element) {
        TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element);
        if (textPaintInfo == null) {
            return -1;
        }
        return textPaintInfo.endChar;
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        AttributedStringBuffer attributedStringBuffer = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(bridgeContext, element, true, null, null, null, attributedStringBuffer);
        return attributedStringBuffer.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl2, TextPath textPath, Integer n2, Map map, AttributedStringBuffer attributedStringBuffer) {
        Object object;
        Object object2;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl3 = string.equals("preserve");
        Element element2 = element;
        int n3 = attributedStringBuffer.length();
        if (bl2) {
            this.endLimit = 0;
        }
        if (bl3) {
            this.endLimit = attributedStringBuffer.length();
        }
        HashMap hashMap = map == null ? new HashMap() : new HashMap(map);
        map = this.getAttributeMap(bridgeContext, element, textPath, n2, hashMap);
        Object v2 = hashMap.get(TextAttribute.BIDI_EMBEDDING);
        Integer n4 = n2;
        if (v2 != null) {
            n4 = (Integer)v2;
        }
        Node node = this.getFirstChild(element);
        while (node != null) {
            boolean bl4 = bl3 ? false : (attributedStringBuffer.length() == 0 ? true : attributedStringBuffer.getLastChar() == 32);
            switch (node.getNodeType()) {
                case 1: {
                    int n5;
                    Object object3;
                    if (!"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) break;
                    element2 = (Element)node;
                    object2 = node.getLocalName();
                    if (((String)object2).equals("tspan") || ((String)object2).equals("altGlyph")) {
                        int n6 = attributedStringBuffer.count;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n4, map, attributedStringBuffer);
                        if (attributedStringBuffer.count == n6) break;
                        map = null;
                        break;
                    }
                    if (((String)object2).equals("textPath")) {
                        SVGTextPathElementBridge sVGTextPathElementBridge = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object = sVGTextPathElementBridge.createTextPath(bridgeContext, element2);
                        if (object == null) break;
                        int n7 = attributedStringBuffer.count;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, (TextPath)object, n4, map, attributedStringBuffer);
                        if (attributedStringBuffer.count == n7) break;
                        map = null;
                        break;
                    }
                    if (((String)object2).equals("tref")) {
                        String string2 = XLinkSupport.getXLinkHref((Element)node);
                        object = bridgeContext.getReferencedElement((Element)node, string2);
                        string = TextUtilities.getElementContent((Element)object);
                        if ((string = this.normalizeString(string, bl3, bl4)).length() == 0) break;
                        int n8 = attributedStringBuffer.length();
                        object3 = map == null ? new HashMap() : new HashMap(map);
                        this.getAttributeMap(bridgeContext, element2, textPath, n2, (Map)object3);
                        attributedStringBuffer.append(string, (Map)object3);
                        n5 = attributedStringBuffer.length() - 1;
                        TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(element2);
                        textPaintInfo.startChar = n8;
                        textPaintInfo.endChar = n5;
                        map = null;
                        break;
                    }
                    if (!((String)object2).equals("a")) break;
                    NodeEventTarget nodeEventTarget = (NodeEventTarget)((Object)element2);
                    object = bridgeContext.getUserAgent();
                    SVGAElementBridge.CursorHolder cursorHolder = new SVGAElementBridge.CursorHolder(CursorManager.DEFAULT_CURSOR);
                    object3 = new SVGAElementBridge.AnchorListener((UserAgent)object, cursorHolder);
                    nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", (EventListener)object3, false, null);
                    bridgeContext.storeEventListenerNS(nodeEventTarget, "http://www.w3.org/2001/xml-events", "click", (EventListener)object3, false);
                    n5 = attributedStringBuffer.count;
                    this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n4, map, attributedStringBuffer);
                    if (attributedStringBuffer.count == n5) break;
                    map = null;
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl3, bl4);
                    if (string.length() == 0) break;
                    attributedStringBuffer.append(string, hashMap);
                    if (bl3) {
                        this.endLimit = attributedStringBuffer.length();
                    }
                    map = null;
                }
            }
            node = this.getNextSibling(node);
        }
        if (bl2) {
            boolean bl5 = false;
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                attributedStringBuffer.stripLast();
                bl5 = true;
            }
            if (bl5) {
                for (Object e2 : this.elemTPI.values()) {
                    object = (TextPaintInfo)e2;
                    if (((TextPaintInfo)object).endChar < attributedStringBuffer.length()) continue;
                    ((TextPaintInfo)object).endChar = attributedStringBuffer.length() - 1;
                    if (((TextPaintInfo)object).startChar <= ((TextPaintInfo)object).endChar) continue;
                    ((TextPaintInfo)object).startChar = ((TextPaintInfo)object).endChar;
                }
            }
        }
        int n9 = attributedStringBuffer.length() - 1;
        object2 = (TextPaintInfo)this.elemTPI.get(element);
        ((TextPaintInfo)object2).startChar = n3;
        ((TextPaintInfo)object2).endChar = n9;
    }

    protected String normalizeString(String string, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl2) {
            block10: for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                switch (c2) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        continue block10;
                    }
                    default: {
                        stringBuffer.append(c2);
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (bl3) {
            block11: for (int i3 = 0; i3 < string.length(); ++i3) {
                switch (string.charAt(i3)) {
                    default: {
                        break block11;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block11;
                    }
                }
            }
        }
        boolean bl4 = false;
        block12: for (int i4 = i3; i4 < string.length(); ++i4) {
            char c3 = string.charAt(i4);
            switch (c3) {
                case '\n': 
                case '\r': {
                    continue block12;
                }
                case '\t': 
                case ' ': {
                    if (bl4) continue block12;
                    stringBuffer.append(' ');
                    bl4 = true;
                    continue block12;
                }
                default: {
                    stringBuffer.append(c3);
                    bl4 = false;
                }
            }
        }
        return stringBuffer.toString();
    }

    protected boolean nodeAncestorOf(Node node, Node node2) {
        if (node2 == null || node == null) {
            return false;
        }
        Node node3 = this.getParentNode(node2);
        while (node3 != null && node3 != node) {
            node3 = this.getParentNode(node3);
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        if (element.getLocalName().equals("textPath")) {
            this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        int n2 = this.getElementStartIndex(element);
        if (n2 == -1) {
            return;
        }
        int n3 = this.getElementEndIndex(element);
        if (!(element instanceof SVGTextPositioningElement)) {
            this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        SVGTextPositioningElement sVGTextPositioningElement = (SVGTextPositioningElement)element;
        try {
            int n4;
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList = (SVGOMAnimatedLengthList)sVGTextPositioningElement.getX();
            sVGOMAnimatedLengthList.check();
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList2 = (SVGOMAnimatedLengthList)sVGTextPositioningElement.getY();
            sVGOMAnimatedLengthList2.check();
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList3 = (SVGOMAnimatedLengthList)sVGTextPositioningElement.getDx();
            sVGOMAnimatedLengthList3.check();
            SVGOMAnimatedLengthList sVGOMAnimatedLengthList4 = (SVGOMAnimatedLengthList)sVGTextPositioningElement.getDy();
            sVGOMAnimatedLengthList4.check();
            SVGOMAnimatedNumberList sVGOMAnimatedNumberList = (SVGOMAnimatedNumberList)sVGTextPositioningElement.getRotate();
            sVGOMAnimatedNumberList.check();
            SVGLengthList sVGLengthList = sVGOMAnimatedLengthList.getAnimVal();
            SVGLengthList sVGLengthList2 = sVGOMAnimatedLengthList2.getAnimVal();
            SVGLengthList sVGLengthList3 = sVGOMAnimatedLengthList3.getAnimVal();
            SVGLengthList sVGLengthList4 = sVGOMAnimatedLengthList4.getAnimVal();
            SVGNumberList sVGNumberList = sVGOMAnimatedNumberList.getAnimVal();
            int n5 = sVGLengthList.getNumberOfItems();
            for (n4 = 0; n4 < n5 && n2 + n4 <= n3; ++n4) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, Float.valueOf(sVGLengthList.getItem(n4).getValue()), n2 + n4, n2 + n4 + 1);
            }
            n5 = sVGLengthList2.getNumberOfItems();
            for (n4 = 0; n4 < n5 && n2 + n4 <= n3; ++n4) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, Float.valueOf(sVGLengthList2.getItem(n4).getValue()), n2 + n4, n2 + n4 + 1);
            }
            n5 = sVGLengthList3.getNumberOfItems();
            for (n4 = 0; n4 < n5 && n2 + n4 <= n3; ++n4) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, Float.valueOf(sVGLengthList3.getItem(n4).getValue()), n2 + n4, n2 + n4 + 1);
            }
            n5 = sVGLengthList4.getNumberOfItems();
            for (n4 = 0; n4 < n5 && n2 + n4 <= n3; ++n4) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, Float.valueOf(sVGLengthList4.getItem(n4).getValue()), n2 + n4, n2 + n4 + 1);
            }
            n5 = sVGNumberList.getNumberOfItems();
            if (n5 == 1) {
                Float f2 = Float.valueOf((float)Math.toRadians(sVGNumberList.getItem(0).getValue()));
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, f2, n2, n3 + 1);
            } else if (n5 > 1) {
                for (n4 = 0; n4 < n5 && n2 + n4 <= n3; ++n4) {
                    Float f3 = Float.valueOf((float)Math.toRadians(sVGNumberList.getItem(n4).getValue()));
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, f3, n2 + n4, n2 + n4 + 1);
                }
            }
            this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        Node node = this.getFirstChild(element);
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 1 && this.isTextChild(element2 = (Element)node)) {
                this.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
            }
            node = this.getNextSibling(node);
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        Object v2 = this.elemTPI.get(element);
        if (v2 != null) {
            textNode.swapTextPaintInfo(textPaintInfo, (TextPaintInfo)v2);
        }
        this.addChildPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        Node node = this.getFirstChild(element);
        while (node != null) {
            Element element2;
            if (node.getNodeType() == 1 && this.isTextChild(element2 = (Element)node)) {
                TextPaintInfo textPaintInfo2 = this.getTextPaintInfo(element2, textNode, textPaintInfo, bridgeContext);
                this.addPaintAttributes(attributedString, element2, textNode, textPaintInfo2, bridgeContext);
            }
            node = this.getNextSibling(node);
        }
    }

    protected List getFontList(BridgeContext bridgeContext, Element element, Map map) {
        map.put(TEXT_COMPOUND_ID, new SoftReference<Element>(element));
        Float f2 = TextUtilities.convertFontSize(element);
        float f3 = f2.floatValue();
        map.put(TextAttribute.SIZE, f2);
        map.put(TextAttribute.WIDTH, TextUtilities.convertFontStretch(element));
        map.put(TextAttribute.POSTURE, TextUtilities.convertFontStyle(element));
        map.put(TextAttribute.WEIGHT, TextUtilities.convertFontWeight(element));
        Value value = CSSUtilities.getComputedStyle(element, 27);
        String string = value.getCssText();
        String string2 = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        map.put(TEXT_COMPOUND_DELIMITER, element);
        Value value2 = CSSUtilities.getComputedStyle(element, 21);
        ArrayList<GVTFontFamily> arrayList = new ArrayList<GVTFontFamily>();
        ArrayList<GVTFont> arrayList2 = new ArrayList<GVTFont>();
        int n2 = value2.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value3 = value2.item(i2);
            String string3 = value3.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, string3, string, string2);
            if (gVTFontFamily != null && gVTFontFamily instanceof UnresolvedFontFamily) {
                gVTFontFamily = bridgeContext.getFontFamilyResolver().resolve(gVTFontFamily.getFamilyName());
            }
            if (gVTFontFamily == null) continue;
            arrayList.add(gVTFontFamily);
            if (gVTFontFamily.isComplex()) {
                this.usingComplexSVGFont = true;
            }
            GVTFont gVTFont = gVTFontFamily.deriveFont(f3, map);
            arrayList2.add(gVTFont);
        }
        map.put(GVT_FONT_FAMILIES, arrayList);
        if (!bridgeContext.isDynamic()) {
            map.remove(TEXT_COMPOUND_DELIMITER);
        }
        return arrayList2;
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n2, Map map) {
        Value value;
        String string;
        SVGTextContentElement sVGTextContentElement = null;
        if (element instanceof SVGTextContentElement) {
            sVGTextContentElement = (SVGTextContentElement)element;
        }
        HashMap<GVTAttributedCharacterIterator.TextAttribute, Serializable> hashMap = null;
        if ("http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) && element.getLocalName().equals("altGlyph")) {
            map.put(ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        TextPaintInfo textPaintInfo = new TextPaintInfo();
        textPaintInfo.visible = true;
        textPaintInfo.fillPaint = Color.black;
        map.put(PAINT_INFO, textPaintInfo);
        this.elemTPI.put(element, textPaintInfo);
        if (textPath != null) {
            map.put(TEXTPATH, textPath);
        }
        TextNode.Anchor anchor = TextUtilities.convertTextAnchor(element);
        map.put(ANCHOR_TYPE, anchor);
        List list = this.getFontList(bridgeContext, element, map);
        map.put(GVT_FONTS, list);
        Object object = TextUtilities.convertBaselineShift(element);
        if (object != null) {
            map.put(BASELINE_SHIFT, object);
        }
        if ((string = (value = CSSUtilities.getComputedStyle(element, 56)).getStringValue()).charAt(0) == 'n') {
            if (n2 != null) {
                map.put(TextAttribute.BIDI_EMBEDDING, n2);
            }
        } else {
            value = CSSUtilities.getComputedStyle(element, 11);
            String string2 = value.getStringValue();
            int n3 = 0;
            if (n2 != null) {
                n3 = n2;
            }
            if (n3 < 0) {
                n3 = -n3;
            }
            switch (string2.charAt(0)) {
                case 'l': {
                    map.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    if ((n3 & 1) == 1) {
                        ++n3;
                        break;
                    }
                    n3 += 2;
                    break;
                }
                case 'r': {
                    map.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    if ((n3 & 1) == 1) {
                        n3 += 2;
                        break;
                    }
                    ++n3;
                }
            }
            switch (string.charAt(0)) {
                case 'b': {
                    n3 = -n3;
                }
            }
            map.put(TextAttribute.BIDI_EMBEDDING, n3);
        }
        value = CSSUtilities.getComputedStyle(element, 59);
        string = value.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                map.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                map.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                map.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        value = CSSUtilities.getComputedStyle(element, 29);
        short s2 = value.getPrimitiveType();
        switch (s2) {
            case 21: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, Float.valueOf(value.getFloatValue()));
                break;
            }
            case 12: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, Float.valueOf((float)Math.toDegrees(value.getFloatValue())));
                break;
            }
            case 13: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                map.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, Float.valueOf(value.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected primitiveType (V):" + s2);
            }
        }
        value = CSSUtilities.getComputedStyle(element, 28);
        s2 = value.getPrimitiveType();
        switch (s2) {
            case 11: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, Float.valueOf(value.getFloatValue()));
                break;
            }
            case 12: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, Float.valueOf((float)Math.toDegrees(value.getFloatValue())));
                break;
            }
            case 13: {
                map.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, Float.valueOf(value.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new IllegalStateException("unexpected primitiveType (H):" + s2);
            }
        }
        Float f2 = TextUtilities.convertLetterSpacing(element);
        if (f2 != null) {
            map.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, f2);
            map.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((f2 = TextUtilities.convertWordSpacing(element)) != null) {
            map.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, f2);
            map.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((f2 = TextUtilities.convertKerning(element)) != null) {
            map.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, f2);
            map.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if (sVGTextContentElement == null) {
            return hashMap;
        }
        try {
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGTextContentElement.getTextLength();
            if (abstractSVGAnimatedLength.isSpecified()) {
                if (hashMap == null) {
                    hashMap = new HashMap<GVTAttributedCharacterIterator.TextAttribute, Serializable>();
                }
                Float f3 = Float.valueOf(abstractSVGAnimatedLength.getCheckedValue());
                map.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, f3);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, f3);
                SVGOMAnimatedEnumeration sVGOMAnimatedEnumeration = (SVGOMAnimatedEnumeration)sVGTextContentElement.getLengthAdjust();
                if (sVGOMAnimatedEnumeration.getCheckedVal() == 2) {
                    map.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
                } else {
                    map.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                    map.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
                    hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
                }
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
        return hashMap;
    }

    protected TextPaintInfo getParentTextPaintInfo(Element element) {
        Node node = this.getParentNode(element);
        while (node != null) {
            TextPaintInfo textPaintInfo = (TextPaintInfo)this.elemTPI.get(node);
            if (textPaintInfo != null) {
                return textPaintInfo;
            }
            node = this.getParentNode(node);
        }
        return null;
    }

    protected TextPaintInfo getTextPaintInfo(Element element, GraphicsNode graphicsNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        CSSUtilities.getComputedStyle(element, 54);
        TextPaintInfo textPaintInfo2 = new TextPaintInfo(textPaintInfo);
        StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (styleMap.isNullCascaded(54) && styleMap.isNullCascaded(15) && styleMap.isNullCascaded(45) && styleMap.isNullCascaded(52) && styleMap.isNullCascaded(38)) {
            return textPaintInfo2;
        }
        this.setBaseTextPaintInfo(textPaintInfo2, element, graphicsNode, bridgeContext);
        if (!styleMap.isNullCascaded(54)) {
            this.setDecorationTextPaintInfo(textPaintInfo2, element);
        }
        return textPaintInfo2;
    }

    public void setBaseTextPaintInfo(TextPaintInfo textPaintInfo, Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        textPaintInfo.composite = !element.getLocalName().equals("text") ? CSSUtilities.convertOpacity(element) : AlphaComposite.SrcOver;
        textPaintInfo.visible = CSSUtilities.convertVisibility(element);
        textPaintInfo.fillPaint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
        textPaintInfo.strokePaint = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
        textPaintInfo.strokeStroke = PaintServer.convertStroke(element);
    }

    public void setDecorationTextPaintInfo(TextPaintInfo textPaintInfo, Element element) {
        Value value = CSSUtilities.getComputedStyle(element, 54);
        switch (value.getCssValueType()) {
            case 2: {
                ListValue listValue = (ListValue)value;
                int n2 = listValue.getLength();
                block8: for (int i2 = 0; i2 < n2; ++i2) {
                    Value value2 = listValue.item(i2);
                    String string = value2.getStringValue();
                    switch (string.charAt(0)) {
                        case 'u': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.underlinePaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.underlineStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) continue block8;
                            textPaintInfo.underlineStroke = textPaintInfo.strokeStroke;
                            continue block8;
                        }
                        case 'o': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.overlinePaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.overlineStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) continue block8;
                            textPaintInfo.overlineStroke = textPaintInfo.strokeStroke;
                            continue block8;
                        }
                        case 'l': {
                            if (textPaintInfo.fillPaint != null) {
                                textPaintInfo.strikethroughPaint = textPaintInfo.fillPaint;
                            }
                            if (textPaintInfo.strokePaint != null) {
                                textPaintInfo.strikethroughStrokePaint = textPaintInfo.strokePaint;
                            }
                            if (textPaintInfo.strokeStroke == null) continue block8;
                            textPaintInfo.strikethroughStroke = textPaintInfo.strokeStroke;
                        }
                    }
                }
                break;
            }
            default: {
                textPaintInfo.underlinePaint = null;
                textPaintInfo.underlineStrokePaint = null;
                textPaintInfo.underlineStroke = null;
                textPaintInfo.overlinePaint = null;
                textPaintInfo.overlineStrokePaint = null;
                textPaintInfo.overlineStroke = null;
                textPaintInfo.strikethroughPaint = null;
                textPaintInfo.strikethroughStrokePaint = null;
                textPaintInfo.strikethroughStroke = null;
            }
        }
    }

    @Override
    public int getNumberOfChars() {
        return this.getNumberOfChars(this.e);
    }

    @Override
    public Rectangle2D getExtentOfChar(int n2) {
        return this.getExtentOfChar(this.e, n2);
    }

    @Override
    public Point2D getStartPositionOfChar(int n2) {
        return this.getStartPositionOfChar(this.e, n2);
    }

    @Override
    public Point2D getEndPositionOfChar(int n2) {
        return this.getEndPositionOfChar(this.e, n2);
    }

    @Override
    public void selectSubString(int n2, int n3) {
        this.selectSubString(this.e, n2, n3);
    }

    @Override
    public float getRotationOfChar(int n2) {
        return this.getRotationOfChar(this.e, n2);
    }

    @Override
    public float getComputedTextLength() {
        return this.getComputedTextLength(this.e);
    }

    @Override
    public float getSubStringLength(int n2, int n3) {
        return this.getSubStringLength(this.e, n2, n3);
    }

    @Override
    public int getCharNumAtPosition(float f2, float f3) {
        return this.getCharNumAtPosition(this.e, f2, f3);
    }

    protected int getNumberOfChars(Element element) {
        AttributedCharacterIterator attributedCharacterIterator = this.getTextNode().getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return 0;
        }
        int n2 = this.getElementStartIndex(element);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.getElementEndIndex(element);
        return n3 - n2 + 1;
    }

    protected Rectangle2D getExtentOfChar(Element element, int n2) {
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n3 = this.getElementStartIndex(element);
        if (n3 == -1) {
            return null;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n2, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Shape shape = null;
        if (characterInformation.glyphIndexStart == characterInformation.glyphIndexEnd) {
            if (gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexStart)) {
                shape = gVTGlyphVector.getGlyphCellBounds(characterInformation.glyphIndexStart);
            }
        } else {
            Path2D path2D = null;
            for (int i2 = characterInformation.glyphIndexStart; i2 <= characterInformation.glyphIndexEnd; ++i2) {
                if (!gVTGlyphVector.isGlyphVisible(i2)) continue;
                Rectangle2D rectangle2D = gVTGlyphVector.getGlyphCellBounds(i2);
                if (path2D == null) {
                    path2D = new GeneralPath(rectangle2D);
                    continue;
                }
                path2D.append(rectangle2D, false);
            }
            shape = path2D;
        }
        if (shape == null) {
            return null;
        }
        return shape.getBounds2D();
    }

    protected Point2D getStartPositionOfChar(Element element, int n2) {
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n3 = this.getElementStartIndex(element);
        if (n3 == -1) {
            return null;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n2, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        return this.getStartPoint(characterInformation);
    }

    protected Point2D getStartPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        if (!gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexStart)) {
            return null;
        }
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexStart);
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexStart);
        Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
        if (affineTransform != null) {
            affineTransform.transform(float_, float_);
        }
        float_.x = (float)((double)float_.x + point2D.getX());
        float_.y = (float)((double)float_.y + point2D.getY());
        return float_;
    }

    protected Point2D getEndPositionOfChar(Element element, int n2) {
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return null;
        }
        int n3 = this.getElementStartIndex(element);
        if (n3 == -1) {
            return null;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n2, attributedCharacterIterator);
        if (characterInformation == null) {
            return null;
        }
        return this.getEndPoint(characterInformation);
    }

    protected Point2D getEndPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        if (!gVTGlyphVector.isGlyphVisible(characterInformation.glyphIndexEnd)) {
            return null;
        }
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexEnd);
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexEnd);
        GVTGlyphMetrics gVTGlyphMetrics = gVTGlyphVector.getGlyphMetrics(characterInformation.glyphIndexEnd);
        Point2D.Float float_ = new Point2D.Float(gVTGlyphMetrics.getHorizontalAdvance(), 0.0f);
        if (affineTransform != null) {
            affineTransform.transform(float_, float_);
        }
        float_.x = (float)((double)float_.x + point2D.getX());
        float_.y = (float)((double)float_.y + point2D.getY());
        return float_;
    }

    protected float getRotationOfChar(Element element, int n2) {
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return 0.0f;
        }
        int n3 = this.getElementStartIndex(element);
        if (n3 == -1) {
            return 0.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n2, attributedCharacterIterator);
        double d2 = 0.0;
        int n4 = 0;
        if (characterInformation != null) {
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            for (int i2 = characterInformation.glyphIndexStart; i2 <= characterInformation.glyphIndexEnd; ++i2) {
                if (!gVTGlyphVector.isGlyphVisible(i2)) continue;
                ++n4;
                AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(i2);
                if (affineTransform == null) continue;
                double d3 = 0.0;
                double d4 = affineTransform.getScaleX();
                double d5 = affineTransform.getShearX();
                if (d4 == 0.0) {
                    d3 = d5 > 0.0 ? Math.PI : -Math.PI;
                } else {
                    d3 = Math.atan(d5 / d4);
                    if (d4 < 0.0) {
                        d3 += Math.PI;
                    }
                }
                d3 = Math.toDegrees(-d3) % 360.0;
                d2 += d3 - characterInformation.getComputedOrientationAngle();
            }
        }
        if (n4 == 0) {
            return 0.0f;
        }
        return (float)(d2 / (double)n4);
    }

    protected float getComputedTextLength(Element element) {
        return this.getSubStringLength(element, 0, this.getNumberOfChars(element));
    }

    protected float getSubStringLength(Element element, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return 0.0f;
        }
        float f2 = 0.0f;
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return -1.0f;
        }
        int n5 = this.getElementStartIndex(element);
        if (n5 == -1) {
            return -1.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n5, n2, attributedCharacterIterator);
        CharacterInformation characterInformation2 = null;
        int n6 = characterInformation.characterIndex + 1;
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        boolean[] blArray = new boolean[fArray.length];
        for (n4 = n2 + 1; n4 < n2 + n3; ++n4) {
            if (characterInformation.layout.isOnATextPath()) {
                for (int i2 = characterInformation.glyphIndexStart; i2 <= characterInformation.glyphIndexEnd; ++i2) {
                    if (gVTGlyphVector.isGlyphVisible(i2) && !blArray[i2]) {
                        f2 += fArray[i2 + 1] - fArray[i2];
                    }
                    blArray[i2] = true;
                }
                CharacterInformation characterInformation3 = this.getCharacterInformation(list, n5, n4, attributedCharacterIterator);
                if (characterInformation3.layout != characterInformation.layout) {
                    gVTGlyphVector = characterInformation3.layout.getGlyphVector();
                    fArray = characterInformation3.layout.getGlyphAdvances();
                    blArray = new boolean[fArray.length];
                    n6 = characterInformation.characterIndex + 1;
                }
                characterInformation = characterInformation3;
                continue;
            }
            if (characterInformation.layout.hasCharacterIndex(n6)) {
                ++n6;
                continue;
            }
            characterInformation2 = this.getCharacterInformation(list, n5, n4 - 1, attributedCharacterIterator);
            f2 += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
            characterInformation = this.getCharacterInformation(list, n5, n4, attributedCharacterIterator);
            n6 = characterInformation.characterIndex + 1;
            gVTGlyphVector = characterInformation.layout.getGlyphVector();
            fArray = characterInformation.layout.getGlyphAdvances();
            blArray = new boolean[fArray.length];
            characterInformation2 = null;
        }
        if (characterInformation.layout.isOnATextPath()) {
            for (n4 = characterInformation.glyphIndexStart; n4 <= characterInformation.glyphIndexEnd; ++n4) {
                if (gVTGlyphVector.isGlyphVisible(n4) && !blArray[n4]) {
                    f2 += fArray[n4 + 1] - fArray[n4];
                }
                blArray[n4] = true;
            }
        } else {
            if (characterInformation2 == null) {
                characterInformation2 = this.getCharacterInformation(list, n5, n2 + n3 - 1, attributedCharacterIterator);
            }
            f2 += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
        }
        return f2;
    }

    protected float distanceFirstLastCharacterInRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        int n2 = characterInformation.glyphIndexStart;
        int n3 = characterInformation.glyphIndexEnd;
        int n4 = characterInformation2.glyphIndexStart;
        int n5 = characterInformation2.glyphIndexEnd;
        int n6 = n2 < n4 ? n2 : n4;
        int n7 = n3 < n5 ? n5 : n3;
        return fArray[n7 + 1] - fArray[n6];
    }

    protected float distanceBetweenRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        CharacterInformation characterInformation3 = new CharacterInformation();
        characterInformation3.layout = characterInformation.layout;
        characterInformation3.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
        Point2D point2D = this.getEndPoint(characterInformation3);
        characterInformation3.layout = characterInformation2.layout;
        characterInformation3.glyphIndexStart = 0;
        Point2D point2D2 = this.getStartPoint(characterInformation3);
        float f2 = characterInformation2.isVertical() ? (float)(point2D2.getY() - point2D.getY()) : (float)(point2D2.getX() - point2D.getX());
        return f2;
    }

    protected void selectSubString(Element element, int n2, int n3) {
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return;
        }
        int n4 = this.getElementStartIndex(element);
        if (n4 == -1) {
            return;
        }
        List list = this.getTextRuns(textNode);
        int n5 = this.getElementEndIndex(element);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n4, n2, attributedCharacterIterator);
        CharacterInformation characterInformation2 = this.getCharacterInformation(list, n4, n2 + n3 - 1, attributedCharacterIterator);
        Mark mark = textNode.getMarkerForChar(characterInformation.characterIndex, true);
        Mark mark2 = characterInformation2 != null && characterInformation2.characterIndex <= n5 ? textNode.getMarkerForChar(characterInformation2.characterIndex, false) : textNode.getMarkerForChar(n5, false);
        this.ctx.getUserAgent().setTextSelection(mark, mark2);
    }

    protected int getCharNumAtPosition(Element element, float f2, float f3) {
        int n2;
        TextNode textNode = this.getTextNode();
        AttributedCharacterIterator attributedCharacterIterator = textNode.getAttributedCharacterIterator();
        if (attributedCharacterIterator == null) {
            return -1;
        }
        List list = this.getTextRuns(textNode);
        TextHit textHit = null;
        for (n2 = list.size() - 1; n2 >= 0 && textHit == null; --n2) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(n2);
            textHit = textRun.getLayout().hitTestChar(f2, f3);
        }
        if (textHit == null) {
            return -1;
        }
        n2 = this.getElementStartIndex(element);
        int n3 = this.getElementEndIndex(element);
        int n4 = textHit.getCharIndex();
        if (n4 >= n2 && n4 <= n3) {
            return n4 - n2;
        }
        return -1;
    }

    protected List getTextRuns(TextNode textNode) {
        if (textNode.getTextRuns() == null) {
            textNode.getPrimitiveBounds();
        }
        return textNode.getTextRuns();
    }

    protected CharacterInformation getCharacterInformation(List list, int n2, int n3, AttributedCharacterIterator attributedCharacterIterator) {
        CharacterInformation characterInformation = new CharacterInformation();
        characterInformation.characterIndex = n2 + n3;
        for (Object e2 : list) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            if (!textRun.getLayout().hasCharacterIndex(characterInformation.characterIndex)) continue;
            characterInformation.layout = textRun.getLayout();
            attributedCharacterIterator.setIndex(characterInformation.characterIndex);
            if (attributedCharacterIterator.getAttribute(ALT_GLYPH_HANDLER) != null) {
                characterInformation.glyphIndexStart = 0;
                characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
            } else {
                characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex);
                if (characterInformation.glyphIndexStart == -1) {
                    characterInformation.glyphIndexStart = 0;
                    characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
                } else {
                    characterInformation.glyphIndexEnd = characterInformation.glyphIndexStart;
                }
            }
            return characterInformation;
        }
        return null;
    }

    public Set getTextIntersectionSet(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        HashSet<Element> hashSet = new HashSet<Element>();
        TextNode textNode = this.getTextNode();
        List list = textNode.getTextRuns();
        if (list == null) {
            return hashSet;
        }
        block0: for (Object e2 : list) {
            Rectangle2D rectangle2D2;
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            SoftReference softReference = (SoftReference)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_ID);
            Element element = (Element)softReference.get();
            if (element == null || hashSet.contains(element) || !SVGTextElementBridge.isTextSensitive(element) || (rectangle2D2 = textSpanLayout.getBounds2D()) != null && !rectangle2D.intersects(rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D())) continue;
            GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
            for (int i2 = 0; i2 < gVTGlyphVector.getNumGlyphs(); ++i2) {
                Shape shape = gVTGlyphVector.getGlyphLogicalBounds(i2);
                if (shape == null || !(shape = affineTransform.createTransformedShape(shape).getBounds2D()).intersects(rectangle2D)) continue;
                hashSet.add(element);
                continue block0;
            }
        }
        return hashSet;
    }

    public Set getTextEnclosureSet(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        TextNode textNode = this.getTextNode();
        HashSet<Element> hashSet = new HashSet<Element>();
        List list = textNode.getTextRuns();
        if (list == null) {
            return hashSet;
        }
        HashSet<Element> hashSet2 = new HashSet<Element>();
        for (Object e2 : list) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            SoftReference softReference = (SoftReference)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_ID);
            Element element = (Element)softReference.get();
            if (element == null || hashSet2.contains(element)) continue;
            if (!SVGTextElementBridge.isTextSensitive(element)) {
                hashSet2.add(element);
                continue;
            }
            Rectangle2D rectangle2D2 = textSpanLayout.getBounds2D();
            if (rectangle2D2 == null) continue;
            if (rectangle2D.contains(rectangle2D2 = affineTransform.createTransformedShape(rectangle2D2).getBounds2D())) {
                hashSet.add(element);
                continue;
            }
            hashSet2.add(element);
            hashSet.remove(element);
        }
        return hashSet;
    }

    public static boolean getTextIntersection(BridgeContext bridgeContext, Element element, AffineTransform affineTransform, Rectangle2D rectangle2D, boolean bl2) {
        Object object;
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement) {
            sVGContext = ((SVGOMElement)element).getSVGContext();
        }
        if (sVGContext == null) {
            return false;
        }
        SVGTextElementBridge sVGTextElementBridge = null;
        if (sVGContext instanceof SVGTextElementBridge) {
            sVGTextElementBridge = (SVGTextElementBridge)sVGContext;
        } else if (sVGContext instanceof AbstractTextChildSVGContext) {
            object = (AbstractTextChildSVGContext)sVGContext;
            sVGTextElementBridge = ((AbstractTextChildSVGContext)object).getTextBridge();
        }
        if (sVGTextElementBridge == null) {
            return false;
        }
        object = sVGTextElementBridge.getTextNode();
        List list = ((TextNode)object).getTextRuns();
        if (list == null) {
            return false;
        }
        Element element2 = sVGTextElementBridge.e;
        AffineTransform affineTransform2 = ((AbstractGraphicsNode)object).getGlobalTransform();
        affineTransform2.preConcatenate(affineTransform);
        Rectangle2D rectangle2D2 = ((AbstractGraphicsNode)object).getBounds();
        rectangle2D2 = affineTransform2.createTransformedShape(rectangle2D2).getBounds2D();
        if (!rectangle2D.intersects(rectangle2D2)) {
            return false;
        }
        for (Object e2 : list) {
            Rectangle2D rectangle2D3;
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            SoftReference softReference = (SoftReference)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_ID);
            Element element3 = (Element)softReference.get();
            if (element3 == null || bl2 && !SVGTextElementBridge.isTextSensitive(element3)) continue;
            Element element4 = element3;
            while (element4 != null && element4 != element2 && element4 != element) {
                element4 = (Element)sVGTextElementBridge.getParentNode(element4);
            }
            if (element4 != element || (rectangle2D3 = textSpanLayout.getBounds2D()) == null || !rectangle2D.intersects(rectangle2D3 = affineTransform2.createTransformedShape(rectangle2D3).getBounds2D())) continue;
            GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
            for (int i2 = 0; i2 < gVTGlyphVector.getNumGlyphs(); ++i2) {
                Shape shape = gVTGlyphVector.getGlyphLogicalBounds(i2);
                if (shape == null || !(shape = affineTransform2.createTransformedShape(shape).getBounds2D()).intersects(rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    public static Rectangle2D getTextBounds(BridgeContext bridgeContext, Element element, boolean bl2) {
        Object object;
        SVGContext sVGContext = null;
        if (element instanceof SVGOMElement) {
            sVGContext = ((SVGOMElement)element).getSVGContext();
        }
        if (sVGContext == null) {
            return null;
        }
        SVGTextElementBridge sVGTextElementBridge = null;
        if (sVGContext instanceof SVGTextElementBridge) {
            sVGTextElementBridge = (SVGTextElementBridge)sVGContext;
        } else if (sVGContext instanceof AbstractTextChildSVGContext) {
            object = (AbstractTextChildSVGContext)sVGContext;
            sVGTextElementBridge = ((AbstractTextChildSVGContext)object).getTextBridge();
        }
        if (sVGTextElementBridge == null) {
            return null;
        }
        object = sVGTextElementBridge.getTextNode();
        List list = ((TextNode)object).getTextRuns();
        if (list == null) {
            return null;
        }
        Element element2 = sVGTextElementBridge.e;
        Rectangle2D rectangle2D = null;
        for (Object e2 : list) {
            Rectangle2D rectangle2D2;
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)e2;
            TextSpanLayout textSpanLayout = textRun.getLayout();
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            attributedCharacterIterator.first();
            SoftReference softReference = (SoftReference)attributedCharacterIterator.getAttribute(TEXT_COMPOUND_ID);
            Element element3 = (Element)softReference.get();
            if (element3 == null || bl2 && !SVGTextElementBridge.isTextSensitive(element3)) continue;
            Element element4 = element3;
            while (element4 != null && element4 != element2 && element4 != element) {
                element4 = (Element)sVGTextElementBridge.getParentNode(element4);
            }
            if (element4 != element || (rectangle2D2 = textSpanLayout.getBounds2D()) == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public static boolean isTextSensitive(Element element) {
        int n2 = CSSUtilities.convertPointerEvents(element);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return CSSUtilities.convertVisibility(element);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected static class CharacterInformation {
        TextSpanLayout layout;
        int glyphIndexStart;
        int glyphIndexEnd;
        int characterIndex;

        protected CharacterInformation() {
        }

        public boolean isVertical() {
            return this.layout.isVertical();
        }

        public double getComputedOrientationAngle() {
            return this.layout.getComputedOrientationAngle(this.characterIndex);
        }
    }

    protected class TspanBridge
    extends AbstractTextChildTextContent {
        protected TspanBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        @Override
        public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            String string;
            if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate") || string.equals("textLength") || string.equals("lengthAdjust"))) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.getTextNode());
                return;
            }
            super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildTextContent {
        protected TextPathBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildTextContent {
        protected TRefBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        @Override
        public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            String string;
            if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate") || string.equals("textLength") || string.equals("lengthAdjust"))) {
                this.textBridge.computeLaidoutText(this.ctx, this.textBridge.e, this.textBridge.getTextNode());
                return;
            }
            super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
        }
    }

    protected class AbstractTextChildTextContent
    extends AbstractTextChildBridgeUpdateHandler
    implements SVGTextContent {
        protected AbstractTextChildTextContent(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        @Override
        public int getNumberOfChars() {
            return this.textBridge.getNumberOfChars(this.e);
        }

        @Override
        public Rectangle2D getExtentOfChar(int n2) {
            return this.textBridge.getExtentOfChar(this.e, n2);
        }

        @Override
        public Point2D getStartPositionOfChar(int n2) {
            return this.textBridge.getStartPositionOfChar(this.e, n2);
        }

        @Override
        public Point2D getEndPositionOfChar(int n2) {
            return this.textBridge.getEndPositionOfChar(this.e, n2);
        }

        @Override
        public void selectSubString(int n2, int n3) {
            this.textBridge.selectSubString(this.e, n2, n3);
        }

        @Override
        public float getRotationOfChar(int n2) {
            return this.textBridge.getRotationOfChar(this.e, n2);
        }

        @Override
        public float getComputedTextLength() {
            return this.textBridge.getComputedTextLength(this.e);
        }

        @Override
        public float getSubStringLength(int n2, int n3) {
            return this.textBridge.getSubStringLength(this.e, n2, n3);
        }

        @Override
        public int getCharNumAtPosition(float f2, float f3) {
            return this.textBridge.getCharNumAtPosition(this.e, f2, f3);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        protected AbstractTextChildBridgeUpdateHandler(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        @Override
        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        }

        @Override
        public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
            this.textBridge.handleDOMNodeInsertedEvent(mutationEvent);
        }

        @Override
        public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        }

        @Override
        public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
            this.textBridge.handleDOMCharacterDataModified(mutationEvent);
        }

        @Override
        public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
            this.textBridge.handleCSSEngineEvent(cSSEngineEvent);
        }

        @Override
        public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        }

        @Override
        public void handleOtherAnimationChanged(String string) {
        }

        @Override
        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
            SVGTextElementBridge.this.elemTPI.remove(this.e);
        }
    }

    public static abstract class AbstractTextChildSVGContext
    extends AnimatableSVGBridge {
        protected SVGTextElementBridge textBridge;

        public AbstractTextChildSVGContext(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge, Element element) {
            this.ctx = bridgeContext;
            this.textBridge = sVGTextElementBridge;
            this.e = element;
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public Bridge getInstance() {
            return null;
        }

        public SVGTextElementBridge getTextBridge() {
            return this.textBridge;
        }

        @Override
        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        @Override
        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        @Override
        public Rectangle2D getBBox() {
            return null;
        }

        @Override
        public AffineTransform getCTM() {
            return null;
        }

        @Override
        public AffineTransform getGlobalTransform() {
            return null;
        }

        @Override
        public AffineTransform getScreenTransform() {
            return null;
        }

        @Override
        public void setScreenTransform(AffineTransform affineTransform) {
        }

        @Override
        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        @Override
        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        @Override
        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String string, Map map) {
            if (string.length() == 0) {
                return;
            }
            this.strings.add(string);
            this.attributes.add(map);
            ++this.count;
            this.length += string.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String string = (String)this.strings.get(this.count - 1);
            return string.charAt(string.length() - 1);
        }

        public void stripFirst() {
            String string = (String)this.strings.get(0);
            if (string.charAt(string.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (string.length() == 1) {
                this.attributes.remove(0);
                this.strings.remove(0);
                --this.count;
                return;
            }
            this.strings.set(0, string.substring(1));
        }

        public void stripLast() {
            String string = (String)this.strings.get(this.count - 1);
            if (string.charAt(string.length() - 1) != ' ') {
                return;
            }
            --this.length;
            if (string.length() == 1) {
                this.attributes.remove(--this.count);
                this.strings.remove(this.count);
                return;
            }
            this.strings.set(this.count - 1, string.substring(0, string.length() - 1));
        }

        public AttributedString toAttributedString() {
            Object object2;
            switch (this.count) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer stringBuffer = new StringBuffer(this.strings.size() * 5);
            for (Object object2 : this.strings) {
                stringBuffer.append((String)object2);
            }
            AttributedString attributedString = new AttributedString(stringBuffer.toString());
            object2 = this.strings.iterator();
            Iterator iterator = this.attributes.iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                String string = (String)object2.next();
                int n3 = n2 + string.length();
                Map map = (Map)iterator.next();
                Iterator iterator2 = map.keySet().iterator();
                Iterator iterator3 = map.values().iterator();
                while (iterator2.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator2.next();
                    Object v2 = iterator3.next();
                    attributedString.addAttribute(attribute, v2, n2, n3);
                }
                n2 = n3;
            }
            return attributedString;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer stringBuffer = new StringBuffer(this.strings.size() * 5);
            for (Object e2 : this.strings) {
                stringBuffer.append((String)e2);
            }
            return stringBuffer.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)event);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        @Override
        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)event);
        }
    }
}

