/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMAnimatedPoints;
import org.apache.batik.anim.dom.SVGOMPolygonElement;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolygonProducer;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPolygonElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    @Override
    public String getLocalName() {
        return "polygon";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolygonElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        SVGOMPolygonElement sVGOMPolygonElement = (SVGOMPolygonElement)element;
        try {
            SVGOMAnimatedPoints sVGOMAnimatedPoints = sVGOMPolygonElement.getSVGOMAnimatedPoints();
            sVGOMAnimatedPoints.check();
            SVGPointList sVGPointList = sVGOMAnimatedPoints.getAnimatedPoints();
            int n2 = sVGPointList.getNumberOfItems();
            if (n2 == 0) {
                shapeNode.setShape(DEFAULT_SHAPE);
            } else {
                AWTPolygonProducer aWTPolygonProducer = new AWTPolygonProducer();
                aWTPolygonProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolygonProducer.startPoints();
                for (int i2 = 0; i2 < n2; ++i2) {
                    SVGPoint sVGPoint = sVGPointList.getItem(i2);
                    aWTPolygonProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolygonProducer.endPoints();
                shapeNode.setShape(aWTPolygonProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected void handleCSSPropertyChanged(int n2) {
        switch (n2) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n2);
            }
        }
    }
}

