/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.ConcreteComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPatternElementBridge
extends AnimatableGenericSVGBridge
implements ErrorConstants,
PaintBridge {
    @Override
    public String getLocalName() {
        return "pattern";
    }

    @Override
    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f2) {
        Object object;
        RootGraphicsNode rootGraphicsNode = (RootGraphicsNode)bridgeContext.getElementData(element);
        if (rootGraphicsNode == null) {
            rootGraphicsNode = SVGPatternElementBridge.extractPatternContent(element, bridgeContext);
            bridgeContext.setElementData(element, rootGraphicsNode);
        }
        if (rootGraphicsNode == null) {
            return null;
        }
        Rectangle2D rectangle2D = SVGUtilities.convertPatternRegion(element, element2, graphicsNode, bridgeContext);
        String string = SVGUtilities.getChainableAttributeNS(element, null, "patternTransform", bridgeContext);
        AffineTransform affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "patternTransform", string, bridgeContext) : new AffineTransform();
        boolean bl2 = CSSUtilities.convertOverflow(element);
        string = SVGUtilities.getChainableAttributeNS(element, null, "patternContentUnits", bridgeContext);
        short s2 = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "patternContentUnits", string, bridgeContext);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = SVGUtilities.getChainableAttributeNS(element, null, "viewBox", bridgeContext);
        if (string2.length() > 0) {
            object = SVGUtilities.getChainableAttributeNS(element, null, "preserveAspectRatio", bridgeContext);
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            AffineTransform affineTransform3 = ViewBox.getPreserveAspectRatioTransform(element, string2, (String)object, f3, f4, bridgeContext);
            affineTransform2.concatenate(affineTransform3);
        } else if (s2 == 2) {
            object = new AffineTransform();
            Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
            ((AffineTransform)object).translate(rectangle2D2.getX(), rectangle2D2.getY());
            ((AffineTransform)object).scale(rectangle2D2.getWidth(), rectangle2D2.getHeight());
            affineTransform2.concatenate((AffineTransform)object);
        }
        object = new PatternGraphicsNode(rootGraphicsNode);
        object.setTransform(affineTransform2);
        if (f2 != 1.0f) {
            Filter filter = object.getGraphicsNodeRable(true);
            filter = new ComponentTransferRable8Bit(filter, ConcreteComponentTransferFunction.getLinearTransfer(f2, 0.0f), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer());
            object.setFilter(filter);
        }
        return new PatternPaint((GraphicsNode)object, rectangle2D, !bl2, affineTransform);
    }

    protected static RootGraphicsNode extractPatternContent(Element element, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        RootGraphicsNode rootGraphicsNode;
        while ((rootGraphicsNode = SVGPatternElementBridge.extractLocalPatternContent(element, bridgeContext)) == null) {
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return null;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (!parsedURL.complete()) {
                throw new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string});
            }
            if (SVGPatternElementBridge.contains(linkedList, parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            linkedList.add(parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
        return rootGraphicsNode;
    }

    protected static RootGraphicsNode extractLocalPatternContent(Element element, BridgeContext bridgeContext) {
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        CompositeGraphicsNode compositeGraphicsNode = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            GraphicsNode graphicsNode;
            if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
            if (compositeGraphicsNode == null) {
                compositeGraphicsNode = new RootGraphicsNode();
            }
            compositeGraphicsNode.getChildren().add(graphicsNode);
        }
        return compositeGraphicsNode;
    }

    private static boolean contains(List list, ParsedURL parsedURL) {
        for (Object e2 : list) {
            if (!parsedURL.equals(e2)) continue;
            return true;
        }
        return false;
    }

    public static class PatternGraphicsNode
    extends AbstractGraphicsNode {
        GraphicsNode pcn;
        Rectangle2D pBounds;
        Rectangle2D gBounds;
        Rectangle2D sBounds;
        Shape oShape;

        public PatternGraphicsNode(GraphicsNode graphicsNode) {
            this.pcn = graphicsNode;
        }

        @Override
        public void primitivePaint(Graphics2D graphics2D) {
            this.pcn.paint(graphics2D);
        }

        @Override
        public Rectangle2D getPrimitiveBounds() {
            if (this.pBounds != null) {
                return this.pBounds;
            }
            this.pBounds = this.pcn.getTransformedBounds(IDENTITY);
            return this.pBounds;
        }

        @Override
        public Rectangle2D getGeometryBounds() {
            if (this.gBounds != null) {
                return this.gBounds;
            }
            this.gBounds = this.pcn.getTransformedGeometryBounds(IDENTITY);
            return this.gBounds;
        }

        @Override
        public Rectangle2D getSensitiveBounds() {
            if (this.sBounds != null) {
                return this.sBounds;
            }
            this.sBounds = this.pcn.getTransformedSensitiveBounds(IDENTITY);
            return this.sBounds;
        }

        @Override
        public Shape getOutline() {
            if (this.oShape != null) {
                return this.oShape;
            }
            this.oShape = this.pcn.getOutline();
            AffineTransform affineTransform = this.pcn.getTransform();
            if (affineTransform != null) {
                this.oShape = affineTransform.createTransformedShape(this.oShape);
            }
            return this.oShape;
        }

        @Override
        protected void invalidateGeometryCache() {
            this.pBounds = null;
            this.gBounds = null;
            this.sBounds = null;
            this.oShape = null;
            super.invalidateGeometryCache();
        }
    }
}

