/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.MorphologyRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeMorphologyElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feMorphology";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        float[] fArray = SVGFeMorphologyElementBridge.convertRadius(element, bridgeContext);
        if (fArray[0] == 0.0f || fArray[1] == 0.0f) {
            return null;
        }
        boolean bl2 = SVGFeMorphologyElementBridge.convertOperator(element, bridgeContext);
        Filter filter2 = SVGFeMorphologyElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        MorphologyRable8Bit morphologyRable8Bit = new MorphologyRable8Bit(padRable8Bit, fArray[0], fArray[1], bl2);
        SVGFeMorphologyElementBridge.handleColorInterpolationFilters(morphologyRable8Bit, element);
        PadRable8Bit padRable8Bit2 = new PadRable8Bit(morphologyRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeMorphologyElementBridge.updateFilterMap(element, padRable8Bit2, map);
        return padRable8Bit2;
    }

    protected static float[] convertRadius(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "radius");
        if (string.length() == 0) {
            return new float[]{0.0f, 0.0f};
        }
        float[] fArray = new float[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            fArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            fArray[1] = stringTokenizer.hasMoreTokens() ? SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : fArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"radius", string, numberFormatException});
        }
        if (stringTokenizer.hasMoreTokens() || fArray[0] < 0.0f || fArray[1] < 0.0f) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"radius", string});
        }
        return fArray;
    }

    protected static boolean convertOperator(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "operator");
        if (string.length() == 0) {
            return false;
        }
        if ("erode".equals(string)) {
            return false;
        }
        if ("dilate".equals(string)) {
            return true;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"operator", string});
    }
}

