/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.Kernel;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ConvolveMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeConvolveMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feConvolveMatrix";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        int[] nArray = SVGFeConvolveMatrixElementBridge.convertOrder(element, bridgeContext);
        float[] fArray = SVGFeConvolveMatrixElementBridge.convertKernelMatrix(element, nArray, bridgeContext);
        float f2 = SVGFeConvolveMatrixElementBridge.convertDivisor(element, fArray, bridgeContext);
        float f3 = SVGFeConvolveMatrixElementBridge.convertNumber(element, "bias", 0.0f, bridgeContext);
        int[] nArray2 = SVGFeConvolveMatrixElementBridge.convertTarget(element, nArray, bridgeContext);
        PadMode padMode = SVGFeConvolveMatrixElementBridge.convertEdgeMode(element, bridgeContext);
        double[] dArray = SVGFeConvolveMatrixElementBridge.convertKernelUnitLength(element, bridgeContext);
        boolean bl2 = SVGFeConvolveMatrixElementBridge.convertPreserveAlpha(element, bridgeContext);
        Filter filter2 = SVGFeConvolveMatrixElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        ConvolveMatrixRable8Bit convolveMatrixRable8Bit = new ConvolveMatrixRable8Bit(padRable8Bit);
        int n2 = 0;
        while (n2 < fArray.length) {
            int n3 = n2++;
            fArray[n3] = fArray[n3] / f2;
        }
        convolveMatrixRable8Bit.setKernel(new Kernel(nArray[0], nArray[1], fArray));
        convolveMatrixRable8Bit.setTarget(new Point(nArray2[0], nArray2[1]));
        convolveMatrixRable8Bit.setBias(f3);
        convolveMatrixRable8Bit.setEdgeMode(padMode);
        convolveMatrixRable8Bit.setKernelUnitLength(dArray);
        convolveMatrixRable8Bit.setPreserveAlpha(bl2);
        SVGFeConvolveMatrixElementBridge.handleColorInterpolationFilters(convolveMatrixRable8Bit, element);
        PadRable8Bit padRable8Bit2 = new PadRable8Bit(convolveMatrixRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeConvolveMatrixElementBridge.updateFilterMap(element, padRable8Bit2, map);
        return padRable8Bit2;
    }

    protected static int[] convertOrder(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "order");
        if (string.length() == 0) {
            return new int[]{3, 3};
        }
        int[] nArray = new int[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            nArray[0] = SVGUtilities.convertSVGInteger(stringTokenizer.nextToken());
            nArray[1] = stringTokenizer.hasMoreTokens() ? SVGUtilities.convertSVGInteger(stringTokenizer.nextToken()) : nArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"order", string, numberFormatException});
        }
        if (stringTokenizer.hasMoreTokens() || nArray[0] <= 0 || nArray[1] <= 0) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"order", string});
        }
        return nArray;
    }

    protected static float[] convertKernelMatrix(Element element, int[] nArray, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "kernelMatrix");
        if (string.length() == 0) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"kernelMatrix"});
        }
        int n2 = nArray[0] * nArray[1];
        float[] fArray = new float[n2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n3 = 0;
        try {
            while (stringTokenizer.hasMoreTokens() && n3 < n2) {
                fArray[n3++] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"kernelMatrix", string, numberFormatException});
        }
        if (n3 != n2) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"kernelMatrix", string});
        }
        return fArray;
    }

    protected static float convertDivisor(Element element, float[] fArray, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "divisor");
        if (string.length() == 0) {
            float f2 = 0.0f;
            for (float f3 : fArray) {
                f2 += f3;
            }
            return f2 == 0.0f ? 1.0f : f2;
        }
        try {
            return SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"divisor", string, numberFormatException});
        }
    }

    protected static int[] convertTarget(Element element, int[] nArray, BridgeContext bridgeContext) {
        int n2;
        int[] nArray2 = new int[2];
        String string = element.getAttributeNS(null, "targetX");
        if (string.length() == 0) {
            nArray2[0] = nArray[0] / 2;
        } else {
            try {
                n2 = SVGUtilities.convertSVGInteger(string);
                if (n2 < 0 || n2 >= nArray[0]) {
                    throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"targetX", string});
                }
                nArray2[0] = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"targetX", string, numberFormatException});
            }
        }
        string = element.getAttributeNS(null, "targetY");
        if (string.length() == 0) {
            nArray2[1] = nArray[1] / 2;
        } else {
            try {
                n2 = SVGUtilities.convertSVGInteger(string);
                if (n2 < 0 || n2 >= nArray[1]) {
                    throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"targetY", string});
                }
                nArray2[1] = n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"targetY", string, numberFormatException});
            }
        }
        return nArray2;
    }

    protected static double[] convertKernelUnitLength(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "kernelUnitLength");
        if (string.length() == 0) {
            return null;
        }
        double[] dArray = new double[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            dArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            dArray[1] = stringTokenizer.hasMoreTokens() ? (double)SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : dArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        if (stringTokenizer.hasMoreTokens() || dArray[0] <= 0.0 || dArray[1] <= 0.0) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        return dArray;
    }

    protected static PadMode convertEdgeMode(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "edgeMode");
        if (string.length() == 0) {
            return PadMode.REPLICATE;
        }
        if ("duplicate".equals(string)) {
            return PadMode.REPLICATE;
        }
        if ("wrap".equals(string)) {
            return PadMode.WRAP;
        }
        if ("none".equals(string)) {
            return PadMode.ZERO_PAD;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"edgeMode", string});
    }

    protected static boolean convertPreserveAlpha(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "preserveAlpha");
        if (string.length() == 0) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"preserveAlpha", string});
    }
}

