/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable;
import org.apache.batik.ext.awt.image.renderable.ColorMatrixRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeColorMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feColorMatrix";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        ColorMatrixRable colorMatrixRable;
        Filter filter2 = SVGFeColorMatrixElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        int n2 = SVGFeColorMatrixElementBridge.convertType(element, bridgeContext);
        switch (n2) {
            case 2: {
                float f2 = SVGFeColorMatrixElementBridge.convertValuesToHueRotate(element, bridgeContext);
                colorMatrixRable = ColorMatrixRable8Bit.buildHueRotate(f2);
                break;
            }
            case 3: {
                colorMatrixRable = ColorMatrixRable8Bit.buildLuminanceToAlpha();
                break;
            }
            case 0: {
                float[][] fArray = SVGFeColorMatrixElementBridge.convertValuesToMatrix(element, bridgeContext);
                colorMatrixRable = ColorMatrixRable8Bit.buildMatrix(fArray);
                break;
            }
            case 1: {
                float f3 = SVGFeColorMatrixElementBridge.convertValuesToSaturate(element, bridgeContext);
                colorMatrixRable = ColorMatrixRable8Bit.buildSaturate(f3);
                break;
            }
            default: {
                throw new RuntimeException("invalid convertType:" + n2);
            }
        }
        colorMatrixRable.setSource(filter2);
        SVGFeColorMatrixElementBridge.handleColorInterpolationFilters(colorMatrixRable, element);
        PadRable8Bit padRable8Bit = new PadRable8Bit(colorMatrixRable, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeColorMatrixElementBridge.updateFilterMap(element, padRable8Bit, map);
        return padRable8Bit;
    }

    protected static float[][] convertValuesToMatrix(Element element, BridgeContext bridgeContext) {
        int n2;
        String string = element.getAttributeNS(null, "values");
        float[][] fArray = new float[4][5];
        if (string.length() == 0) {
            fArray[0][0] = 1.0f;
            fArray[1][1] = 1.0f;
            fArray[2][2] = 1.0f;
            fArray[3][3] = 1.0f;
            return fArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            for (n2 = 0; n2 < 20 && stringTokenizer.hasMoreTokens(); ++n2) {
                fArray[n2 / 5][n2 % 5] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"values", string, numberFormatException});
        }
        if (n2 != 20 || stringTokenizer.hasMoreTokens()) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"values", string});
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            float[] fArray2 = fArray[i2];
            fArray2[4] = fArray2[4] * 255.0f;
        }
        return fArray;
    }

    protected static float convertValuesToSaturate(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "values");
        if (string.length() == 0) {
            return 1.0f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static float convertValuesToHueRotate(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "values");
        if (string.length() == 0) {
            return 0.0f;
        }
        try {
            return (float)Math.toRadians(SVGUtilities.convertSVGNumber(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected static int convertType(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "type");
        if (string.length() == 0) {
            return 0;
        }
        if ("hueRotate".equals(string)) {
            return 2;
        }
        if ("luminanceToAlpha".equals(string)) {
            return 3;
        }
        if ("matrix".equals(string)) {
            return 0;
        }
        if ("saturate".equals(string)) {
            return 1;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"type", string});
    }
}

