/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.NamedProfileCache;
import org.apache.batik.util.ParsedURL;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    @Override
    public String getLocalName() {
        return "color-profile";
    }

    public ICCColorSpaceWithIntent createICCColorSpaceWithIntent(BridgeContext bridgeContext, Element element, String string) {
        Object object;
        Object object2;
        Object object3;
        ICCColorSpaceWithIntent iCCColorSpaceWithIntent = this.cache.request(string.toLowerCase());
        if (iCCColorSpaceWithIntent != null) {
            return iCCColorSpaceWithIntent;
        }
        Document document = element.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n2 = nodeList.getLength();
        Object object4 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            object3 = nodeList.item(i2);
            if (object3.getNodeType() != 1 || !string.equalsIgnoreCase((String)(object2 = (object = (Element)object3).getAttributeNS(null, "name")))) continue;
            object4 = object;
        }
        if (object4 == null) {
            return null;
        }
        String string2 = XLinkSupport.getXLinkHref(object4);
        object3 = null;
        if (string2 != null) {
            ParsedURL parsedURL;
            object = object4.getBaseURI();
            object2 = null;
            if (object != null) {
                object2 = new ParsedURL((String)object);
            }
            if (!(parsedURL = new ParsedURL((ParsedURL)object2, string2)).complete()) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string2});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
            try {
                bridgeContext.getUserAgent().checkLoadExternalResource(parsedURL, (ParsedURL)object2);
                object3 = ICC_Profile.getInstance(parsedURL.openStream());
            }
            catch (IOException iOException) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, iOException, "uri.io", new Object[]{string2});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
            catch (SecurityException securityException) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{string2});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
        }
        if (object3 == null) {
            return null;
        }
        object = SVGColorProfileElementBridge.convertIntent((Element)object4, bridgeContext);
        iCCColorSpaceWithIntent = new ICCColorSpaceWithIntent((ICC_Profile)object3, (RenderingIntent)((Object)object), string2, string);
        this.cache.put(string.toLowerCase(), iCCColorSpaceWithIntent);
        return iCCColorSpaceWithIntent;
    }

    private static RenderingIntent convertIntent(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "rendering-intent");
        if (string.length() == 0) {
            return RenderingIntent.AUTO;
        }
        if ("perceptual".equals(string)) {
            return RenderingIntent.PERCEPTUAL;
        }
        if ("auto".equals(string)) {
            return RenderingIntent.AUTO;
        }
        if ("relative-colorimetric".equals(string)) {
            return RenderingIntent.RELATIVE_COLORIMETRIC;
        }
        if ("absolute-colorimetric".equals(string)) {
            return RenderingIntent.ABSOLUTE_COLORIMETRIC;
        }
        if ("saturation".equals(string)) {
            return RenderingIntent.SATURATION;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"rendering-intent", string});
    }
}

